/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionInfo;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;

public abstract class HBaseRpc {
    static final byte RPC_SUCCESS = 0;
    static final byte RPC_ERROR = 1;
    static final byte RPC_FRAMED = 2;
    static final byte RPC_FATAL = -1;
    private Deferred<Object> deferred;
    final byte[] table;
    final byte[] key;
    RegionInfo region;
    byte attempt;
    boolean failfast = false;
    static final long MAX_BYTE_ARRAY_MASK = -268435456L;

    abstract ChannelBuffer serialize(byte var1);

    abstract Object deserialize(ChannelBuffer var1, int var2);

    static void ensureNoCell(int cell_size) {
        if (cell_size != 0) {
            throw new InvalidResponseException("Should not have gotten any cell blocks, yet there are " + cell_size + " bytes that follow the protobuf response." + "  This should never happen." + "  Are you using an incompatible version of HBase?", null);
        }
    }

    public final boolean setFailfast(boolean failfast) {
        this.failfast = failfast;
        return this.failfast;
    }

    public final boolean failfast() {
        return this.failfast;
    }

    HBaseRpc() {
        this.table = null;
        this.key = null;
    }

    HBaseRpc(byte[] table, byte[] key) {
        KeyValue.checkTable(table);
        KeyValue.checkKey(key);
        this.table = table;
        this.key = key;
    }

    abstract byte[] method(byte var1);

    final void setRegion(RegionInfo region) {
        if (this.table == null) {
            throw new AssertionError((Object)"Can't use setRegion if no table was given.");
        }
        this.region = region;
    }

    final RegionInfo getRegion() {
        return this.region;
    }

    final Deferred<Object> getDeferred() {
        if (this.deferred == null) {
            this.deferred = new Deferred();
        }
        return this.deferred;
    }

    final void callback(Object result) {
        Deferred<Object> d = this.deferred;
        if (d == null) {
            return;
        }
        this.deferred = null;
        this.attempt = 0;
        d.callback(result);
    }

    final boolean hasDeferred() {
        return this.deferred != null;
    }

    public String toString() {
        String method = new String(this.method((byte)0));
        StringBuilder buf = new StringBuilder(16 + method.length() + 2 + 8 + (this.table == null ? 4 : this.table.length + 2) + 6 + (this.key == null ? 4 : this.key.length * 2) + 9 + (this.region == null ? 4 : this.region.stringSizeHint()) + 10 + 1 + 1);
        buf.append("HBaseRpc(method=");
        buf.append(method);
        buf.append(", table=");
        Bytes.pretty(buf, this.table);
        buf.append(", key=");
        Bytes.pretty(buf, this.key);
        buf.append(", region=");
        if (this.region == null) {
            buf.append("null");
        } else {
            this.region.toStringbuf(buf);
        }
        buf.append(", attempt=").append(this.attempt);
        buf.append(')');
        return buf.toString();
    }

    final String toStringWithQualifiers(String classname, byte[] family, byte[][] qualifiers) {
        return this.toStringWithQualifiers(classname, family, qualifiers, (byte[][])null, "");
    }

    final String toStringWithQualifiers(String classname, byte[] family, byte[][] qualifiers, byte[][] values, String fields) {
        return this.toStringWithQualifiers(classname, new byte[][]{family}, new byte[][][]{qualifiers}, new byte[][][]{values}, fields);
    }

    final String toStringWithQualifiers(String classname, byte[][] families, byte[][][] qualifiers) {
        return this.toStringWithQualifiers(classname, families, qualifiers, (byte[][][])null, "");
    }

    final String toStringWithQualifiers(String classname, byte[][] families, byte[][][] qualifiers, byte[][][] values, String fields) {
        return this.toStringWithQualifiers(classname, families, qualifiers, null, null, "");
    }

    final String toStringWithQualifiers(String classname, byte[][] families, byte[][][] qualifiers, byte[][][] values, long[][] timestamps, String fields) {
        StringBuilder buf = new StringBuilder(256 + fields.length());
        buf.append(classname).append("(table=");
        Bytes.pretty(buf, this.table);
        buf.append(", key=");
        Bytes.pretty(buf, this.key);
        buf.append(", families=");
        if (families == null || families.length == 0 || families == DeleteRequest.WHOLE_ROW) {
            buf.append("null");
        } else {
            buf.append("[");
            for (int family_idx = 0; family_idx < families.length; ++family_idx) {
                buf.append("{name=");
                byte[] family = families[family_idx];
                Bytes.pretty(buf, family);
                if (qualifiers != null && qualifiers[family_idx] != null) {
                    buf.append(", qualifiers=");
                    Bytes.pretty(buf, qualifiers[family_idx]);
                }
                if (values != null && values[family_idx] != null) {
                    buf.append(", values=");
                    Bytes.pretty(buf, values[family_idx]);
                }
                if (timestamps != null && timestamps[family_idx] != null) {
                    buf.append(", timestamps=");
                    buf.append(Arrays.toString(timestamps[family_idx]));
                }
                buf.append("}, ");
            }
            buf.setLength(buf.length() - 2);
            buf.append("]");
        }
        buf.append(fields);
        buf.append(", attempt=").append(this.attempt).append(", region=");
        if (this.region == null) {
            buf.append("null");
        } else {
            this.region.toStringbuf(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    final String toStringWithQualifier(String classname, byte[] family, byte[] qualifier, String fields) {
        StringBuilder buf = new StringBuilder(256 + fields.length());
        buf.append(classname).append("(table=");
        Bytes.pretty(buf, this.table);
        buf.append(", key=");
        Bytes.pretty(buf, this.key);
        buf.append(", family=");
        Bytes.pretty(buf, family);
        buf.append(", qualifier=");
        Bytes.pretty(buf, qualifier);
        buf.append(fields);
        buf.append(", attempt=").append(this.attempt).append(", region=");
        if (this.region == null) {
            buf.append("null");
        } else {
            this.region.toStringbuf(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    final ChannelBuffer newBuffer(byte server_version, int max_payload_size) {
        int header = 10 + this.method(server_version).length + (server_version < 29 ? 0 : 13);
        ChannelBuffer buf = ChannelBuffers.buffer((int)(header + max_payload_size));
        buf.setIndex(0, header);
        return buf;
    }

    static final ChannelBuffer toChannelBuffer(byte[] method, AbstractMessageLite pb) {
        int pblen = pb.getSerializedSize();
        int vlen = CodedOutputStream.computeRawVarint32Size((int)pblen);
        byte[] buf = new byte[23 + method.length + vlen + pblen];
        try {
            CodedOutputStream out = CodedOutputStream.newInstance((byte[])buf, (int)(23 + method.length), (int)(vlen + pblen));
            out.writeRawVarint32(pblen);
            pb.writeTo(out);
            out.checkNoSpaceLeft();
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen", e);
        }
        return ChannelBuffers.wrappedBuffer((byte[])buf);
    }

    static void writeHBaseBool(ChannelBuffer buf, boolean b) {
        buf.writeByte(1);
        buf.writeByte(b ? 1 : 0);
    }

    static void writeHBaseInt(ChannelBuffer buf, int v) {
        buf.writeByte(5);
        buf.writeInt(v);
    }

    static void writeHBaseLong(ChannelBuffer buf, long v) {
        buf.writeByte(6);
        buf.writeLong(v);
    }

    static void writeHBaseString(ChannelBuffer buf, String s) {
        buf.writeByte(10);
        byte[] b = s.getBytes(CharsetUtil.UTF_8);
        HBaseRpc.writeVLong(buf, b.length);
        buf.writeBytes(b);
    }

    static void writeHBaseByteArray(ChannelBuffer buf, byte[] b) {
        buf.writeByte(11);
        HBaseRpc.writeByteArray(buf, b);
    }

    static void writeByteArray(ChannelBuffer buf, byte[] b) {
        HBaseRpc.writeVLong(buf, b.length);
        buf.writeBytes(b);
    }

    static void writeHBaseNull(ChannelBuffer buf) {
        buf.writeByte(14);
        buf.writeByte(17);
        buf.writeByte(14);
    }

    static void checkArrayLength(ChannelBuffer buf, long length) {
        if ((length & 0xFFFFFFFFF0000000L) != 0L) {
            if (length < 0L) {
                throw new IllegalArgumentException("Read negative byte array length: " + length + " in buf=" + buf + '=' + Bytes.pretty(buf));
            }
            throw new IllegalArgumentException("Read byte array length that's too large: " + length + " > " + 0xFFFFFFFL + " in buf=" + buf + '=' + Bytes.pretty(buf));
        }
    }

    static void checkArrayLength(byte[] array) {
        if (((long)array.length & 0xFFFFFFFFF0000000L) != 0L) {
            if (array.length < 0) {
                throw new AssertionError((Object)("Negative byte array length: " + array.length + ' ' + Bytes.pretty(array)));
            }
            throw new IllegalArgumentException("Byte array length too big: " + array.length + " > " + 0xFFFFFFFL);
        }
    }

    static void checkNonEmptyArrayLength(ChannelBuffer buf, long length) {
        if (length == 0L) {
            throw new IllegalArgumentException("Read zero-length byte array  in buf=" + buf + '=' + Bytes.pretty(buf));
        }
        HBaseRpc.checkArrayLength(buf, length);
    }

    static byte[] readByteArray(ChannelBuffer buf) {
        long length = HBaseRpc.readVLong(buf);
        HBaseRpc.checkArrayLength(buf, length);
        byte[] b = new byte[(int)length];
        buf.readBytes(b);
        return b;
    }

    static String readHadoopString(ChannelBuffer buf) {
        int length = buf.readInt();
        HBaseRpc.checkArrayLength(buf, length);
        byte[] s = new byte[length];
        buf.readBytes(s);
        return new String(s, CharsetUtil.UTF_8);
    }

    static <T> T readProtobuf(ChannelBuffer buf, Parser<T> parser) {
        int offset;
        byte[] payload;
        int length = HBaseRpc.readProtoBufVarint(buf);
        HBaseRpc.checkArrayLength(buf, length);
        if (buf.hasArray()) {
            payload = buf.array();
            offset = buf.arrayOffset() + buf.readerIndex();
        } else {
            payload = new byte[length];
            buf.readBytes(payload);
            offset = 0;
        }
        try {
            return (T)parser.parseFrom(payload, offset, length);
        }
        catch (InvalidProtocolBufferException e) {
            String msg = "Invalid RPC response: length=" + length + ", payload=" + Bytes.pretty(payload);
            throw new InvalidResponseException(msg, (Exception)((Object)e));
        }
    }

    static void writeVLong(ChannelBuffer buf, long n) {
        if (n >= -112L && n <= 127L) {
            buf.writeByte((int)((byte)n));
            return;
        }
        int b = -112;
        if (n < 0L) {
            n ^= 0xFFFFFFFFFFFFFFFFL;
            b = -120;
        }
        long tmp = n;
        do {
            b = (byte)(b - 1);
        } while ((tmp >>>= 8) != 0L);
        buf.writeByte(b);
        switch (b & 7) {
            case 0: {
                buf.writeLong(n);
                break;
            }
            case 1: {
                buf.writeInt((int)(n >>> 24));
                buf.writeMedium((int)n);
                break;
            }
            case 2: {
                buf.writeMedium((int)(n >>> 24));
                buf.writeMedium((int)n);
                break;
            }
            case 3: {
                buf.writeByte((int)((byte)(n >>> 32)));
            }
            case 4: {
                buf.writeInt((int)n);
                break;
            }
            case 5: {
                buf.writeMedium((int)n);
                break;
            }
            case 6: {
                buf.writeShort((int)((short)n));
                break;
            }
            case 7: {
                buf.writeByte((int)((byte)n));
            }
        }
    }

    static long readVLong(ChannelBuffer buf) {
        byte b = buf.readByte();
        if ((b & 0xF0) != 128) {
            return b;
        }
        boolean negate = (b & 8) == 0;
        long result = 0L;
        switch (b & 7) {
            case 0: {
                result = buf.readLong();
                break;
            }
            case 1: {
                result = buf.readUnsignedInt();
                result <<= 32;
                result |= (long)buf.readUnsignedMedium();
                break;
            }
            case 2: {
                result = buf.readUnsignedMedium();
                result <<= 24;
                result |= (long)buf.readUnsignedMedium();
                break;
            }
            case 3: {
                b = buf.readByte();
                result <<= 8;
                result |= (long)(b & 0xFF);
            }
            case 4: {
                result <<= 32;
                result |= buf.readUnsignedInt();
                break;
            }
            case 5: {
                result |= (long)buf.readUnsignedMedium();
                break;
            }
            case 6: {
                result |= (long)buf.readUnsignedShort();
                break;
            }
            case 7: {
                b = buf.readByte();
                result <<= 8;
                result |= (long)(b & 0xFF);
            }
        }
        return negate ? result ^ 0xFFFFFFFFFFFFFFFFL : result;
    }

    static int readProtoBufVarint(ChannelBuffer buf) {
        int result = buf.readByte();
        if (result >= 0) {
            return result;
        }
        result &= 0x7F;
        if ((result |= buf.readByte() << 7) >= 0) {
            return result;
        }
        result &= 0x3FFF;
        if ((result |= buf.readByte() << 14) >= 0) {
            return result;
        }
        result &= 0x1FFFFF;
        if ((result |= buf.readByte() << 21) >= 0) {
            return result;
        }
        result &= 0xFFFFFFF;
        byte b = buf.readByte();
        result |= b << 28;
        if (b >= 0) {
            return result;
        }
        throw new IllegalArgumentException("Not a 32 bit varint: " + result + " (5th byte: " + b + ")");
    }

    static interface IsEdit {
        public static final byte[] MUTATE = new byte[]{77, 117, 116, 97, 116, 101};
    }

    public static interface HasTimestamp {
        public long timestamp();
    }

    public static interface HasValues {
        public byte[][] values();

        public byte[][][] getValues();
    }

    public static interface HasValue {
        public byte[] value();
    }

    public static interface HasQualifiers {
        public byte[][] qualifiers();

        public byte[][][] getQualifiers();
    }

    public static interface HasQualifier {
        public byte[] qualifier();
    }

    public static interface HasFamily {
        public byte[] family();

        public byte[][] getFamilies();
    }

    public static interface HasKey {
        public byte[] key();
    }

    public static interface HasTable {
        public byte[] table();
    }
}

