/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthHandler;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.ietf.jgss.GSSManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticationHandler
extends KerberosAuthHandler {
    private static Logger LOG = LoggerFactory.getLogger(KerberosAuthenticationHandler.class);
    public static final String TYPE = "kerberos";
    public static final String PRINCIPAL = "kerberos.principal";
    public static final String KEYTAB = "kerberos.keytab";
    public static final String NAME_RULES = "kerberos.name.rules";

    @Override
    public void init(Properties config) throws ServletException {
        try {
            this.principal = config.getProperty(PRINCIPAL, this.principal);
            if (this.principal == null || this.principal.trim().length() == 0) {
                LOG.warn("Principal not defined in configuration. Trying JAAS with MAPR_WEBSERVER_KERBEROS");
                super.init(config);
                return;
            }
            this.keytab = config.getProperty(KEYTAB, this.keytab);
            if (this.keytab == null || this.keytab.trim().length() == 0) {
                LOG.warn("Keytab not defined in configuration. Trying JAAS with MAPR_WEBSERVER_KERBEROS");
                super.init(config);
                return;
            }
            if (!new File(this.keytab).exists()) {
                LOG.warn("Keytab does not exist: " + this.keytab + ". Trying JAAS with MAPR_WEBSERVER_KERBEROS");
                super.init(config);
                return;
            }
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(this.principal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            KerberosConfiguration kerberosConfiguration = new KerberosConfiguration(this.keytab, this.principal);
            LOG.info("Login using keytab " + this.keytab + ", for principal " + this.principal);
            this.loginContext = new LoginContext("", subject, null, kerberosConfiguration);
            this.loginContext.login();
            Subject serverSubject = this.loginContext.getSubject();
            try {
                this.gssManager = Subject.doAs(serverSubject, new PrivilegedExceptionAction<GSSManager>(){

                    @Override
                    public GSSManager run() throws Exception {
                        return GSSManager.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
            LOG.info("Initialized, principal [{}] from keytab [{}]", (Object)this.principal, (Object)this.keytab);
        }
        catch (Exception ex) {
            KerberosUtil.checkJCEKeyStrength();
            throw new ServletException((Throwable)ex);
        }
    }

    @Override
    public void destroy() {
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
                this.loginContext = null;
            }
        }
        catch (LoginException ex) {
            LOG.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected String getPrincipal() {
        return this.principal;
    }

    @Override
    protected String getKeytab() {
        return this.keytab;
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Negotiate")) {
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.setStatus(401);
            if (authorization == null) {
                LOG.trace("SPNEGO starting");
            } else {
                LOG.warn("'Authorization' does not start with 'Negotiate' :  {}", (Object)authorization);
            }
        } else {
            token = this.postauthenticate(request, response);
        }
        return token;
    }

    private static class KerberosConfiguration
    extends Configuration {
        private String keytab;
        private String principal;

        public KerberosConfiguration(String keytab, String principal) {
            this.keytab = keytab;
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("keyTab", this.keytab);
            options.put("principal", this.principal);
            options.put("useKeyTab", "true");
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            options.put("useTicketCache", "true");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", "false");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                options.put("ticketCache", ticketCache);
            }
            if (LOG.isDebugEnabled()) {
                options.put("debug", "true");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

