/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Category;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

class FairSchedulerEventLog {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.FairSchedulerEventLog");
    private boolean logDisabled = true;
    private String logDir;
    private String logFile;
    private DailyRollingFileAppender appender;

    FairSchedulerEventLog() {
    }

    boolean init(Configuration conf, String jobtrackerHostname) {
        try {
            this.logDir = conf.get("mapred.fairscheduler.eventlog.location", new File(System.getProperty("hadoop.log.dir")).getAbsolutePath() + File.separator + "fairscheduler");
            Path logDirPath = new Path(this.logDir);
            FileSystem fs = logDirPath.getFileSystem(conf);
            if (!fs.exists(logDirPath) && !fs.mkdirs(logDirPath)) {
                throw new IOException("Mkdirs failed to create " + logDirPath.toString());
            }
            String username = System.getProperty("user.name");
            this.logFile = String.format("%s%shadoop-%s-fairscheduler-%s.log", this.logDir, File.separator, username, jobtrackerHostname);
            this.logDisabled = false;
            PatternLayout layout = new PatternLayout("%d{ISO8601}\t%m%n");
            this.appender = new DailyRollingFileAppender((Layout)layout, this.logFile, "'.'yyyy-MM-dd");
            this.appender.activateOptions();
            LOG.info((Object)("Initialized fair scheduler event log, logging to " + this.logFile));
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to initialize fair scheduler event log. Disabling it.", (Throwable)e);
            this.logDisabled = true;
        }
        return !this.logDisabled;
    }

    synchronized void log(String eventType, Object ... params) {
        try {
            if (this.logDisabled) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(eventType);
            for (Object param : params) {
                buffer.append("\t");
                buffer.append(param);
            }
            String message = buffer.toString();
            Logger logger = Logger.getLogger(this.getClass());
            this.appender.append(new LoggingEvent("", (Category)logger, (Priority)Level.INFO, (Object)message, null));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to append to fair scheduler event log", (Throwable)e);
            this.logDisabled = true;
        }
    }

    void shutdown() {
        try {
            if (this.appender != null) {
                this.appender.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.logDisabled = true;
    }

    boolean isEnabled() {
        return !this.logDisabled;
    }
}

