/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.WeightAdjuster;
import org.apache.hadoop.mapreduce.TaskType;

public class NewJobWeightBooster
extends Configured
implements WeightAdjuster {
    private static final float DEFAULT_FACTOR = 3.0f;
    private static final long DEFAULT_DURATION = 300000L;
    private float factor;
    private long duration;

    public void setConf(Configuration conf) {
        if (conf != null) {
            this.factor = conf.getFloat("mapred.newjobweightbooster.factor", 3.0f);
            this.duration = conf.getLong("mapred.newjobweightbooster.duration", 300000L);
        }
        super.setConf(conf);
    }

    @Override
    public double adjustWeight(JobInProgress job, TaskType taskType, double curWeight) {
        long start = job.getStartTime();
        long now = System.currentTimeMillis();
        if (now - start < this.duration) {
            return curWeight * (double)this.factor;
        }
        return curWeight;
    }
}

