/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MiniYARNCluster
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(MiniYARNCluster.class);
    private NodeManager[] nodeManagers;
    private ResourceManager[] resourceManagers;
    private String[] rmIds;
    private ApplicationHistoryServer appHistoryServer;
    private boolean useFixedPorts;
    private boolean useRpc = false;
    private int failoverTimeout;
    private ConcurrentMap<ApplicationAttemptId, Long> appMasters = new ConcurrentHashMap(16, 0.75f, 2);
    private File testWorkDir;
    private int numLocalDirs;
    private int numLogDirs;
    private boolean enableAHS;

    public MiniYARNCluster(String testName, int numResourceManagers, int numNodeManagers, int numLocalDirs, int numLogDirs, boolean enableAHS) {
        super(testName.replace("$", ""));
        this.numLocalDirs = numLocalDirs;
        this.numLogDirs = numLogDirs;
        this.enableAHS = enableAHS;
        String testSubDir = testName.replace("$", "");
        File targetWorkDir = new File("target", testSubDir);
        try {
            FileContext.getLocalFSFileContext().delete(new Path(targetWorkDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            LOG.warn((Object)"COULD NOT CLEANUP", (Throwable)e);
            throw new YarnRuntimeException("could not cleanup test dir: " + e, (Throwable)e);
        }
        if (Shell.WINDOWS) {
            String targetPath = targetWorkDir.getAbsolutePath();
            File link = new File(System.getProperty("java.io.tmpdir"), String.valueOf(System.currentTimeMillis()));
            String linkPath = link.getAbsolutePath();
            try {
                FileContext.getLocalFSFileContext().delete(new Path(linkPath), true);
            }
            catch (IOException e) {
                throw new YarnRuntimeException("could not cleanup symlink: " + linkPath, (Throwable)e);
            }
            targetWorkDir.mkdirs();
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(Shell.getSymlinkCommand((String)targetPath, (String)linkPath));
            try {
                shexec.execute();
            }
            catch (IOException e) {
                throw new YarnRuntimeException(String.format("failed to create symlink from %s to %s, shell output: %s", linkPath, targetPath, shexec.getOutput()), (Throwable)e);
            }
            this.testWorkDir = link;
        } else {
            this.testWorkDir = targetWorkDir;
        }
        this.resourceManagers = new ResourceManager[numResourceManagers];
        this.nodeManagers = new NodeManager[numNodeManagers];
    }

    public MiniYARNCluster(String testName, int numResourceManagers, int numNodeManagers, int numLocalDirs, int numLogDirs) {
        this(testName, numResourceManagers, numNodeManagers, numLocalDirs, numLogDirs, false);
    }

    public MiniYARNCluster(String testName, int numNodeManagers, int numLocalDirs, int numLogDirs) {
        this(testName, 1, numNodeManagers, numLocalDirs, numLogDirs);
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.useFixedPorts = conf.getBoolean("yarn.minicluster.fixed.ports", false);
        this.useRpc = conf.getBoolean("yarn.minicluster.use-rpc", false);
        this.failoverTimeout = conf.getInt("yarn.resourcemanager.zk-timeout-ms", 10000);
        if (this.useRpc && !this.useFixedPorts) {
            throw new YarnRuntimeException("Invalid configuration! Minicluster can use rpc only when configured to use fixed ports");
        }
        conf.setBoolean("yarn.is.minicluster", true);
        if (this.resourceManagers.length > 1) {
            conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
            if (conf.get("yarn.resourcemanager.ha.rm-ids") == null) {
                StringBuilder rmIds = new StringBuilder();
                for (int i = 0; i < this.resourceManagers.length; ++i) {
                    if (i != 0) {
                        rmIds.append(",");
                    }
                    rmIds.append("rm" + i);
                }
                conf.set("yarn.resourcemanager.ha.rm-ids", rmIds.toString());
            }
            Collection rmIdsCollection = HAUtil.getRMHAIds((Configuration)conf);
            this.rmIds = rmIdsCollection.toArray(new String[rmIdsCollection.size()]);
        }
        for (int i = 0; i < this.resourceManagers.length; ++i) {
            this.resourceManagers[i] = this.createResourceManager();
            if (!this.useFixedPorts) {
                if (HAUtil.isHAEnabled((Configuration)conf)) {
                    this.setHARMConfiguration(i, conf);
                } else {
                    this.setNonHARMConfiguration(conf);
                }
            }
            this.addService((Service)new ResourceManagerWrapper(this, i));
        }
        for (int index = 0; index < this.nodeManagers.length; ++index) {
            this.nodeManagers[index] = this.useRpc ? new CustomNodeManager(this, null) : new ShortCircuitedNodeManager(this, null);
            this.addService((Service)new NodeManagerWrapper(this, index));
        }
        if (this.enableAHS) {
            this.addService((Service)new ApplicationHistoryServerWrapper(this));
        }
        super.serviceInit((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
    }

    private void setNonHARMConfiguration(Configuration conf) {
        String hostname = MiniYARNCluster.getHostname();
        conf.set("yarn.resourcemanager.address", hostname + ":0");
        conf.set("yarn.resourcemanager.admin.address", hostname + ":0");
        conf.set("yarn.resourcemanager.scheduler.address", hostname + ":0");
        conf.set("yarn.resourcemanager.resource-tracker.address", hostname + ":0");
        WebAppUtils.setRMWebAppHostnameAndPort((Configuration)conf, (String)hostname, (int)0);
    }

    private void setHARMConfiguration(int index, Configuration conf) {
        String hostname = MiniYARNCluster.getHostname();
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)conf)) {
            conf.set(HAUtil.addSuffix((String)confKey, (String)this.rmIds[index]), hostname + ":0");
        }
    }

    private synchronized void initResourceManager(int index, Configuration conf) {
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            conf.set("yarn.resourcemanager.ha.id", this.rmIds[index]);
        }
        this.resourceManagers[index].init(conf);
        this.resourceManagers[index].getRMContext().getDispatcher().register(RMAppAttemptEventType.class, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private synchronized void startResourceManager(int index) {
        try {
            2 rmThread = new /* Unavailable Anonymous Inner Class!! */;
            rmThread.setName("RM-" + index);
            rmThread.start();
            int waitCount = 0;
            while (this.resourceManagers[index].getServiceState() == Service.STATE.INITED && waitCount++ < 60) {
                LOG.info((Object)"Waiting for RM to start...");
                Thread.sleep(1500L);
            }
            if (this.resourceManagers[index].getServiceState() != Service.STATE.STARTED) {
                throw new IOException("ResourceManager failed to start. Final state is " + this.resourceManagers[index].getServiceState());
            }
        }
        catch (Throwable t) {
            throw new YarnRuntimeException(t);
        }
        LOG.info((Object)("MiniYARN ResourceManager address: " + this.getConfig().get("yarn.resourcemanager.address")));
        LOG.info((Object)("MiniYARN ResourceManager web address: " + WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.getConfig())));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void stopResourceManager(int index) {
        if (this.resourceManagers[index] != null) {
            this.resourceManagers[index].stop();
            this.resourceManagers[index] = null;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized void restartResourceManager(int index) throws InterruptedException {
        if (this.resourceManagers[index] != null) {
            this.resourceManagers[index].stop();
            this.resourceManagers[index] = null;
        }
        Configuration conf = this.getConfig();
        this.resourceManagers[index] = new ResourceManager();
        this.initResourceManager(index, this.getConfig());
        this.startResourceManager(index);
    }

    public File getTestWorkDir() {
        return this.testWorkDir;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int getActiveRMIndex() {
        if (this.resourceManagers.length == 1) {
            return 0;
        }
        int numRetriesForRMBecomingActive = this.failoverTimeout / 100;
        while (numRetriesForRMBecomingActive-- > 0) {
            for (int i = 0; i < this.resourceManagers.length; ++i) {
                if (this.resourceManagers[i] == null) continue;
                try {
                    if (HAServiceProtocol.HAServiceState.ACTIVE != this.resourceManagers[i].getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
                    return i;
                }
                catch (IOException e) {
                    throw new YarnRuntimeException("Couldn't read the status of a ResourceManger in the HA ensemble.", (Throwable)e);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new YarnRuntimeException("Interrupted while waiting for one of the ResourceManagers to become active");
            }
        }
        return -1;
    }

    public ResourceManager getResourceManager() {
        int activeRMIndex = this.getActiveRMIndex();
        return activeRMIndex == -1 ? null : this.resourceManagers[activeRMIndex];
    }

    public ResourceManager getResourceManager(int i) {
        return this.resourceManagers[i];
    }

    public NodeManager getNodeManager(int i) {
        return this.nodeManagers[i];
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean waitForNodeManagersToConnect(long timeout) throws YarnException, InterruptedException {
        GetClusterMetricsRequest req = GetClusterMetricsRequest.newInstance();
        int i = 0;
        while ((long)i < timeout / 100L) {
            ResourceManager rm = this.getResourceManager();
            if (rm == null) {
                throw new YarnException("Can not find the active RM.");
            }
            if (this.nodeManagers.length == rm.getClientRMService().getClusterMetrics(req).getClusterMetrics().getNumNodeManagers()) {
                return true;
            }
            Thread.sleep(100L);
            ++i;
        }
        return false;
    }

    public ApplicationHistoryServer getApplicationHistoryServer() {
        return this.appHistoryServer;
    }

    protected ResourceManager createResourceManager() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public int getNumOfResourceManager() {
        return this.resourceManagers.length;
    }

    static /* synthetic */ ConcurrentMap access$200(MiniYARNCluster x0) {
        return x0.appMasters;
    }

    static /* synthetic */ ResourceManager[] access$300(MiniYARNCluster x0) {
        return x0.resourceManagers;
    }

    static /* synthetic */ void access$400(MiniYARNCluster x0, int x1, Configuration x2) {
        x0.initResourceManager(x1, x2);
    }

    static /* synthetic */ void access$500(MiniYARNCluster x0, int x1) {
        x0.startResourceManager(x1);
    }

    static /* synthetic */ Log access$600() {
        return LOG;
    }

    static /* synthetic */ File access$700(MiniYARNCluster x0) {
        return x0.testWorkDir;
    }

    static /* synthetic */ int access$800(MiniYARNCluster x0) {
        return x0.numLocalDirs;
    }

    static /* synthetic */ int access$900(MiniYARNCluster x0) {
        return x0.numLogDirs;
    }

    static /* synthetic */ NodeManager[] access$1000(MiniYARNCluster x0) {
        return x0.nodeManagers;
    }

    static /* synthetic */ ApplicationHistoryServer access$1102(MiniYARNCluster x0, ApplicationHistoryServer x1) {
        x0.appHistoryServer = x1;
        return x0.appHistoryServer;
    }

    static /* synthetic */ ApplicationHistoryServer access$1100(MiniYARNCluster x0) {
        return x0.appHistoryServer;
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }
}

