/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.security.NMTokenSecretManagerInNM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestContainerManagerSecurity
extends KerberosSecurityTestcase {
    static Log LOG = LogFactory.getLog(TestContainerManagerSecurity.class);
    static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static MiniYARNCluster yarnCluster;
    private static final File testRootDir;
    private static File httpSpnegoKeytabFile;
    private static String httpSpnegoPrincipal;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        testRootDir.mkdirs();
        httpSpnegoKeytabFile.deleteOnExit();
        this.getKdc().createPrincipal(httpSpnegoKeytabFile, new String[]{httpSpnegoPrincipal});
    }

    @After
    public void tearDown() {
        testRootDir.delete();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        Configuration configurationWithoutSecurity = new Configuration();
        configurationWithoutSecurity.set("hadoop.security.authentication", "simple");
        Configuration configurationWithSecurity = new Configuration();
        configurationWithSecurity.set("hadoop.security.authentication", "kerberos");
        configurationWithSecurity.set("yarn.resourcemanager.webapp.spnego-principal", httpSpnegoPrincipal);
        configurationWithSecurity.set("yarn.resourcemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        configurationWithSecurity.set("yarn.nodemanager.webapp.spnego-principal", httpSpnegoPrincipal);
        configurationWithSecurity.set("yarn.nodemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
        return Arrays.asList({configurationWithoutSecurity}, {configurationWithSecurity});
    }

    public TestContainerManagerSecurity(Configuration conf) {
        conf.setLong("yarn.am.liveness-monitor.expiry-interval-ms", 100000L);
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.conf = conf;
    }

    @Test(timeout=1000000L)
    public void testContainerManager() throws Exception {
        try {
            yarnCluster = new MiniYARNCluster(TestContainerManagerSecurity.class.getName(), 1, 1, 1);
            yarnCluster.init(this.conf);
            yarnCluster.start();
            this.testNMTokens(this.conf);
            this.testContainerToken(this.conf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (yarnCluster != null) {
                yarnCluster.stop();
                yarnCluster = null;
            }
        }
    }

    private void testNMTokens(Configuration conf) throws Exception {
        NMTokenSecretManagerInRM nmTokenSecretManagerRM = yarnCluster.getResourceManager().getRMContext().getNMTokenSecretManager();
        NMTokenSecretManagerInNM nmTokenSecretManagerNM = yarnCluster.getNodeManager(0).getNMContext().getNMTokenSecretManager();
        RMContainerTokenSecretManager containerTokenSecretManager = yarnCluster.getResourceManager().getRMContext().getContainerTokenSecretManager();
        NodeManager nm = yarnCluster.getNodeManager(0);
        this.waitForNMToReceiveNMTokenKey(nmTokenSecretManagerNM, nm);
        junit.framework.Assert.assertEquals((int)nmTokenSecretManagerNM.getCurrentKey().getKeyId(), (int)nmTokenSecretManagerRM.getCurrentKey().getKeyId());
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        String user = "test";
        Resource r = Resource.newInstance((int)1024, (int)1);
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId validAppAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ApplicationAttemptId invalidAppAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        ContainerId validContainerId = ContainerId.newInstance((ApplicationAttemptId)validAppAttemptId, (int)0);
        NodeId validNode = yarnCluster.getNodeManager(0).getNMContext().getNodeId();
        NodeId invalidNode = NodeId.newInstance((String)"InvalidHost", (int)1234);
        Token validNMToken = nmTokenSecretManagerRM.createNMToken(validAppAttemptId, validNode, user);
        Token validContainerToken = containerTokenSecretManager.createContainerToken(validContainerId, validNode, user, r);
        NMTokenSecretManagerInRM tempManager = new NMTokenSecretManagerInRM(conf);
        tempManager.rollMasterKey();
        do {
            tempManager.rollMasterKey();
            tempManager.activateNextMasterKey();
        } while (tempManager.getCurrentKey().getKeyId() == nmTokenSecretManagerRM.getCurrentKey().getKeyId());
        StringBuilder sb = UserGroupInformation.isSecurityEnabled() ? new StringBuilder("Client cannot authenticate via:[TOKEN]") : new StringBuilder("SIMPLE authentication is not enabled.  Available:[TOKEN]");
        String errorMsg = this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, null, true);
        junit.framework.Assert.assertTrue((boolean)errorMsg.contains(sb.toString()));
        Token invalidNMToken = tempManager.createNMToken(validAppAttemptId, validNode, user);
        sb = new StringBuilder("Given NMToken for application : ");
        sb.append(validAppAttemptId.toString()).append(" seems to have been generated illegally.");
        junit.framework.Assert.assertTrue((boolean)sb.toString().contains(this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, invalidNMToken, true)));
        invalidNMToken = nmTokenSecretManagerRM.createNMToken(validAppAttemptId, invalidNode, user);
        sb = new StringBuilder("Given NMToken for application : ");
        sb.append(validAppAttemptId).append(" is not valid for current node manager.expected : ").append(validNode.toString()).append(" found : ").append(invalidNode.toString());
        junit.framework.Assert.assertTrue((boolean)sb.toString().contains(this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, invalidNMToken, true)));
        invalidNMToken = nmTokenSecretManagerRM.createNMToken(invalidAppAttemptId, validNode, user);
        sb = new StringBuilder("\nNMToken for application attempt : ");
        sb.append(invalidAppAttemptId.toString()).append(" was used for starting container with container token").append(" issued for application attempt : ").append(validAppAttemptId.toString());
        junit.framework.Assert.assertTrue((boolean)this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, invalidNMToken, true).contains(sb.toString()));
        conf.setInt("yarn.resourcemanager.rm.container-allocation.expiry-interval-ms", 240000);
        validContainerToken = containerTokenSecretManager.createContainerToken(validContainerId, validNode, user, r);
        this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, validNMToken, false);
        junit.framework.Assert.assertTrue((boolean)nmTokenSecretManagerNM.isAppAttemptNMTokenKeyPresent(validAppAttemptId));
        this.waitForContainerToFinishOnNM(validContainerId);
        sb = new StringBuilder("Attempt to relaunch the same container with id ");
        sb.append(validContainerId);
        junit.framework.Assert.assertTrue((boolean)this.testStartContainer(rpc, validAppAttemptId, validNode, validContainerToken, validNMToken, true).contains(sb.toString()));
        this.testStopContainer(rpc, validAppAttemptId, validNode, validContainerId, validNMToken, false);
        this.rollNMTokenMasterKey(nmTokenSecretManagerRM, nmTokenSecretManagerNM);
        this.rollNMTokenMasterKey(nmTokenSecretManagerRM, nmTokenSecretManagerNM);
        sb = new StringBuilder("Container ");
        sb.append(validContainerId);
        sb.append(" was recently stopped on node manager");
        junit.framework.Assert.assertTrue((boolean)this.testGetContainer(rpc, validAppAttemptId, validNode, validContainerId, validNMToken, true).contains(sb.toString()));
        nm.getNodeStatusUpdater().clearFinishedContainersFromCache();
        sb = new StringBuilder("Container ");
        sb.append(validContainerId.toString());
        sb.append(" is not handled by this NodeManager");
        junit.framework.Assert.assertTrue((boolean)this.testGetContainer(rpc, validAppAttemptId, validNode, validContainerId, validNMToken, false).contains(sb.toString()));
    }

    private void waitForContainerToFinishOnNM(ContainerId containerId) {
        Context nmContet = yarnCluster.getNodeManager(0).getNMContext();
        int interval = 240;
        while (interval-- > 0 && nmContet.getContainers().containsKey(containerId)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        junit.framework.Assert.assertFalse((boolean)nmContet.getContainers().containsKey(containerId));
    }

    protected void waitForNMToReceiveNMTokenKey(NMTokenSecretManagerInNM nmTokenSecretManagerNM, NodeManager nm) throws InterruptedException {
        int attempt = 60;
        ContainerManagerImpl cm = (ContainerManagerImpl)nm.getNMContext().getContainerManager();
        while ((cm.getBlockNewContainerRequestsStatus() || nmTokenSecretManagerNM.getNodeId() == null) && attempt-- > 0) {
            Thread.sleep(2000L);
        }
    }

    protected void rollNMTokenMasterKey(NMTokenSecretManagerInRM nmTokenSecretManagerRM, NMTokenSecretManagerInNM nmTokenSecretManagerNM) throws Exception {
        int oldKeyId = nmTokenSecretManagerRM.getCurrentKey().getKeyId();
        nmTokenSecretManagerRM.rollMasterKey();
        int interval = 40;
        while (nmTokenSecretManagerNM.getCurrentKey().getKeyId() == oldKeyId && interval-- > 0) {
            Thread.sleep(1000L);
        }
        nmTokenSecretManagerRM.activateNextMasterKey();
        junit.framework.Assert.assertTrue((nmTokenSecretManagerNM.getCurrentKey().getKeyId() == nmTokenSecretManagerRM.getCurrentKey().getKeyId() ? 1 : 0) != 0);
    }

    private String testStopContainer(YarnRPC rpc, ApplicationAttemptId appAttemptId, NodeId nodeId, ContainerId containerId, Token nmToken, boolean isExceptionExpected) {
        try {
            this.stopContainer(rpc, nmToken, Arrays.asList(containerId), appAttemptId, nodeId);
            if (isExceptionExpected) {
                Assert.fail((String)"Exception was expected!!");
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private String testGetContainer(YarnRPC rpc, ApplicationAttemptId appAttemptId, NodeId nodeId, ContainerId containerId, Token nmToken, boolean isExceptionExpected) {
        try {
            this.getContainerStatus(rpc, nmToken, containerId, appAttemptId, nodeId, isExceptionExpected);
            if (isExceptionExpected) {
                Assert.fail((String)"Exception was expected!!");
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private String testStartContainer(YarnRPC rpc, ApplicationAttemptId appAttemptId, NodeId nodeId, Token containerToken, Token nmToken, boolean isExceptionExpected) {
        try {
            this.startContainer(rpc, nmToken, containerToken, nodeId, appAttemptId.toString());
            if (isExceptionExpected) {
                Assert.fail((String)"Exception was expected!!");
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private void stopContainer(YarnRPC rpc, Token nmToken, List<ContainerId> containerId, ApplicationAttemptId appAttemptId, NodeId nodeId) throws Exception {
        block3: {
            StopContainersRequest request = StopContainersRequest.newInstance(containerId);
            ContainerManagementProtocol proxy = null;
            try {
                proxy = this.getContainerManagementProtocolProxy(rpc, nmToken, nodeId, appAttemptId.toString());
                StopContainersResponse response = proxy.stopContainers(request);
                if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                    this.parseAndThrowException(((SerializedException)response.getFailedRequests().get(containerId)).deSerialize());
                }
            }
            catch (Exception e) {
                if (proxy == null) break block3;
                rpc.stopProxy((Object)proxy, this.conf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getContainerStatus(YarnRPC rpc, Token nmToken, ContainerId containerId, ApplicationAttemptId appAttemptId, NodeId nodeId, boolean isExceptionExpected) throws Exception {
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        GetContainerStatusesRequest request = GetContainerStatusesRequest.newInstance(containerIds);
        ContainerManagementProtocol proxy = null;
        try {
            proxy = this.getContainerManagementProtocolProxy(rpc, nmToken, nodeId, appAttemptId.toString());
            GetContainerStatusesResponse statuses = proxy.getContainerStatuses(request);
            if (statuses.getFailedRequests() != null && statuses.getFailedRequests().containsKey(containerId)) {
                this.parseAndThrowException(((SerializedException)statuses.getFailedRequests().get(containerId)).deSerialize());
            }
        }
        finally {
            if (proxy != null) {
                rpc.stopProxy((Object)proxy, this.conf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainer(YarnRPC rpc, Token nmToken, Token containerToken, NodeId nodeId, String user) throws Exception {
        ContainerLaunchContext context = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        StartContainerRequest scRequest = StartContainerRequest.newInstance((ContainerLaunchContext)context, (Token)containerToken);
        ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
        list.add(scRequest);
        StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
        ContainerManagementProtocol proxy = null;
        try {
            proxy = this.getContainerManagementProtocolProxy(rpc, nmToken, nodeId, user);
            StartContainersResponse response = proxy.startContainers(allRequests);
            for (SerializedException ex : response.getFailedRequests().values()) {
                this.parseAndThrowException(ex.deSerialize());
            }
        }
        finally {
            if (proxy != null) {
                rpc.stopProxy((Object)proxy, this.conf);
            }
        }
    }

    private void parseAndThrowException(Throwable t) throws YarnException, IOException {
        if (t instanceof YarnException) {
            throw (YarnException)t;
        }
        if (t instanceof SecretManager.InvalidToken) {
            throw (SecretManager.InvalidToken)t;
        }
        throw (IOException)t;
    }

    protected ContainerManagementProtocol getContainerManagementProtocolProxy(final YarnRPC rpc, Token nmToken, NodeId nodeId, String user) {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        final InetSocketAddress addr = NetUtils.createSocketAddr((String)nodeId.getHost(), (int)nodeId.getPort());
        if (nmToken != null) {
            ugi.addToken(ConverterUtils.convertFromYarn((Token)nmToken, (InetSocketAddress)addr));
        }
        ContainerManagementProtocol proxy = (ContainerManagementProtocol)ugi.doAs((PrivilegedAction)new PrivilegedAction<ContainerManagementProtocol>(){

            @Override
            public ContainerManagementProtocol run() {
                return (ContainerManagementProtocol)rpc.getProxy(ContainerManagementProtocol.class, addr, TestContainerManagerSecurity.this.conf);
            }
        });
        return proxy;
    }

    private void testContainerToken(Configuration conf) throws IOException, InterruptedException, YarnException {
        LOG.info((Object)"Running test for malice user");
        NMTokenSecretManagerInRM nmTokenSecretManagerInRM = yarnCluster.getResourceManager().getRMContext().getNMTokenSecretManager();
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        ContainerId cId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)0);
        NodeManager nm = yarnCluster.getNodeManager(0);
        NMTokenSecretManagerInNM nmTokenSecretManagerInNM = nm.getNMContext().getNMTokenSecretManager();
        String user = "test";
        this.waitForNMToReceiveNMTokenKey(nmTokenSecretManagerInNM, nm);
        NodeId nodeId = nm.getNMContext().getNodeId();
        junit.framework.Assert.assertEquals((int)nmTokenSecretManagerInNM.getCurrentKey().getKeyId(), (int)nmTokenSecretManagerInRM.getCurrentKey().getKeyId());
        RMContainerTokenSecretManager containerTokenSecretManager = yarnCluster.getResourceManager().getRMContext().getContainerTokenSecretManager();
        RMContainerTokenSecretManager tamperedContainerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        tamperedContainerTokenSecretManager.rollMasterKey();
        do {
            tamperedContainerTokenSecretManager.rollMasterKey();
            tamperedContainerTokenSecretManager.activateNextMasterKey();
        } while (containerTokenSecretManager.getCurrentKey().getKeyId() == tamperedContainerTokenSecretManager.getCurrentKey().getKeyId());
        Resource r = Resource.newInstance((int)1230, (int)2);
        Token containerToken = tamperedContainerTokenSecretManager.createContainerToken(cId, nodeId, user, r);
        Token nmToken = nmTokenSecretManagerInRM.createNMToken(appAttemptId, nodeId, user);
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        StringBuilder sb = new StringBuilder("Given Container ");
        sb.append(cId);
        sb.append(" seems to have an illegally generated token.");
        junit.framework.Assert.assertTrue((boolean)this.testStartContainer(rpc, appAttemptId, nodeId, containerToken, nmToken, true).contains(sb.toString()));
    }

    static {
        testRootDir = new File("target", TestContainerManagerSecurity.class.getName() + "-root");
        httpSpnegoKeytabFile = new File(testRootDir, "httpSpnegoKeytabFile.keytab");
        httpSpnegoPrincipal = "HTTP/localhost@EXAMPLE.COM";
    }
}

