/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerEventLog;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.MaxRunningAppsEnforcer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.WeightAdjuster;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.DiskBasedResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class FairScheduler
extends AbstractYarnScheduler<FSSchedulerApp, FSSchedulerNode> {
    private FairSchedulerConfiguration conf;
    private Resource incrAllocation;
    private QueueManager queueMgr;
    private Clock clock;
    private boolean usePortForNodeName;
    private static final Log LOG = LogFactory.getLog(FairScheduler.class);
    private static final ResourceCalculator RESOURCE_CALCULATOR = new DiskBasedResourceCalculator();
    public static final Resource CONTAINER_RESERVED = Resources.createResource((int)-1);
    protected long UPDATE_INTERVAL = 500L;
    private Thread updateThread;
    private Thread schedulingThread;
    protected final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    FSQueueMetrics rootMetrics;
    protected long lastPreemptionUpdateTime;
    private long lastPreemptCheckTime;
    protected boolean preemptionEnabled;
    protected float preemptionUtilizationThreshold;
    protected long preemptionInterval;
    protected long waitTimeBeforeKill;
    private List<RMContainer> warnedContainers = new ArrayList<RMContainer>();
    protected boolean sizeBasedWeight;
    protected WeightAdjuster weightAdjuster;
    protected boolean continuousSchedulingEnabled;
    protected int continuousSchedulingSleepMs;
    private Comparator<NodeId> nodeAvailableResourceComparator = new NodeAvailableResourceComparator();
    protected double nodeLocalityThreshold;
    protected double rackLocalityThreshold;
    protected long nodeLocalityDelayMs;
    protected long rackLocalityDelayMs;
    private FairSchedulerEventLog eventLog;
    protected boolean assignMultiple;
    protected int maxAssign;
    @VisibleForTesting
    final MaxRunningAppsEnforcer maxRunningEnforcer;
    private AllocationFileLoaderService allocsLoader;
    @VisibleForTesting
    AllocationConfiguration allocConf;

    public FairScheduler() {
        super(FairScheduler.class.getName());
        this.clock = new SystemClock();
        this.allocsLoader = new AllocationFileLoaderService();
        this.queueMgr = new QueueManager(this);
        this.maxRunningEnforcer = new MaxRunningAppsEnforcer(this);
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem < 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min should equal greater than 0" + ", max should be no smaller than min.");
        }
        int minVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores < 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration, yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ", min should equal greater than 0" + ", max should be no smaller than min.");
        }
        double minDisk = conf.getDouble("yarn.scheduler.minimum-allocation-disks", 0.0);
        double maxDisk = conf.getDouble("yarn.scheduler.maximum-allocation-disks", 4.0);
        if (minDisk < 0.0 || minDisk > maxDisk) {
            throw new YarnRuntimeException("Invalid resource scheduler disk allocation configuration, yarn.scheduler.minimum-allocation-disks=" + minDisk + ", " + "yarn.scheduler.maximum-allocation-disks" + "=" + maxDisk + ", min should equal greater than 0" + ", max should be no smaller than min.");
        }
    }

    public FairSchedulerConfiguration getConf() {
        return this.conf;
    }

    public QueueManager getQueueManager() {
        return this.queueMgr;
    }

    protected synchronized void update() {
        this.updatePreemptionVariables();
        FSParentQueue rootQueue = this.queueMgr.getRootQueue();
        ((Schedulable)rootQueue).updateDemand();
        rootQueue.setFairShare(this.clusterResource);
        ((FSQueue)rootQueue).recomputeShares();
    }

    private void updatePreemptionVariables() {
        long now;
        this.lastPreemptionUpdateTime = now = this.clock.getTime();
        for (FSLeafQueue sched : this.queueMgr.getLeafQueues()) {
            if (!this.isStarvedForMinShare(sched)) {
                sched.setLastTimeAtMinShare(now);
            }
            if (this.isStarvedForFairShare(sched)) continue;
            sched.setLastTimeAtHalfFairShare(now);
        }
    }

    boolean isStarvedForMinShare(FSLeafQueue sched) {
        Resource desiredShare = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)sched.getMinShare(), (Resource)sched.getDemand());
        return Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)sched.getResourceUsage(), (Resource)desiredShare);
    }

    boolean isStarvedForFairShare(FSLeafQueue sched) {
        Resource desiredFairShare = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)Resources.multiply((Resource)sched.getFairShare(), (double)0.5), (Resource)sched.getDemand());
        return Resources.lessThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)sched.getResourceUsage(), (Resource)desiredFairShare);
    }

    protected synchronized void preemptTasksIfNecessary() {
        if (!this.shouldAttemptPreemption()) {
            return;
        }
        long curTime = this.clock.getTime();
        if (curTime - this.lastPreemptCheckTime < this.preemptionInterval) {
            return;
        }
        this.lastPreemptCheckTime = curTime;
        Resource resToPreempt = Resources.clone((Resource)Resources.none());
        for (FSLeafQueue sched : this.queueMgr.getLeafQueues()) {
            Resources.addTo((Resource)resToPreempt, (Resource)this.resToPreempt(sched, curTime));
        }
        if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)resToPreempt, (Resource)Resources.none())) {
            this.preemptResources(resToPreempt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preemptResources(Resource toPreempt) {
        RMContainer container;
        if (Resources.equals((Resource)toPreempt, (Resource)Resources.none())) {
            return;
        }
        Iterator<RMContainer> warnedIter = this.warnedContainers.iterator();
        while (warnedIter.hasNext()) {
            container = warnedIter.next();
            if ((container.getState() == RMContainerState.RUNNING || container.getState() == RMContainerState.ALLOCATED) && Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)toPreempt, (Resource)Resources.none())) {
                this.warnOrKillContainer(container);
                Resources.subtractFrom((Resource)toPreempt, (Resource)container.getContainer().getResource());
                continue;
            }
            warnedIter.remove();
        }
        try {
            for (FSLeafQueue queue : this.getQueueManager().getLeafQueues()) {
                for (AppSchedulable app : queue.getRunnableAppSchedulables()) {
                    app.getApp().resetPreemptedResources();
                }
            }
            while (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)toPreempt, (Resource)Resources.none())) {
                container = this.getQueueManager().getRootQueue().preemptContainer();
                if (container == null) {
                    break;
                }
                this.warnOrKillContainer(container);
                this.warnedContainers.add(container);
                Resources.subtractFrom((Resource)toPreempt, (Resource)container.getContainer().getResource());
            }
        }
        finally {
            for (FSLeafQueue queue : this.getQueueManager().getLeafQueues()) {
                for (AppSchedulable app : queue.getRunnableAppSchedulables()) {
                    app.getApp().clearPreemptedResources();
                }
            }
        }
    }

    protected void warnOrKillContainer(RMContainer container) {
        ApplicationAttemptId appAttemptId = container.getApplicationAttemptId();
        FSSchedulerApp app = this.getSchedulerApp(appAttemptId);
        FSLeafQueue queue = app.getQueue();
        LOG.info((Object)("Preempting container (prio=" + container.getContainer().getPriority() + "res=" + container.getContainer().getResource() + ") from queue " + queue.getName()));
        Long time = app.getContainerPreemptionTime(container);
        if (time != null) {
            if (time + this.waitTimeBeforeKill < this.clock.getTime()) {
                ContainerStatus status = SchedulerUtils.createPreemptedContainerStatus(container.getContainerId(), "Container preempted by scheduler");
                this.recoverResourceRequestForContainer(container);
                this.completedContainer(container, status, RMContainerEventType.KILL);
                LOG.info((Object)("Killing container" + container + " (after waiting for premption for " + (this.clock.getTime() - time) + "ms)"));
            }
        } else {
            app.addPreemption(container, this.clock.getTime());
        }
    }

    protected Resource resToPreempt(FSLeafQueue sched, long curTime) {
        Resource resToPreempt;
        Resource target;
        String queue = sched.getName();
        long minShareTimeout = this.allocConf.getMinSharePreemptionTimeout(queue);
        long fairShareTimeout = this.allocConf.getFairSharePreemptionTimeout();
        Resource resDueToMinShare = Resources.none();
        Resource resDueToFairShare = Resources.none();
        if (curTime - sched.getLastTimeAtMinShare() > minShareTimeout) {
            target = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)sched.getMinShare(), (Resource)sched.getDemand());
            resDueToMinShare = Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)Resources.none(), (Resource)Resources.subtract((Resource)target, (Resource)sched.getResourceUsage()));
        }
        if (curTime - sched.getLastTimeAtHalfFairShare() > fairShareTimeout) {
            target = Resources.min((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)sched.getFairShare(), (Resource)sched.getDemand());
            resDueToFairShare = Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)Resources.none(), (Resource)Resources.subtract((Resource)target, (Resource)sched.getResourceUsage()));
        }
        if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)(resToPreempt = Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)resDueToMinShare, (Resource)resDueToFairShare)), (Resource)Resources.none())) {
            String message = "Should preempt " + resToPreempt + " res for queue " + sched.getName() + ": resDueToMinShare = " + resDueToMinShare + ", resDueToFairShare = " + resDueToFairShare;
            LOG.info((Object)message);
        }
        return resToPreempt;
    }

    public synchronized RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    public synchronized ResourceWeights getAppWeight(AppSchedulable app) {
        double weight = 1.0;
        if (this.sizeBasedWeight) {
            weight = Math.log1p(app.getDemand().getMemory()) / Math.log(2.0);
        }
        weight *= (double)app.getPriority().getPriority();
        if (this.weightAdjuster != null) {
            weight = this.weightAdjuster.adjustWeight(app, weight);
        }
        ResourceWeights resourceWeights = app.getResourceWeights();
        resourceWeights.setWeight((float)weight);
        return resourceWeights;
    }

    public Resource getIncrementResourceCapability() {
        return this.incrAllocation;
    }

    private FSSchedulerNode getFSSchedulerNode(NodeId nodeId) {
        return (FSSchedulerNode)this.nodes.get(nodeId);
    }

    public double getNodeLocalityThreshold() {
        return this.nodeLocalityThreshold;
    }

    public double getRackLocalityThreshold() {
        return this.rackLocalityThreshold;
    }

    public long getNodeLocalityDelayMs() {
        return this.nodeLocalityDelayMs;
    }

    public long getRackLocalityDelayMs() {
        return this.rackLocalityDelayMs;
    }

    public boolean isContinuousSchedulingEnabled() {
        return this.continuousSchedulingEnabled;
    }

    public synchronized int getContinuousSchedulingSleepMs() {
        return this.continuousSchedulingSleepMs;
    }

    public synchronized Clock getClock() {
        return this.clock;
    }

    protected synchronized void setClock(Clock clock) {
        this.clock = clock;
    }

    public FairSchedulerEventLog getEventLog() {
        return this.eventLog;
    }

    protected synchronized void addApplication(ApplicationId applicationId, String queueName, String user) {
        if (queueName == null || queueName.isEmpty()) {
            String message = "Reject application " + applicationId + " submitted by user " + user + " with an empty queue name.";
            LOG.info((Object)message);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(applicationId, message));
            return;
        }
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationId);
        FSLeafQueue queue = this.assignToQueue(rmApp, queueName, user);
        if (queue == null) {
            return;
        }
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)user);
        if (!queue.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi) && !queue.hasAccess(QueueACL.ADMINISTER_QUEUE, userUgi)) {
            String msg = "User " + userUgi.getUserName() + " cannot submit applications to queue " + queue.getName();
            LOG.info((Object)msg);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(applicationId, msg));
            return;
        }
        SchedulerApplication application = new SchedulerApplication(queue, user);
        this.applications.put(applicationId, application);
        queue.getMetrics().submitApp(user);
        LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queueName + ", currently num of applications: " + this.applications.size()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
    }

    protected synchronized void addApplicationAttempt(ApplicationAttemptId applicationAttemptId, boolean transferStateFromPreviousAttempt, boolean shouldNotifyAttemptAdded) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        String user = application.getUser();
        FSLeafQueue queue = (FSLeafQueue)application.getQueue();
        FSSchedulerApp attempt = new FSSchedulerApp(applicationAttemptId, user, queue, new ActiveUsersManager(this.getRootQueueMetrics()), this.rmContext);
        if (transferStateFromPreviousAttempt) {
            attempt.transferStateFromPreviousAttempt((SchedulerApplicationAttempt)application.getCurrentAppAttempt());
        }
        application.setCurrentAppAttempt(attempt);
        boolean runnable = this.maxRunningEnforcer.canAppBeRunnable(queue, user);
        queue.addApp(attempt, runnable);
        if (runnable) {
            this.maxRunningEnforcer.trackRunnableApp(attempt);
        } else {
            this.maxRunningEnforcer.trackNonRunnableApp(attempt);
        }
        queue.getMetrics().submitAppAttempt(user);
        LOG.info((Object)("Added Application Attempt " + applicationAttemptId + " to scheduler from user: " + user));
        if (shouldNotifyAttemptAdded) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Skipping notifying ATTEMPT_ADDED");
        }
    }

    @VisibleForTesting
    FSLeafQueue assignToQueue(RMApp rmApp, String queueName, String user) {
        FSLeafQueue queue = null;
        String appRejectMsg = null;
        try {
            QueuePlacementPolicy placementPolicy = this.allocConf.getPlacementPolicy();
            queueName = placementPolicy.assignAppToQueue(queueName, user);
            if (queueName == null) {
                appRejectMsg = "Application rejected by queue placement policy";
            } else {
                queue = this.queueMgr.getLeafQueue(queueName, true);
                if (queue == null) {
                    appRejectMsg = queueName + " is not a leaf queue";
                }
            }
        }
        catch (IOException ioe) {
            appRejectMsg = "Error assigning app to queue " + queueName;
        }
        if (appRejectMsg != null && rmApp != null) {
            LOG.error((Object)appRejectMsg);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppRejectedEvent(rmApp.getApplicationId(), appRejectMsg));
            return null;
        }
        if (rmApp != null) {
            rmApp.setQueue(queue.getName());
        } else {
            LOG.error((Object)"Couldn't find RM app to set queue name on");
        }
        return queue;
    }

    private synchronized void removeApplication(ApplicationId applicationId, RMAppState finalState) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
        if (application == null) {
            LOG.warn((Object)("Couldn't find application " + applicationId));
            return;
        }
        application.stop(finalState);
        this.applications.remove(applicationId);
    }

    private synchronized void removeApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) {
        LOG.info((Object)("Application " + applicationAttemptId + " is done." + " finalState=" + (Object)((Object)rmAppAttemptFinalState)));
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        FSSchedulerApp attempt = this.getSchedulerApp(applicationAttemptId);
        if (attempt == null || application == null) {
            LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
            return;
        }
        for (RMContainer rmContainer : attempt.getLiveContainers()) {
            if (keepContainers && rmContainer.getState().equals((Object)RMContainerState.RUNNING)) {
                LOG.info((Object)("Skip killing " + rmContainer.getContainerId()));
                continue;
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        for (RMContainer rmContainer : attempt.getReservedContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
        }
        attempt.stop(rmAppAttemptFinalState);
        FSLeafQueue queue = this.queueMgr.getLeafQueue(attempt.getQueue().getQueueName(), false);
        boolean wasRunnable = queue.removeApp(attempt);
        if (wasRunnable) {
            this.maxRunningEnforcer.untrackRunnableApp(attempt);
            this.maxRunningEnforcer.updateRunnabilityOnAppRemoval(attempt, attempt.getQueue());
        } else {
            this.maxRunningEnforcer.untrackNonRunnableApp(attempt);
        }
    }

    private synchronized void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        FSSchedulerApp application = (FSSchedulerApp)this.getCurrentAttemptForContainer(container.getId());
        ApplicationId appId = container.getId().getApplicationAttemptId().getApplicationId();
        if (application == null) {
            LOG.info((Object)("Container " + container + " of" + " unknown application attempt " + appId + " completed with event " + (Object)((Object)event)));
            return;
        }
        FSSchedulerNode node = this.getFSSchedulerNode(container.getNodeId());
        if (rmContainer.getState() == RMContainerState.RESERVED) {
            application.unreserve(node, rmContainer.getReservedPriority());
            node.unreserveResource(application);
        } else {
            application.containerCompleted(rmContainer, containerStatus, event);
            node.releaseContainer(container);
            this.updateRootQueueMetrics();
        }
        LOG.info((Object)("Application attempt " + application.getApplicationAttemptId() + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
    }

    private synchronized void addNode(RMNode node) {
        this.nodes.put(node.getNodeID(), new FSSchedulerNode(node, this.usePortForNodeName));
        Resources.addTo((Resource)this.clusterResource, (Resource)node.getTotalCapability());
        this.updateRootQueueMetrics();
        LOG.info((Object)("Added node " + node.getNodeAddress() + " cluster capacity: " + this.clusterResource));
    }

    private synchronized void removeNode(RMNode rmNode) {
        FSSchedulerNode node = this.getFSSchedulerNode(rmNode.getNodeID());
        if (node == null) {
            return;
        }
        Resources.subtractFrom((Resource)this.clusterResource, (Resource)rmNode.getTotalCapability());
        this.updateRootQueueMetrics();
        List<RMContainer> runningContainers = node.getRunningContainers();
        for (RMContainer container : runningContainers) {
            this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            this.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(rmNode.getNodeID());
        LOG.info((Object)("Removed node " + rmNode.getNodeAddress() + " cluster capacity: " + this.clusterResource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Allocation allocate(ApplicationAttemptId appAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        FSSchedulerApp application = this.getSchedulerApp(appAttemptId);
        if (application == null) {
            LOG.info((Object)("Calling allocate on removed or non existant application " + appAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, (ResourceCalculator)new DiskBasedResourceCalculator(), this.clusterResource, this.minimumAllocation, this.maximumAllocation, this.incrAllocation);
        if (!application.getUnmanagedAM() && ask.size() == 1 && application.getLiveContainers().isEmpty()) {
            application.setAMResource(ask.get(0).getCapability());
        }
        for (ContainerId releasedContainerId : release) {
            RMContainer rmContainer = this.getRMContainer(releasedContainerId);
            if (rmContainer == null) {
                RMAuditLogger.logFailure(application.getUser(), "AM Released Container", "Unauthorized access or invalid container", "FairScheduler", "Trying to release container not owned by app or with invalid id", application.getApplicationId(), releasedContainerId);
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(releasedContainerId, "Container released by application"), RMContainerEventType.RELEASED);
        }
        FSSchedulerApp fSSchedulerApp = application;
        synchronized (fSSchedulerApp) {
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update applicationAttemptId=" + appAttemptId + " application=" + application.getApplicationId()));
                }
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)"allocate: post-update");
                application.showRequests();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: applicationAttemptId=" + appAttemptId + " #ask=" + ask.size()));
                LOG.debug((Object)("Preempting " + application.getPreemptionContainers().size() + " container(s)"));
            }
            HashSet<ContainerId> preemptionContainerIds = new HashSet<ContainerId>();
            for (RMContainer container : application.getPreemptionContainers()) {
                preemptionContainerIds.add(container.getContainerId());
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            SchedulerApplicationAttempt.ContainersAndNMTokensAllocation allocation = application.pullNewlyAllocatedContainersAndNMTokens();
            return new Allocation(allocation.getContainerList(), application.getHeadroom(), preemptionContainerIds, null, null, allocation.getNMTokenList());
        }
    }

    private void containerLaunchedOnNode(ContainerId containerId, FSSchedulerNode node) {
        FSSchedulerApp application = (FSSchedulerApp)this.getCurrentAttemptForContainer(containerId);
        if (application == null) {
            LOG.info((Object)("Unknown application " + containerId.getApplicationAttemptId().getApplicationId() + " launched container " + containerId + " on node: " + node));
            return;
        }
        application.containerLaunchedOnNode(containerId, node.getNodeID());
    }

    private synchronized void nodeUpdate(RMNode nm) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("nodeUpdate: " + nm + " cluster capacity: " + this.clusterResource));
        }
        this.eventLog.log("HEARTBEAT", nm.getHostName());
        FSSchedulerNode node = this.getFSSchedulerNode(nm.getNodeID());
        SchedulerUtils.updateResourceIfChanged(node, nm, this.clusterResource, LOG);
        List<UpdatedContainerInfo> containerInfoList = nm.pullContainerUpdates();
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.completedContainer(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        if (this.continuousSchedulingEnabled) {
            if (!completedContainers.isEmpty()) {
                this.attemptScheduling(node);
            }
        } else {
            this.attemptScheduling(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void continuousScheduling() {
        while (true) {
            ArrayList nodeIdList = new ArrayList(this.nodes.keySet());
            FairScheduler fairScheduler = this;
            synchronized (fairScheduler) {
                Collections.sort(nodeIdList, this.nodeAvailableResourceComparator);
            }
            for (NodeId nodeId : nodeIdList) {
                if (!this.nodes.containsKey(nodeId)) continue;
                FSSchedulerNode node = this.getFSSchedulerNode(nodeId);
                try {
                    if (!Resources.fitsIn((Resource)this.minimumAllocation, (Resource)node.getAvailableResource())) continue;
                    this.attemptScheduling(node);
                }
                catch (Throwable ex) {
                    LOG.warn((Object)("Error while attempting scheduling for node " + node + ": " + ex.toString()), ex);
                }
            }
            try {
                Thread.sleep(this.getContinuousSchedulingSleepMs());
                continue;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Error while doing sleep in continuous scheduling: " + e.toString()), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private synchronized void attemptScheduling(FSSchedulerNode node) {
        AppSchedulable reservedAppSchedulable = node.getReservedAppSchedulable();
        if (reservedAppSchedulable != null) {
            Priority reservedPriority = node.getReservedContainer().getReservedPriority();
            if (!reservedAppSchedulable.hasContainerForNode(reservedPriority, node)) {
                LOG.info((Object)("Releasing reservation that cannot be satisfied for application " + reservedAppSchedulable.getApp().getApplicationAttemptId() + " on node " + node));
                reservedAppSchedulable.unreserve(reservedPriority, node);
                reservedAppSchedulable = null;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Trying to fulfill reservation for application " + reservedAppSchedulable.getApp().getApplicationAttemptId() + " on node: " + node));
                }
                node.getReservedAppSchedulable().assignReservedContainer(node);
            }
        }
        if (reservedAppSchedulable == null) {
            int assignedContainers = 0;
            while (node.getReservedContainer() == null) {
                boolean assignedContainer = false;
                if (!this.queueMgr.getRootQueue().assignContainer(node).equals((Object)Resources.none())) {
                    ++assignedContainers;
                    assignedContainer = true;
                }
                if (assignedContainer && this.assignMultiple && (assignedContainers < this.maxAssign || this.maxAssign <= 0)) continue;
                break;
            }
        }
        this.updateRootQueueMetrics();
    }

    public FSSchedulerApp getSchedulerApp(ApplicationAttemptId appAttemptId) {
        return (FSSchedulerApp)super.getApplicationAttempt(appAttemptId);
    }

    private void updateRootQueueMetrics() {
        this.rootMetrics.setAvailableResourcesToQueue(Resources.subtract((Resource)this.clusterResource, (Resource)this.rootMetrics.getAllocatedResources()));
    }

    private boolean shouldAttemptPreemption() {
        if (this.preemptionEnabled) {
            return this.preemptionUtilizationThreshold < Math.max((float)this.rootMetrics.getAllocatedMB() / (float)this.clusterResource.getMemory(), (float)this.rootMetrics.getAllocatedVirtualCores() / (float)this.clusterResource.getVirtualCores());
        }
        return false;
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.rootMetrics;
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                if (!(event instanceof NodeAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                if (!(event instanceof NodeRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                if (!(event instanceof NodeUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ADDED: {
                if (!(event instanceof AppAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                this.addApplication(appAddedEvent.getApplicationId(), appAddedEvent.getQueue(), appAddedEvent.getUser());
                break;
            }
            case APP_REMOVED: {
                if (!(event instanceof AppRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.removeApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case APP_ATTEMPT_ADDED: {
                if (!(event instanceof AppAttemptAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt(), appAttemptAddedEvent.getShouldNotifyAttemptAdded());
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                if (!(event instanceof AppAttemptRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                this.removeApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                break;
            }
            case CONTAINER_EXPIRED: {
                if (!(event instanceof ContainerExpiredSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Unknown event arrived at FairScheduler: " + event.toString()));
            }
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public synchronized void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    private synchronized void initScheduler(Configuration conf) throws IOException {
        this.conf = new FairSchedulerConfiguration(conf);
        this.validateConf(this.conf);
        this.minimumAllocation = this.conf.getMinimumAllocation();
        this.maximumAllocation = this.conf.getMaximumAllocation();
        this.incrAllocation = this.conf.getIncrementAllocation();
        this.continuousSchedulingEnabled = this.conf.isContinuousSchedulingEnabled();
        this.continuousSchedulingSleepMs = this.conf.getContinuousSchedulingSleepMs();
        this.nodeLocalityThreshold = this.conf.getLocalityThresholdNode();
        this.rackLocalityThreshold = this.conf.getLocalityThresholdRack();
        this.nodeLocalityDelayMs = this.conf.getLocalityDelayNodeMs();
        this.rackLocalityDelayMs = this.conf.getLocalityDelayRackMs();
        this.preemptionEnabled = this.conf.getPreemptionEnabled();
        this.preemptionUtilizationThreshold = this.conf.getPreemptionUtilizationThreshold();
        this.assignMultiple = this.conf.getAssignMultiple();
        this.maxAssign = this.conf.getMaxAssign();
        this.sizeBasedWeight = this.conf.getSizeBasedWeight();
        this.preemptionInterval = this.conf.getPreemptionInterval();
        this.waitTimeBeforeKill = this.conf.getWaitTimeBeforeKill();
        this.usePortForNodeName = this.conf.getUsePortForNodeName();
        this.rootMetrics = FSQueueMetrics.forQueue("root", null, true, conf);
        this.applications = new ConcurrentHashMap();
        this.eventLog = new FairSchedulerEventLog();
        this.eventLog.init(this.conf);
        this.allocConf = new AllocationConfiguration(conf);
        try {
            this.queueMgr.initialize(conf);
        }
        catch (Exception e) {
            throw new IOException("Failed to start FairScheduler", e);
        }
        this.updateThread = new Thread(new UpdateThread());
        this.updateThread.setName("FairSchedulerUpdateThread");
        this.updateThread.setDaemon(true);
        if (this.continuousSchedulingEnabled) {
            this.schedulingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    FairScheduler.this.continuousScheduling();
                }
            });
            this.schedulingThread.setName("ContinuousScheduling");
            this.schedulingThread.setDaemon(true);
        }
        this.allocsLoader.init(conf);
        this.allocsLoader.setReloadListener(new AllocationReloadListener());
        try {
            this.allocsLoader.reloadAllocations();
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize FairScheduler", e);
        }
    }

    private synchronized void startSchedulerThreads() {
        Preconditions.checkNotNull((Object)this.updateThread, (Object)"updateThread is null");
        Preconditions.checkNotNull((Object)((Object)this.allocsLoader), (Object)"allocsLoader is null");
        this.updateThread.start();
        if (this.continuousSchedulingEnabled) {
            Preconditions.checkNotNull((Object)this.schedulingThread, (Object)"schedulingThread is null");
            this.schedulingThread.start();
        }
        this.allocsLoader.start();
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.initScheduler(conf);
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        this.startSchedulerThreads();
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            if (this.updateThread != null) {
                this.updateThread.interrupt();
                this.updateThread.join(1000L);
            }
            if (this.continuousSchedulingEnabled && this.schedulingThread != null) {
                this.schedulingThread.interrupt();
                this.schedulingThread.join(1000L);
            }
            if (this.allocsLoader != null) {
                this.allocsLoader.stop();
            }
        }
        super.serviceStop();
    }

    @Override
    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        try {
            this.allocsLoader.reloadAllocations();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to reload allocations file", (Throwable)e);
        }
    }

    @Override
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        if (!this.queueMgr.exists(queueName)) {
            throw new IOException("queue " + queueName + " does not exist");
        }
        return this.queueMgr.getQueue(queueName).getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user = null;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.queueMgr.getRootQueue().getQueueUserAclInfo(user);
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodes.size();
    }

    @Override
    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        FSQueue queue = this.getQueueManager().getQueue(queueName);
        if (queue == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ACL not found for queue access-type " + acl + " for queue " + queueName));
            }
            return false;
        }
        return queue.hasAccess(acl, callerUGI);
    }

    public AllocationConfiguration getAllocationConfiguration() {
        return this.allocConf;
    }

    @Override
    public List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        FSQueue queue = this.queueMgr.getQueue(queueName);
        if (queue == null) {
            return null;
        }
        ArrayList<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>();
        queue.collectSchedulerApplications(apps);
        return apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String moveApplication(ApplicationId appId, String queueName) throws YarnException {
        FSSchedulerApp attempt;
        SchedulerApplication app = (SchedulerApplication)this.applications.get(appId);
        if (app == null) {
            throw new YarnException("App to be moved " + appId + " not found.");
        }
        FSSchedulerApp fSSchedulerApp = attempt = (FSSchedulerApp)app.getCurrentAppAttempt();
        synchronized (fSSchedulerApp) {
            FSLeafQueue oldQueue = (FSLeafQueue)app.getQueue();
            FSLeafQueue targetQueue = this.queueMgr.getLeafQueue(queueName, false);
            if (targetQueue == null) {
                throw new YarnException("Target queue " + queueName + " not found or is not a leaf queue.");
            }
            if (targetQueue == oldQueue) {
                return oldQueue.getQueueName();
            }
            if (oldQueue.getRunnableAppSchedulables().contains(attempt.getAppSchedulable())) {
                this.verifyMoveDoesNotViolateConstraints(attempt, oldQueue, targetQueue);
            }
            this.executeMove(app, attempt, oldQueue, targetQueue);
            return targetQueue.getQueueName();
        }
    }

    private void verifyMoveDoesNotViolateConstraints(FSSchedulerApp app, FSLeafQueue oldQueue, FSLeafQueue targetQueue) throws YarnException {
        String queueName = targetQueue.getQueueName();
        ApplicationAttemptId appAttId = app.getApplicationAttemptId();
        FSQueue lowestCommonAncestor = this.findLowestCommonAncestorQueue(oldQueue, targetQueue);
        Resource consumption = app.getCurrentConsumption();
        for (FSQueue cur = targetQueue; cur != lowestCommonAncestor; cur = cur.getParent()) {
            if (cur.getNumRunnableApps() == this.allocConf.getQueueMaxApps(cur.getQueueName())) {
                throw new YarnException("Moving app attempt " + appAttId + " to queue " + queueName + " would violate queue maxRunningApps constraints on" + " queue " + cur.getQueueName());
            }
            if (Resources.fitsIn((Resource)Resources.add((Resource)cur.getResourceUsage(), (Resource)consumption), (Resource)cur.getMaxShare())) continue;
            throw new YarnException("Moving app attempt " + appAttId + " to queue " + queueName + " would violate queue maxShare constraints on" + " queue " + cur.getQueueName());
        }
    }

    private void executeMove(SchedulerApplication<FSSchedulerApp> app, FSSchedulerApp attempt, FSLeafQueue oldQueue, FSLeafQueue newQueue) {
        boolean wasRunnable = oldQueue.removeApp(attempt);
        boolean nowRunnable = this.maxRunningEnforcer.canAppBeRunnable(newQueue, attempt.getUser());
        if (wasRunnable && !nowRunnable) {
            throw new IllegalStateException("Should have already verified that app " + attempt.getApplicationId() + " would be runnable in new queue");
        }
        if (wasRunnable) {
            this.maxRunningEnforcer.untrackRunnableApp(attempt);
        } else if (nowRunnable) {
            this.maxRunningEnforcer.untrackNonRunnableApp(attempt);
        }
        attempt.move(newQueue);
        app.setQueue(newQueue);
        newQueue.addApp(attempt, nowRunnable);
        if (nowRunnable) {
            this.maxRunningEnforcer.trackRunnableApp(attempt);
        }
        if (wasRunnable) {
            this.maxRunningEnforcer.updateRunnabilityOnAppRemoval(attempt, oldQueue);
        }
    }

    @VisibleForTesting
    FSQueue findLowestCommonAncestorQueue(FSQueue queue1, FSQueue queue2) {
        String name1 = queue1.getName();
        String name2 = queue2.getName();
        int lastPeriodIndex = -1;
        for (int i = 0; i < Math.max(name1.length(), name2.length()); ++i) {
            if (name1.length() <= i || name2.length() <= i || name1.charAt(i) != name2.charAt(i)) {
                return this.queueMgr.getQueue(name1.substring(0, lastPeriodIndex));
            }
            if (name1.charAt(i) != '.') continue;
            lastPeriodIndex = i;
        }
        return queue1;
    }

    private class AllocationReloadListener
    implements AllocationFileLoaderService.Listener {
        private AllocationReloadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReload(AllocationConfiguration queueInfo) {
            FairScheduler fairScheduler = FairScheduler.this;
            synchronized (fairScheduler) {
                FairScheduler.this.allocConf = queueInfo;
                FairScheduler.this.allocConf.getDefaultSchedulingPolicy().initialize(FairScheduler.this.clusterResource);
                FairScheduler.this.queueMgr.updateAllocationConfiguration(FairScheduler.this.allocConf);
            }
        }
    }

    private class NodeAvailableResourceComparator
    implements Comparator<NodeId> {
        private NodeAvailableResourceComparator() {
        }

        @Override
        public int compare(NodeId n1, NodeId n2) {
            return RESOURCE_CALCULATOR.compare(FairScheduler.this.clusterResource, ((FSSchedulerNode)FairScheduler.this.nodes.get(n2)).getAvailableResource(), ((FSSchedulerNode)FairScheduler.this.nodes.get(n1)).getAvailableResource());
        }
    }

    private class UpdateThread
    implements Runnable {
        private UpdateThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(FairScheduler.this.UPDATE_INTERVAL);
                        FairScheduler.this.update();
                        FairScheduler.this.preemptTasksIfNecessary();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception in fair scheduler UpdateThread", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

