/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;

public class RMContextImpl
implements RMContext {
    private Dispatcher rmDispatcher;
    private final ConcurrentMap<ApplicationId, RMApp> applications;
    private final ConcurrentMap<NodeId, RMNode> nodes;
    private final ConcurrentMap<String, RMNode> inactiveNodes;
    private boolean isHAEnabled;
    private boolean isWorkPreservingRecoveryEnabled;
    private HAServiceProtocol.HAServiceState haServiceState;
    private AMLivelinessMonitor amLivelinessMonitor;
    private AMLivelinessMonitor amFinishingMonitor;
    private RMStateStore stateStore;
    private ContainerAllocationExpirer containerAllocationExpirer;
    private DelegationTokenRenewer delegationTokenRenewer;
    private AMRMTokenSecretManager amRMTokenSecretManager;
    private RMContainerTokenSecretManager containerTokenSecretManager;
    private NMTokenSecretManagerInRM nmTokenSecretManager;
    private ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager;
    private AdminService adminService;
    private ClientRMService clientRMService;
    private RMDelegationTokenSecretManager rmDelegationTokenSecretManager;
    private ResourceScheduler scheduler;
    private NodesListManager nodesListManager;
    private ResourceTrackerService resourceTrackerService;
    private ApplicationMasterService applicationMasterService;
    private RMApplicationHistoryWriter rmApplicationHistoryWriter;
    private ConfigurationProvider configurationProvider;
    private int epoch;

    public RMContextImpl() {
        this.applications = new ConcurrentHashMap<ApplicationId, RMApp>();
        this.nodes = new ConcurrentHashMap<NodeId, RMNode>();
        this.inactiveNodes = new ConcurrentHashMap<String, RMNode>();
        this.haServiceState = HAServiceProtocol.HAServiceState.INITIALIZING;
        this.stateStore = null;
    }

    @VisibleForTesting
    public RMContextImpl(Dispatcher rmDispatcher, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager appTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager, RMApplicationHistoryWriter rmApplicationHistoryWriter) {
        block2: {
            this();
            this.setDispatcher(rmDispatcher);
            this.setContainerAllocationExpirer(containerAllocationExpirer);
            this.setAMLivelinessMonitor(amLivelinessMonitor);
            this.setAMFinishingMonitor(amFinishingMonitor);
            this.setDelegationTokenRenewer(delegationTokenRenewer);
            this.setAMRMTokenSecretManager(appTokenSecretManager);
            this.setContainerTokenSecretManager(containerTokenSecretManager);
            this.setNMTokenSecretManager(nmTokenSecretManager);
            this.setClientToAMTokenSecretManager(clientToAMTokenSecretManager);
            this.setRMApplicationHistoryWriter(rmApplicationHistoryWriter);
            NullRMStateStore nullStore = new NullRMStateStore();
            nullStore.setRMDispatcher(rmDispatcher);
            try {
                nullStore.init((Configuration)new YarnConfiguration());
                this.setStateStore(nullStore);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        LocalConfigurationProvider provider = new LocalConfigurationProvider();
        this.setConfigurationProvider((ConfigurationProvider)provider);
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.rmDispatcher;
    }

    @Override
    public RMStateStore getStateStore() {
        return this.stateStore;
    }

    @Override
    public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
        return this.applications;
    }

    @Override
    public ConcurrentMap<NodeId, RMNode> getRMNodes() {
        return this.nodes;
    }

    @Override
    public ConcurrentMap<String, RMNode> getInactiveRMNodes() {
        return this.inactiveNodes;
    }

    @Override
    public ContainerAllocationExpirer getContainerAllocationExpirer() {
        return this.containerAllocationExpirer;
    }

    @Override
    public AMLivelinessMonitor getAMLivelinessMonitor() {
        return this.amLivelinessMonitor;
    }

    @Override
    public AMLivelinessMonitor getAMFinishingMonitor() {
        return this.amFinishingMonitor;
    }

    @Override
    public DelegationTokenRenewer getDelegationTokenRenewer() {
        return this.delegationTokenRenewer;
    }

    @Override
    public AMRMTokenSecretManager getAMRMTokenSecretManager() {
        return this.amRMTokenSecretManager;
    }

    @Override
    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.containerTokenSecretManager;
    }

    @Override
    public NMTokenSecretManagerInRM getNMTokenSecretManager() {
        return this.nmTokenSecretManager;
    }

    @Override
    public ResourceScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public NodesListManager getNodesListManager() {
        return this.nodesListManager;
    }

    @Override
    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.clientToAMTokenSecretManager;
    }

    @Override
    public AdminService getRMAdminService() {
        return this.adminService;
    }

    @VisibleForTesting
    public void setStateStore(RMStateStore store) {
        this.stateStore = store;
    }

    @Override
    public ClientRMService getClientRMService() {
        return this.clientRMService;
    }

    @Override
    public ApplicationMasterService getApplicationMasterService() {
        return this.applicationMasterService;
    }

    @Override
    public ResourceTrackerService getResourceTrackerService() {
        return this.resourceTrackerService;
    }

    void setHAEnabled(boolean isHAEnabled) {
        this.isHAEnabled = isHAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHAServiceState(HAServiceProtocol.HAServiceState haServiceState) {
        HAServiceProtocol.HAServiceState hAServiceState = haServiceState;
        synchronized (hAServiceState) {
            this.haServiceState = haServiceState;
        }
    }

    void setDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    void setRMAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    @Override
    public void setClientRMService(ClientRMService clientRMService) {
        this.clientRMService = clientRMService;
    }

    @Override
    public RMDelegationTokenSecretManager getRMDelegationTokenSecretManager() {
        return this.rmDelegationTokenSecretManager;
    }

    @Override
    public void setRMDelegationTokenSecretManager(RMDelegationTokenSecretManager delegationTokenSecretManager) {
        this.rmDelegationTokenSecretManager = delegationTokenSecretManager;
    }

    void setContainerAllocationExpirer(ContainerAllocationExpirer containerAllocationExpirer) {
        this.containerAllocationExpirer = containerAllocationExpirer;
    }

    void setAMLivelinessMonitor(AMLivelinessMonitor amLivelinessMonitor) {
        this.amLivelinessMonitor = amLivelinessMonitor;
    }

    void setAMFinishingMonitor(AMLivelinessMonitor amFinishingMonitor) {
        this.amFinishingMonitor = amFinishingMonitor;
    }

    void setContainerTokenSecretManager(RMContainerTokenSecretManager containerTokenSecretManager) {
        this.containerTokenSecretManager = containerTokenSecretManager;
    }

    void setNMTokenSecretManager(NMTokenSecretManagerInRM nmTokenSecretManager) {
        this.nmTokenSecretManager = nmTokenSecretManager;
    }

    void setScheduler(ResourceScheduler scheduler) {
        this.scheduler = scheduler;
    }

    void setDelegationTokenRenewer(DelegationTokenRenewer delegationTokenRenewer) {
        this.delegationTokenRenewer = delegationTokenRenewer;
    }

    void setClientToAMTokenSecretManager(ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        this.clientToAMTokenSecretManager = clientToAMTokenSecretManager;
    }

    void setAMRMTokenSecretManager(AMRMTokenSecretManager amRMTokenSecretManager) {
        this.amRMTokenSecretManager = amRMTokenSecretManager;
    }

    void setNodesListManager(NodesListManager nodesListManager) {
        this.nodesListManager = nodesListManager;
    }

    void setApplicationMasterService(ApplicationMasterService applicationMasterService) {
        this.applicationMasterService = applicationMasterService;
    }

    void setResourceTrackerService(ResourceTrackerService resourceTrackerService) {
        this.resourceTrackerService = resourceTrackerService;
    }

    @Override
    public boolean isHAEnabled() {
        return this.isHAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HAServiceProtocol.HAServiceState getHAServiceState() {
        HAServiceProtocol.HAServiceState hAServiceState = this.haServiceState;
        synchronized (hAServiceState) {
            return this.haServiceState;
        }
    }

    public void setWorkPreservingRecoveryEnabled(boolean enabled) {
        this.isWorkPreservingRecoveryEnabled = enabled;
    }

    @Override
    public boolean isWorkPreservingRecoveryEnabled() {
        return this.isWorkPreservingRecoveryEnabled;
    }

    @Override
    public RMApplicationHistoryWriter getRMApplicationHistoryWriter() {
        return this.rmApplicationHistoryWriter;
    }

    @Override
    public void setRMApplicationHistoryWriter(RMApplicationHistoryWriter rmApplicationHistoryWriter) {
        this.rmApplicationHistoryWriter = rmApplicationHistoryWriter;
    }

    @Override
    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    @Override
    public int getEpoch() {
        return this.epoch;
    }

    void setEpoch(int epoch) {
        this.epoch = epoch;
    }
}

