/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSLeafQueue {
    private FSLeafQueue schedulable = null;
    private Resource maxResource = Resources.createResource((int)10);

    @Before
    public void setup() throws IOException {
        FairScheduler scheduler = new FairScheduler();
        Configuration conf = this.createConfiguration();
        conf.set("yarn.scheduler.fair.assignmultiple", "false");
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.init(conf);
        ((AsyncDispatcher)resourceManager.getRMContext().getDispatcher()).start();
        scheduler.init(conf);
        scheduler.start();
        scheduler.reinitialize(conf, resourceManager.getRMContext());
        String queueName = "root.queue1";
        scheduler.allocConf = (AllocationConfiguration)Mockito.mock(AllocationConfiguration.class);
        Mockito.when((Object)scheduler.allocConf.getMaxResources(queueName)).thenReturn((Object)this.maxResource);
        Mockito.when((Object)scheduler.allocConf.getMinResources(queueName)).thenReturn((Object)Resources.none());
        this.schedulable = new FSLeafQueue(queueName, scheduler, null);
    }

    @Test
    public void testUpdateDemand() {
        AppSchedulable app = (AppSchedulable)Mockito.mock(AppSchedulable.class);
        Mockito.when((Object)app.getDemand()).thenReturn((Object)this.maxResource);
        this.schedulable.addAppSchedulable(app);
        this.schedulable.addAppSchedulable(app);
        this.schedulable.updateDemand();
        Assert.assertTrue((String)"Demand is greater than max allowed ", (boolean)Resources.equals((Resource)this.schedulable.getDemand(), (Resource)this.maxResource));
    }

    private Configuration createConfiguration() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        return conf;
    }
}

