/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.junit.Assert;
import org.junit.Test;

public class TestQueueParsing {
    private static final Log LOG = LogFactory.getLog(TestQueueParsing.class);
    private static final double DELTA = 1.0E-6;

    @Test
    public void testQueueParsing() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        RMContextImpl rmContext = new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)conf), new NMTokenSecretManagerInRM((Configuration)conf), new ClientToAMTokenSecretManagerInRM(), null);
        capacityScheduler.setConf((Configuration)conf);
        capacityScheduler.setRMContext((RMContext)rmContext);
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        capacityScheduler.reinitialize((Configuration)conf, (RMContext)rmContext);
        CSQueue a = capacityScheduler.getQueue("a");
        Assert.assertEquals((double)0.1, (double)a.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.15, (double)a.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue b1 = capacityScheduler.getQueue("b1");
        Assert.assertEquals((double)0.1, (double)b1.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((String)"Parent B has no MAX_CAP", (double)0.85, (double)b1.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        CSQueue c12 = capacityScheduler.getQueue("c12");
        Assert.assertEquals((double)0.1575, (double)c12.getAbsoluteCapacity(), (double)1.0E-6);
        Assert.assertEquals((double)0.26949999999999996, (double)c12.getAbsoluteMaximumCapacity(), (double)1.0E-6);
        capacityScheduler.stop();
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"a", "b", "c"});
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
        LOG.info((Object)"Setup top-level queues");
        String A1 = "root.a.a1";
        String A2 = "root.a.a2";
        conf.setQueues("root.a", new String[]{"a1", "a2"});
        conf.setCapacity("root.a.a1", 30.0f);
        conf.setMaximumCapacity("root.a.a1", 45.0f);
        conf.setCapacity("root.a.a2", 70.0f);
        conf.setMaximumCapacity("root.a.a2", 85.0f);
        String B1 = "root.b.b1";
        String B2 = "root.b.b2";
        String B3 = "root.b.b3";
        conf.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        conf.setCapacity("root.b.b1", 50.0f);
        conf.setMaximumCapacity("root.b.b1", 85.0f);
        conf.setCapacity("root.b.b2", 30.0f);
        conf.setMaximumCapacity("root.b.b2", 35.0f);
        conf.setCapacity("root.b.b3", 20.0f);
        conf.setMaximumCapacity("root.b.b3", 35.0f);
        String C1 = "root.c.c1";
        String C2 = "root.c.c2";
        String C3 = "root.c.c3";
        String C4 = "root.c.c4";
        conf.setQueues("root.c", new String[]{"c1", "c2", "c3", "c4"});
        conf.setCapacity("root.c.c1", 50.0f);
        conf.setMaximumCapacity("root.c.c1", 55.0f);
        conf.setCapacity("root.c.c2", 10.0f);
        conf.setMaximumCapacity("root.c.c2", 25.0f);
        conf.setCapacity("root.c.c3", 35.0f);
        conf.setMaximumCapacity("root.c.c3", 38.0f);
        conf.setCapacity("root.c.c4", 5.0f);
        conf.setMaximumCapacity("root.c.c4", 5.0f);
        LOG.info((Object)"Setup 2nd-level queues");
        String C11 = "root.c.c1.c11";
        String C12 = "root.c.c1.c12";
        String C13 = "root.c.c1.c13";
        conf.setQueues("root.c.c1", new String[]{"c11", "c12", "c13"});
        conf.setCapacity("root.c.c1.c11", 15.0f);
        conf.setMaximumCapacity("root.c.c1.c11", 30.0f);
        conf.setCapacity("root.c.c1.c12", 45.0f);
        conf.setMaximumCapacity("root.c.c1.c12", 70.0f);
        conf.setCapacity("root.c.c1.c13", 40.0f);
        conf.setMaximumCapacity("root.c.c1.c13", 40.0f);
        LOG.info((Object)"Setup 3rd-level queues");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRootQueueParsing() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setCapacity("root", 90.0f);
        CapacityScheduler capacityScheduler = new CapacityScheduler();
        capacityScheduler.setConf((Configuration)new YarnConfiguration());
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        capacityScheduler.reinitialize((Configuration)conf, null);
        capacityScheduler.stop();
    }

    public void testMaxCapacity() throws Exception {
        CapacityScheduler capacityScheduler;
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setQueues("root", new String[]{"a", "b", "c"});
        String A = "root.a";
        conf.setCapacity("root.a", 50.0f);
        conf.setMaximumCapacity("root.a", 60.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 50.0f);
        conf.setMaximumCapacity("root.b", 45.0f);
        boolean fail = false;
        try {
            capacityScheduler = new CapacityScheduler();
            capacityScheduler.setConf((Configuration)new YarnConfiguration());
            capacityScheduler.init((Configuration)conf);
            capacityScheduler.start();
            capacityScheduler.reinitialize((Configuration)conf, null);
        }
        catch (IllegalArgumentException iae) {
            fail = true;
        }
        Assert.assertTrue((String)"Didn't throw IllegalArgumentException for wrong maxCap", (boolean)fail);
        conf.setMaximumCapacity("root.b", 60.0f);
        capacityScheduler = new CapacityScheduler();
        capacityScheduler.setConf((Configuration)new YarnConfiguration());
        capacityScheduler.init((Configuration)conf);
        capacityScheduler.start();
        capacityScheduler.reinitialize((Configuration)conf, null);
        fail = false;
        try {
            LeafQueue a = (LeafQueue)capacityScheduler.getQueue("root.a");
            a.setMaxCapacity(45.0f);
        }
        catch (IllegalArgumentException iae) {
            fail = true;
        }
        Assert.assertTrue((String)"Didn't throw IllegalArgumentException for wrong setMaxCap", (boolean)fail);
        capacityScheduler.stop();
    }
}

