/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestLeafQueue {
    private static final Log LOG = LogFactory.getLog(TestLeafQueue.class);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    RMContext rmContext;
    CapacityScheduler cs;
    CapacitySchedulerConfiguration csConf;
    CapacitySchedulerContext csContext;
    CSQueue root;
    Map<String, CSQueue> queues = new HashMap();
    static final int GB = 1024;
    static final String DEFAULT_RACK = "/default";
    private final ResourceCalculator resourceCalculator = new DefaultResourceCalculator();
    private static final String A = "a";
    private static final String B = "b";
    private static final String C = "c";
    private static final String C1 = "c1";
    private static final String D = "d";
    private static final String E = "e";

    @Before
    public void setUp() throws Exception {
        CapacityScheduler spyCs = new CapacityScheduler();
        this.cs = (CapacityScheduler)Mockito.spy((Object)spyCs);
        this.rmContext = TestUtils.getMockRMContext();
        this.csConf = new CapacitySchedulerConfiguration();
        this.csConf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        String newRoot = "root" + System.currentTimeMillis();
        this.setupQueueConfiguration(this.csConf, newRoot);
        YarnConfiguration conf = new YarnConfiguration();
        this.cs.setConf((Configuration)conf);
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)this.csConf);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)3200));
        Mockito.when((Object)this.csContext.getApplicationComparator()).thenReturn((Object)CapacityScheduler.applicationComparator);
        Mockito.when((Object)this.csContext.getQueueComparator()).thenReturn((Object)CapacityScheduler.queueComparator);
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager((Configuration)conf);
        containerTokenSecretManager.rollMasterKey();
        Mockito.when((Object)this.csContext.getContainerTokenSecretManager()).thenReturn((Object)containerTokenSecretManager);
        this.root = CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (Map)this.queues, (Map)this.queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        this.cs.setRMContext(this.rmContext);
        this.cs.init((Configuration)this.csConf);
        this.cs.start();
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf, String newRoot) {
        conf.setQueues("root", new String[]{newRoot});
        conf.setMaximumCapacity("root", 100.0f);
        conf.setAcl("root", QueueACL.SUBMIT_APPLICATIONS, " ");
        String Q_newRoot = "root." + newRoot;
        conf.setQueues(Q_newRoot, new String[]{"a", "b", "c", "d", "e"});
        conf.setCapacity(Q_newRoot, 100.0f);
        conf.setMaximumCapacity(Q_newRoot, 100.0f);
        conf.setAcl(Q_newRoot, QueueACL.SUBMIT_APPLICATIONS, " ");
        String Q_A = Q_newRoot + "." + "a";
        conf.setCapacity(Q_A, 8.5f);
        conf.setMaximumCapacity(Q_A, 20.0f);
        conf.setAcl(Q_A, QueueACL.SUBMIT_APPLICATIONS, "*");
        String Q_B = Q_newRoot + "." + "b";
        conf.setCapacity(Q_B, 80.0f);
        conf.setMaximumCapacity(Q_B, 99.0f);
        conf.setAcl(Q_B, QueueACL.SUBMIT_APPLICATIONS, "*");
        String Q_C = Q_newRoot + "." + "c";
        conf.setCapacity(Q_C, 1.5f);
        conf.setMaximumCapacity(Q_C, 10.0f);
        conf.setAcl(Q_C, QueueACL.SUBMIT_APPLICATIONS, " ");
        conf.setQueues(Q_C, new String[]{"c1"});
        String Q_C1 = Q_C + "." + "c1";
        conf.setCapacity(Q_C1, 100.0f);
        String Q_D = Q_newRoot + "." + "d";
        conf.setCapacity(Q_D, 9.0f);
        conf.setMaximumCapacity(Q_D, 11.0f);
        conf.setAcl(Q_D, QueueACL.SUBMIT_APPLICATIONS, "user_d");
        String Q_E = Q_newRoot + "." + "e";
        conf.setCapacity(Q_E, 1.0f);
        conf.setMaximumCapacity(Q_E, 1.0f);
        conf.setAcl(Q_E, QueueACL.SUBMIT_APPLICATIONS, "user_e");
    }

    static LeafQueue stubLeafQueue(LeafQueue queue) {
        ((LeafQueue)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)queue)).createContainer((FiCaSchedulerApp)Matchers.any(FiCaSchedulerApp.class), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), (Resource)Matchers.any(Resource.class), (Priority)Matchers.any(Priority.class));
        CSQueue parent = queue.getParent();
        ((CSQueue)Mockito.doNothing().when((Object)parent)).completedContainer((Resource)Matchers.any(Resource.class), (FiCaSchedulerApp)Matchers.any(FiCaSchedulerApp.class), (FiCaSchedulerNode)Matchers.any(FiCaSchedulerNode.class), (RMContainer)Matchers.any(RMContainer.class), (ContainerStatus)Matchers.any(ContainerStatus.class), (RMContainerEventType)Matchers.any(RMContainerEventType.class), (CSQueue)Matchers.any(CSQueue.class));
        return queue;
    }

    @Test
    public void testInitializeQueue() throws Exception {
        float epsilon = 1.0E-5f;
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        Assert.assertEquals((double)0.085, (double)a.getCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.085, (double)a.getAbsoluteCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.2, (double)a.getMaximumCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.2, (double)a.getAbsoluteMaximumCapacity(), (double)1.0E-5f);
        LeafQueue b = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("b")));
        Assert.assertEquals((double)0.8, (double)b.getCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.8, (double)b.getAbsoluteCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.99, (double)b.getMaximumCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.99, (double)b.getAbsoluteMaximumCapacity(), (double)1.0E-5f);
        ParentQueue c = (ParentQueue)this.queues.get("c");
        Assert.assertEquals((double)0.015, (double)c.getCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.015, (double)c.getAbsoluteCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.1, (double)c.getMaximumCapacity(), (double)1.0E-5f);
        Assert.assertEquals((double)0.1, (double)c.getAbsoluteMaximumCapacity(), (double)1.0E-5f);
    }

    @Test
    public void testSingleQueueOneUserMetrics() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("b")));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)"/default", (int)0, (int)8192);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)8192, (int)16);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Priority priority = TestUtils.createMockPriority((int)1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)3, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)((int)((float)node_0.getTotalResource().getMemory() * a.getCapacity()) - 1024), (long)a.getMetrics().getAvailableMB());
    }

    @Test
    public void testUserQueueAcl() throws Exception {
        LeafQueue d = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("d")));
        String user_d = "user_d";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)1);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_d", (Queue)d, null, this.rmContext);
        d.submitApplicationAttempt(app_0, "user_d");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)0, (int)2);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_d", (Queue)d, null, this.rmContext);
        d.submitApplicationAttempt(app_1, "user_d");
    }

    @Test
    public void testAppAttemptMetrics() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("b")));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)1);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(appAttemptId_0.getApplicationId(), a.getQueueName(), "user_0");
        this.cs.handle((SchedulerEvent)addAppEvent);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId_0, false);
        this.cs.handle((SchedulerEvent)addAttemptEvent);
        AppAttemptRemovedSchedulerEvent event = new AppAttemptRemovedSchedulerEvent(appAttemptId_0, RMAppAttemptState.FAILED, false);
        this.cs.handle((SchedulerEvent)event);
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAppsPending());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAppsFailed());
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)0, (int)2);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, null, this.rmContext);
        a.submitApplicationAttempt(app_1, "user_0");
        Assert.assertEquals((long)1L, (long)a.getMetrics().getAppsSubmitted());
        Assert.assertEquals((long)1L, (long)a.getMetrics().getAppsPending());
        event = new AppAttemptRemovedSchedulerEvent(appAttemptId_0, RMAppAttemptState.FINISHED, false);
        this.cs.handle((SchedulerEvent)event);
        AppRemovedSchedulerEvent rEvent = new AppRemovedSchedulerEvent(appAttemptId_0.getApplicationId(), RMAppState.FINISHED);
        this.cs.handle((SchedulerEvent)rEvent);
        Assert.assertEquals((long)1L, (long)a.getMetrics().getAppsSubmitted());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAppsPending());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAppsFailed());
        Assert.assertEquals((long)1L, (long)a.getMetrics().getAppsCompleted());
        QueueMetrics userMetrics = a.getMetrics().getUserMetrics("user_0");
        Assert.assertEquals((long)1L, (long)userMetrics.getAppsSubmitted());
    }

    @Test
    public void testSingleQueueWithOneUser() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)"/default", (int)0, (int)8192);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)8192, (int)16);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Priority priority = TestUtils.createMockPriority((int)1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)3, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)2, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)1024L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAvailableMB());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        a.setUserLimitFactor(10);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)3072L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)3072L, (long)a.getMetrics().getAllocatedMB());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getAllocatedMB());
        a.setMaxCapacity(0.5f);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getAllocatedMB());
        for (RMContainer rmContainer : app_0.getLiveContainers()) {
            a.completedContainer(clusterResource, app_0, node_0, rmContainer, null, RMContainerEventType.KILL, null);
        }
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)1024L, (long)a.getMetrics().getAllocatedMB());
        for (RMContainer rmContainer : app_1.getLiveContainers()) {
            a.completedContainer(clusterResource, app_1, node_0, rmContainer, null, RMContainerEventType.KILL, null);
        }
        Assert.assertEquals((long)0L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)((int)(a.getCapacity() * (float)node_0.getTotalResource().getMemory())), (long)a.getMetrics().getAvailableMB());
    }

    @Test
    public void testUserLimits() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_1, "user_0");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId((int)2, (int)0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_1", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_2, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)"/default", (int)0, (int)8192);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode((String)host_1, (String)"/default", (int)0, (int)8192);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)16384, (int)32);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        Priority priority = TestUtils.createMockPriority((int)1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)2048, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)2, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        a.setUserLimit(50);
        a.setUserLimitFactor(2);
        Assert.assertEquals((String)"There should only be 1 active user!", (long)1L, (long)a.getActiveUsersManager().getNumActiveUsers());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)3072L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemory());
        a.assignContainers(clusterResource, node_1);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)2048L, (long)app_1.getCurrentConsumption().getMemory());
    }

    @Test
    public void testHeadroomWithMaxCap() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_1, "user_0");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId((int)2, (int)0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_1", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_2, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)"/default", (int)0, (int)8192);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode((String)host_1, (String)"/default", (int)0, (int)8192);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)16384, (int)1);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        Priority priority = TestUtils.createMockPriority((int)1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)2048, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)2, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        a.setUserLimit(50);
        a.setUserLimitFactor(2);
        Assert.assertEquals((String)"There should only be 1 active user!", (long)1L, (long)a.getActiveUsersManager().getNumActiveUsers());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getHeadroom().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getHeadroom().getMemory());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)3072L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getHeadroom().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getHeadroom().getMemory());
        a.setMaxCapacity(0.1f);
        app_2.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        Assert.assertEquals((long)2L, (long)a.getActiveUsersManager().getNumActiveUsers());
        a.assignContainers(clusterResource, node_1);
        Assert.assertEquals((long)3072L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)1024L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_2.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getHeadroom().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getHeadroom().getMemory());
        LOG.info((Object)"here");
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)0, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        Assert.assertEquals((long)1L, (long)a.getActiveUsersManager().getNumActiveUsers());
        a.assignContainers(clusterResource, node_1);
        Assert.assertEquals((long)1024L, (long)app_2.getHeadroom().getMemory());
    }

    @Test
    public void testSingleQueueWithMultipleUsers() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        String user_2 = "user_2";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_1, "user_0");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId((int)2, (int)0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_1", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_2, "user_1");
        ApplicationAttemptId appAttemptId_3 = TestUtils.getMockApplicationAttemptId((int)3, (int)0);
        FiCaSchedulerApp app_3 = new FiCaSchedulerApp(appAttemptId_3, "user_2", (Queue)a, a.getActiveUsersManager(), this.rmContext);
        a.submitApplicationAttempt(app_3, "user_2");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)"/default", (int)0, (int)8192);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)8192, (int)16);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Priority priority = TestUtils.createMockPriority((int)1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)10, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)10, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        a.setUserLimit(25);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        app_2.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)3072, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        app_3.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)2, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        a.setUserLimitFactor(10);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemory());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)6144L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemory());
        a.setMaxCapacity(0.5f);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)6144L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemory());
        a.setMaxCapacity(1.0f);
        a.setUserLimitFactor(1);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)7168L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)1024L, (long)app_3.getCurrentConsumption().getMemory());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)3072L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)2048L, (long)app_3.getCurrentConsumption().getMemory());
        for (RMContainer rmContainer : app_0.getLiveContainers()) {
            a.completedContainer(clusterResource, app_0, node_0, rmContainer, null, RMContainerEventType.KILL, null);
        }
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)3072L, (long)app_2.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)2048L, (long)app_3.getCurrentConsumption().getMemory());
        for (RMContainer rmContainer : app_2.getLiveContainers()) {
            a.completedContainer(clusterResource, app_2, node_0, rmContainer, null, RMContainerEventType.KILL, null);
        }
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_2.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)2048L, (long)app_3.getCurrentConsumption().getMemory());
        for (RMContainer rmContainer : app_3.getLiveContainers()) {
            a.completedContainer(clusterResource, app_3, node_0, rmContainer, null, RMContainerEventType.KILL, null);
        }
        Assert.assertEquals((long)0L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_2.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_3.getCurrentConsumption().getMemory());
    }

    @Test
    public void testReservation() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_1", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_1, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)"/default", (int)0, (int)4096);
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)8192, (int)32);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        Priority priority = TestUtils.createMockPriority((int)1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)2, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)4096, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)1024L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAvailableMB());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)6144L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)2048L, (long)node_0.getUsedResource().getMemory());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        a.completedContainer(clusterResource, app_0, node_0, (RMContainer)app_0.getLiveContainers().iterator().next(), null, RMContainerEventType.KILL, null);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)1024L, (long)node_0.getUsedResource().getMemory());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)1024L, (long)a.getMetrics().getAllocatedMB());
        a.completedContainer(clusterResource, app_0, node_0, (RMContainer)app_0.getLiveContainers().iterator().next(), null, RMContainerEventType.KILL, null);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)4096L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)4096L, (long)node_0.getUsedResource().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getAllocatedMB());
    }

    @Test
    public void testStolenReservedContainer() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        a.setMaxCapacity(1.0f);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_1", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_1, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)"/default", (int)0, (int)4096);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode((String)host_1, (String)"/default", (int)0, (int)4096);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)12288, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        Priority priority = TestUtils.createMockPriority((int)1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)2048, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        ArrayList<ResourceRequest> appRequests_1 = new ArrayList<ResourceRequest>(4);
        appRequests_1.add(TestUtils.createResourceRequest((String)host_0, (int)4096, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        appRequests_1.add(TestUtils.createResourceRequest((String)"/default", (int)4096, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        appRequests_1.add(TestUtils.createResourceRequest((String)"*", (int)4096, (int)2, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_1.updateResourceRequests(appRequests_1);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getAvailableMB());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)6144L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)2048L, (long)node_0.getUsedResource().getMemory());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)2048L, (long)a.getMetrics().getAllocatedMB());
        ((LeafQueue)Mockito.doReturn((Object)-1).when((Object)a)).getNodeLocalityDelay();
        a.assignContainers(clusterResource, node_1);
        Assert.assertEquals((long)10240L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)4096L, (long)node_1.getUsedResource().getMemory());
        Assert.assertEquals((long)4096L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)6144L, (long)a.getMetrics().getAllocatedMB());
        a.completedContainer(clusterResource, app_0, node_0, (RMContainer)app_0.getLiveContainers().iterator().next(), null, RMContainerEventType.KILL, null);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)8192L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)4096L, (long)node_0.getUsedResource().getMemory());
        Assert.assertEquals((long)0L, (long)a.getMetrics().getReservedMB());
        Assert.assertEquals((long)8192L, (long)a.getMetrics().getAllocatedMB());
    }

    @Test
    public void testReservationExchange() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        a.setMaxCapacity(1.0f);
        a.setUserLimitFactor(10);
        String user_0 = "user_0";
        String user_1 = "user_1";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_1", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_1, "user_1");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)"/default", (int)0, (int)4096);
        String host_1 = "127.0.0.2";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode((String)host_1, (String)"/default", (int)0, (int)4096);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)12288, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)4096, (int)16));
        Mockito.when((Object)a.getMaximumAllocation()).thenReturn((Object)Resources.createResource((int)4096, (int)16));
        Mockito.when((Object)Float.valueOf(a.getMinimumAllocationFactor())).thenReturn((Object)Float.valueOf(0.25f));
        Priority priority = TestUtils.createMockPriority((int)1);
        app_0.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)1024, (int)2, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        app_1.updateResourceRequests(Collections.singletonList(TestUtils.createResourceRequest((String)"*", (int)4096, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)1024L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)2048L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)6144L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)2048L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)2048L, (long)node_0.getUsedResource().getMemory());
        a.completedContainer(clusterResource, app_0, node_0, (RMContainer)app_0.getLiveContainers().iterator().next(), null, RMContainerEventType.KILL, null);
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)1024L, (long)node_0.getUsedResource().getMemory());
        Assert.assertEquals((long)1L, (long)app_1.getReReservations(priority));
        a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)5120L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)0L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)1024L, (long)node_0.getUsedResource().getMemory());
        Assert.assertEquals((long)2L, (long)app_1.getReReservations(priority));
        a.assignContainers(clusterResource, node_1);
        Assert.assertEquals((long)9216L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)1024L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)4096L, (long)node_1.getUsedResource().getMemory());
        Assert.assertEquals((long)2L, (long)app_1.getReReservations(priority));
        a.completedContainer(clusterResource, app_0, node_0, (RMContainer)app_0.getLiveContainers().iterator().next(), null, RMContainerEventType.KILL, null);
        CSAssignment assignment = a.assignContainers(clusterResource, node_0);
        Assert.assertEquals((long)8192L, (long)a.getUsedResources().getMemory());
        Assert.assertEquals((long)0L, (long)app_0.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentConsumption().getMemory());
        Assert.assertEquals((long)4096L, (long)app_1.getCurrentReservation().getMemory());
        Assert.assertEquals((long)0L, (long)node_0.getUsedResource().getMemory());
        Assert.assertEquals((long)4096L, (long)assignment.getExcessReservation().getContainer().getResource().getMemory());
    }

    @Test
    public void testLocalityScheduling() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext));
        a.submitApplicationAttempt(app_0, user_0);
        String host_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)rack_0, (int)0, (int)8192);
        String host_1 = "127.0.0.2";
        String rack_1 = "rack_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode((String)host_1, (String)rack_1, (int)0, (int)8192);
        String host_2 = "127.0.0.3";
        String rack_2 = "rack_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode((String)host_2, (String)rack_2, (int)0, (int)8192);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        Priority priority = TestUtils.createMockPriority((int)1);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_0, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_0, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_1, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_1, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)"*", (int)1024, (int)3, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        CSAssignment assignment = null;
        assignment = a.assignContainers(clusterResource, node_2);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)3L, (long)app_0.getTotalRequiredResources(priority));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node_2);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)2L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)3L, (long)app_0.getTotalRequiredResources(priority));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node_2);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)3L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)3L, (long)app_0.getTotalRequiredResources(priority));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node_2);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.OFF_SWITCH), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)4L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)2L, (long)app_0.getTotalRequiredResources(priority));
        Assert.assertEquals((Object)NodeType.OFF_SWITCH, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node_0);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.NODE_LOCAL), (FiCaSchedulerNode)Matchers.eq((Object)node_0), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)1L, (long)app_0.getTotalRequiredResources(priority));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node_1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.NODE_LOCAL), (FiCaSchedulerNode)Matchers.eq((Object)node_1), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)0L, (long)app_0.getTotalRequiredResources(priority));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_1, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_1, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)"*", (int)1024, (int)2, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        Assert.assertEquals((long)2L, (long)app_0.getTotalRequiredResources(priority));
        String host_3 = "127.0.0.4";
        FiCaSchedulerNode node_3 = TestUtils.getMockNode((String)host_3, (String)rack_1, (int)0, (int)8192);
        ((LeafQueue)Mockito.doReturn((Object)1).when((Object)a)).getNodeLocalityDelay();
        assignment = a.assignContainers(clusterResource, node_3);
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)2L, (long)app_0.getTotalRequiredResources(priority));
        Assert.assertEquals((Object)NodeType.NODE_LOCAL, (Object)assignment.getType());
        assignment = a.assignContainers(clusterResource, node_3);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.RACK_LOCAL), (FiCaSchedulerNode)Matchers.eq((Object)node_3), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)1L, (long)app_0.getTotalRequiredResources(priority));
        Assert.assertEquals((Object)NodeType.RACK_LOCAL, (Object)assignment.getType());
    }

    @Test
    public void testApplicationPriorityScheduling() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext));
        a.submitApplicationAttempt(app_0, user_0);
        String host_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)rack_0, (int)0, (int)8192);
        String host_1 = "127.0.0.2";
        String rack_1 = "rack_1";
        FiCaSchedulerNode node_1 = TestUtils.getMockNode((String)host_1, (String)rack_1, (int)0, (int)8192);
        String host_2 = "127.0.0.3";
        String rack_2 = "rack_2";
        FiCaSchedulerNode node_2 = TestUtils.getMockNode((String)host_2, (String)rack_2, (int)0, (int)8192);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576, (int)1);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        Priority priority_1 = TestUtils.createMockPriority((int)1);
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_0, (int)1024, (int)1, (boolean)true, (Priority)priority_1, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_0, (int)1024, (int)1, (boolean)true, (Priority)priority_1, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_1, (int)1024, (int)1, (boolean)true, (Priority)priority_1, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_1, (int)1024, (int)1, (boolean)true, (Priority)priority_1, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)"*", (int)1024, (int)2, (boolean)true, (Priority)priority_1, (RecordFactory)this.recordFactory));
        Priority priority_2 = TestUtils.createMockPriority((int)2);
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_2, (int)2048, (int)1, (boolean)true, (Priority)priority_2, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_2, (int)2048, (int)1, (boolean)true, (Priority)priority_2, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)"*", (int)2048, (int)1, (boolean)true, (Priority)priority_2, (RecordFactory)this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        a.assignContainers(clusterResource, node_2);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.eq((Object)priority_1), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(priority_1));
        Assert.assertEquals((long)2L, (long)app_0.getTotalRequiredResources(priority_1));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.eq((Object)priority_2), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority_2));
        Assert.assertEquals((long)1L, (long)app_0.getTotalRequiredResources(priority_2));
        a.assignContainers(clusterResource, node_2);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.eq((Object)priority_1), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)2L, (long)app_0.getSchedulingOpportunities(priority_1));
        Assert.assertEquals((long)2L, (long)app_0.getTotalRequiredResources(priority_1));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.eq((Object)priority_2), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority_2));
        Assert.assertEquals((long)1L, (long)app_0.getTotalRequiredResources(priority_2));
        a.assignContainers(clusterResource, node_2);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.OFF_SWITCH), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.eq((Object)priority_1), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)3L, (long)app_0.getSchedulingOpportunities(priority_1));
        Assert.assertEquals((long)1L, (long)app_0.getTotalRequiredResources(priority_1));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_2), (Priority)Matchers.eq((Object)priority_2), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority_2));
        Assert.assertEquals((long)1L, (long)app_0.getTotalRequiredResources(priority_2));
        a.assignContainers(clusterResource, node_0);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.NODE_LOCAL), (FiCaSchedulerNode)Matchers.eq((Object)node_0), (Priority)Matchers.eq((Object)priority_1), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority_1));
        Assert.assertEquals((long)0L, (long)app_0.getTotalRequiredResources(priority_1));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_0), (Priority)Matchers.eq((Object)priority_2), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority_2));
        Assert.assertEquals((long)1L, (long)app_0.getTotalRequiredResources(priority_2));
        a.assignContainers(clusterResource, node_1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_1), (Priority)Matchers.eq((Object)priority_1), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority_1));
        Assert.assertEquals((long)0L, (long)app_0.getTotalRequiredResources(priority_1));
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.OFF_SWITCH), (FiCaSchedulerNode)Matchers.eq((Object)node_1), (Priority)Matchers.eq((Object)priority_2), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(priority_2));
        Assert.assertEquals((long)0L, (long)app_0.getTotalRequiredResources(priority_2));
    }

    @Test
    public void testSchedulingConstraints() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext));
        a.submitApplicationAttempt(app_0, user_0);
        String host_0_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        FiCaSchedulerNode node_0_0 = TestUtils.getMockNode((String)host_0_0, (String)rack_0, (int)0, (int)8192);
        String host_0_1 = "127.0.0.2";
        FiCaSchedulerNode node_0_1 = TestUtils.getMockNode((String)host_0_1, (String)rack_0, (int)0, (int)8192);
        String host_1_0 = "127.0.0.3";
        String rack_1 = "rack_1";
        FiCaSchedulerNode node_1_0 = TestUtils.getMockNode((String)host_1_0, (String)rack_1, (int)0, (int)8192);
        int numNodes = 3;
        Resource clusterResource = Resources.createResource((int)24576, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        Priority priority = TestUtils.createMockPriority((int)1);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_0_0, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_0_1, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_0, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_1_0, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_1, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest((String)"*", (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        a.assignContainers(clusterResource, node_0_0);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.NODE_LOCAL), (FiCaSchedulerNode)Matchers.eq((Object)node_0_0), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)0L, (long)app_0.getTotalRequiredResources(priority));
        a.assignContainers(clusterResource, node_1_0);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_1_0), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)0L, (long)app_0.getTotalRequiredResources(priority));
        app_0_requests_0.clear();
        app_0_requests_0.add(TestUtils.createResourceRequest((String)"*", (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        a.assignContainers(clusterResource, node_0_1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_1_0), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)1L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)1L, (long)app_0.getTotalRequiredResources(priority));
        a.assignContainers(clusterResource, node_1_0);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.NODE_LOCAL), (FiCaSchedulerNode)Matchers.eq((Object)node_1_0), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)0L, (long)app_0.getTotalRequiredResources(priority));
    }

    @Test(timeout=30000L)
    public void testActivateApplicationAfterQueueRefresh() throws Exception {
        LeafQueue e = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("e")));
        String user_e = "user_e";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_e", (Queue)e, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        e.submitApplicationAttempt(app_0, "user_e");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_e", (Queue)e, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        e.submitApplicationAttempt(app_1, "user_e");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId((int)2, (int)0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_e", (Queue)e, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        e.submitApplicationAttempt(app_2, "user_e");
        Assert.assertEquals((long)2L, (long)e.activeApplications.size());
        Assert.assertEquals((long)1L, (long)e.pendingApplications.size());
        this.csConf.setDouble("yarn.scheduler.capacity.maximum-am-resource-percent", (double)0.2f);
        HashMap newQueues = new HashMap();
        CSQueue newRoot = CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", newQueues, (Map)this.queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        this.queues = newQueues;
        this.root.reinitialize(newRoot, this.cs.getClusterResource());
        Assert.assertEquals((long)3L, (long)e.activeApplications.size());
        Assert.assertEquals((long)0L, (long)e.pendingApplications.size());
    }

    @Test(timeout=30000L)
    public void testNodeLocalityAfterQueueRefresh() throws Exception {
        LeafQueue e = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("e")));
        Assert.assertEquals((long)40L, (long)e.getNodeLocalityDelay());
        this.csConf.setInt("yarn.scheduler.capacity.node-locality-delay", 60);
        HashMap newQueues = new HashMap();
        CSQueue newRoot = CapacityScheduler.parseQueue((CapacitySchedulerContext)this.csContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", newQueues, (Map)this.queues, (CapacityScheduler.QueueHook)TestUtils.spyHook);
        this.queues = newQueues;
        this.root.reinitialize(newRoot, this.cs.getClusterResource());
        Assert.assertEquals((long)60L, (long)e.getNodeLocalityDelay());
    }

    @Test(timeout=30000L)
    public void testActivateApplicationByUpdatingClusterResource() throws Exception {
        LeafQueue e = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("e")));
        String user_e = "user_e";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_e", (Queue)e, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        e.submitApplicationAttempt(app_0, "user_e");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_e", (Queue)e, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        e.submitApplicationAttempt(app_1, "user_e");
        ApplicationAttemptId appAttemptId_2 = TestUtils.getMockApplicationAttemptId((int)2, (int)0);
        FiCaSchedulerApp app_2 = new FiCaSchedulerApp(appAttemptId_2, "user_e", (Queue)e, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        e.submitApplicationAttempt(app_2, "user_e");
        Assert.assertEquals((long)2L, (long)e.activeApplications.size());
        Assert.assertEquals((long)1L, (long)e.pendingApplications.size());
        e.updateClusterResource(Resources.createResource((int)0x320000, (int)3200));
        Assert.assertEquals((long)3L, (long)e.activeApplications.size());
        Assert.assertEquals((long)0L, (long)e.pendingApplications.size());
    }

    public boolean hasQueueACL(List<QueueUserACLInfo> aclInfos, QueueACL acl) {
        for (QueueUserACLInfo aclInfo : aclInfos) {
            if (!aclInfo.getUserAcls().contains(acl)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testInheritedQueueAcls() throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        LeafQueue b = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("b")));
        ParentQueue c = (ParentQueue)this.queues.get("c");
        LeafQueue c1 = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("c1")));
        Assert.assertFalse((boolean)this.root.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)a.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)b.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)c.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)c1.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)this.hasQueueACL(a.getQueueUserAclInfo(user), QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertTrue((boolean)this.hasQueueACL(b.getQueueUserAclInfo(user), QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertFalse((boolean)this.hasQueueACL(c.getQueueUserAclInfo(user), QueueACL.SUBMIT_APPLICATIONS));
        Assert.assertFalse((boolean)this.hasQueueACL(c1.getQueueUserAclInfo(user), QueueACL.SUBMIT_APPLICATIONS));
    }

    @Test
    public void testLocalityConstraints() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("a")));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_0, user_0, (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext));
        a.submitApplicationAttempt(app_0, user_0);
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = (FiCaSchedulerApp)Mockito.spy((Object)new FiCaSchedulerApp(appAttemptId_1, user_0, (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext));
        a.submitApplicationAttempt(app_1, user_0);
        String host_0_0 = "127.0.0.1";
        String rack_0 = "rack_0";
        String host_0_1 = "127.0.0.2";
        FiCaSchedulerNode node_0_1 = TestUtils.getMockNode((String)host_0_1, (String)rack_0, (int)0, (int)8192);
        String host_1_0 = "127.0.0.3";
        String rack_1 = "rack_1";
        FiCaSchedulerNode node_1_0 = TestUtils.getMockNode((String)host_1_0, (String)rack_1, (int)0, (int)8192);
        String host_1_1 = "127.0.0.4";
        FiCaSchedulerNode node_1_1 = TestUtils.getMockNode((String)host_1_1, (String)rack_1, (int)0, (int)8192);
        int numNodes = 4;
        Resource clusterResource = Resources.createResource((int)32768, (int)4);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)4);
        Priority priority = TestUtils.createMockPriority((int)1);
        ArrayList<ResourceRequest> app_0_requests_0 = new ArrayList<ResourceRequest>();
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_0_0, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)host_1_0, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_1, (int)1024, (int)1, (boolean)false, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)"*", (int)1024, (int)1, (boolean)false, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0.updateBlacklist(Collections.singletonList(host_0_0), null);
        app_0_requests_0.clear();
        a.assignContainers(clusterResource, node_0_1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_0_1), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        a.assignContainers(clusterResource, node_1_1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_0_1), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_1, (int)1024, (int)1, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0.updateBlacklist(Collections.singletonList(host_1_1), null);
        app_0_requests_0.clear();
        a.assignContainers(clusterResource, node_1_1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_1_1), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0.updateBlacklist(Collections.singletonList(rack_1), Collections.singletonList(host_1_1));
        app_0_requests_0.clear();
        a.assignContainers(clusterResource, node_1_1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.any(NodeType.class), (FiCaSchedulerNode)Matchers.eq((Object)node_1_1), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0.updateBlacklist(null, Collections.singletonList(rack_1));
        app_0_requests_0.clear();
        a.assignContainers(clusterResource, node_1_1);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0, (VerificationMode)Mockito.never())).allocate((NodeType)Matchers.eq((Object)NodeType.RACK_LOCAL), (FiCaSchedulerNode)Matchers.eq((Object)node_1_1), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)1L, (long)app_0.getTotalRequiredResources(priority));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)rack_1, (int)1024, (int)1, (boolean)false, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0_requests_0.add(TestUtils.createResourceRequest((String)"*", (int)1024, (int)1, (boolean)false, (Priority)priority, (RecordFactory)this.recordFactory));
        app_0.updateResourceRequests(app_0_requests_0);
        app_0_requests_0.clear();
        a.assignContainers(clusterResource, node_1_0);
        ((FiCaSchedulerApp)Mockito.verify((Object)app_0)).allocate((NodeType)Matchers.eq((Object)NodeType.NODE_LOCAL), (FiCaSchedulerNode)Matchers.eq((Object)node_1_0), (Priority)Matchers.any(Priority.class), (ResourceRequest)Matchers.any(ResourceRequest.class), (Container)Matchers.any(Container.class));
        Assert.assertEquals((long)0L, (long)app_0.getSchedulingOpportunities(priority));
        Assert.assertEquals((long)0L, (long)app_0.getTotalRequiredResources(priority));
    }

    @Test
    public void testMaxAMResourcePerQueuePercentAfterQueueRefresh() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        Resource clusterResource = Resources.createResource((int)0x190000, (int)3200);
        CapacitySchedulerContext csContext = this.mockCSContext(csConf, clusterResource);
        csConf.setFloat("yarn.scheduler.capacity.maximum-am-resource-percent", 0.1f);
        ParentQueue root = new ParentQueue(csContext, "root", null, null);
        csConf.setCapacity("root.a", 80.0f);
        LeafQueue a = new LeafQueue(csContext, "a", (CSQueue)root, null);
        Assert.assertEquals((float)0.1f, (float)a.getMaxAMResourcePerQueuePercent(), (float)0.001f);
        Assert.assertEquals((long)160L, (long)a.getMaximumActiveApplications());
        csConf.setFloat("yarn.scheduler.capacity.maximum-am-resource-percent", 0.2f);
        LeafQueue newA = new LeafQueue(csContext, "a", (CSQueue)root, null);
        a.reinitialize((CSQueue)newA, clusterResource);
        Assert.assertEquals((float)0.2f, (float)a.getMaxAMResourcePerQueuePercent(), (float)0.001f);
        Assert.assertEquals((long)320L, (long)a.getMaximumActiveApplications());
        Resource newClusterResource = Resources.createResource((int)2048000, (int)3200);
        a.updateClusterResource(newClusterResource);
        Assert.assertEquals((long)400L, (long)a.getMaximumActiveApplications());
    }

    @Test
    public void testAllocateContainerOnNodeWithoutOffSwitchSpecified() throws Exception {
        LeafQueue a = TestLeafQueue.stubLeafQueue((LeafQueue)((LeafQueue)this.queues.get("b")));
        String user_0 = "user_0";
        ApplicationAttemptId appAttemptId_0 = TestUtils.getMockApplicationAttemptId((int)0, (int)0);
        FiCaSchedulerApp app_0 = new FiCaSchedulerApp(appAttemptId_0, "user_0", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_0, "user_0");
        ApplicationAttemptId appAttemptId_1 = TestUtils.getMockApplicationAttemptId((int)1, (int)0);
        FiCaSchedulerApp app_1 = new FiCaSchedulerApp(appAttemptId_1, "user_0", (Queue)a, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), this.rmContext);
        a.submitApplicationAttempt(app_1, "user_0");
        String host_0 = "127.0.0.1";
        FiCaSchedulerNode node_0 = TestUtils.getMockNode((String)host_0, (String)"/default", (int)0, (int)8192);
        boolean numNodes = true;
        Resource clusterResource = Resources.createResource((int)8192, (int)16);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)1);
        Priority priority = TestUtils.createMockPriority((int)1);
        app_0.updateResourceRequests(Arrays.asList(TestUtils.createResourceRequest((String)"127.0.0.1", (int)1024, (int)3, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory), TestUtils.createResourceRequest((String)"/default", (int)1024, (int)3, (boolean)true, (Priority)priority, (RecordFactory)this.recordFactory)));
        try {
            a.assignContainers(clusterResource, node_0);
        }
        catch (NullPointerException e) {
            Assert.fail((String)"NPE when allocating container on node but forget to set off-switch request should be handled");
        }
    }

    private CapacitySchedulerContext mockCSContext(CapacitySchedulerConfiguration csConf, Resource clusterResource) {
        CapacitySchedulerContext csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)csContext.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)csContext.getConf()).thenReturn((Object)new YarnConfiguration());
        Mockito.when((Object)csContext.getResourceCalculator()).thenReturn((Object)this.resourceCalculator);
        Mockito.when((Object)csContext.getClusterResource()).thenReturn((Object)clusterResource);
        Mockito.when((Object)csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)2048, (int)2));
        return csContext;
    }

    @After
    public void tearDown() throws Exception {
        if (this.cs != null) {
            this.cs.stop();
        }
    }
}

