/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMNodeImpl
implements RMNode,
EventHandler<RMNodeEvent> {
    private static final Log LOG = LogFactory.getLog(RMNodeImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ConcurrentLinkedQueue<UpdatedContainerInfo> nodeUpdateQueue;
    private volatile boolean nextHeartBeat = true;
    private final NodeId nodeId;
    private final RMContext context;
    private final String hostName;
    private final int commandPort;
    private final int httpPort;
    private final String nodeAddress;
    private final String httpAddress;
    private volatile ResourceOption resourceOption;
    private final Node node;
    private String healthReport;
    private long lastHealthReportTime;
    private String nodeManagerVersion;
    private final Map<ContainerId, ContainerStatus> justLaunchedContainers = new HashMap();
    private final Set<ContainerId> containersToClean = new TreeSet(new BuilderUtils.ContainerIdComparator());
    private final List<ApplicationId> finishedApplications = new ArrayList();
    private NodeHeartbeatResponse latestNodeHeartBeatResponse = (NodeHeartbeatResponse)recordFactory.newRecordInstance(NodeHeartbeatResponse.class);
    private static final StateMachineFactory<RMNodeImpl, NodeState, RMNodeEventType, RMNodeEvent> stateMachineFactory = new StateMachineFactory((Enum)NodeState.NEW).addTransition((Enum)NodeState.NEW, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.STARTED, (SingleArcTransition)new AddNodeTransition()).addTransition((Enum)NodeState.RUNNING, EnumSet.of(NodeState.RUNNING, NodeState.UNHEALTHY), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenHealthyTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)NodeState.RUNNING, (Enum)NodeState.RUNNING, (Enum)RMNodeEventType.RECONNECTED, (SingleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.UNHEALTHY, EnumSet.of(NodeState.UNHEALTHY, NodeState.RUNNING), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenUnHealthyTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new DeactivateNodeTransition(NodeState.DECOMMISSIONED)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new DeactivateNodeTransition(NodeState.LOST)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.REBOOTED, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new DeactivateNodeTransition(NodeState.REBOOTED)).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.RECONNECTED, (SingleArcTransition)new ReconnectNodeTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)NodeState.UNHEALTHY, (Enum)NodeState.UNHEALTHY, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).installTopology();
    private final StateMachine<NodeState, RMNodeEventType, RMNodeEvent> stateMachine;

    public RMNodeImpl(NodeId nodeId, RMContext context, String hostName, int cmPort, int httpPort, Node node, ResourceOption resourceOption, String nodeManagerVersion) {
        this.nodeId = nodeId;
        this.context = context;
        this.hostName = hostName;
        this.commandPort = cmPort;
        this.httpPort = httpPort;
        this.resourceOption = resourceOption;
        this.nodeAddress = hostName + ":" + cmPort;
        this.httpAddress = hostName + ":" + httpPort;
        this.node = node;
        this.healthReport = "Healthy";
        this.lastHealthReportTime = System.currentTimeMillis();
        this.nodeManagerVersion = nodeManagerVersion;
        this.latestNodeHeartBeatResponse.setResponseId(0);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.nodeUpdateQueue = new ConcurrentLinkedQueue();
    }

    public String toString() {
        return this.nodeId.toString();
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getCommandPort() {
        return this.commandPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public NodeId getNodeID() {
        return this.nodeId;
    }

    public String getNodeAddress() {
        return this.nodeAddress;
    }

    public String getHttpAddress() {
        return this.httpAddress;
    }

    public Resource getTotalCapability() {
        return this.resourceOption.getResource();
    }

    public void setResourceOption(ResourceOption resourceOption) {
        this.resourceOption = resourceOption;
    }

    public ResourceOption getResourceOption() {
        return this.resourceOption;
    }

    public String getRackName() {
        return this.node.getNetworkLocation();
    }

    public Node getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHealthReport() {
        this.readLock.lock();
        try {
            String string = this.healthReport;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHealthReport(String healthReport) {
        this.writeLock.lock();
        try {
            this.healthReport = healthReport;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastHealthReportTime(long lastHealthReportTime) {
        this.writeLock.lock();
        try {
            this.lastHealthReportTime = lastHealthReportTime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastHealthReportTime() {
        this.readLock.lock();
        try {
            long l = this.lastHealthReportTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getNodeManagerVersion() {
        return this.nodeManagerVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getState() {
        this.readLock.lock();
        try {
            NodeState nodeState = (NodeState)this.stateMachine.getCurrentState();
            return nodeState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApplicationId> getAppsToCleanup() {
        this.readLock.lock();
        try {
            ArrayList<ApplicationId> arrayList = new ArrayList<ApplicationId>(this.finishedApplications);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerId> getContainersToCleanUp() {
        this.readLock.lock();
        try {
            ArrayList<ContainerId> arrayList = new ArrayList<ContainerId>(this.containersToClean);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNodeHeartbeatResponseForCleanup(NodeHeartbeatResponse response) {
        this.writeLock.lock();
        try {
            response.addAllContainersToCleanup(new ArrayList(this.containersToClean));
            response.addAllApplicationsToCleanup(this.finishedApplications);
            this.containersToClean.clear();
            this.finishedApplications.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeHeartbeatResponse getLastNodeHeartBeatResponse() {
        this.readLock.lock();
        try {
            NodeHeartbeatResponse nodeHeartbeatResponse = this.latestNodeHeartBeatResponse;
            return nodeHeartbeatResponse;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMNodeEvent event) {
        LOG.debug((Object)("Processing " + event.getNodeId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            NodeState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on Node  " + this.nodeId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.nodeId + " Node Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateMetricsForRejoinedNode(NodeState previousNodeState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        metrics.incrNumActiveNodes();
        switch (1.$SwitchMap$org$apache$hadoop$yarn$api$records$NodeState[previousNodeState.ordinal()]) {
            case 1: {
                metrics.decrNumLostNMs();
                break;
            }
            case 2: {
                metrics.decrNumRebootedNMs();
                break;
            }
            case 3: {
                metrics.decrDecommisionedNMs();
                break;
            }
            case 4: {
                metrics.decrNumUnhealthyNMs();
            }
        }
    }

    private void updateMetricsForDeactivatedNode(NodeState initialState, NodeState finalState) {
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        switch (1.$SwitchMap$org$apache$hadoop$yarn$api$records$NodeState[initialState.ordinal()]) {
            case 5: {
                metrics.decrNumActiveNodes();
                break;
            }
            case 4: {
                metrics.decrNumUnhealthyNMs();
            }
        }
        switch (1.$SwitchMap$org$apache$hadoop$yarn$api$records$NodeState[finalState.ordinal()]) {
            case 3: {
                Set ecludedHosts = this.context.getNodesListManager().getHostsReader().getExcludedHosts();
                if (ecludedHosts.contains(this.hostName) || ecludedHosts.contains(NetUtils.normalizeHostName((String)this.hostName))) break;
                metrics.incrDecommisionedNMs();
                break;
            }
            case 1: {
                metrics.incrNumLostNMs();
                break;
            }
            case 2: {
                metrics.incrNumRebootedNMs();
                break;
            }
            case 4: {
                metrics.incrNumUnhealthyNMs();
            }
        }
    }

    public List<UpdatedContainerInfo> pullContainerUpdates() {
        ArrayList<UpdatedContainerInfo> latestContainerInfoList = new ArrayList<UpdatedContainerInfo>();
        while (this.nodeUpdateQueue.peek() != null) {
            latestContainerInfoList.add((UpdatedContainerInfo)this.nodeUpdateQueue.poll());
        }
        this.nextHeartBeat = true;
        return latestContainerInfoList;
    }

    @VisibleForTesting
    public void setNextHeartBeat(boolean nextHeartBeat) {
        this.nextHeartBeat = nextHeartBeat;
    }

    @VisibleForTesting
    public int getQueueSize() {
        return this.nodeUpdateQueue.size();
    }

    static /* synthetic */ NodeId access$000(RMNodeImpl x0) {
        return x0.nodeId;
    }

    static /* synthetic */ RMContext access$100(RMNodeImpl x0) {
        return x0.context;
    }

    static /* synthetic */ void access$200(RMNodeImpl x0, NodeState x1) {
        x0.updateMetricsForRejoinedNode(x1);
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }

    static /* synthetic */ List access$400(RMNodeImpl x0) {
        return x0.finishedApplications;
    }

    static /* synthetic */ ConcurrentLinkedQueue access$500(RMNodeImpl x0) {
        return x0.nodeUpdateQueue;
    }

    static /* synthetic */ String access$602(RMNodeImpl x0, String x1) {
        x0.nodeManagerVersion = x1;
        return x0.nodeManagerVersion;
    }

    static /* synthetic */ Set access$700(RMNodeImpl x0) {
        return x0.containersToClean;
    }

    static /* synthetic */ void access$800(RMNodeImpl x0, NodeState x1, NodeState x2) {
        x0.updateMetricsForDeactivatedNode(x1, x2);
    }

    static /* synthetic */ NodeHeartbeatResponse access$902(RMNodeImpl x0, NodeHeartbeatResponse x1) {
        x0.latestNodeHeartBeatResponse = x1;
        return x0.latestNodeHeartBeatResponse;
    }

    static /* synthetic */ Map access$1000(RMNodeImpl x0) {
        return x0.justLaunchedContainers;
    }

    static /* synthetic */ boolean access$1100(RMNodeImpl x0) {
        return x0.nextHeartBeat;
    }

    static /* synthetic */ boolean access$1102(RMNodeImpl x0, boolean x1) {
        x0.nextHeartBeat = x1;
        return x0.nextHeartBeat;
    }
}

