/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmcontainer;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRMContainerImpl {
    @Test
    public void testReleaseWhileRunning() {
        DrainDispatcher drainDispatcher = new DrainDispatcher();
        EventHandler appAttemptEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        EventHandler generic = (EventHandler)Mockito.mock(EventHandler.class);
        drainDispatcher.register(RMAppAttemptEventType.class, appAttemptEventHandler);
        drainDispatcher.register(RMNodeEventType.class, generic);
        drainDispatcher.init((Configuration)new YarnConfiguration());
        drainDispatcher.start();
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)3425);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (int)1);
        ContainerAllocationExpirer expirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        Resource resource = BuilderUtils.newResource((int)512, (int)1);
        Priority priority = BuilderUtils.newPriority((int)5);
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)"host:3465", (Resource)resource, (Priority)priority, null);
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)drainDispatcher);
        Mockito.when((Object)rmContext.getContainerAllocationExpirer()).thenReturn((Object)expirer);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        RMContainerImpl rmContainer = new RMContainerImpl(container, appAttemptId, nodeId, "user", rmContext);
        Assert.assertEquals((Object)RMContainerState.NEW, (Object)rmContainer.getState());
        Assert.assertEquals((Object)resource, (Object)rmContainer.getAllocatedResource());
        Assert.assertEquals((Object)nodeId, (Object)rmContainer.getAllocatedNode());
        Assert.assertEquals((Object)priority, (Object)rmContainer.getAllocatedPriority());
        ((RMApplicationHistoryWriter)Mockito.verify((Object)writer)).containerStarted((RMContainer)Mockito.any(RMContainer.class));
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.START));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.ALLOCATED, (Object)rmContainer.getState());
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.ACQUIRED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.ACQUIRED, (Object)rmContainer.getState());
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.RUNNING, (Object)rmContainer.getState());
        Assert.assertEquals((Object)"//host:3465/node/containerlogs/container_1_0001_01_000001/user", (Object)rmContainer.getLogURL());
        Mockito.reset((Object[])new EventHandler[]{appAttemptEventHandler});
        ContainerStatus containerStatus = SchedulerUtils.createAbnormalContainerStatus((ContainerId)containerId, (String)"Container released by application");
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, RMContainerEventType.RELEASED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.RELEASED, (Object)rmContainer.getState());
        Assert.assertEquals((Object)"Container released by application", (Object)rmContainer.getDiagnosticsInfo());
        Assert.assertEquals((long)-100L, (long)rmContainer.getContainerExitStatus());
        Assert.assertEquals((Object)ContainerState.COMPLETE, (Object)rmContainer.getContainerState());
        ((RMApplicationHistoryWriter)Mockito.verify((Object)writer)).containerFinished((RMContainer)Mockito.any(RMContainer.class));
        ArgumentCaptor captor = ArgumentCaptor.forClass(RMAppAttemptContainerFinishedEvent.class);
        ((EventHandler)Mockito.verify((Object)appAttemptEventHandler)).handle((Event)captor.capture());
        RMAppAttemptContainerFinishedEvent cfEvent = (RMAppAttemptContainerFinishedEvent)captor.getValue();
        Assert.assertEquals((Object)appAttemptId, (Object)cfEvent.getApplicationAttemptId());
        Assert.assertEquals((Object)containerStatus, (Object)cfEvent.getContainerStatus());
        Assert.assertEquals((Object)RMAppAttemptEventType.CONTAINER_FINISHED, (Object)cfEvent.getType());
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, SchedulerUtils.createAbnormalContainerStatus((ContainerId)containerId, (String)"FinishedContainer"), RMContainerEventType.FINISHED));
        Assert.assertEquals((Object)RMContainerState.RELEASED, (Object)rmContainer.getState());
    }

    @Test
    public void testExpireWhileRunning() {
        DrainDispatcher drainDispatcher = new DrainDispatcher();
        EventHandler appAttemptEventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        EventHandler generic = (EventHandler)Mockito.mock(EventHandler.class);
        drainDispatcher.register(RMAppAttemptEventType.class, appAttemptEventHandler);
        drainDispatcher.register(RMNodeEventType.class, generic);
        drainDispatcher.init((Configuration)new YarnConfiguration());
        drainDispatcher.start();
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)3425);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)appAttemptId, (int)1);
        ContainerAllocationExpirer expirer = (ContainerAllocationExpirer)Mockito.mock(ContainerAllocationExpirer.class);
        Resource resource = BuilderUtils.newResource((int)512, (int)1);
        Priority priority = BuilderUtils.newPriority((int)5);
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)"host:3465", (Resource)resource, (Priority)priority, null);
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)drainDispatcher);
        Mockito.when((Object)rmContext.getContainerAllocationExpirer()).thenReturn((Object)expirer);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        RMContainerImpl rmContainer = new RMContainerImpl(container, appAttemptId, nodeId, "user", rmContext);
        Assert.assertEquals((Object)RMContainerState.NEW, (Object)rmContainer.getState());
        Assert.assertEquals((Object)resource, (Object)rmContainer.getAllocatedResource());
        Assert.assertEquals((Object)nodeId, (Object)rmContainer.getAllocatedNode());
        Assert.assertEquals((Object)priority, (Object)rmContainer.getAllocatedPriority());
        ((RMApplicationHistoryWriter)Mockito.verify((Object)writer)).containerStarted((RMContainer)Mockito.any(RMContainer.class));
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.START));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.ALLOCATED, (Object)rmContainer.getState());
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.ACQUIRED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.ACQUIRED, (Object)rmContainer.getState());
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.RUNNING, (Object)rmContainer.getState());
        Assert.assertEquals((Object)"//host:3465/node/containerlogs/container_1_0001_01_000001/user", (Object)rmContainer.getLogURL());
        Mockito.reset((Object[])new EventHandler[]{appAttemptEventHandler});
        ContainerStatus containerStatus = SchedulerUtils.createAbnormalContainerStatus((ContainerId)containerId, (String)"Container expired since it was unused");
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, RMContainerEventType.EXPIRE));
        drainDispatcher.await();
        Assert.assertEquals((Object)RMContainerState.RUNNING, (Object)rmContainer.getState());
        ((RMApplicationHistoryWriter)Mockito.verify((Object)writer, (VerificationMode)Mockito.never())).containerFinished((RMContainer)Mockito.any(RMContainer.class));
    }

    @Test
    public void testExistenceOfResourceRequestInRMContainer() throws Exception {
        Configuration conf = new Configuration();
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        MockNM nm1 = rm1.registerNode("unknownhost:1234", 8000);
        RMApp app1 = rm1.submitApp(1024);
        MockAM am1 = MockRM.launchAndRegisterAM((RMApp)app1, (MockRM)rm1, (MockNM)nm1);
        ResourceScheduler scheduler = rm1.getResourceScheduler();
        am1.allocate("127.0.0.1", 1024, 1, new ArrayList());
        ContainerId containerId2 = ContainerId.newInstance((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)2);
        rm1.waitForState(nm1, containerId2, RMContainerState.ALLOCATED);
        Assert.assertNotNull((Object)scheduler.getRMContainer(containerId2).getResourceRequests());
        am1.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
        rm1.waitForState(nm1, containerId2, RMContainerState.ACQUIRED);
        Assert.assertNull((Object)scheduler.getRMContainer(containerId2).getResourceRequests());
    }
}

