/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resource;

import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceWeights {
    @Test(timeout=3000L)
    public void testWeights() {
        ResourceWeights rw1 = new ResourceWeights();
        Assert.assertEquals((String)"Default CPU weight should be 0.0f.", (float)0.0f, (float)rw1.getWeight(ResourceType.CPU), (float)1.0E-5f);
        Assert.assertEquals((String)"Default memory weight should be 0.0f", (float)0.0f, (float)rw1.getWeight(ResourceType.MEMORY), (float)1.0E-5f);
        ResourceWeights rw2 = new ResourceWeights(2.0f);
        Assert.assertEquals((String)"The CPU weight should be 2.0f.", (float)2.0f, (float)rw2.getWeight(ResourceType.CPU), (float)1.0E-5f);
        Assert.assertEquals((String)"The memory weight should be 2.0f", (float)2.0f, (float)rw2.getWeight(ResourceType.MEMORY), (float)1.0E-5f);
        ResourceWeights rw3 = new ResourceWeights(1.5f, 2.0f);
        Assert.assertEquals((String)"The CPU weight should be 2.0f", (float)2.0f, (float)rw3.getWeight(ResourceType.CPU), (float)1.0E-5f);
        Assert.assertEquals((String)"The memory weight should be 1.5f", (float)1.5f, (float)rw3.getWeight(ResourceType.MEMORY), (float)1.0E-5f);
        rw3.setWeight(ResourceType.CPU, 2.5f);
        Assert.assertEquals((String)"The CPU weight should be set to 2.5f.", (float)2.5f, (float)rw3.getWeight(ResourceType.CPU), (float)1.0E-5f);
        rw3.setWeight(ResourceType.MEMORY, 4.0f);
        Assert.assertEquals((String)"The memory weight should be set to 4.0f.", (float)4.0f, (float)rw3.getWeight(ResourceType.MEMORY), (float)1.0E-5f);
    }
}

