/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.ahs;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerHistoryData;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.TestRMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestRMApplicationHistoryWriter {
    private static int MAX_RETRIES = 10;
    private RMApplicationHistoryWriter writer;
    private ApplicationHistoryStore store;
    private List<CounterDispatcher> dispatchers = new ArrayList();

    @Before
    public void setup() {
        this.store = new MemoryApplicationHistoryStore();
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.timeline-service.generic-application-history.enabled", true);
        this.writer = new /* Unavailable Anonymous Inner Class!! */;
        this.writer.init(conf);
        this.writer.start();
    }

    @After
    public void tearDown() {
        this.writer.stop();
    }

    private static RMApp createRMApp(ApplicationId appId) {
        RMApp app = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)app.getName()).thenReturn((Object)"test app");
        Mockito.when((Object)app.getApplicationType()).thenReturn((Object)"test app type");
        Mockito.when((Object)app.getUser()).thenReturn((Object)"test user");
        Mockito.when((Object)app.getQueue()).thenReturn((Object)"test queue");
        Mockito.when((Object)app.getSubmitTime()).thenReturn((Object)0L);
        Mockito.when((Object)app.getStartTime()).thenReturn((Object)1L);
        Mockito.when((Object)app.getFinishTime()).thenReturn((Object)2L);
        Mockito.when((Object)app.getDiagnostics()).thenReturn((Object)new StringBuilder("test diagnostics info"));
        Mockito.when((Object)app.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.UNDEFINED);
        return app;
    }

    private static RMAppAttempt createRMAppAttempt(ApplicationAttemptId appAttemptId) {
        RMAppAttempt appAttempt = (RMAppAttempt)Mockito.mock(RMAppAttempt.class);
        Mockito.when((Object)appAttempt.getAppAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)appAttempt.getHost()).thenReturn((Object)"test host");
        Mockito.when((Object)appAttempt.getRpcPort()).thenReturn((Object)-100);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)container.getId()).thenReturn((Object)ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1));
        Mockito.when((Object)appAttempt.getMasterContainer()).thenReturn((Object)container);
        Mockito.when((Object)appAttempt.getDiagnostics()).thenReturn((Object)"test diagnostics info");
        Mockito.when((Object)appAttempt.getTrackingUrl()).thenReturn((Object)"test url");
        Mockito.when((Object)appAttempt.getFinalApplicationStatus()).thenReturn((Object)FinalApplicationStatus.UNDEFINED);
        return appAttempt;
    }

    private static RMContainer createRMContainer(ContainerId containerId) {
        RMContainer container = (RMContainer)Mockito.mock(RMContainer.class);
        Mockito.when((Object)container.getContainerId()).thenReturn((Object)containerId);
        Mockito.when((Object)container.getAllocatedNode()).thenReturn((Object)NodeId.newInstance((String)"test host", (int)-100));
        Mockito.when((Object)container.getAllocatedResource()).thenReturn((Object)Resource.newInstance((int)-1, (int)-1));
        Mockito.when((Object)container.getAllocatedPriority()).thenReturn((Object)Priority.UNDEFINED);
        Mockito.when((Object)container.getCreationTime()).thenReturn((Object)0L);
        Mockito.when((Object)container.getFinishTime()).thenReturn((Object)1L);
        Mockito.when((Object)container.getDiagnosticsInfo()).thenReturn((Object)"test diagnostics info");
        Mockito.when((Object)container.getLogURL()).thenReturn((Object)"test log url");
        Mockito.when((Object)container.getContainerExitStatus()).thenReturn((Object)-1);
        Mockito.when((Object)container.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
        return container;
    }

    @Test
    public void testWriteApplication() throws Exception {
        int i;
        RMApp app = TestRMApplicationHistoryWriter.createRMApp((ApplicationId)ApplicationId.newInstance((long)0L, (int)1));
        this.writer.applicationStarted(app);
        ApplicationHistoryData appHD = null;
        for (i = 0; i < MAX_RETRIES && (appHD = this.store.getApplication(ApplicationId.newInstance((long)0L, (int)1))) == null; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertNotNull(appHD);
        Assert.assertEquals((Object)"test app", (Object)appHD.getApplicationName());
        Assert.assertEquals((Object)"test app type", (Object)appHD.getApplicationType());
        Assert.assertEquals((Object)"test user", (Object)appHD.getUser());
        Assert.assertEquals((Object)"test queue", (Object)appHD.getQueue());
        Assert.assertEquals((long)0L, (long)appHD.getSubmitTime());
        Assert.assertEquals((long)1L, (long)appHD.getStartTime());
        this.writer.applicationFinished(app, RMAppState.FINISHED);
        for (i = 0; i < MAX_RETRIES && (appHD = this.store.getApplication(ApplicationId.newInstance((long)0L, (int)1))).getYarnApplicationState() == null; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)2L, (long)appHD.getFinishTime());
        Assert.assertEquals((Object)"test diagnostics info", (Object)appHD.getDiagnosticsInfo());
        Assert.assertEquals((Object)FinalApplicationStatus.UNDEFINED, (Object)appHD.getFinalApplicationStatus());
        Assert.assertEquals((Object)YarnApplicationState.FINISHED, (Object)appHD.getYarnApplicationState());
    }

    @Test
    public void testWriteApplicationAttempt() throws Exception {
        int i;
        RMAppAttempt appAttempt = TestRMApplicationHistoryWriter.createRMAppAttempt((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1));
        this.writer.applicationAttemptStarted(appAttempt);
        ApplicationAttemptHistoryData appAttemptHD = null;
        for (i = 0; i < MAX_RETRIES && (appAttemptHD = this.store.getApplicationAttempt(ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1))) == null; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertNotNull(appAttemptHD);
        Assert.assertEquals((Object)"test host", (Object)appAttemptHD.getHost());
        Assert.assertEquals((long)-100L, (long)appAttemptHD.getRPCPort());
        Assert.assertEquals((Object)ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1), (Object)appAttemptHD.getMasterContainerId());
        this.writer.applicationAttemptFinished(appAttempt, RMAppAttemptState.FINISHED);
        for (i = 0; i < MAX_RETRIES && (appAttemptHD = this.store.getApplicationAttempt(ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1))).getYarnApplicationAttemptState() == null; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)"test diagnostics info", (Object)appAttemptHD.getDiagnosticsInfo());
        Assert.assertEquals((Object)"test url", (Object)appAttemptHD.getTrackingURL());
        Assert.assertEquals((Object)FinalApplicationStatus.UNDEFINED, (Object)appAttemptHD.getFinalApplicationStatus());
        Assert.assertEquals((Object)YarnApplicationAttemptState.FINISHED, (Object)appAttemptHD.getYarnApplicationAttemptState());
    }

    @Test
    public void testWriteContainer() throws Exception {
        int i;
        RMContainer container = TestRMApplicationHistoryWriter.createRMContainer((ContainerId)ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1));
        this.writer.containerStarted(container);
        ContainerHistoryData containerHD = null;
        for (i = 0; i < MAX_RETRIES && (containerHD = this.store.getContainer(ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1))) == null; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertNotNull(containerHD);
        Assert.assertEquals((Object)NodeId.newInstance((String)"test host", (int)-100), (Object)containerHD.getAssignedNode());
        Assert.assertEquals((Object)Resource.newInstance((int)-1, (int)-1), (Object)containerHD.getAllocatedResource());
        Assert.assertEquals((Object)Priority.UNDEFINED, (Object)containerHD.getPriority());
        Assert.assertEquals((long)0L, (long)container.getCreationTime());
        this.writer.containerFinished(container);
        for (i = 0; i < MAX_RETRIES && (containerHD = this.store.getContainer(ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1))).getContainerState() == null; ++i) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((Object)"test diagnostics info", (Object)containerHD.getDiagnosticsInfo());
        Assert.assertEquals((long)-1L, (long)containerHD.getContainerExitStatus());
        Assert.assertEquals((Object)ContainerState.COMPLETE, (Object)containerHD.getContainerState());
    }

    @Test
    public void testParallelWrite() throws Exception {
        int i;
        ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>();
        for (i = 0; i < 10; ++i) {
            Random rand = new Random(i);
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)rand.nextInt());
            appIds.add(appId);
            RMApp app = TestRMApplicationHistoryWriter.createRMApp((ApplicationId)appId);
            this.writer.applicationStarted(app);
            for (int j = 1; j <= 10; ++j) {
                ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)j);
                RMAppAttempt appAttempt = TestRMApplicationHistoryWriter.createRMAppAttempt((ApplicationAttemptId)appAttemptId);
                this.writer.applicationAttemptStarted(appAttempt);
                for (int k = 1; k <= 10; ++k) {
                    ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)k);
                    RMContainer container = TestRMApplicationHistoryWriter.createRMContainer((ContainerId)containerId);
                    this.writer.containerStarted(container);
                    this.writer.containerFinished(container);
                }
                this.writer.applicationAttemptFinished(appAttempt, RMAppAttemptState.FINISHED);
            }
            this.writer.applicationFinished(app, RMAppState.FINISHED);
        }
        for (i = 0; i < MAX_RETRIES && !this.allEventsHandled(2220); ++i) {
            Thread.sleep(500L);
        }
        Assert.assertTrue((boolean)this.allEventsHandled(2220));
        for (ApplicationId appId : appIds) {
            Assert.assertTrue((boolean)this.handledByOne(appId));
        }
    }

    private boolean allEventsHandled(int expected) {
        int actual = 0;
        for (CounterDispatcher dispatcher : this.dispatchers) {
            for (Integer count : CounterDispatcher.access$300((CounterDispatcher)dispatcher).values()) {
                actual += count.intValue();
            }
        }
        return actual == expected;
    }

    @Test
    public void testRMWritingMassiveHistory() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        2 rm = new /* Unavailable Anonymous Inner Class!! */;
        long startTime1 = System.currentTimeMillis();
        this.testRMWritingMassiveHistory((MockRM)rm);
        long finishTime1 = System.currentTimeMillis();
        long elapsedTime1 = finishTime1 - startTime1;
        rm = new MockRM((Configuration)conf);
        long startTime2 = System.currentTimeMillis();
        this.testRMWritingMassiveHistory((MockRM)rm);
        long finishTime2 = System.currentTimeMillis();
        long elapsedTime2 = finishTime2 - startTime2;
        Assert.assertTrue((elapsedTime2 - elapsedTime1 < elapsedTime1 / 10L ? 1 : 0) != 0);
    }

    private void testRMWritingMassiveHistory(MockRM rm) throws Exception {
        int cleanedSize;
        int allocatedSize;
        rm.start();
        MockNM nm = rm.registerNode("127.0.0.1:1234", 0x9DD000);
        RMApp app = rm.submitApp(1024);
        nm.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        int request = 10000;
        am.allocate("127.0.0.1", 1024, request, new ArrayList());
        nm.nodeHeartbeat(true);
        List allocated = am.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
        int waitCount = 0;
        for (allocatedSize = allocated.size(); allocatedSize < request && waitCount++ < 200; allocatedSize += allocated.size()) {
            Thread.sleep(300L);
            allocated = am.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
            nm.nodeHeartbeat(true);
        }
        Assert.assertEquals((long)request, (long)allocatedSize);
        am.unregisterAppAttempt();
        am.waitForState(RMAppAttemptState.FINISHING);
        nm.nodeHeartbeat(am.getApplicationAttemptId(), 1, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        NodeHeartbeatResponse resp = nm.nodeHeartbeat(true);
        List cleaned = resp.getContainersToCleanup();
        waitCount = 0;
        for (cleanedSize = cleaned.size(); cleanedSize < allocatedSize && waitCount++ < 200; cleanedSize += cleaned.size()) {
            Thread.sleep(300L);
            resp = nm.nodeHeartbeat(true);
            cleaned = resp.getContainersToCleanup();
        }
        Assert.assertEquals((long)allocatedSize, (long)cleanedSize);
        rm.waitForState(app.getApplicationId(), RMAppState.FINISHED);
        rm.stop();
    }

    private boolean handledByOne(ApplicationId appId) {
        int count = 0;
        for (CounterDispatcher dispatcher : this.dispatchers) {
            if (!CounterDispatcher.access$300((CounterDispatcher)dispatcher).containsKey(appId)) continue;
            ++count;
        }
        return count == 1;
    }

    static /* synthetic */ ApplicationHistoryStore access$000(TestRMApplicationHistoryWriter x0) {
        return x0.store;
    }

    static /* synthetic */ List access$200(TestRMApplicationHistoryWriter x0) {
        return x0.dispatchers;
    }
}

