/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=Parameterized.class)
public class TestWorkPreservingRMRestart {
    private YarnConfiguration conf;
    private Class<?> schedulerClass;
    MockRM rm1 = null;
    MockRM rm2 = null;
    private static final String R = "Default";
    private static final String A = "QueueA";
    private static final String B = "QueueB";
    private static final String USER_1 = "user1";
    private static final String USER_2 = "user2";

    @Before
    public void setup() throws UnknownHostException {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        this.conf = new YarnConfiguration();
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.conf.set("yarn.resourcemanager.recovery.enabled", "true");
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.conf.setClass("yarn.resourcemanager.scheduler.class", this.schedulerClass, ResourceScheduler.class);
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    @After
    public void tearDown() {
        if (this.rm1 != null) {
            this.rm1.stop();
        }
        if (this.rm2 != null) {
            this.rm2.stop();
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({CapacityScheduler.class}, {FifoScheduler.class});
    }

    public TestWorkPreservingRMRestart(Class<?> schedulerClass) {
        this.schedulerClass = schedulerClass;
    }

    @Test(timeout=20000L)
    public void testSchedulerRecovery() throws Exception {
        this.conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.conf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        int containerMemory = 1024;
        Resource containerResource = Resource.newInstance((int)containerMemory, (int)1);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        this.rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = this.rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM((RMApp)app1, (MockRM)this.rm1, (MockNM)nm1);
        this.rm1.clearQueueMetrics(app1);
        this.rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        RMApp recoveredApp1 = (RMApp)this.rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        RMAppAttempt loadedAttempt1 = recoveredApp1.getCurrentAppAttempt();
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)1, (ContainerState)ContainerState.RUNNING);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)2, (ContainerState)ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)3, (ContainerState)ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(amContainer, runningContainer, completedContainer), null);
        this.waitForNumContainersToRecover(2, this.rm2, am1.getApplicationAttemptId());
        this.rm2.waitForState(nm1, amContainer.getContainerId(), RMContainerState.RUNNING);
        this.rm2.waitForState(nm1, runningContainer.getContainerId(), RMContainerState.RUNNING);
        this.rm2.waitForContainerToComplete(loadedAttempt1, completedContainer);
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.rm2.getResourceScheduler();
        SchedulerNode schedulerNode1 = scheduler.getSchedulerNode(nm1.getNodeId());
        Resource usedResources = Resources.multiply((Resource)containerResource, (double)2.0);
        Resource nmResource = Resource.newInstance((int)nm1.getMemory(), (int)nm1.getvCores());
        Assert.assertTrue((boolean)schedulerNode1.isValidContainer(amContainer.getContainerId()));
        Assert.assertTrue((boolean)schedulerNode1.isValidContainer(runningContainer.getContainerId()));
        Assert.assertFalse((boolean)schedulerNode1.isValidContainer(completedContainer.getContainerId()));
        Assert.assertEquals((long)2L, (long)schedulerNode1.getNumContainers());
        Assert.assertEquals((Object)Resources.subtract((Resource)nmResource, (Resource)usedResources), (Object)schedulerNode1.getAvailableResource());
        Assert.assertEquals((Object)usedResources, (Object)schedulerNode1.getUsedResource());
        Resource availableResources = Resources.subtract((Resource)nmResource, (Resource)usedResources);
        Map schedulerApps = ((AbstractYarnScheduler)this.rm2.getResourceScheduler()).getSchedulerApplications();
        SchedulerApplication schedulerApp = (SchedulerApplication)schedulerApps.get(recoveredApp1.getApplicationId());
        if (this.schedulerClass.equals(CapacityScheduler.class)) {
            this.checkCSQueue(this.rm2, schedulerApp, nmResource, nmResource, usedResources, 2);
        } else if (this.schedulerClass.equals(FifoScheduler.class)) {
            this.checkFifoQueue(schedulerApp, usedResources, availableResources);
        }
        SchedulerApplicationAttempt schedulerAttempt = schedulerApp.getCurrentAppAttempt();
        Assert.assertTrue((boolean)schedulerAttempt.getLiveContainers().contains(scheduler.getRMContainer(amContainer.getContainerId())));
        Assert.assertTrue((boolean)schedulerAttempt.getLiveContainers().contains(scheduler.getRMContainer(runningContainer.getContainerId())));
        Assert.assertEquals((Object)schedulerAttempt.getCurrentConsumption(), (Object)usedResources);
        Assert.assertEquals((Object)availableResources, (Object)schedulerAttempt.getHeadroom());
        Assert.assertEquals((long)0x400001L, (long)schedulerAttempt.getNewContainerId());
    }

    private void checkCSQueue(MockRM rm, SchedulerApplication<SchedulerApplicationAttempt> app, Resource clusterResource, Resource queueResource, Resource usedResource, int numContainers) throws Exception {
        this.checkCSLeafQueue(this.rm2, app, clusterResource, queueResource, usedResource, numContainers);
        LeafQueue queue = (LeafQueue)app.getQueue();
        Resource availableResources = Resources.subtract((Resource)queueResource, (Resource)usedResource);
        QueueMetrics queueMetrics = queue.getMetrics();
        this.asserteMetrics(queueMetrics, 1, 0, 1, 0, 2, availableResources.getMemory(), availableResources.getVirtualCores(), usedResource.getMemory(), usedResource.getVirtualCores());
        QueueMetrics userMetrics = queueMetrics.getUserMetrics(app.getUser());
        this.asserteMetrics(userMetrics, 1, 0, 1, 0, 2, availableResources.getMemory(), availableResources.getVirtualCores(), usedResource.getMemory(), usedResource.getVirtualCores());
    }

    private void checkCSLeafQueue(MockRM rm, SchedulerApplication<SchedulerApplicationAttempt> app, Resource clusterResource, Resource queueResource, Resource usedResource, int numContainers) {
        LeafQueue leafQueue = (LeafQueue)app.getQueue();
        Assert.assertEquals((Object)usedResource, (Object)leafQueue.getUsedResources());
        Assert.assertEquals((long)numContainers, (long)leafQueue.getNumContainers());
        ResourceCalculator calc = ((CapacityScheduler)rm.getResourceScheduler()).getResourceCalculator();
        float usedCapacity = Resources.divide((ResourceCalculator)calc, (Resource)clusterResource, (Resource)usedResource, (Resource)queueResource);
        Assert.assertEquals((double)usedCapacity, (double)leafQueue.getUsedCapacity(), (double)1.0E-8);
        float absoluteUsedCapacity = Resources.divide((ResourceCalculator)calc, (Resource)clusterResource, (Resource)usedResource, (Resource)clusterResource);
        Assert.assertEquals((double)absoluteUsedCapacity, (double)leafQueue.getAbsoluteUsedCapacity(), (double)1.0E-8);
        Assert.assertEquals((Object)usedResource, (Object)leafQueue.getUser(app.getUser()).getConsumedResources());
    }

    private void checkFifoQueue(SchedulerApplication schedulerApp, Resource usedResources, Resource availableResources) throws Exception {
        FifoScheduler scheduler = (FifoScheduler)this.rm2.getResourceScheduler();
        Assert.assertEquals((Object)usedResources, (Object)scheduler.getUsedResource());
        SchedulerApplicationAttempt schedulerAttempt = schedulerApp.getCurrentAppAttempt();
        Assert.assertEquals((Object)availableResources, (Object)schedulerAttempt.getHeadroom());
        QueueMetrics queueMetrics = scheduler.getRootQueueMetrics();
        this.asserteMetrics(queueMetrics, 1, 0, 1, 0, 2, availableResources.getMemory(), availableResources.getVirtualCores(), usedResources.getMemory(), usedResources.getVirtualCores());
    }

    public static List<NMContainerStatus> createNMContainerStatusForApp(MockAM am) {
        ArrayList<NMContainerStatus> list = new ArrayList<NMContainerStatus>();
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am.getApplicationAttemptId(), (int)1, (ContainerState)ContainerState.RUNNING);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am.getApplicationAttemptId(), (int)2, (ContainerState)ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am.getApplicationAttemptId(), (int)3, (ContainerState)ContainerState.COMPLETE);
        list.add(amContainer);
        list.add(runningContainer);
        list.add(completedContainer);
        return list;
    }

    private void setupQueueConfiguration(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{"Default"});
        String Q_R = "root.Default";
        conf.setCapacity("root.Default", 100.0f);
        String Q_A = "root.Default.QueueA";
        String Q_B = "root.Default.QueueB";
        conf.setQueues("root.Default", new String[]{"QueueA", "QueueB"});
        conf.setCapacity("root.Default.QueueA", 50.0f);
        conf.setCapacity("root.Default.QueueB", 50.0f);
        conf.setDouble("yarn.scheduler.capacity.maximum-am-resource-percent", 0.5);
    }

    @Test(timeout=30000L)
    public void testCapacitySchedulerRecovery() throws Exception {
        if (!this.schedulerClass.equals(CapacityScheduler.class)) {
            return;
        }
        this.conf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.conf.set("yarn.scheduler.capacity.resource-calculator", DominantResourceCalculator.class.getName());
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        this.setupQueueConfiguration(csConf);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)csConf);
        this.rm1 = new MockRM((Configuration)csConf, (RMStateStore)memStore);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        MockNM nm2 = new MockNM("127.1.1.1:4321", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        nm2.registerNode();
        RMApp app1_1 = this.rm1.submitApp(1024, "app1_1", "user1", null, "QueueA");
        MockAM am1_1 = MockRM.launchAndRegisterAM((RMApp)app1_1, (MockRM)this.rm1, (MockNM)nm1);
        RMApp app1_2 = this.rm1.submitApp(1024, "app1_2", "user1", null, "QueueA");
        MockAM am1_2 = MockRM.launchAndRegisterAM((RMApp)app1_2, (MockRM)this.rm1, (MockNM)nm2);
        RMApp app2 = this.rm1.submitApp(1024, "app2", "user2", null, "QueueB");
        MockAM am2 = MockRM.launchAndRegisterAM((RMApp)app2, (MockRM)this.rm1, (MockNM)nm2);
        this.rm1.clearQueueMetrics(app1_1);
        this.rm1.clearQueueMetrics(app1_2);
        this.rm1.clearQueueMetrics(app2);
        this.rm2 = new MockRM((Configuration)csConf, (RMStateStore)memStore);
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        nm2.setResourceTrackerService(this.rm2.getResourceTrackerService());
        List am1_1Containers = TestWorkPreservingRMRestart.createNMContainerStatusForApp((MockAM)am1_1);
        List am1_2Containers = TestWorkPreservingRMRestart.createNMContainerStatusForApp((MockAM)am1_2);
        am1_1Containers.addAll(am1_2Containers);
        nm1.registerNode(am1_1Containers, null);
        List am2Containers = TestWorkPreservingRMRestart.createNMContainerStatusForApp((MockAM)am2);
        nm2.registerNode(am2Containers, null);
        this.waitForNumContainersToRecover(2, this.rm2, am1_1.getApplicationAttemptId());
        this.waitForNumContainersToRecover(2, this.rm2, am1_2.getApplicationAttemptId());
        this.waitForNumContainersToRecover(2, this.rm2, am1_2.getApplicationAttemptId());
        Resource containerResource = Resource.newInstance((int)1024, (int)1);
        Resource nmResource = Resource.newInstance((int)nm1.getMemory(), (int)nm1.getvCores());
        Resource clusterResource = Resources.multiply((Resource)nmResource, (double)2.0);
        Resource q1Resource = Resources.multiply((Resource)clusterResource, (double)0.5);
        Resource q2Resource = Resources.multiply((Resource)clusterResource, (double)0.5);
        Resource q1UsedResource = Resources.multiply((Resource)containerResource, (double)4.0);
        Resource q2UsedResource = Resources.multiply((Resource)containerResource, (double)2.0);
        Resource totalUsedResource = Resources.add((Resource)q1UsedResource, (Resource)q2UsedResource);
        Resource q1availableResources = Resources.subtract((Resource)q1Resource, (Resource)q1UsedResource);
        Resource q2availableResources = Resources.subtract((Resource)q2Resource, (Resource)q2UsedResource);
        Resource totalAvailableResource = Resources.add((Resource)q1availableResources, (Resource)q2availableResources);
        Map schedulerApps = ((AbstractYarnScheduler)this.rm2.getResourceScheduler()).getSchedulerApplications();
        SchedulerApplication schedulerApp1_1 = (SchedulerApplication)schedulerApps.get(app1_1.getApplicationId());
        this.checkCSLeafQueue(this.rm2, schedulerApp1_1, clusterResource, q1Resource, q1UsedResource, 4);
        QueueMetrics queue1Metrics = schedulerApp1_1.getQueue().getMetrics();
        this.asserteMetrics(queue1Metrics, 2, 0, 2, 0, 4, q1availableResources.getMemory(), q1availableResources.getVirtualCores(), q1UsedResource.getMemory(), q1UsedResource.getVirtualCores());
        SchedulerApplication schedulerApp2 = (SchedulerApplication)schedulerApps.get(app2.getApplicationId());
        this.checkCSLeafQueue(this.rm2, schedulerApp2, clusterResource, q2Resource, q2UsedResource, 2);
        QueueMetrics queue2Metrics = schedulerApp2.getQueue().getMetrics();
        this.asserteMetrics(queue2Metrics, 1, 0, 1, 0, 2, q2availableResources.getMemory(), q2availableResources.getVirtualCores(), q2UsedResource.getMemory(), q2UsedResource.getVirtualCores());
        LeafQueue leafQueue = (LeafQueue)schedulerApp2.getQueue();
        ParentQueue parentQueue = (ParentQueue)leafQueue.getParent();
        this.checkParentQueue(parentQueue, 6, totalUsedResource, 0.375f, 0.375f);
        this.asserteMetrics(parentQueue.getMetrics(), 3, 0, 3, 0, 6, totalAvailableResource.getMemory(), totalAvailableResource.getVirtualCores(), totalUsedResource.getMemory(), totalUsedResource.getVirtualCores());
    }

    private void checkParentQueue(ParentQueue parentQueue, int numContainers, Resource usedResource, float UsedCapacity, float absoluteUsedCapacity) {
        Assert.assertEquals((long)numContainers, (long)parentQueue.getNumContainers());
        Assert.assertEquals((Object)usedResource, (Object)parentQueue.getUsedResources());
        Assert.assertEquals((double)UsedCapacity, (double)parentQueue.getUsedCapacity(), (double)1.0E-8);
        Assert.assertEquals((double)absoluteUsedCapacity, (double)parentQueue.getAbsoluteUsedCapacity(), (double)1.0E-8);
    }

    @Test(timeout=20000L)
    public void testAMfailedBetweenRMRestart() throws Exception {
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        this.rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = this.rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM((RMApp)app1, (MockRM)this.rm1, (MockNM)nm1);
        this.rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        NMContainerStatus amContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)1, (ContainerState)ContainerState.COMPLETE);
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)2, (ContainerState)ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)3, (ContainerState)ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(amContainer, runningContainer, completedContainer), null);
        this.rm2.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.FAILED);
        Thread.sleep(3000L);
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.rm2.getResourceScheduler();
        Assert.assertNull((Object)scheduler.getRMContainer(runningContainer.getContainerId()));
        Assert.assertNull((Object)scheduler.getRMContainer(completedContainer.getContainerId()));
    }

    @Test(timeout=20000L)
    public void testContainersNotRecoveredForCompletedApps() throws Exception {
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        this.rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1 = this.rm1.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM((RMApp)app1, (MockRM)this.rm1, (MockNM)nm1);
        MockRM.finishAMAndVerifyAppState((RMApp)app1, (MockRM)this.rm1, (MockNM)nm1, (MockAM)am1);
        this.rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        NMContainerStatus runningContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)2, (ContainerState)ContainerState.RUNNING);
        NMContainerStatus completedContainer = TestRMRestart.createNMContainerStatus((ApplicationAttemptId)am1.getApplicationAttemptId(), (int)3, (ContainerState)ContainerState.COMPLETE);
        nm1.registerNode(Arrays.asList(runningContainer, completedContainer), null);
        RMApp recoveredApp1 = (RMApp)this.rm2.getRMContext().getRMApps().get(app1.getApplicationId());
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)recoveredApp1.getState());
        Thread.sleep(3000L);
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.rm2.getResourceScheduler();
        Assert.assertNull((Object)scheduler.getRMContainer(runningContainer.getContainerId()));
        Assert.assertNull((Object)scheduler.getRMContainer(completedContainer.getContainerId()));
    }

    @Test(timeout=600000L)
    public void testAppReregisterOnRMWorkPreservingRestart() throws Exception {
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        this.rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app0 = this.rm1.submitApp(200);
        MockAM am0 = MockRM.launchAM((RMApp)app0, (MockRM)this.rm1, (MockNM)nm1);
        this.rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm2.start();
        this.rm2.waitForState(app0.getApplicationId(), RMAppState.ACCEPTED);
        this.rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.LAUNCHED);
        am0.setAMRMProtocol((ApplicationMasterProtocol)this.rm2.getApplicationMasterService());
        am0.registerAppAttempt(false);
        this.rm2.waitForState(app0.getApplicationId(), RMAppState.RUNNING);
        this.rm2.waitForState(am0.getApplicationAttemptId(), RMAppAttemptState.RUNNING);
    }

    @Test(timeout=30000L)
    public void testAMContainerStatusWithRMRestart() throws Exception {
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)this.conf);
        this.rm1 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm1.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8192, this.rm1.getResourceTrackerService());
        nm1.registerNode();
        RMApp app1_1 = this.rm1.submitApp(1024);
        MockAM am1_1 = MockRM.launchAndRegisterAM((RMApp)app1_1, (MockRM)this.rm1, (MockNM)nm1);
        RMAppAttempt attempt0 = app1_1.getCurrentAppAttempt();
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)this.rm1.getResourceScheduler();
        Assert.assertTrue((boolean)scheduler.getRMContainer(attempt0.getMasterContainer().getId()).isAMContainer());
        this.rm2 = new MockRM((Configuration)this.conf, (RMStateStore)memStore);
        this.rm2.start();
        nm1.setResourceTrackerService(this.rm2.getResourceTrackerService());
        List am1_1Containers = TestWorkPreservingRMRestart.createNMContainerStatusForApp((MockAM)am1_1);
        nm1.registerNode(am1_1Containers, null);
        this.waitForNumContainersToRecover(2, this.rm2, am1_1.getApplicationAttemptId());
        scheduler = (AbstractYarnScheduler)this.rm2.getResourceScheduler();
        Assert.assertTrue((boolean)scheduler.getRMContainer(attempt0.getMasterContainer().getId()).isAMContainer());
    }

    private void asserteMetrics(QueueMetrics qm, int appsSubmitted, int appsPending, int appsRunning, int appsCompleted, int allocatedContainers, int availableMB, int availableVirtualCores, int allocatedMB, int allocatedVirtualCores) {
        Assert.assertEquals((long)appsSubmitted, (long)qm.getAppsSubmitted());
        Assert.assertEquals((long)appsPending, (long)qm.getAppsPending());
        Assert.assertEquals((long)appsRunning, (long)qm.getAppsRunning());
        Assert.assertEquals((long)appsCompleted, (long)qm.getAppsCompleted());
        Assert.assertEquals((long)allocatedContainers, (long)qm.getAllocatedContainers());
        Assert.assertEquals((long)availableMB, (long)qm.getAvailableMB());
        Assert.assertEquals((long)availableVirtualCores, (long)qm.getAvailableVirtualCores());
        Assert.assertEquals((long)allocatedMB, (long)qm.getAllocatedMB());
        Assert.assertEquals((long)allocatedVirtualCores, (long)qm.getAllocatedVirtualCores());
    }

    private void waitForNumContainersToRecover(int num, MockRM rm, ApplicationAttemptId attemptId) throws Exception {
        AbstractYarnScheduler scheduler = (AbstractYarnScheduler)rm.getResourceScheduler();
        SchedulerApplicationAttempt attempt = scheduler.getApplicationAttempt(attemptId);
        while (attempt == null) {
            System.out.println("Wait for scheduler attempt " + attemptId + " to be created");
            Thread.sleep(200L);
            attempt = scheduler.getApplicationAttempt(attemptId);
        }
        while (attempt.getLiveContainers().size() < num) {
            System.out.println("Wait for " + num + " containers to recover.");
            Thread.sleep(200L);
        }
    }
}

