/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;

/*
 * Exception performing whole class analysis ignored.
 */
public class RMAuditLogger {
    private static final Log LOG = LogFactory.getLog(RMAuditLogger.class);

    static String createSuccessLog(String user, String operation, String target, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        StringBuilder b = new StringBuilder();
        RMAuditLogger.start((Keys)Keys.USER, (String)user, (StringBuilder)b);
        RMAuditLogger.addRemoteIP((StringBuilder)b);
        RMAuditLogger.add((Keys)Keys.OPERATION, (String)operation, (StringBuilder)b);
        RMAuditLogger.add((Keys)Keys.TARGET, (String)target, (StringBuilder)b);
        RMAuditLogger.add((Keys)Keys.RESULT, (String)"SUCCESS", (StringBuilder)b);
        if (appId != null) {
            RMAuditLogger.add((Keys)Keys.APPID, (String)appId.toString(), (StringBuilder)b);
        }
        if (attemptId != null) {
            RMAuditLogger.add((Keys)Keys.APPATTEMPTID, (String)attemptId.toString(), (StringBuilder)b);
        }
        if (containerId != null) {
            RMAuditLogger.add((Keys)Keys.CONTAINERID, (String)containerId.toString(), (StringBuilder)b);
        }
        return b.toString();
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, ContainerId containerId) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog((String)user, (String)operation, (String)target, (ApplicationId)appId, null, (ContainerId)containerId));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, ApplicationAttemptId attemptId) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog((String)user, (String)operation, (String)target, (ApplicationId)appId, (ApplicationAttemptId)attemptId, null));
        }
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog((String)user, (String)operation, (String)target, (ApplicationId)appId, null, null));
        }
    }

    public static void logSuccess(String user, String operation, String target) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)RMAuditLogger.createSuccessLog((String)user, (String)operation, (String)target, null, null, null));
        }
    }

    static String createFailureLog(String user, String operation, String perm, String target, String description, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        StringBuilder b = new StringBuilder();
        RMAuditLogger.start((Keys)Keys.USER, (String)user, (StringBuilder)b);
        RMAuditLogger.addRemoteIP((StringBuilder)b);
        RMAuditLogger.add((Keys)Keys.OPERATION, (String)operation, (StringBuilder)b);
        RMAuditLogger.add((Keys)Keys.TARGET, (String)target, (StringBuilder)b);
        RMAuditLogger.add((Keys)Keys.RESULT, (String)"FAILURE", (StringBuilder)b);
        RMAuditLogger.add((Keys)Keys.DESCRIPTION, (String)description, (StringBuilder)b);
        RMAuditLogger.add((Keys)Keys.PERMISSIONS, (String)perm, (StringBuilder)b);
        if (appId != null) {
            RMAuditLogger.add((Keys)Keys.APPID, (String)appId.toString(), (StringBuilder)b);
        }
        if (attemptId != null) {
            RMAuditLogger.add((Keys)Keys.APPATTEMPTID, (String)attemptId.toString(), (StringBuilder)b);
        }
        if (containerId != null) {
            RMAuditLogger.add((Keys)Keys.CONTAINERID, (String)containerId.toString(), (StringBuilder)b);
        }
        return b.toString();
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, ContainerId containerId) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog((String)user, (String)operation, (String)perm, (String)target, (String)description, (ApplicationId)appId, null, (ContainerId)containerId));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId, ApplicationAttemptId attemptId) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog((String)user, (String)operation, (String)perm, (String)target, (String)description, (ApplicationId)appId, (ApplicationAttemptId)attemptId, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description, ApplicationId appId) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog((String)user, (String)operation, (String)perm, (String)target, (String)description, (ApplicationId)appId, null, null));
        }
    }

    public static void logFailure(String user, String operation, String perm, String target, String description) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)RMAuditLogger.createFailureLog((String)user, (String)operation, (String)perm, (String)target, (String)description, null, null, null));
        }
    }

    static void addRemoteIP(StringBuilder b) {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            RMAuditLogger.add((Keys)Keys.IP, (String)ip.getHostAddress(), (StringBuilder)b);
        }
    }

    static void start(Keys key, String value, StringBuilder b) {
        b.append(key.name()).append("=").append(value);
    }

    static void add(Keys key, String value, StringBuilder b) {
        b.append('\t').append(key.name()).append("=").append(value);
    }
}

