/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
public abstract class MockAsm
extends MockApps {
    public static RMApp newApplication(int i) {
        final ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)MockAsm.newAppID((int)i), (int)0);
        Container masterContainer = (Container)Records.newRecord(Container.class);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)0);
        masterContainer.setId(containerId);
        masterContainer.setNodeHttpAddress("node:port");
        final String user = MockAsm.newUserName();
        final String name = MockAsm.newAppName();
        final String queue = MockAsm.newQueue();
        final long start = 123456 + i * 1000;
        final long finish = 234567 + i * 1000;
        String type = "YARN";
        YarnApplicationState[] allStates = YarnApplicationState.values();
        final YarnApplicationState state = allStates[i % allStates.length];
        final int maxAppAttempts = i % 1000;
        return new ApplicationBase(){

            @Override
            public ApplicationId getApplicationId() {
                return appAttemptId.getApplicationId();
            }

            @Override
            public String getUser() {
                return user;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getApplicationType() {
                return "YARN";
            }

            @Override
            public String getQueue() {
                return queue;
            }

            @Override
            public long getStartTime() {
                return start;
            }

            @Override
            public long getFinishTime() {
                return finish;
            }

            @Override
            public String getTrackingUrl() {
                return null;
            }

            @Override
            public YarnApplicationState createApplicationState() {
                return state;
            }

            @Override
            public StringBuilder getDiagnostics() {
                return new StringBuilder();
            }

            @Override
            public float getProgress() {
                return (float)Math.random();
            }

            @Override
            public FinalApplicationStatus getFinalApplicationStatus() {
                return FinalApplicationStatus.UNDEFINED;
            }

            @Override
            public RMAppAttempt getCurrentAppAttempt() {
                return null;
            }

            @Override
            public int getMaxAppAttempts() {
                return maxAppAttempts;
            }

            @Override
            public Set<String> getApplicationTags() {
                return null;
            }
        };
    }

    public static List<RMApp> newApplications(int n) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            list.add(MockAsm.newApplication(i));
        }
        return list;
    }

    public static class ApplicationBase
    implements RMApp {
        public String getUser() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationSubmissionContext getApplicationSubmissionContext() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getQueue() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getStartTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getSubmitTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getFinishTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public StringBuilder getDiagnostics() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationId getApplicationId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppAttempt getCurrentAppAttempt() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<ApplicationAttemptId, RMAppAttempt> getAppAttempts() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public float getProgress() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppAttempt getRMAppAttempt(ApplicationAttemptId appAttemptId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppState getState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getTrackingUrl() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getMaxAppAttempts() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void handle(RMAppEvent event) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FinalApplicationStatus getFinalApplicationStatus() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int pullRMNodeUpdates(Collection<RMNode> updatedNodes) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getApplicationType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<String> getApplicationTags() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setQueue(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isAppFinalStateStored() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public YarnApplicationState createApplicationState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

