/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.labelmanagement;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import net.java.dev.eval.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelStorage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;

public class LabelExpressionHandlingHelper {
    private static final Log LOG = LogFactory.getLog(LabelExpressionHandlingHelper.class);

    static Expression getEffectiveLabelExpr(String appLabelStr) throws IOException {
        Expression appLabelExpression;
        if (appLabelStr == null) {
            return null;
        }
        String appLabelExpressionString = appLabelStr.replaceAll("^\"|\"$", "");
        if ("*".equals(appLabelExpressionString) || "all".equals(appLabelExpressionString)) {
            appLabelExpression = null;
        } else {
            try {
                appLabelExpression = new Expression(appLabelExpressionString);
            }
            catch (Throwable t) {
                LOG.warn((Object)("Invalid label format " + appLabelExpressionString + " Error " + t));
                return null;
            }
        }
        return appLabelExpression;
    }

    static Expression constructAppLabel(Queue.QueueLabelPolicy policy, Expression appLabelExpression, Expression queueLabelExpression) {
        if (Queue.QueueLabelPolicy.AND.equals((Object)policy)) {
            if (queueLabelExpression != null && appLabelExpression != null) {
                return new Expression("(" + queueLabelExpression.toString() + ") && (" + appLabelExpression.toString() + ")");
            }
            if (queueLabelExpression == null) {
                return appLabelExpression;
            }
            return queueLabelExpression;
        }
        if (Queue.QueueLabelPolicy.OR.equals((Object)policy)) {
            if (queueLabelExpression != null && appLabelExpression != null) {
                return new Expression("(" + queueLabelExpression.toString() + ") || (" + appLabelExpression.toString() + ")");
            }
            if (queueLabelExpression == null) {
                return appLabelExpression;
            }
            return queueLabelExpression;
        }
        if (Queue.QueueLabelPolicy.PREFER_QUEUE.equals((Object)policy)) {
            return queueLabelExpression;
        }
        if (Queue.QueueLabelPolicy.PREFER_APP.equals((Object)policy)) {
            return appLabelExpression;
        }
        return appLabelExpression;
    }

    static LabelManager.LabelApplicabilityStatus isNodeApplicableForApp(String node, Expression finalAppLabelExp) throws IOException {
        if (finalAppLabelExp == null) {
            return LabelManager.LabelApplicabilityStatus.NOT_APPLICABLE;
        }
        Set<String> nodeLabels = LabelStorage.getInstance().getLabelsForNode(node);
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            return LabelManager.LabelApplicabilityStatus.NOT_APPLICABLE;
        }
        Map<String, BigDecimal> labelEvalFillersTmp = LabelStorage.getInstance().getFillers();
        for (String label : nodeLabels) {
            labelEvalFillersTmp.put(label, BigDecimal.valueOf(1L));
        }
        try {
            BigDecimal retValue = finalAppLabelExp.eval(labelEvalFillersTmp);
            return retValue.intValue() == 0 ? LabelManager.LabelApplicabilityStatus.NODE_DOES_NOT_HAVE_LABEL : LabelManager.LabelApplicabilityStatus.NODE_HAS_LABEL;
        }
        catch (Throwable t) {
            LOG.warn((Object)("Exception while evaluating: " + finalAppLabelExp), t);
            throw new IOException("Exception while evaluating: " + finalAppLabelExp);
        }
    }
}

