/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFifoScheduler {
    private static final Log LOG = LogFactory.getLog(TestFifoScheduler.class);
    private final int GB = 1024;
    private ResourceManager resourceManager = null;
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Before
    public void setUp() throws Exception {
        this.resourceManager = new ResourceManager();
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        this.resourceManager.init(conf);
    }

    @After
    public void tearDown() throws Exception {
        this.resourceManager.stop();
    }

    private NodeManager registerNode(String hostName, int containerManagerPort, int nmHttpPort, String rackName, Resource capability) throws IOException, YarnException {
        return new NodeManager(hostName, containerManagerPort, nmHttpPort, rackName, capability, this.resourceManager);
    }

    private ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
        return attId;
    }

    private ResourceRequest createResourceRequest(int memory, String host, int priority, int numContainers) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        request.setCapability(Resources.createResource((int)memory));
        request.setResourceName(host);
        request.setNumContainers(numContainers);
        Priority prio = (Priority)recordFactory.newRecordInstance(Priority.class);
        prio.setPriority(priority);
        request.setPriority(prio);
        return request;
    }

    @Test(timeout=5000L)
    public void testFifoSchedulerCapacityWhenNoNMs() {
        FifoScheduler scheduler = new FifoScheduler();
        QueueInfo queueInfo = scheduler.getQueueInfo(null, false, false);
        junit.framework.Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(queueInfo.getCurrentCapacity()));
    }

    @Test(timeout=5000L)
    public void testAppAttemptMetrics() throws Exception {
        InlineDispatcher dispatcher = new InlineDispatcher();
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContextImpl rmContext = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, null, null, null, writer);
        FifoScheduler schedular = new FifoScheduler();
        schedular.reinitialize(new Configuration(), (RMContext)rmContext);
        QueueMetrics metrics = schedular.getRootQueueMetrics();
        int beforeAppsSubmitted = metrics.getAppsSubmitted();
        ApplicationId appId = BuilderUtils.newApplicationId((long)200L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appId, "queue", "user");
        schedular.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        schedular.handle((SchedulerEvent)attemptEvent);
        appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)2);
        AppAttemptAddedSchedulerEvent attemptEvent2 = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        schedular.handle((SchedulerEvent)attemptEvent2);
        int afterAppsSubmitted = metrics.getAppsSubmitted();
        junit.framework.Assert.assertEquals((int)1, (int)(afterAppsSubmitted - beforeAppsSubmitted));
    }

    @Test(timeout=2000L)
    public void testNodeLocalAssignment() throws Exception {
        InlineDispatcher dispatcher = new InlineDispatcher();
        Configuration conf = new Configuration();
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        containerTokenSecretManager.rollMasterKey();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM(conf);
        nmTokenSecretManager.rollMasterKey();
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContextImpl rmContext = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, containerTokenSecretManager, nmTokenSecretManager, null, writer);
        FifoScheduler scheduler = new FifoScheduler();
        scheduler.reinitialize(new Configuration(), (RMContext)rmContext);
        RMNode node0 = MockNodes.newNodeInfo(1, Resources.createResource((int)65536), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node0);
        scheduler.handle((SchedulerEvent)nodeEvent1);
        int _appId = 1;
        int _appAttemptId = 1;
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(_appId, _appAttemptId);
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appAttemptId.getApplicationId(), "queue1", "user1");
        scheduler.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        scheduler.handle((SchedulerEvent)attemptEvent);
        int memory = 64;
        int nConts = 3;
        int priority = 20;
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest nodeLocal = this.createResourceRequest(memory, node0.getHostName(), priority, nConts);
        ResourceRequest rackLocal = this.createResourceRequest(memory, node0.getRackName(), priority, nConts);
        ResourceRequest any = this.createResourceRequest(memory, "*", priority, nConts);
        ask.add(nodeLocal);
        ask.add(rackLocal);
        ask.add(any);
        scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null);
        NodeUpdateSchedulerEvent node0Update = new NodeUpdateSchedulerEvent(node0);
        junit.framework.Assert.assertEquals((int)3, (int)nodeLocal.getNumContainers());
        scheduler.handle((SchedulerEvent)node0Update);
        junit.framework.Assert.assertEquals((int)0, (int)nodeLocal.getNumContainers());
        SchedulerAppReport info = scheduler.getSchedulerAppInfo(appAttemptId);
        junit.framework.Assert.assertEquals((int)3, (int)info.getLiveContainers().size());
    }

    @Test(timeout=2000L)
    public void testUpdateResourceOnNode() throws Exception {
        InlineDispatcher dispatcher = new InlineDispatcher();
        Configuration conf = new Configuration();
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        containerTokenSecretManager.rollMasterKey();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM(conf);
        nmTokenSecretManager.rollMasterKey();
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContextImpl rmContext = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, containerTokenSecretManager, nmTokenSecretManager, null, writer);
        FifoScheduler scheduler = new FifoScheduler(){

            public Map<NodeId, FiCaSchedulerNode> getNodes() {
                return this.nodes;
            }
        };
        scheduler.reinitialize(new Configuration(), (RMContext)rmContext);
        RMNode node0 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node0);
        scheduler.handle((SchedulerEvent)nodeEvent1);
        Method method = scheduler.getClass().getDeclaredMethod("getNodes", new Class[0]);
        Map schedulerNodes = (Map)method.invoke((Object)scheduler, new Object[0]);
        Assert.assertEquals((long)schedulerNodes.values().size(), (long)1L);
        node0.setResourceOption(ResourceOption.newInstance((Resource)Resources.createResource((int)1024, (int)4), (int)-1));
        Assert.assertEquals((long)node0.getTotalCapability().getMemory(), (long)1024L);
        Assert.assertEquals((long)((FiCaSchedulerNode)schedulerNodes.get(node0.getNodeID())).getAvailableResource().getMemory(), (long)2048L);
        NodeUpdateSchedulerEvent node0Update = new NodeUpdateSchedulerEvent(node0);
        scheduler.handle((SchedulerEvent)node0Update);
        Assert.assertEquals((long)((FiCaSchedulerNode)schedulerNodes.get(node0.getNodeID())).getAvailableResource().getMemory(), (long)1024L);
        QueueInfo queueInfo = scheduler.getQueueInfo(null, false, false);
        junit.framework.Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(queueInfo.getCurrentCapacity()));
        int _appId = 1;
        int _appAttemptId = 1;
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(_appId, _appAttemptId);
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appAttemptId.getApplicationId(), "queue1", "user1");
        scheduler.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        scheduler.handle((SchedulerEvent)attemptEvent);
        int memory = 1024;
        int priority = 1;
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest nodeLocal = this.createResourceRequest(memory, node0.getHostName(), priority, 1);
        ResourceRequest rackLocal = this.createResourceRequest(memory, node0.getRackName(), priority, 1);
        ResourceRequest any = this.createResourceRequest(memory, "*", priority, 1);
        ask.add(nodeLocal);
        ask.add(rackLocal);
        ask.add(any);
        scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null);
        junit.framework.Assert.assertEquals((int)1, (int)nodeLocal.getNumContainers());
        scheduler.handle((SchedulerEvent)node0Update);
        junit.framework.Assert.assertEquals((int)0, (int)nodeLocal.getNumContainers());
        SchedulerAppReport info = scheduler.getSchedulerAppInfo(appAttemptId);
        junit.framework.Assert.assertEquals((int)1, (int)info.getLiveContainers().size());
        queueInfo = scheduler.getQueueInfo(null, false, false);
        junit.framework.Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(queueInfo.getCurrentCapacity()));
    }

    public void testFifoScheduler() throws Exception {
        LOG.info((Object)"--- START: testFifoScheduler ---");
        int GB = 1024;
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)1));
        nm_0.heartbeat();
        String host_1 = "host_1";
        NodeManager nm_1 = this.registerNode(host_1, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)1));
        nm_1.heartbeat();
        Priority priority_0 = org.apache.hadoop.yarn.server.resourcemanager.resource.Priority.create((int)0);
        Priority priority_1 = org.apache.hadoop.yarn.server.resourcemanager.resource.Priority.create((int)1);
        Application application_0 = new Application("user_0", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)1024);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_0);
        Application application_1 = new Application("user_1", this.resourceManager);
        application_1.submit();
        application_1.addNodeManager(host_0, 1234, nm_0);
        application_1.addNodeManager(host_1, 1234, nm_1);
        Resource capability_1_0 = Resources.createResource((int)3072);
        application_1.addResourceRequestSpec(priority_1, capability_1_0);
        Resource capability_1_1 = Resources.createResource((int)4096);
        application_1.addResourceRequestSpec(priority_0, capability_1_1);
        Task task_1_0 = new Task(application_1, priority_1, new String[]{host_0, host_1});
        application_1.addTask(task_1_0);
        LOG.info((Object)"Send resource requests to the scheduler");
        application_0.schedule();
        application_1.schedule();
        LOG.info((Object)"Send a heartbeat to kick the tires on the Scheduler... nm0 -> task_0_0 and task_1_0 allocated, used=4G nm1 -> nothing allocated");
        nm_0.heartbeat();
        nm_1.heartbeat();
        application_0.schedule();
        this.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(3072, application_1);
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(0, nm_1);
        LOG.info((Object)"Adding new tasks...");
        Task task_1_1 = new Task(application_1, priority_1, new String[]{"*"});
        application_1.addTask(task_1_1);
        Task task_1_2 = new Task(application_1, priority_1, new String[]{"*"});
        application_1.addTask(task_1_2);
        Task task_1_3 = new Task(application_1, priority_0, new String[]{"*"});
        application_1.addTask(task_1_3);
        application_1.schedule();
        Task task_0_1 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_1);
        Task task_0_2 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_2);
        Task task_0_3 = new Task(application_0, priority_0, new String[]{"*"});
        application_0.addTask(task_0_3);
        application_0.schedule();
        LOG.info((Object)("Sending hb from " + nm_0.getHostName()));
        nm_0.heartbeat();
        LOG.info((Object)("Sending hb from " + nm_1.getHostName()));
        nm_1.heartbeat();
        LOG.info((Object)"Trying to allocate...");
        application_0.schedule();
        this.checkApplicationResourceUsage(3072, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(3072, application_1);
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(2048, nm_1);
        LOG.info((Object)"Finishing up task_0_0");
        application_0.finishTask(task_0_0);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(3072, application_0);
        this.checkApplicationResourceUsage(3072, application_1);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(2048, nm_1);
        LOG.info((Object)"Finishing up task_1_0");
        application_1.finishTask(task_1_0);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(4096, application_0);
        this.checkApplicationResourceUsage(0, application_1);
        this.checkNodeResourceUsage(2048, nm_1);
        LOG.info((Object)"Finishing up task_0_3");
        application_0.finishTask(task_0_3);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(2048, application_0);
        this.checkApplicationResourceUsage(0, application_1);
        this.checkNodeResourceUsage(0, nm_1);
        LOG.info((Object)"Finishing up task_0_1");
        application_0.finishTask(task_0_1);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(1024, application_0);
        this.checkApplicationResourceUsage(0, application_1);
        LOG.info((Object)"Finishing up task_0_2");
        application_0.finishTask(task_0_2);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(0, application_0);
        this.checkApplicationResourceUsage(4096, application_1);
        LOG.info((Object)"Finishing up task_1_3");
        application_1.finishTask(task_1_3);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(0, application_0);
        this.checkApplicationResourceUsage(3072, application_1);
        LOG.info((Object)"Finishing up task_1_1");
        application_1.finishTask(task_1_1);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(0, application_0);
        this.checkApplicationResourceUsage(3072, application_1);
        LOG.info((Object)"--- END: testFifoScheduler ---");
    }

    @Test
    public void testBlackListNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        FifoScheduler fs = (FifoScheduler)rm.getResourceScheduler();
        String host = "127.0.0.1";
        RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        ApplicationId appId = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appId, "default", "user");
        fs.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        fs.handle((SchedulerEvent)attemptEvent);
        fs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(host), null);
        junit.framework.Assert.assertTrue((boolean)fs.getApplicationAttempt(appAttemptId).isBlacklisted(host));
        fs.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, Collections.singletonList(host));
        junit.framework.Assert.assertFalse((boolean)fs.getApplicationAttempt(appAttemptId).isBlacklisted(host));
        rm.stop();
    }

    @Test
    public void testGetAppsInQueue() throws Exception {
        Application application_0 = new Application("user_0", this.resourceManager);
        application_0.submit();
        Application application_1 = new Application("user_0", this.resourceManager);
        application_1.submit();
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        List appsInDefault = scheduler.getAppsInQueue("default");
        Assert.assertTrue((boolean)appsInDefault.contains(application_0.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInDefault.contains(application_1.getApplicationAttemptId()));
        Assert.assertEquals((long)2L, (long)appsInDefault.size());
        junit.framework.Assert.assertNull((Object)scheduler.getAppsInQueue("someotherqueue"));
    }

    @Test
    public void testAddAndRemoveAppFromFiFoScheduler() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        FifoScheduler fs = (FifoScheduler)rm.getResourceScheduler();
        TestSchedulerUtils.verifyAppAddedAndRemovedFromScheduler(fs.getSchedulerApplications(), (EventHandler<SchedulerEvent>)fs, "queue");
    }

    private void checkApplicationResourceUsage(int expected, Application application) {
        junit.framework.Assert.assertEquals((int)expected, (int)application.getUsedResources().getMemory());
    }

    private void checkNodeResourceUsage(int expected, NodeManager node) {
        junit.framework.Assert.assertEquals((int)expected, (int)node.getUsed().getMemory());
        node.checkResourceUsage();
    }

    public static void main(String[] arg) throws Exception {
        TestFifoScheduler t = new TestFifoScheduler();
        t.setUp();
        t.testFifoScheduler();
        t.tearDown();
    }
}

