/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.FileSystemRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMStateVersion;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.RMStateVersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFSRMStateStore
extends RMStateStoreTestBase {
    public static final Log LOG = LogFactory.getLog(TestFSRMStateStore.class);
    private TestFSRMStateStoreTester fsTester;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFSRMStateStore() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            this.fsTester = new TestFSRMStateStoreTester(cluster);
            FSDataOutputStream fsOut = null;
            FileSystemRMStateStore fileSystemRMStateStore = (FileSystemRMStateStore)this.fsTester.getRMStateStore();
            String appAttemptIdStr3 = "appattempt_1352994193343_0001_000003";
            ApplicationAttemptId attemptId3 = ConverterUtils.toApplicationAttemptId((String)appAttemptIdStr3);
            Path appDir = this.fsTester.store.getAppDir(attemptId3.getApplicationId().toString());
            Path tempAppAttemptFile = new Path(appDir, attemptId3.toString() + ".tmp");
            fsOut = fileSystemRMStateStore.fs.create(tempAppAttemptFile, false);
            fsOut.write("Some random data ".getBytes());
            fsOut.close();
            this.testRMAppStateStore(this.fsTester);
            junit.framework.Assert.assertFalse((boolean)this.fsTester.workingDirPathURI.getFileSystem((Configuration)conf).exists(tempAppAttemptFile));
            this.testRMDTSecretManagerStateStore(this.fsTester);
            this.testCheckVersion(this.fsTester);
            this.testAppDeletion(this.fsTester);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Override
    protected void modifyAppState() throws Exception {
        String appAttemptIdStr1 = "appattempt_1352994193343_0001_000001";
        ApplicationAttemptId attemptId1 = ConverterUtils.toApplicationAttemptId((String)appAttemptIdStr1);
        Path appDir = this.fsTester.store.getAppDir(attemptId1.getApplicationId().toString());
        Path appAttemptFile1 = new Path(appDir, attemptId1.toString() + ".new");
        FileSystemRMStateStore fileSystemRMStateStore = (FileSystemRMStateStore)this.fsTester.getRMStateStore();
        fileSystemRMStateStore.renameFile(appAttemptFile1, new Path(appAttemptFile1.getParent(), appAttemptFile1.getName() + ".new"));
    }

    @Override
    protected void modifyRMDelegationTokenState() throws Exception {
        Path nodeCreatePath = this.fsTester.store.getNodePath(this.fsTester.store.rmDTSecretManagerRoot, "RMDelegationToken_0");
        FileSystemRMStateStore fileSystemRMStateStore = (FileSystemRMStateStore)this.fsTester.getRMStateStore();
        fileSystemRMStateStore.renameFile(nodeCreatePath, new Path(nodeCreatePath.getParent(), nodeCreatePath.getName() + ".new"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testFSRMStateStoreClientRetry() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitActive();
        try {
            TestFSRMStateStoreTester fsTester = new TestFSRMStateStoreTester(cluster);
            final RMStateStore store = fsTester.getRMStateStore();
            store.setRMDispatcher((Dispatcher)new RMStateStoreTestBase.TestDispatcher());
            final AtomicBoolean assertionFailedInThread = new AtomicBoolean(false);
            cluster.shutdownNameNodes();
            Thread clientThread = new Thread(){

                @Override
                public void run() {
                    try {
                        store.storeApplicationStateInternal(ApplicationId.newInstance((long)100L, (int)1), (ApplicationStateDataPBImpl)ApplicationStateDataPBImpl.newApplicationStateData((long)111L, (long)111L, (String)"user", null, (RMAppState)RMAppState.ACCEPTED, (String)"diagnostics", (long)333L));
                    }
                    catch (Exception e) {
                        if (!e.getMessage().contains("could only be replicated to 0 nodes instead of minReplication (=1)")) {
                            assertionFailedInThread.set(true);
                        }
                        e.printStackTrace();
                    }
                }
            };
            Thread.sleep(2000L);
            clientThread.start();
            cluster.restartNameNode(new String[0]);
            clientThread.join();
            junit.framework.Assert.assertFalse((boolean)assertionFailedInThread.get());
        }
        finally {
            cluster.shutdown();
        }
    }

    class TestFSRMStateStoreTester
    implements RMStateStoreTestBase.RMStateStoreHelper {
        Path workingDirPathURI;
        TestFileSystemRMStore store;
        MiniDFSCluster cluster;

        public TestFSRMStateStoreTester(MiniDFSCluster cluster) throws Exception {
            Path workingDirPath = new Path("/Test");
            this.cluster = cluster;
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.mkdirs(workingDirPath);
            Path clusterURI = new Path(cluster.getURI());
            this.workingDirPathURI = new Path(clusterURI, workingDirPath);
            fs.close();
        }

        @Override
        public RMStateStore getRMStateStore() throws Exception {
            YarnConfiguration conf = new YarnConfiguration();
            conf.set("yarn.resourcemanager.fs.state-store.uri", this.workingDirPathURI.toString());
            conf.set("yarn.resourcemanager.fs.state-store.retry-policy-spec", "100,6000");
            this.store = new TestFileSystemRMStore((Configuration)conf);
            return this.store;
        }

        @Override
        public boolean isFinalStateValid() throws Exception {
            DistributedFileSystem fs = this.cluster.getFileSystem();
            FileStatus[] files = fs.listStatus(this.workingDirPathURI);
            return files.length == 1;
        }

        @Override
        public void writeVersion(RMStateVersion version) throws Exception {
            this.store.updateFile(this.store.getVersionNode(), ((RMStateVersionPBImpl)version).getProto().toByteArray());
        }

        @Override
        public RMStateVersion getCurrentVersion() throws Exception {
            return this.store.getCurrentVersion();
        }

        @Override
        public boolean appExists(RMApp app) throws IOException {
            DistributedFileSystem fs = this.cluster.getFileSystem();
            Path nodePath = this.store.getAppDir(app.getApplicationId().toString());
            return fs.exists(nodePath);
        }

        class TestFileSystemRMStore
        extends FileSystemRMStateStore {
            TestFileSystemRMStore(Configuration conf) throws Exception {
                this.init(conf);
                junit.framework.Assert.assertNull((Object)this.fs);
                Assert.assertTrue((boolean)TestFSRMStateStoreTester.this.workingDirPathURI.equals((Object)this.fsWorkingPath));
                this.start();
                junit.framework.Assert.assertNotNull((Object)this.fs);
            }

            public Path getVersionNode() {
                return new Path(new Path(TestFSRMStateStoreTester.this.workingDirPathURI, "FSRMStateRoot"), "RMVersionNode");
            }

            public RMStateVersion getCurrentVersion() {
                return CURRENT_VERSION_INFO;
            }

            public Path getAppDir(String appId) {
                Path rootDir = new Path(TestFSRMStateStoreTester.this.workingDirPathURI, "FSRMStateRoot");
                Path appRootDir = new Path(rootDir, "RMAppRoot");
                Path appDir = new Path(appRootDir, appId);
                return appDir;
            }
        }
    }
}

