/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.TestFairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FifoPolicy;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

public class TestFairScheduler {
    static final String TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
    static final String ALLOC_FILE = new File(TEST_DIR, "test-queues").getAbsolutePath();
    private FairScheduler scheduler;
    private ResourceManager resourceManager;
    private Configuration conf;
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private int APP_ID = 1;
    private int ATTEMPT_ID = 1;

    @Before
    public void setUp() throws IOException {
        this.scheduler = new FairScheduler();
        this.conf = this.createConfiguration();
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        this.conf.setInt("yarn.scheduler.increment-allocation-mb", 1024);
        this.conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        this.conf.set("yarn.scheduler.fair.assignmultiple", "false");
        this.resourceManager = new ResourceManager();
        this.resourceManager.init(this.conf);
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.resourceManager.getRMContext().getStateStore().start();
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
    }

    @After
    public void tearDown() {
        this.scheduler = null;
        this.resourceManager = null;
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        FairScheduler scheduler = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 2048);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        try {
            scheduler.reinitialize((Configuration)conf, null);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
        conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 2);
        conf.setInt("yarn.scheduler.maximum-allocation-vcores", 1);
        try {
            scheduler.reinitialize((Configuration)conf, null);
            Assert.fail((String)"Exception is expected because the min vcores allocation is larger than the max vcores allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler vcores"));
        }
    }

    private Configuration createConfiguration() {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        return conf;
    }

    private ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
        return attId;
    }

    private ResourceRequest createResourceRequest(int memory, String host, int priority, int numContainers, boolean relaxLocality) {
        return this.createResourceRequest(memory, 1, host, priority, numContainers, relaxLocality);
    }

    private ResourceRequest createResourceRequest(int memory, int vcores, String host, int priority, int numContainers, boolean relaxLocality) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        request.setCapability(BuilderUtils.newResource((int)memory, (int)vcores));
        request.setResourceName(host);
        request.setNumContainers(numContainers);
        Priority prio = (Priority)recordFactory.newRecordInstance(Priority.class);
        prio.setPriority(priority);
        request.setPriority(prio);
        request.setRelaxLocality(relaxLocality);
        return request;
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId) {
        return this.createSchedulingRequest(memory, queueId, userId, 1);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId) {
        return this.createSchedulingRequest(memory, vcores, queueId, userId, 1);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId, int numContainers) {
        return this.createSchedulingRequest(memory, queueId, userId, numContainers, 1);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId, int numContainers) {
        return this.createSchedulingRequest(memory, vcores, queueId, userId, numContainers, 1);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, String queueId, String userId, int numContainers, int priority) {
        return this.createSchedulingRequest(memory, 1, queueId, userId, numContainers, priority);
    }

    private ApplicationAttemptId createSchedulingRequest(int memory, int vcores, String queueId, String userId, int numContainers, int priority) {
        ApplicationAttemptId id = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.scheduler.addApplication(id.getApplicationId(), queueId, userId);
        if (this.scheduler.getSchedulerApplications().containsKey(id.getApplicationId())) {
            this.scheduler.addApplicationAttempt(id, false);
        }
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest request = this.createResourceRequest(memory, vcores, "*", priority, numContainers, true);
        ask.add(request);
        this.scheduler.allocate(id, ask, new ArrayList(), null, null);
        return id;
    }

    private void createSchedulingRequestExistingApplication(int memory, int priority, ApplicationAttemptId attId) {
        ResourceRequest request = this.createResourceRequest(memory, "*", priority, 1, true);
        this.createSchedulingRequestExistingApplication(request, attId);
    }

    private void createSchedulingRequestExistingApplication(int memory, int vcores, int priority, ApplicationAttemptId attId) {
        ResourceRequest request = this.createResourceRequest(memory, vcores, "*", priority, 1, true);
        this.createSchedulingRequestExistingApplication(request, attId);
    }

    private void createSchedulingRequestExistingApplication(ResourceRequest request, ApplicationAttemptId attId) {
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ask.add(request);
        this.scheduler.allocate(attId, ask, new ArrayList(), null, null);
    }

    @Test(timeout=2000L)
    public void testLoadConfigurationOnInitialize() throws IOException {
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.conf.setInt("yarn.scheduler.fair.max.assign", 3);
        this.conf.setBoolean("yarn.scheduler.fair.sizebasedweight", true);
        this.conf.setFloat("yarn.scheduler.fair.locality.threshold.node", 0.5f);
        this.conf.setFloat("yarn.scheduler.fair.locality.threshold.rack", 0.7f);
        this.conf.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        this.conf.setInt("yarn.scheduler.fair.continuous-scheduling-sleep-ms", 10);
        this.conf.setInt("yarn.scheduler.fair.locality-delay-rack-ms", 5000);
        this.conf.setInt("yarn.scheduler.fair.locality-delay-node-ms", 5000);
        this.conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 512);
        this.conf.setInt("yarn.scheduler.increment-allocation-mb", 128);
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        junit.framework.Assert.assertEquals((boolean)true, (boolean)this.scheduler.assignMultiple);
        junit.framework.Assert.assertEquals((int)3, (int)this.scheduler.maxAssign);
        junit.framework.Assert.assertEquals((boolean)true, (boolean)this.scheduler.sizeBasedWeight);
        junit.framework.Assert.assertEquals((double)0.5, (double)this.scheduler.nodeLocalityThreshold, (double)0.01);
        junit.framework.Assert.assertEquals((double)0.7, (double)this.scheduler.rackLocalityThreshold, (double)0.01);
        junit.framework.Assert.assertTrue((String)"The continuous scheduling should be enabled", (boolean)this.scheduler.continuousSchedulingEnabled);
        junit.framework.Assert.assertEquals((int)10, (int)this.scheduler.continuousSchedulingSleepMs);
        junit.framework.Assert.assertEquals((long)5000L, (long)this.scheduler.nodeLocalityDelayMs);
        junit.framework.Assert.assertEquals((long)5000L, (long)this.scheduler.rackLocalityDelayMs);
        junit.framework.Assert.assertEquals((int)1024, (int)this.scheduler.getMaximumResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)512, (int)this.scheduler.getMinimumResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)128, (int)this.scheduler.getIncrementResourceCapability().getMemory());
    }

    @Test
    public void testNonMinZeroResourcesSettings() throws IOException {
        FairScheduler fs = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 256);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 1);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 512);
        conf.setInt("yarn.scheduler.increment-allocation-vcores", 2);
        fs.reinitialize((Configuration)conf, null);
        junit.framework.Assert.assertEquals((int)256, (int)fs.getMinimumResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)1, (int)fs.getMinimumResourceCapability().getVirtualCores());
        junit.framework.Assert.assertEquals((int)512, (int)fs.getIncrementResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)2, (int)fs.getIncrementResourceCapability().getVirtualCores());
    }

    @Test
    public void testMinZeroResourcesSettings() throws IOException {
        FairScheduler fs = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        conf.setInt("yarn.scheduler.minimum-allocation-vcores", 0);
        conf.setInt("yarn.scheduler.increment-allocation-mb", 512);
        conf.setInt("yarn.scheduler.increment-allocation-vcores", 2);
        fs.reinitialize((Configuration)conf, null);
        junit.framework.Assert.assertEquals((int)0, (int)fs.getMinimumResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)0, (int)fs.getMinimumResourceCapability().getVirtualCores());
        junit.framework.Assert.assertEquals((int)512, (int)fs.getIncrementResourceCapability().getMemory());
        junit.framework.Assert.assertEquals((int)2, (int)fs.getIncrementResourceCapability().getVirtualCores());
    }

    @Test
    public void testAggregateCapacityTracking() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getClusterCapacity().getMemory());
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)512), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((long)1536L, (long)this.scheduler.getClusterCapacity().getMemory());
        NodeRemovedSchedulerEvent nodeEvent3 = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        Assert.assertEquals((long)512L, (long)this.scheduler.getClusterCapacity().getMemory());
    }

    @Test
    public void testSimpleFairShareCalculation() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)10240), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "queue1", "user1");
        this.createSchedulingRequest(10240, "queue2", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            Assert.assertEquals((long)3414L, (long)p.getFairShare().getMemory());
            Assert.assertEquals((long)3414L, (long)p.getMetrics().getFairShareMB());
        }
    }

    @Test
    public void testSimpleHierarchicalFairShareCalculation() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int capacity = 240;
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)capacity), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(10240, "parent.queue2", "user1");
        this.createSchedulingRequest(10240, "parent.queue3", "user1");
        this.scheduler.update();
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection queues = queueManager.getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        FSLeafQueue queue1 = queueManager.getLeafQueue("default", true);
        FSLeafQueue queue2 = queueManager.getLeafQueue("parent.queue2", true);
        FSLeafQueue queue3 = queueManager.getLeafQueue("parent.queue3", true);
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 2), (long)queue1.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 4), (long)queue2.getMetrics().getFairShareMB());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getFairShare().getMemory());
        Assert.assertEquals((long)(capacity / 4), (long)queue3.getMetrics().getFairShareMB());
    }

    @Test
    public void testHierarchicalQueuesSimilarParents() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSLeafQueue leafQueue = queueManager.getLeafQueue("parent.child", true);
        junit.framework.Assert.assertEquals((int)2, (int)queueManager.getLeafQueues().size());
        junit.framework.Assert.assertNotNull((Object)leafQueue);
        junit.framework.Assert.assertEquals((String)"root.parent.child", (String)leafQueue.getName());
        FSLeafQueue leafQueue2 = queueManager.getLeafQueue("parent", true);
        junit.framework.Assert.assertNull((Object)leafQueue2);
        junit.framework.Assert.assertEquals((int)2, (int)queueManager.getLeafQueues().size());
        FSLeafQueue leafQueue3 = queueManager.getLeafQueue("parent.child.grandchild", true);
        junit.framework.Assert.assertNull((Object)leafQueue3);
        junit.framework.Assert.assertEquals((int)2, (int)queueManager.getLeafQueues().size());
        FSLeafQueue leafQueue4 = queueManager.getLeafQueue("parent.sister", true);
        junit.framework.Assert.assertNotNull((Object)leafQueue4);
        junit.framework.Assert.assertEquals((String)"root.parent.sister", (String)leafQueue4.getName());
        junit.framework.Assert.assertEquals((int)3, (int)queueManager.getLeafQueues().size());
    }

    @Test
    public void testSchedulerRootQueueMetrics() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024));
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.createSchedulingRequest(1024, "queue2", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.rootMetrics.getReservedMB());
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024));
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.rootMetrics.getReservedMB());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.rootMetrics.getReservedMB());
    }

    @Test(timeout=5000L)
    public void testSimpleContainerAllocation() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024, (int)4), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)512, (int)2), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(512, 2, "queue1", "user1", 2);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getVirtualCores());
        FSQueueMetrics queue1Metrics = this.scheduler.getQueueManager().getQueue("queue1").getMetrics();
        Assert.assertEquals((long)1024L, (long)queue1Metrics.getAllocatedMB());
        Assert.assertEquals((long)2L, (long)queue1Metrics.getAllocatedVirtualCores());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAllocatedMB());
        Assert.assertEquals((long)2L, (long)this.scheduler.getRootQueueMetrics().getAllocatedVirtualCores());
        Assert.assertEquals((long)512L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test(timeout=5000L)
    public void testSimpleContainerReservation() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue1").getResourceUsage().getMemory());
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue2", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getMemory());
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getQueueManager().getQueue("queue2").getResourceUsage().getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getMemory());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId).getCurrentReservation().getMemory());
    }

    @Test
    public void testUserAsDefaultQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMContext rmContext = this.resourceManager.getRMContext();
        ConcurrentMap appsMap = rmContext.getRMApps();
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        RMAppImpl rmApp = new RMAppImpl(appAttemptId.getApplicationId(), rmContext, this.conf, null, null, null, ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, null, null), null, null, 0L, null, null);
        appsMap.put(appAttemptId.getApplicationId(), rmApp);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(appAttemptId.getApplicationId(), "default", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attempAddedEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        this.scheduler.handle((SchedulerEvent)attempAddedEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getRunnableAppSchedulables().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getRunnableAppSchedulables().size());
        Assert.assertEquals((Object)"root.user1", (Object)rmApp.getQueue());
    }

    @Test
    public void testNotUserAsDefaultQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "false");
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMContext rmContext = this.resourceManager.getRMContext();
        ConcurrentMap appsMap = rmContext.getRMApps();
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        RMAppImpl rmApp = new RMAppImpl(appAttemptId.getApplicationId(), rmContext, this.conf, null, null, null, ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, null, null), null, null, 0L, null, null);
        appsMap.put(appAttemptId.getApplicationId(), rmApp);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(appAttemptId.getApplicationId(), "default", "user2");
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attempAddedEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        this.scheduler.handle((SchedulerEvent)attempAddedEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getRunnableAppSchedulables().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getRunnableAppSchedulables().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user2", true).getRunnableAppSchedulables().size());
    }

    @Test
    public void testEmptyQueueName() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(appAttemptId.getApplicationId(), "", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertNull((Object)this.scheduler.getSchedulerApp(appAttemptId));
        Assert.assertEquals((long)0L, (long)this.resourceManager.getRMContext().getRMApps().size());
    }

    @Test
    public void testAssignToQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        MockRMApp rmApp2 = new MockRMApp(1, 1L, RMAppState.NEW);
        FSLeafQueue queue1 = this.scheduler.assignToQueue((RMApp)rmApp1, "default", "asterix");
        FSLeafQueue queue2 = this.scheduler.assignToQueue((RMApp)rmApp2, "notdefault", "obelix");
        Assert.assertEquals((Object)rmApp1.getQueue(), (Object)queue1.getName());
        Assert.assertEquals((Object)"root.asterix", (Object)rmApp1.getQueue());
        Assert.assertEquals((Object)rmApp2.getQueue(), (Object)queue2.getName());
        Assert.assertEquals((Object)"root.notdefault", (Object)rmApp2.getQueue());
    }

    @Test
    public void testAssignToNonLeafQueueReturnsNull() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.getQueueManager().getLeafQueue("root.child1.granchild", true);
        this.scheduler.getQueueManager().getLeafQueue("root.child2", true);
        MockRMApp rmApp1 = new MockRMApp(0, 0L, RMAppState.NEW);
        MockRMApp rmApp2 = new MockRMApp(1, 1L, RMAppState.NEW);
        Assert.assertNull((Object)this.scheduler.assignToQueue((RMApp)rmApp1, "root.child1", "tintin"));
        Assert.assertNotNull((Object)this.scheduler.assignToQueue((RMApp)rmApp2, "root.child2", "snowy"));
    }

    @Test
    public void testQueuePlacementWithPolicy() throws Exception {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ArrayList<QueuePlacementRule> rules = new ArrayList<QueuePlacementRule>();
        rules.add(new QueuePlacementRule.Specified().initialize(true, null));
        rules.add(new QueuePlacementRule.User().initialize(false, null));
        rules.add(new QueuePlacementRule.PrimaryGroup().initialize(false, null));
        rules.add(new QueuePlacementRule.SecondaryGroupExistingQueue().initialize(false, null));
        rules.add(new QueuePlacementRule.Default().initialize(true, null));
        HashSet queues = Sets.newHashSet((Object[])new String[]{"root.user1", "root.user3group", "root.user4subgroup1", "root.user4subgroup2", "root.user5subgroup2"});
        this.scheduler.getAllocationConfiguration().placementPolicy = new QueuePlacementPolicy(rules, (Set)queues, this.conf);
        ApplicationAttemptId appId = this.createSchedulingRequest(1024, "somequeue", "user1");
        Assert.assertEquals((Object)"root.somequeue", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user1");
        Assert.assertEquals((Object)"root.user1", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user3");
        Assert.assertEquals((Object)"root.user3group", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user4");
        Assert.assertEquals((Object)"root.user4subgroup1", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "user5");
        Assert.assertEquals((Object)"root.user5subgroup2", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "otheruser");
        Assert.assertEquals((Object)"root.default", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        rules = new ArrayList();
        rules.add(new QueuePlacementRule.User().initialize(false, null));
        rules.add(new QueuePlacementRule.Specified().initialize(true, null));
        rules.add(new QueuePlacementRule.Default().initialize(true, null));
        this.scheduler.getAllocationConfiguration().placementPolicy = new QueuePlacementPolicy(rules, (Set)queues, this.conf);
        appId = this.createSchedulingRequest(1024, "somequeue", "user1");
        Assert.assertEquals((Object)"root.user1", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "somequeue", "otheruser");
        Assert.assertEquals((Object)"root.somequeue", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
        appId = this.createSchedulingRequest(1024, "default", "otheruser");
        Assert.assertEquals((Object)"root.default", (Object)this.scheduler.getSchedulerApp(appId).getQueueName());
    }

    @Test
    public void testFairShareWithMinAlloc() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)3072), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(2048, "queueA", "user1");
        this.createSchedulingRequest(2048, "queueB", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            if (p.getName().equals("root.queueA")) {
                Assert.assertEquals((long)1024L, (long)p.getFairShare().getMemory());
                continue;
            }
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((long)2048L, (long)p.getFairShare().getMemory());
        }
    }

    @Test
    public void testQueueDemandCalculation() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId id11 = this.createAppAttemptId(1, 1);
        this.scheduler.addApplication(id11.getApplicationId(), "root.queue1", "user1");
        this.scheduler.addApplicationAttempt(id11, false);
        ApplicationAttemptId id21 = this.createAppAttemptId(2, 1);
        this.scheduler.addApplication(id21.getApplicationId(), "root.queue2", "user1");
        this.scheduler.addApplicationAttempt(id21, false);
        ApplicationAttemptId id22 = this.createAppAttemptId(2, 2);
        this.scheduler.addApplication(id22.getApplicationId(), "root.queue2", "user1");
        this.scheduler.addApplicationAttempt(id22, false);
        int minReqSize = 1024;
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ResourceRequest request1 = this.createResourceRequest(minReqSize * 2, "*", 1, 1, true);
        ask1.add(request1);
        this.scheduler.allocate(id11, ask1, new ArrayList(), null, null);
        ArrayList<ResourceRequest> ask2 = new ArrayList<ResourceRequest>();
        ResourceRequest request2 = this.createResourceRequest(2 * minReqSize, "foo", 1, 1, false);
        ResourceRequest request3 = this.createResourceRequest(minReqSize, "bar", 1, 2, false);
        ask2.add(request2);
        ask2.add(request3);
        this.scheduler.allocate(id21, ask2, new ArrayList(), null, null);
        ArrayList<ResourceRequest> ask3 = new ArrayList<ResourceRequest>();
        ResourceRequest request4 = this.createResourceRequest(2 * minReqSize, "*", 1, 1, true);
        ask3.add(request4);
        this.scheduler.allocate(id22, ask3, new ArrayList(), null, null);
        this.scheduler.update();
        Assert.assertEquals((long)(2 * minReqSize), (long)this.scheduler.getQueueManager().getQueue("root.queue1").getDemand().getMemory());
        Assert.assertEquals((long)(2 * minReqSize + 2 * minReqSize + 2 * minReqSize), (long)this.scheduler.getQueueManager().getQueue("root.queue2").getDemand().getMemory());
    }

    @Test
    public void testAppAdditionAndRemoval() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(attemptId.getApplicationId(), "default", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attemptAddedEvent = new AppAttemptAddedSchedulerEvent(this.createAppAttemptId(1, 1), false);
        this.scheduler.handle((SchedulerEvent)attemptAddedEvent);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getRunnableAppSchedulables().size());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(this.createAppAttemptId(1, 1), RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getRunnableAppSchedulables().size());
    }

    @Test
    public void testHierarchicalQueueAllocationFileParsing() throws IOException, SAXException, AllocationConfigurationException, ParserConfigurationException {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<queue name=\"queueC\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        Collection leafQueues = queueManager.getLeafQueues();
        junit.framework.Assert.assertEquals((int)4, (int)leafQueues.size());
        junit.framework.Assert.assertNotNull((Object)queueManager.getLeafQueue("queueA", false));
        junit.framework.Assert.assertNotNull((Object)queueManager.getLeafQueue("queueB.queueC", false));
        junit.framework.Assert.assertNotNull((Object)queueManager.getLeafQueue("queueB.queueD", false));
        junit.framework.Assert.assertNotNull((Object)queueManager.getLeafQueue("default", false));
        junit.framework.Assert.assertEquals((int)4, (int)leafQueues.size());
    }

    @Test
    public void testConfigureRootQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<defaultQueueSchedulingPolicy>fair</defaultQueueSchedulingPolicy>");
        out.println("<queue name=\"root\">");
        out.println("  <schedulingPolicy>drf</schedulingPolicy>");
        out.println("  <queue name=\"child1\">");
        out.println("    <minResources>1024mb,1vcores</minResources>");
        out.println("  </queue>");
        out.println("  <queue name=\"child2\">");
        out.println("    <minResources>1024mb,4vcores</minResources>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSParentQueue root = queueManager.getRootQueue();
        Assert.assertTrue((boolean)(root.getPolicy() instanceof DominantResourceFairnessPolicy));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("child1", false));
        Assert.assertNotNull((Object)queueManager.getLeafQueue("child2", false));
    }

    @Test(timeout=5000L)
    public void testIsStarvedForMinShare() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)4096, (int)4), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(3072, "queueA", "user1");
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeEvent2 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queueB", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            if (p.getName().equals("root.queueA")) {
                Assert.assertEquals((Object)false, (Object)this.scheduler.isStarvedForMinShare(p));
                continue;
            }
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((Object)true, (Object)this.scheduler.isStarvedForMinShare(p));
        }
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        for (FSLeafQueue p : queues) {
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((Object)false, (Object)this.scheduler.isStarvedForMinShare(p));
        }
    }

    @Test(timeout=5000L)
    public void testIsStarvedForFairShare() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.75</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)4096, (int)4), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(3072, "queueA", "user1");
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeEvent2 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        this.createSchedulingRequest(1024, "queueB", "user1");
        this.scheduler.update();
        Collection queues = this.scheduler.getQueueManager().getLeafQueues();
        Assert.assertEquals((long)3L, (long)queues.size());
        for (FSLeafQueue p : queues) {
            if (p.getName().equals("root.queueA")) {
                Assert.assertEquals((Object)false, (Object)this.scheduler.isStarvedForFairShare(p));
                continue;
            }
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((Object)true, (Object)this.scheduler.isStarvedForFairShare(p));
        }
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        for (FSLeafQueue p : queues) {
            if (!p.getName().equals("root.queueB")) continue;
            Assert.assertEquals((Object)false, (Object)this.scheduler.isStarvedForFairShare(p));
        }
    }

    @Test(timeout=5000L)
    public void testChoiceOfPreemptedContainers() throws Exception {
        this.conf.setLong("yarn.scheduler.fair.preemptionInterval", 5000L);
        this.conf.setLong("yarn.scheduler.fair.waitTimeBeforeKill", 10000L);
        this.conf.set("yarn.scheduler.fair.allocation.file.allocation.file", ALLOC_FILE);
        MockClock clock = new MockClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)2048, (int)2), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)2048, (int)2), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)2048, (int)2), (int)3, (String)"127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 3);
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        ApplicationAttemptId app5 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 2);
        ApplicationAttemptId app6 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 3);
        this.scheduler.update();
        for (int i = 0; i < 2; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
        }
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app4).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app5).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app6).getLiveContainers().size());
        ApplicationAttemptId app7 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 1);
        ApplicationAttemptId app8 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 2);
        ApplicationAttemptId app9 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 3);
        ApplicationAttemptId app10 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 1);
        ApplicationAttemptId app11 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 2);
        ApplicationAttemptId app12 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 3);
        this.scheduler.update();
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app4).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app5).getLiveContainers().size());
        Assert.assertTrue((!Collections.disjoint(this.scheduler.getSchedulerApp(app3).getLiveContainers(), this.scheduler.getSchedulerApp(app3).getPreemptionContainers()) ? 1 : 0) != 0);
        Assert.assertTrue((!Collections.disjoint(this.scheduler.getSchedulerApp(app6).getLiveContainers(), this.scheduler.getSchedulerApp(app6).getPreemptionContainers()) ? 1 : 0) != 0);
        clock.tick(15);
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app6).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        clock.tick(15);
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app4).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app5).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app6).getLiveContainers().size());
        this.scheduler.preemptResources(this.scheduler.getQueueManager().getLeafQueues(), Resources.createResource((int)2048));
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app4).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app5).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app6).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testPreemptionDecision() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        MockClock clock = new MockClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.print("<fairSharePreemptionTimeout>10</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)2048, (int)2), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)2048, (int)2), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)2048, (int)2), (int)3, (String)"127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 3);
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        ApplicationAttemptId app5 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 2);
        ApplicationAttemptId app6 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 3);
        this.scheduler.update();
        for (int i = 0; i < 2; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
        }
        ApplicationAttemptId app7 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 1);
        ApplicationAttemptId app8 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 2);
        ApplicationAttemptId app9 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 3);
        ApplicationAttemptId app10 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 1);
        ApplicationAttemptId app11 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 2);
        ApplicationAttemptId app12 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 3);
        this.scheduler.update();
        FSLeafQueue schedC = this.scheduler.getQueueManager().getLeafQueue("queueC", true);
        FSLeafQueue schedD = this.scheduler.getQueueManager().getLeafQueue("queueD", true);
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resToPreempt(schedC, clock.getTime())));
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resToPreempt(schedD, clock.getTime())));
        clock.tick(6);
        Assert.assertEquals((long)1024L, (long)this.scheduler.resToPreempt(schedC, clock.getTime()).getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.resToPreempt(schedD, clock.getTime()).getMemory());
        this.scheduler.update();
        clock.tick(6);
        Assert.assertEquals((long)1536L, (long)this.scheduler.resToPreempt(schedC, clock.getTime()).getMemory());
        Assert.assertEquals((long)1536L, (long)this.scheduler.resToPreempt(schedD, clock.getTime()).getMemory());
    }

    @Test(timeout=5000L)
    public void testMultipleContainersWaitingForReservation() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue2", "user2", 1);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue3", "user3", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getSchedulerApp(attId1).getCurrentReservation().getMemory());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId2).getCurrentReservation().getMemory());
    }

    @Test(timeout=5000L)
    public void testUserMaxRunningApps() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>1</maxRunningApps>");
        out.println("</user>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)8192, (int)8), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(attId2).getLiveContainers().size());
        this.createSchedulingRequestExistingApplication(1024, 1, attId1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(attId1).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testReservationWhileMultiplePriorities() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024, (int)4), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, 4, "queue1", "user1", 1, 2);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(attId);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        ContainerId containerId = ((RMContainer)this.scheduler.getSchedulerApp(attId).getLiveContainers().iterator().next()).getContainerId();
        this.createSchedulingRequestExistingApplication(1024, 4, 2, attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.createSchedulingRequestExistingApplication(1024, 4, 1, attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        for (RMContainer container : app.getReservedContainers()) {
            Assert.assertEquals((long)2L, (long)container.getReservedPriority().getPriority());
        }
        this.scheduler.allocate(attId, new ArrayList(), Arrays.asList(containerId), null, null);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Collection liveContainers = app.getLiveContainers();
        Assert.assertEquals((long)1L, (long)liveContainers.size());
        for (RMContainer liveContainer : liveContainers) {
            junit.framework.Assert.assertEquals((int)2, (int)liveContainer.getContainer().getPriority().getPriority());
        }
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test
    public void testAclSubmitApplication() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <aclSubmitApps> </aclSubmitApps>");
        out.println("  <aclAdministerApps> </aclAdministerApps>");
        out.println("  <queue name=\"queue1\">");
        out.println("    <aclSubmitApps>norealuserhasthisname</aclSubmitApps>");
        out.println("    <aclAdministerApps>norealuserhasthisname</aclAdministerApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "norealuserhasthisname", 1);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "norealuserhasthisname2", 1);
        FSSchedulerApp app1 = this.scheduler.getSchedulerApp(attId1);
        Assert.assertNotNull((String)"The application was not allowed", (Object)app1);
        FSSchedulerApp app2 = this.scheduler.getSchedulerApp(attId2);
        Assert.assertNull((String)"The application was allowed", (Object)app2);
    }

    @Test(timeout=5000L)
    public void testMultipleNodesSingleRackRequest() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)1, (String)"127.0.0.1");
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)2, (String)"127.0.0.2");
        RMNode node3 = MockNodes.newNodeInfo((int)2, (Resource)Resources.createResource((int)1024), (int)3, (String)"127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId appId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.scheduler.addApplication(appId.getApplicationId(), "queue1", "user1");
        this.scheduler.addApplicationAttempt(appId, false);
        ArrayList<ResourceRequest> asks = new ArrayList<ResourceRequest>();
        asks.add(this.createResourceRequest(1024, node1.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node2.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node3.getHostName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node1.getRackName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, node3.getRackName(), 1, 1, true));
        asks.add(this.createResourceRequest(1024, "*", 1, 2, true));
        this.scheduler.allocate(appId, asks, new ArrayList(), null, null);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent1);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(appId).getLiveContainers().size());
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)updateEvent2);
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(appId).getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testFifoWithinQueue() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)3072, (int)3), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 2);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1", "user1", 2);
        FSSchedulerApp app1 = this.scheduler.getSchedulerApp(attId1);
        FSSchedulerApp app2 = this.scheduler.getSchedulerApp(attId2);
        FSLeafQueue queue1 = this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        queue1.setPolicy((SchedulingPolicy)new FifoPolicy());
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)2L, (long)app1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)app2.getLiveContainers().size());
    }

    @Test(timeout=3000L)
    public void testMaxAssign() throws Exception {
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", true);
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)16384, (int)16), (int)0, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "root.default", "user", 8);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(attId);
        this.scheduler.maxAssign = 2;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)2L, (long)app.getLiveContainers().size());
        this.scheduler.maxAssign = -1;
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)8L, (long)app.getLiveContainers().size());
    }

    @Test(timeout=5000L)
    public void testAssignContainer() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        String user = "user1";
        String fifoQueue = "fifo";
        String fairParent = "fairParent";
        String fairChild1 = "fairParent.fairChild1";
        String fairChild2 = "fairParent.fairChild2";
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)8192, (int)8), (int)1, (String)"127.0.0.1");
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)8192, (int)8), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "fifo", "user1", 4);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "fairParent.fairChild1", "user1", 4);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "fairParent.fairChild2", "user1", 4);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "fifo", "user1", 4);
        FSSchedulerApp app1 = this.scheduler.getSchedulerApp(attId1);
        FSSchedulerApp app2 = this.scheduler.getSchedulerApp(attId2);
        FSSchedulerApp app3 = this.scheduler.getSchedulerApp(attId3);
        FSSchedulerApp app4 = this.scheduler.getSchedulerApp(attId4);
        this.scheduler.getQueueManager().getLeafQueue("fifo", true).setPolicy(SchedulingPolicy.parse((String)"fifo"));
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent1 = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent updateEvent2 = new NodeUpdateSchedulerEvent(node2);
        for (int i = 0; i < 8; ++i) {
            this.scheduler.handle((SchedulerEvent)updateEvent1);
            this.scheduler.handle((SchedulerEvent)updateEvent2);
            if ((i + 1) % 2 != 0) continue;
            String ERR = "Wrong number of assigned containers after " + (i + 1) + " updates";
            if (i < 4) {
                Assert.assertEquals((String)ERR, (long)(i + 1), (long)app1.getLiveContainers().size());
                Assert.assertEquals((String)ERR, (long)0L, (long)app4.getLiveContainers().size());
            } else {
                Assert.assertEquals((String)ERR, (long)4L, (long)app1.getLiveContainers().size());
                Assert.assertEquals((String)ERR, (long)(i - 3), (long)app4.getLiveContainers().size());
            }
            Assert.assertEquals((String)ERR, (long)((i + 1) / 2), (long)app2.getLiveContainers().size());
            Assert.assertEquals((String)ERR, (long)((i + 1) / 2), (long)app3.getLiveContainers().size());
        }
    }

    @Test
    public void testNotAllowSubmitApplication() throws Exception {
        int numTries;
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"root\">");
        out.println("  <aclSubmitApps> </aclSubmitApps>");
        out.println("  <aclAdministerApps> </aclAdministerApps>");
        out.println("  <queue name=\"queue1\">");
        out.println("    <aclSubmitApps>userallow</aclSubmitApps>");
        out.println("    <aclAdministerApps>userallow</aclAdministerApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int appId = this.APP_ID++;
        String user = "usernotallow";
        String queue = "queue1";
        ApplicationId applicationId = MockApps.newAppID((int)appId);
        String name = MockApps.newAppName();
        ApplicationMasterService masterService = new ApplicationMasterService(this.resourceManager.getRMContext(), (YarnScheduler)this.scheduler);
        ApplicationSubmissionContextPBImpl submissionContext = new ApplicationSubmissionContextPBImpl();
        ContainerLaunchContext clc = BuilderUtils.newContainerLaunchContext(null, null, null, null, null, null);
        submissionContext.setApplicationId(applicationId);
        submissionContext.setAMContainerSpec(clc);
        RMAppImpl application = new RMAppImpl(applicationId, this.resourceManager.getRMContext(), this.conf, name, user, queue, (ApplicationSubmissionContext)submissionContext, (YarnScheduler)this.scheduler, masterService, System.currentTimeMillis(), "YARN", null);
        this.resourceManager.getRMContext().getRMApps().putIfAbsent(applicationId, application);
        application.handle((Event)new RMAppEvent(applicationId, RMAppEventType.START));
        int MAX_TRIES = 20;
        for (numTries = 0; !application.getState().equals((Object)RMAppState.SUBMITTED) && numTries < 20; ++numTries) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Assert.assertEquals((String)"The application doesn't reach SUBMITTED.", (Object)RMAppState.SUBMITTED, (Object)application.getState());
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)this.ATTEMPT_ID++);
        this.scheduler.addApplication(attId.getApplicationId(), queue, user);
        for (numTries = 0; application.getFinishTime() == 0L && numTries < 20; ++numTries) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Assert.assertEquals((Object)FinalApplicationStatus.FAILED, (Object)application.getFinalApplicationStatus());
    }

    @Test
    public void testReservationThatDoesntFit() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId = this.createSchedulingRequest(2048, "queue1", "user1", 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(attId);
        Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        this.createSchedulingRequestExistingApplication(1024, 2, attId);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
    }

    @Test
    public void testRemoveNodeUpdatesRootQueueMetrics() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024, (int)4), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent addEvent = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)addEvent);
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        Assert.assertEquals((long)1024L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)4L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        NodeRemovedSchedulerEvent removeEvent = new NodeRemovedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)removeEvent);
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
        this.scheduler.update();
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)this.scheduler.getRootQueueMetrics().getAvailableVirtualCores());
    }

    @Test
    public void testStrictLocality() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getHostName(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, node1.getRackName(), 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node1UpdateEvent = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        }
        this.scheduler.handle((SchedulerEvent)node1UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testCancelStrictLocality() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getHostName(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, "rack1", 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
        }
        List<ResourceRequest> update = Arrays.asList(this.createResourceRequest(1024, node1.getHostName(), 1, 0, true), this.createResourceRequest(1024, "rack1", 1, 0, true), this.createResourceRequest(1024, "*", 1, 1, true));
        this.scheduler.allocate(attId1, update, new ArrayList(), null, null);
        this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testReservationsStrictLocality() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)1, (String)"127.0.0.1");
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(attId);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node2.getHostName(), 1, 2, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, "rack1", 1, 2, true);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 2, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId);
        this.createSchedulingRequestExistingApplication(rackRequest, attId);
        this.createSchedulingRequestExistingApplication(anyRequest, attId);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getReservedContainers().size());
        rackRequest = this.createResourceRequest(1024, "rack1", 1, 1, false);
        anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.scheduler.allocate(attId, Arrays.asList(rackRequest, anyRequest), new ArrayList(), null, null);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
    }

    @Test
    public void testNoMoreCpuOnNode() throws IOException {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)2048, (int)1), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId attId = this.createSchedulingRequest(1024, 1, "default", "user1", 2);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(attId);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testBasicDRFAssignment() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo((int)1, (Resource)BuilderUtils.newResource((int)8192, (int)5));
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(2048, 1, "queue1", "user1", 2);
        FSSchedulerApp app1 = this.scheduler.getSchedulerApp(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 2, "queue1", "user1", 2);
        FSSchedulerApp app2 = this.scheduler.getSchedulerApp(appAttId2);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getClusterCapacity());
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)0, (int)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)2, (int)app1.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
    }

    @Test
    public void testBasicDRFWithQueues() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo((int)1, (Resource)BuilderUtils.newResource((int)8192, (int)7), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(3072, 1, "queue1", "user1", 2);
        FSSchedulerApp app1 = this.scheduler.getSchedulerApp(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(2048, 2, "queue1", "user1", 2);
        FSSchedulerApp app2 = this.scheduler.getSchedulerApp(appAttId2);
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(1024, 2, "queue2", "user1", 2);
        FSSchedulerApp app3 = this.scheduler.getSchedulerApp(appAttId3);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getClusterCapacity());
        this.scheduler.getQueueManager().getQueue("root").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)2, (int)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
    }

    @Test
    public void testDRFHierarchicalQueues() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node = MockNodes.newNodeInfo((int)1, (Resource)BuilderUtils.newResource((int)12288, (int)12), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(3074, 1, "queue1.subqueue1", "user1", 2);
        Thread.sleep(3L);
        FSSchedulerApp app1 = this.scheduler.getSchedulerApp(appAttId1);
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 3, "queue1.subqueue1", "user1", 2);
        Thread.sleep(3L);
        FSSchedulerApp app2 = this.scheduler.getSchedulerApp(appAttId2);
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(2048, 2, "queue1.subqueue2", "user1", 2);
        Thread.sleep(3L);
        FSSchedulerApp app3 = this.scheduler.getSchedulerApp(appAttId3);
        ApplicationAttemptId appAttId4 = this.createSchedulingRequest(1024, 2, "queue2", "user1", 2);
        Thread.sleep(3L);
        FSSchedulerApp app4 = this.scheduler.getSchedulerApp(appAttId4);
        DominantResourceFairnessPolicy drfPolicy = new DominantResourceFairnessPolicy();
        drfPolicy.initialize(this.scheduler.getClusterCapacity());
        this.scheduler.getQueueManager().getQueue("root").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.getQueueManager().getQueue("queue1.subqueue1").setPolicy((SchedulingPolicy)drfPolicy);
        this.scheduler.update();
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app4.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)2, (int)app4.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)2, (int)app3.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
        this.scheduler.handle((SchedulerEvent)updateEvent);
        junit.framework.Assert.assertEquals((int)1, (int)app1.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)1, (int)app2.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)2, (int)app3.getLiveContainers().size());
        junit.framework.Assert.assertEquals((int)2, (int)app4.getLiveContainers().size());
    }

    @Test(timeout=30000L)
    public void testHostPortNodeName() throws Exception {
        this.conf.setBoolean("yarn.scheduler.include-port-in-node-name", true);
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)1, (String)"127.0.0.1", (int)1);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024), (int)2, (String)"127.0.0.1", (int)2);
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1", 0);
        ResourceRequest nodeRequest = this.createResourceRequest(1024, node1.getNodeID().getHost() + ":" + node1.getNodeID().getPort(), 1, 1, true);
        ResourceRequest rackRequest = this.createResourceRequest(1024, node1.getRackName(), 1, 1, false);
        ResourceRequest anyRequest = this.createResourceRequest(1024, "*", 1, 1, false);
        this.createSchedulingRequestExistingApplication(nodeRequest, attId1);
        this.createSchedulingRequestExistingApplication(rackRequest, attId1);
        this.createSchedulingRequestExistingApplication(anyRequest, attId1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent node1UpdateEvent = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent node2UpdateEvent = new NodeUpdateSchedulerEvent(node2);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(attId1);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.handle((SchedulerEvent)node2UpdateEvent);
            Assert.assertEquals((long)0L, (long)app.getLiveContainers().size());
            Assert.assertEquals((long)0L, (long)app.getReservedContainers().size());
        }
        this.scheduler.handle((SchedulerEvent)node1UpdateEvent);
        Assert.assertEquals((long)1L, (long)app.getLiveContainers().size());
    }

    private void verifyAppRunnable(ApplicationAttemptId attId, boolean runnable) {
        FSSchedulerApp app = this.scheduler.getSchedulerApp(attId);
        FSLeafQueue queue = app.getQueue();
        Collection runnableApps = queue.getRunnableAppSchedulables();
        List nonRunnableApps = queue.getNonRunnableAppSchedulables();
        Assert.assertEquals((Object)runnable, (Object)runnableApps.contains(app.getAppSchedulable()));
        Assert.assertEquals((Object)(!runnable ? 1 : 0), (Object)nonRunnableApps.contains(app.getAppSchedulable()));
    }

    private void verifyQueueNumRunnable(String queueName, int numRunnableInQueue, int numNonRunnableInQueue) {
        FSLeafQueue queue = this.scheduler.getQueueManager().getLeafQueue(queueName, false);
        Assert.assertEquals((long)numRunnableInQueue, (long)queue.getRunnableAppSchedulables().size());
        Assert.assertEquals((long)numNonRunnableInQueue, (long)queue.getNonRunnableAppSchedulables().size());
    }

    @Test
    public void testUserAndQueueMaxRunningApps() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("<maxRunningApps>2</maxRunningApps>");
        out.println("</queue>");
        out.println("<user name=\"user1\">");
        out.println("<maxRunningApps>1</maxRunningApps>");
        out.println("</user>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1", "user1");
        this.verifyAppRunnable(attId1, true);
        this.verifyQueueNumRunnable("queue1", 1, 0);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue2", "user1");
        this.verifyAppRunnable(attId2, false);
        this.verifyQueueNumRunnable("queue2", 0, 1);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1", "user2");
        this.verifyAppRunnable(attId3, true);
        this.verifyQueueNumRunnable("queue1", 2, 0);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1", "user2");
        this.verifyAppRunnable(attId4, false);
        this.verifyQueueNumRunnable("queue1", 2, 1);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId1, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.verifyAppRunnable(attId2, true);
        this.verifyQueueNumRunnable("queue2", 1, 0);
        this.verifyAppRunnable(attId4, true);
        this.verifyQueueNumRunnable("queue1", 2, 0);
        ApplicationAttemptId attId5 = this.createSchedulingRequest(1024, "queue1", "user2");
        this.verifyAppRunnable(attId5, false);
        this.verifyQueueNumRunnable("queue1", 2, 1);
    }

    @Test
    public void testMaxRunningAppsHierarchicalQueues() throws Exception {
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        MockClock clock = new MockClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queue1\">");
        out.println("  <maxRunningApps>3</maxRunningApps>");
        out.println("  <queue name=\"sub1\"></queue>");
        out.println("  <queue name=\"sub2\"></queue>");
        out.println("  <queue name=\"sub3\">");
        out.println("    <maxRunningApps>1</maxRunningApps>");
        out.println("  </queue>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId attId1 = this.createSchedulingRequest(1024, "queue1.sub1", "user1");
        this.verifyAppRunnable(attId1, true);
        this.verifyQueueNumRunnable("queue1.sub1", 1, 0);
        clock.tick(10);
        ApplicationAttemptId attId2 = this.createSchedulingRequest(1024, "queue1.sub3", "user1");
        this.verifyAppRunnable(attId2, true);
        this.verifyQueueNumRunnable("queue1.sub3", 1, 0);
        clock.tick(10);
        ApplicationAttemptId attId3 = this.createSchedulingRequest(1024, "queue1.sub2", "user1");
        this.verifyAppRunnable(attId3, true);
        this.verifyQueueNumRunnable("queue1.sub2", 1, 0);
        clock.tick(10);
        ApplicationAttemptId attId4 = this.createSchedulingRequest(1024, "queue1.sub2", "user1");
        this.verifyAppRunnable(attId4, false);
        this.verifyQueueNumRunnable("queue1.sub2", 1, 1);
        clock.tick(10);
        ApplicationAttemptId attId5 = this.createSchedulingRequest(1024, "queue1.sub3", "user1");
        this.verifyAppRunnable(attId5, false);
        this.verifyQueueNumRunnable("queue1.sub3", 1, 1);
        clock.tick(10);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(attId2, RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        this.verifyAppRunnable(attId4, true);
        this.verifyQueueNumRunnable("queue1.sub2", 2, 0);
        this.verifyAppRunnable(attId5, false);
        this.verifyQueueNumRunnable("queue1.sub3", 0, 1);
        AppAttemptRemovedSchedulerEvent appRemovedEvent2 = new AppAttemptRemovedSchedulerEvent(attId5, RMAppAttemptState.KILLED, true);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent2);
        Assert.assertEquals((long)0L, (long)this.scheduler.maxRunningEnforcer.usersNonRunnableApps.get((Object)"user1").size());
        this.verifyQueueNumRunnable("queue1.sub3", 0, 0);
        AppAttemptRemovedSchedulerEvent appRemovedEvent3 = new AppAttemptRemovedSchedulerEvent(attId4, RMAppAttemptState.FINISHED, true);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent3);
        this.verifyQueueNumRunnable("queue1.sub2", 1, 0);
        this.verifyQueueNumRunnable("queue1.sub3", 0, 0);
    }

    @Test(timeout=10000L)
    public void testContinuousScheduling() throws Exception {
        FairScheduler fs = new FairScheduler();
        Configuration conf = this.createConfiguration();
        conf.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        fs.reinitialize(conf, this.resourceManager.getRMContext());
        junit.framework.Assert.assertTrue((String)"Continuous scheduling should be enabled.", (boolean)fs.isContinuousSchedulingEnabled());
        RMNode node1 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)8192, (int)8), (int)1, (String)"127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        fs.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)8192, (int)8), (int)2, (String)"127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        fs.handle((SchedulerEvent)nodeEvent2);
        junit.framework.Assert.assertEquals((int)fs.getClusterCapacity().getMemory(), (int)16384);
        junit.framework.Assert.assertEquals((int)fs.getClusterCapacity().getVirtualCores(), (int)16);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        fs.addApplication(appAttemptId.getApplicationId(), "queue11", "user11");
        fs.addApplicationAttempt(appAttemptId, false);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest request = this.createResourceRequest(1024, 1, "*", 1, 1, true);
        ask.add(request);
        fs.allocate(appAttemptId, ask, new ArrayList(), null, null);
        Thread.sleep(fs.getConf().getContinuousSchedulingSleepMs() + 500);
        FSSchedulerApp app = fs.getSchedulerApp(appAttemptId);
        while (app.getCurrentConsumption().equals((Object)Resources.none())) {
        }
        junit.framework.Assert.assertEquals((int)1024, (int)app.getCurrentConsumption().getMemory());
        junit.framework.Assert.assertEquals((int)1, (int)app.getCurrentConsumption().getVirtualCores());
        request = this.createResourceRequest(1024, 1, "*", 2, 1, true);
        ask.clear();
        ask.add(request);
        fs.allocate(appAttemptId, ask, new ArrayList(), null, null);
        while (app.getCurrentConsumption().equals((Object)Resources.createResource((int)1024, (int)1))) {
        }
        junit.framework.Assert.assertEquals((int)2048, (int)app.getCurrentConsumption().getMemory());
        junit.framework.Assert.assertEquals((int)2, (int)app.getCurrentConsumption().getVirtualCores());
        HashSet<NodeId> nodes = new HashSet<NodeId>();
        Iterator it = app.getLiveContainers().iterator();
        while (it.hasNext()) {
            nodes.add(((RMContainer)it.next()).getContainer().getNodeId());
        }
        junit.framework.Assert.assertEquals((int)2, (int)nodes.size());
    }

    @Test
    public void testDontAllowUndeclaredPools() throws Exception {
        this.conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"jerry\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSLeafQueue jerryQueue = queueManager.getLeafQueue("jerry", false);
        FSLeafQueue defaultQueue = queueManager.getLeafQueue("default", false);
        this.createSchedulingRequest(1024, "jerry", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getRunnableAppSchedulables().size());
        this.createSchedulingRequest(1024, "newqueue", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getRunnableAppSchedulables().size());
        Assert.assertEquals((long)1L, (long)defaultQueue.getRunnableAppSchedulables().size());
        this.createSchedulingRequest(1024, "default", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getRunnableAppSchedulables().size());
        Assert.assertEquals((long)2L, (long)defaultQueue.getRunnableAppSchedulables().size());
        this.createSchedulingRequest(1024, "default", "jerry");
        Assert.assertEquals((long)2L, (long)jerryQueue.getRunnableAppSchedulables().size());
        Assert.assertEquals((long)2L, (long)defaultQueue.getRunnableAppSchedulables().size());
    }

    @Test
    public void testBlacklistNodes() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        int GB = 1024;
        String host = "127.0.0.1";
        RMNode node = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)16384, (int)16), (int)0, (String)host);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ApplicationAttemptId appAttemptId = this.createSchedulingRequest(1024, "root.default", "user", 1);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(appAttemptId);
        this.scheduler.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(host), null);
        Assert.assertTrue((boolean)app.isBlacklisted(host));
        this.scheduler.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, Collections.singletonList(host));
        Assert.assertFalse((boolean)this.scheduler.getSchedulerApp(appAttemptId).isBlacklisted(host));
        List<ResourceRequest> update = Arrays.asList(this.createResourceRequest(1024, node.getHostName(), 1, 0, true));
        this.scheduler.allocate(appAttemptId, update, Collections.emptyList(), Collections.singletonList(host), null);
        Assert.assertTrue((boolean)app.isBlacklisted(host));
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)0L, (long)app.getLiveContainers().size());
        this.scheduler.allocate(appAttemptId, update, Collections.emptyList(), null, Collections.singletonList(host));
        Assert.assertFalse((boolean)app.isBlacklisted(host));
        this.createSchedulingRequest(1024, "root.default", "user", 1);
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((String)"Incorrect number of containers allocated", (long)1L, (long)app.getLiveContainers().size());
    }

    @Test
    public void testGetAppsInQueue() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId appAttId1 = this.createSchedulingRequest(1024, 1, "queue1.subqueue1", "user1");
        ApplicationAttemptId appAttId2 = this.createSchedulingRequest(1024, 1, "queue1.subqueue2", "user1");
        ApplicationAttemptId appAttId3 = this.createSchedulingRequest(1024, 1, "default", "user1");
        List apps = this.scheduler.getAppsInQueue("queue1.subqueue1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId1, apps.get(0));
        apps = this.scheduler.getAppsInQueue("root.queue1.subqueue1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId1, apps.get(0));
        apps = this.scheduler.getAppsInQueue("user1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId3, apps.get(0));
        apps = this.scheduler.getAppsInQueue("root.user1");
        Assert.assertEquals((long)1L, (long)apps.size());
        Assert.assertEquals((Object)appAttId3, apps.get(0));
        apps = this.scheduler.getAppsInQueue("queue1");
        junit.framework.Assert.assertEquals((int)2, (int)apps.size());
        HashSet appAttIds = Sets.newHashSet((Object[])new ApplicationAttemptId[]{(ApplicationAttemptId)apps.get(0), (ApplicationAttemptId)apps.get(1)});
        Assert.assertTrue((boolean)appAttIds.contains(appAttId1));
        Assert.assertTrue((boolean)appAttIds.contains(appAttId2));
    }

    @Test
    public void testAddAndRemoveAppFromFairScheduler() throws Exception {
        FairScheduler scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        TestSchedulerUtils.verifyAppAddedAndRemovedFromScheduler((Map)scheduler.getSchedulerApplications(), (EventHandler)scheduler, (String)"default");
    }

    @Test
    public void testMoveRunnableApp() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue targetQueue = queueMgr.getLeafQueue("queue2", true);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        ApplicationId appId = appAttId.getApplicationId();
        RMNode node = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)1024));
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)oldQueue.getResourceUsage());
        this.scheduler.update();
        Assert.assertEquals((Object)Resource.newInstance((int)3072, (int)3), (Object)oldQueue.getDemand());
        this.scheduler.moveApplication(appId, "queue2");
        FSSchedulerApp app = this.scheduler.getSchedulerApp(appAttId);
        Assert.assertSame((Object)targetQueue, (Object)app.getQueue());
        Assert.assertFalse((boolean)oldQueue.getRunnableAppSchedulables().contains(app.getAppSchedulable()));
        Assert.assertTrue((boolean)targetQueue.getRunnableAppSchedulables().contains(app.getAppSchedulable()));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)oldQueue.getResourceUsage());
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)targetQueue.getResourceUsage());
        Assert.assertEquals((long)0L, (long)oldQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)targetQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)queueMgr.getRootQueue().getNumRunnableApps());
        this.scheduler.update();
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)oldQueue.getDemand());
        Assert.assertEquals((Object)Resource.newInstance((int)3072, (int)3), (Object)targetQueue.getDemand());
    }

    @Test
    public void testMoveNonRunnableApp() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue targetQueue = queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue1", 0);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue2", 0);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        Assert.assertEquals((long)0L, (long)oldQueue.getNumRunnableApps());
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
        Assert.assertEquals((long)0L, (long)oldQueue.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)targetQueue.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)queueMgr.getRootQueue().getNumRunnableApps());
    }

    @Test
    public void testMoveMakesAppRunnable() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue targetQueue = queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue1", 0);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        FSSchedulerApp app = this.scheduler.getSchedulerApp(appAttId);
        Assert.assertTrue((boolean)oldQueue.getNonRunnableAppSchedulables().contains(app.getAppSchedulable()));
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
        Assert.assertFalse((boolean)oldQueue.getNonRunnableAppSchedulables().contains(app.getAppSchedulable()));
        Assert.assertFalse((boolean)targetQueue.getNonRunnableAppSchedulables().contains(app.getAppSchedulable()));
        Assert.assertTrue((boolean)targetQueue.getRunnableAppSchedulables().contains(app.getAppSchedulable()));
        Assert.assertEquals((long)1L, (long)targetQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)queueMgr.getRootQueue().getNumRunnableApps());
    }

    @Test(expected=YarnException.class)
    public void testMoveWouldViolateMaxAppsConstraints() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue2", 0);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
    }

    @Test(expected=YarnException.class)
    public void testMoveWouldViolateMaxResourcesConstraints() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().maxQueueResources.put("root.queue2", Resource.newInstance((int)1024, (int)1));
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        RMNode node = MockNodes.newNodeInfo((int)1, (Resource)Resources.createResource((int)2048, (int)2));
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((Object)Resource.newInstance((int)2048, (int)2), (Object)oldQueue.getResourceUsage());
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
    }

    @Test(expected=YarnException.class)
    public void testMoveToNonexistentQueue() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        this.scheduler.getQueueManager().getLeafQueue("queue1", true);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
    }
}

