/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.labelmanagement;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

@InterfaceAudience.Private
public final class LabelStorage {
    private static final Log LOG = LogFactory.getLog(LabelStorage.class);
    public static final Pattern regex = Pattern.compile("[^\\s,\"']+|\"([^\"]*)\"|'([^']*)'");
    public static final Pattern alpha_num = Pattern.compile("^[A-Za-z0-9_ ]+$");
    public static final Pattern keywords = Pattern.compile("^int$|^abs$|^pow$");
    private FileSystem fs;
    private Path labelFile = null;
    private static LabelStorage s_instance = new LabelStorage();
    private Map<String, List<String>> nodeExpressionLabels = new HashMap<String, List<String>>();
    private Map<String, Set<String>> nodeToLabelsMap = new ConcurrentHashMap<String, Set<String>>();
    private Set<String> nodeNoMatchers = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<String, BigDecimal> labelEvalFillers = new HashMap<String, BigDecimal>();

    private LabelStorage() {
    }

    static LabelStorage getInstance() {
        return s_instance;
    }

    void storageInit(FileSystem fs, Path labelFile) {
        this.fs = fs;
        this.labelFile = labelFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    void loadAndApplyLabels() throws IOException {
        if (!this.fs.exists(this.labelFile)) {
            LOG.error((Object)("LabelFile does not exist: " + this.labelFile + ". Existing labels configuration will not be updated"));
            return;
        }
        FSDataInputStream input = this.fs.open(this.labelFile);
        BufferedReader sin = new BufferedReader(new InputStreamReader((InputStream)input));
        try {
            String str = null;
            HashMap nodeNotifierLabelsTmp = new HashMap();
            HashMap<String, BigDecimal> labelEvalFillersTmp = new HashMap<String, BigDecimal>();
            int lineno = 0;
            while ((str = sin.readLine()) != null) {
                String nodeIdentifier;
                ++lineno;
                String[] tokens = str.split("\\s+", 2);
                if (tokens.length != 2) {
                    LOG.warn((Object)("Wrong format in node label file -> " + lineno + ":" + str));
                    continue;
                }
                if (tokens[0].startsWith("/") && tokens[0].endsWith("/")) {
                    nodeIdentifier = tokens[0].replaceAll("^\\/|\\/$", "");
                } else {
                    nodeIdentifier = tokens[0].replaceAll("\\*", ".*");
                    nodeIdentifier = nodeIdentifier.replaceAll("\\?", ".");
                }
                ArrayList<String> nodeLabels = new ArrayList<String>();
                Matcher regexMatcher = regex.matcher(tokens[1]);
                while (regexMatcher.find()) {
                    String term = regexMatcher.group(1) != null ? regexMatcher.group(1) : (regexMatcher.group(2) != null ? regexMatcher.group(2) : regexMatcher.group());
                    if (term != null && alpha_num.matcher(term).matches() && !keywords.matcher(term).matches()) {
                        nodeLabels.add(term);
                        labelEvalFillersTmp.put(term, BigDecimal.ZERO);
                        continue;
                    }
                    LOG.warn((Object)("Invalid node label: '" + term + "'"));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("nodeIdentifier :" + nodeIdentifier + " labels :" + nodeLabels));
                }
                nodeNotifierLabelsTmp.put(nodeIdentifier, nodeLabels);
            }
            Map<String, List<String>> map = this.nodeExpressionLabels;
            synchronized (map) {
                Map<String, BigDecimal> map2 = this.labelEvalFillers;
                synchronized (map2) {
                    this.nodeExpressionLabels.clear();
                    this.nodeExpressionLabels.putAll(nodeNotifierLabelsTmp);
                    this.labelEvalFillers.clear();
                    this.labelEvalFillers.putAll(labelEvalFillersTmp);
                    this.nodeToLabelsMap.clear();
                    this.nodeNoMatchers.clear();
                }
            }
            nodeNotifierLabelsTmp.clear();
            labelEvalFillersTmp.clear();
            nodeNotifierLabelsTmp = null;
            labelEvalFillersTmp = null;
        }
        finally {
            sin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getLabelsForNode(String node) {
        Set<String> labelsForNode = this.nodeToLabelsMap.get(node.toLowerCase());
        if (labelsForNode != null) {
            return labelsForNode;
        }
        if (this.nodeNoMatchers.contains(node.toLowerCase())) {
            return null;
        }
        HashMap<String, List<String>> nodeNotifierLabelsTmp = new HashMap<String, List<String>>();
        Map<String, List<String>> map = this.nodeExpressionLabels;
        synchronized (map) {
            nodeNotifierLabelsTmp.putAll(this.nodeExpressionLabels);
        }
        HashSet<String> nodeLabels = new HashSet<String>();
        for (Map.Entry entry : nodeNotifierLabelsTmp.entrySet()) {
            String nodeIdentifier = (String)entry.getKey();
            if (node.matches(nodeIdentifier)) {
                nodeLabels.addAll((Collection)entry.getValue());
                Set<String> listFromMap = this.nodeToLabelsMap.get(node.toLowerCase());
                if (listFromMap == null) {
                    this.nodeToLabelsMap.put(node.toLowerCase(), new HashSet((Collection)entry.getValue()));
                } else {
                    listFromMap.addAll((Collection)entry.getValue());
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Adding labels for node: " + node + ", labels: " + nodeLabels));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Identifier not matching setLabel node: '" + node + "' identifier: '" + nodeIdentifier + "'"));
        }
        nodeNotifierLabelsTmp.clear();
        nodeNotifierLabelsTmp = null;
        if (nodeLabels.isEmpty()) {
            this.nodeNoMatchers.add(node.toLowerCase());
            return null;
        }
        return nodeLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<NodeToLabelsList> getLabelsForAllNodes() {
        HashMap<String, List<String>> nodeNotifierLabelsTmp = new HashMap<String, List<String>>();
        Map<String, List<String>> map = this.nodeExpressionLabels;
        synchronized (map) {
            nodeNotifierLabelsTmp.putAll(this.nodeExpressionLabels);
        }
        ArrayList<NodeToLabelsList> nodeToLabelsList = new ArrayList<NodeToLabelsList>();
        for (Map.Entry entry : nodeNotifierLabelsTmp.entrySet()) {
            NodeToLabelsList singleNodeToLabelsList = (NodeToLabelsList)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(NodeToLabelsList.class);
            singleNodeToLabelsList.setNode((String)entry.getKey());
            singleNodeToLabelsList.setNodeLabel((List)entry.getValue());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding labels for node: " + (String)entry.getKey() + ", labels: " + entry.getValue()));
            }
            nodeToLabelsList.add(singleNodeToLabelsList);
        }
        nodeNotifierLabelsTmp.clear();
        nodeNotifierLabelsTmp = null;
        return nodeToLabelsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, BigDecimal> getFillers() {
        HashMap<String, BigDecimal> labelEvalFillersTmp = new HashMap<String, BigDecimal>();
        Map<String, BigDecimal> map = this.labelEvalFillers;
        synchronized (map) {
            labelEvalFillersTmp.putAll(this.labelEvalFillers);
        }
        return labelEvalFillersTmp;
    }
}

