/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.server.resourcemanager.QueueACLsTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;

public class TestCapacitySchedulerQueueACLs
extends QueueACLsTestBase {
    protected Configuration createConfiguration() {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.setQueues("root", new String[]{"queueA", "queueB"});
        csConf.setCapacity("root.queueA", 50.0f);
        csConf.setCapacity("root.queueB", 50.0f);
        HashMap<QueueACL, AccessControlList> aclsOnQueueA = new HashMap<QueueACL, AccessControlList>();
        AccessControlList submitACLonQueueA = new AccessControlList("queueA_user");
        submitACLonQueueA.addUser("common_user");
        AccessControlList adminACLonQueueA = new AccessControlList("queueA_admin");
        aclsOnQueueA.put(QueueACL.SUBMIT_APPLICATIONS, submitACLonQueueA);
        aclsOnQueueA.put(QueueACL.ADMINISTER_QUEUE, adminACLonQueueA);
        csConf.setAcls("root.queueA", aclsOnQueueA);
        HashMap<QueueACL, AccessControlList> aclsOnQueueB = new HashMap<QueueACL, AccessControlList>();
        AccessControlList submitACLonQueueB = new AccessControlList("queueB_user");
        submitACLonQueueB.addUser("common_user");
        AccessControlList adminACLonQueueB = new AccessControlList("queueB_admin");
        aclsOnQueueB.put(QueueACL.SUBMIT_APPLICATIONS, submitACLonQueueB);
        aclsOnQueueB.put(QueueACL.ADMINISTER_QUEUE, adminACLonQueueB);
        csConf.setAcls("root.queueB", aclsOnQueueB);
        HashMap<QueueACL, AccessControlList> aclsOnRootQueue = new HashMap<QueueACL, AccessControlList>();
        AccessControlList submitACLonRoot = new AccessControlList("");
        AccessControlList adminACLonRoot = new AccessControlList("root_admin");
        aclsOnRootQueue.put(QueueACL.SUBMIT_APPLICATIONS, submitACLonRoot);
        aclsOnRootQueue.put(QueueACL.ADMINISTER_QUEUE, adminACLonRoot);
        csConf.setAcls("root", aclsOnRootQueue);
        csConf.setBoolean("yarn.acl.enable", true);
        csConf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        return csConf;
    }
}

