/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.TestZKRMStateStoreZKClientConnections;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestZKRMStateStoreZKClientConnections
extends ClientBaseWithFixes {
    private static final int ZK_OP_WAIT_TIME = 3000;
    private static final int ZK_TIMEOUT_MS = 1000;
    private Log LOG = LogFactory.getLog(TestZKRMStateStoreZKClientConnections.class);
    private static final String DIGEST_USER_PASS = "test-user:test-password";
    private static final String TEST_AUTH_GOOD = "digest:test-user:test-password";
    private static final String DIGEST_USER_HASH;
    private static final String TEST_ACL;

    @Test(timeout=20000L)
    public void testZKClientRetry() throws Exception {
        TestZKClient zkClientTester = new TestZKClient(this);
        String path = "/test";
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.zk-timeout-ms", 1000);
        conf.setLong("yarn.resourcemanager.zk-retry-interval-ms", 100L);
        ZKRMStateStore store = (ZKRMStateStore)zkClientTester.getRMStateStore((Configuration)conf);
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        AtomicBoolean assertionFailedInThread = new AtomicBoolean(false);
        this.stopServer();
        1 clientThread = new /* Unavailable Anonymous Inner Class!! */;
        Thread.sleep(2000L);
        this.startServer();
        clientThread.join();
        Assert.assertFalse((boolean)assertionFailedInThread.get());
    }

    @Test(timeout=20000L)
    public void testZKClientDisconnectAndReconnect() throws Exception {
        TestZKClient zkClientTester = new TestZKClient(this);
        String path = "/test";
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.zk-timeout-ms", 1000);
        ZKRMStateStore store = (ZKRMStateStore)zkClientTester.getRMStateStore((Configuration)conf);
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        store.createWithRetries(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        store.getDataWithRetries(path, true);
        store.setDataWithRetries(path, "newBytes".getBytes(), 0);
        this.stopServer();
        zkClientTester.watcher.waitForDisconnected(3000L);
        try {
            store.getDataWithRetries(path, true);
            Assert.fail((String)"Expected ZKClient time out exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Wait for ZKClient creation timed out"));
        }
        this.startServer();
        zkClientTester.watcher.waitForConnected(3000L);
        byte[] ret = null;
        try {
            ret = store.getDataWithRetries(path, true);
        }
        catch (Exception e) {
            String error = "ZKRMStateStore Session restore failed";
            this.LOG.error((Object)error, (Throwable)e);
            Assert.fail((String)error);
        }
        Assert.assertEquals((Object)"newBytes", (Object)new String(ret));
    }

    @Test(timeout=20000L)
    public void testZKSessionTimeout() throws Exception {
        TestZKClient zkClientTester = new TestZKClient(this);
        String path = "/test";
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.zk-timeout-ms", 1000);
        ZKRMStateStore store = (ZKRMStateStore)zkClientTester.getRMStateStore((Configuration)conf);
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        store.setRMDispatcher((Dispatcher)dispatcher);
        zkClientTester.forExpire = true;
        store.createWithRetries(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        store.getDataWithRetries(path, true);
        store.setDataWithRetries(path, "bytes".getBytes(), 0);
        zkClientTester.syncBarrier.await();
        try {
            byte[] ret = store.getDataWithRetries(path, false);
            Assert.assertEquals((Object)"bytes", (Object)new String(ret));
        }
        catch (Exception e) {
            String error = "New session creation failed";
            this.LOG.error((Object)error, (Throwable)e);
            Assert.fail((String)error);
        }
    }

    @Test(timeout=20000L)
    public void testSetZKAcl() {
        TestZKClient zkClientTester = new TestZKClient(this);
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.zk-acl", "world:anyone:rwca");
        try {
            zkClientTester.store.zkClient.delete(zkClientTester.store.znodeWorkingPath, -1);
            Assert.fail((String)"Shouldn't be able to delete path");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=20000L)
    public void testInvalidZKAclConfiguration() {
        TestZKClient zkClientTester = new TestZKClient(this);
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.zk-acl", "randomstring&*");
        try {
            zkClientTester.getRMStateStore((Configuration)conf);
            Assert.fail((String)"ZKRMStateStore created with bad ACL");
        }
        catch (ZKUtil.BadAclFormatException bafe) {
        }
        catch (Exception e) {
            String error = "Incorrect exception on BadAclFormat";
            this.LOG.error((Object)error, (Throwable)e);
            Assert.fail((String)error);
        }
    }

    @Test
    public void testZKAuths() throws Exception {
        TestZKClient zkClientTester = new TestZKClient(this);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.zk-num-retries", 1);
        conf.setInt("yarn.resourcemanager.zk-timeout-ms", 1000);
        conf.set("yarn.resourcemanager.zk-acl", TEST_ACL);
        conf.set("yarn.resourcemanager.zk-auth", TEST_AUTH_GOOD);
        zkClientTester.getRMStateStore((Configuration)conf);
    }

    static /* synthetic */ String access$000(TestZKRMStateStoreZKClientConnections x0) {
        return x0.hostPort;
    }

    static /* synthetic */ TestableZooKeeper access$100(TestZKRMStateStoreZKClientConnections x0, ClientBaseWithFixes.CountdownWatcher x1, String x2, int x3) throws IOException, InterruptedException {
        return x0.createClient(x1, x2, x3);
    }

    static /* synthetic */ Log access$200(TestZKRMStateStoreZKClientConnections x0) {
        return x0.LOG;
    }

    static /* synthetic */ String access$300(TestZKRMStateStoreZKClientConnections x0) {
        return x0.hostPort;
    }

    static {
        try {
            DIGEST_USER_HASH = DigestAuthenticationProvider.generateDigest((String)DIGEST_USER_PASS);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        TEST_ACL = "digest:" + DIGEST_USER_HASH + ":rwcda";
    }
}

