/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.TestZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.zookeeper.TestableZooKeeper;
import org.junit.Assert;
import org.junit.Test;

public class TestZKRMStateStore
extends RMStateStoreTestBase {
    public static final Log LOG = LogFactory.getLog(TestZKRMStateStore.class);
    private static final int ZK_TIMEOUT_MS = 1000;

    @Test(timeout=60000L)
    public void testZKRMStateStoreRealZK() throws Exception {
        TestZKRMStateStoreTester zkTester = new TestZKRMStateStoreTester(this);
        this.testRMAppStateStore((RMStateStoreTestBase.RMStateStoreHelper)zkTester);
        this.testRMDTSecretManagerStateStore((RMStateStoreTestBase.RMStateStoreHelper)zkTester);
        this.testCheckVersion((RMStateStoreTestBase.RMStateStoreHelper)zkTester);
        this.testAppDeletion((RMStateStoreTestBase.RMStateStoreHelper)zkTester);
    }

    private Configuration createHARMConf(String rmIds, String rmId, int adminPort) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", rmIds);
        conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        conf.set("yarn.resourcemanager.store.class", ZKRMStateStore.class.getName());
        conf.set("yarn.resourcemanager.zk-address", this.hostPort);
        conf.setInt("yarn.resourcemanager.zk-timeout-ms", 1000);
        conf.set("yarn.resourcemanager.ha.id", rmId);
        conf.set("yarn.resourcemanager.webapp.address", "localhost:0");
        for (String rpcAddress : YarnConfiguration.getServiceAddressConfKeys((Configuration)conf)) {
            for (String id : HAUtil.getRMHAIds((Configuration)conf)) {
                conf.set(HAUtil.addSuffix((String)rpcAddress, (String)id), "localhost:0");
            }
        }
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.admin.address", (String)rmId), "localhost:" + adminPort);
        return conf;
    }

    @Test
    public void testFencing() throws Exception {
        HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        Configuration conf1 = this.createHARMConf("rm1,rm2", "rm1", 1234);
        conf1.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        ResourceManager rm1 = new ResourceManager();
        rm1.init(conf1);
        rm1.start();
        rm1.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm1.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Configuration conf2 = this.createHARMConf("rm1,rm2", "rm2", 5678);
        conf2.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        ResourceManager rm2 = new ResourceManager();
        rm2.init(conf2);
        rm2.start();
        rm2.getRMContext().getRMAdminService().transitionToActive(req);
        Assert.assertEquals((String)"RM with ZKStore didn't start", (Object)Service.STATE.STARTED, (Object)rm2.getServiceState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
        for (int i = 0; i < 20; ++i) {
            if (HAServiceProtocol.HAServiceState.ACTIVE != rm1.getRMContext().getRMAdminService().getServiceStatus().getState()) continue;
            Thread.sleep(100L);
        }
        Assert.assertEquals((String)"RM should have been fenced", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)rm1.getRMContext().getRMAdminService().getServiceStatus().getState());
        Assert.assertEquals((String)"RM should be Active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)rm2.getRMContext().getRMAdminService().getServiceStatus().getState());
    }

    static /* synthetic */ String access$000(TestZKRMStateStore x0) {
        return x0.hostPort;
    }

    static /* synthetic */ TestableZooKeeper access$100(TestZKRMStateStore x0) throws IOException, InterruptedException {
        return x0.createClient();
    }
}

