/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerPreemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestProportionalCapacityPreemptionPolicy {
    static final long TS = 3141592653L;
    int appAlloc = 0;
    Random rand = null;
    Clock mClock = null;
    Configuration conf = null;
    CapacityScheduler mCS = null;
    EventHandler<ContainerPreemptEvent> mDisp = null;
    ResourceCalculator rc = new DefaultResourceCalculator();
    final ApplicationAttemptId appA = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)0), (int)0);
    final ApplicationAttemptId appB = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)1), (int)0);
    final ApplicationAttemptId appC = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)2), (int)0);
    final ApplicationAttemptId appD = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)3), (int)0);
    final ApplicationAttemptId appE = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)4), (int)0);
    final ArgumentCaptor<ContainerPreemptEvent> evtCaptor = ArgumentCaptor.forClass(ContainerPreemptEvent.class);
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() {
        this.conf = new Configuration(false);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 10000L);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", 3000L);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 1.0f);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 1.0f);
        this.mClock = (Clock)Mockito.mock(Clock.class);
        this.mCS = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)this.mCS.getResourceCalculator()).thenReturn((Object)this.rc);
        this.mDisp = (EventHandler)Mockito.mock(EventHandler.class);
        this.rand = new Random();
        long seed = this.rand.nextLong();
        System.out.println(this.name.getMethodName() + " SEED: " + seed);
        this.rand.setSeed(seed);
        this.appAlloc = 0;
    }

    @Test
    public void testIgnore() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 0, 60, 40}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Mockito.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testProportionalPreemption() {
        int[][] qData = new int[][]{{100, 10, 40, 20, 30}, {100, 100, 100, 100, 100}, {100, 30, 60, 10, 0}, {45, 20, 5, 20, 0}, {0, 0, 0, 0, 0}, {3, 1, 1, 1, 0}, {-1, 1, 1, 1, 1}, {4, 0, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)16))).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testMaxCap() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 45, 100}, {100, 55, 45, 0}, {20, 10, 10, 0}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testPreemptCycle() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 0, 60, 40}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
    }

    @Test
    public void testExpireKill() {
        long killTime = 10000L;
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 0, 60, 40}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 10000L);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)0L);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)5000L);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)20))).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
        Mockito.when((Object)this.mClock.getTime()).thenReturn((Object)10001L);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)30))).handle((Event)this.evtCaptor.capture());
        List events = this.evtCaptor.getAllValues();
        for (ContainerPreemptEvent e : events.subList(20, 30)) {
            Assert.assertEquals((Object)this.appC, (Object)e.getAppId());
            Assert.assertEquals((Object)ContainerPreemptEventType.KILL_CONTAINER, (Object)e.getType());
        }
    }

    @Test
    public void testDeadzone() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 39, 43, 21}, {10, 10, 0, 0}, {0, 0, 0, 0}, {3, 1, 1, 1}, {-1, 1, 1, 1}, {3, 0, 0, 0}};
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.max_ignored_over_capacity", 0.1f);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Mockito.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testOverCapacityImbalance() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 55, 45, 0}, {20, 10, 10, 0}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)5))).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testNaturalTermination() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 55, 45, 0}, {20, 10, 10, 0}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 0.1f);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Mockito.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testObserveOnly() {
        int[][] qData = new int[][]{{100, 40, 40, 20}, {100, 100, 100, 100}, {100, 90, 10, 0}, {80, 10, 20, 50}, {0, 0, 0, 0}, {2, 1, 1, 0}, {-1, 1, 1, 0}, {3, 0, 0, 0}};
        this.conf.setBoolean("yarn.resourcemanager.monitor.capacity.preemption.observe_only", true);
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Mockito.isA(ContainerPreemptEvent.class));
    }

    @Test
    public void testHierarchical() {
        int[][] qData = new int[][]{{200, 100, 50, 50, 100, 10, 90}, {200, 200, 200, 200, 200, 200, 200}, {200, 110, 60, 50, 90, 90, 0}, {10, 0, 0, 0, 10, 0, 10}, {0, 0, 0, 0, 0, 0, 0}, {4, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1}, {2, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)10))).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testZeroGuar() {
        int[][] qData = new int[][]{{200, 100, 0, 99, 100, 10, 90}, {200, 200, 200, 200, 200, 200, 200}, {170, 80, 60, 20, 90, 90, 0}, {10, 0, 0, 0, 10, 0, 10}, {0, 0, 0, 0, 0, 0, 0}, {4, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1}, {2, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.never())).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
    }

    @Test
    public void testZeroGuarOverCap() {
        int[][] qData = new int[][]{{200, 100, 0, 99, 0, 100, 100}, {200, 200, 200, 200, 200, 200, 200}, {170, 170, 60, 20, 90, 0, 0}, {85, 50, 30, 10, 10, 20, 20}, {0, 0, 0, 0, 0, 0, 0}, {4, 3, 1, 1, 1, 1, 1}, {-1, -1, 1, 1, 1, -1, 1}, {2, 3, 0, 0, 0, 1, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)14))).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appC)));
    }

    @Test
    public void testHierarchicalLarge() {
        int[][] qData = new int[][]{{400, 200, 60, 140, 100, 70, 30, 100, 10, 90}, {400, 400, 400, 400, 400, 400, 400, 400, 400, 400}, {400, 210, 70, 140, 100, 50, 50, 90, 90, 0}, {10, 0, 0, 0, 0, 0, 0, 0, 0, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {6, 2, 1, 1, 2, 1, 1, 2, 1, 1}, {-1, -1, 1, 1, -1, 1, 1, -1, 1, 1}, {3, 2, 0, 0, 2, 0, 0, 2, 0, 0}};
        ProportionalCapacityPreemptionPolicy policy = this.buildPolicy((int[][])qData);
        policy.editSchedule();
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)9))).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appA)));
        ((EventHandler)Mockito.verify((Object)this.mDisp, (VerificationMode)Mockito.times((int)4))).handle((Event)Mockito.argThat((Matcher)new IsPreemptionRequestFor(this.appE)));
    }

    @Test
    public void testContainerOrdering() {
        ArrayList<RMContainer> containers = new ArrayList<RMContainer>();
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)3141592653L, (int)10), (int)0);
        RMContainer rm1 = this.mockContainer(appAttId, 5, (Resource)Mockito.mock(Resource.class), 3);
        RMContainer rm2 = this.mockContainer(appAttId, 3, (Resource)Mockito.mock(Resource.class), 3);
        RMContainer rm3 = this.mockContainer(appAttId, 2, (Resource)Mockito.mock(Resource.class), 2);
        RMContainer rm4 = this.mockContainer(appAttId, 1, (Resource)Mockito.mock(Resource.class), 2);
        RMContainer rm5 = this.mockContainer(appAttId, 4, (Resource)Mockito.mock(Resource.class), 1);
        containers.add(rm3);
        containers.add(rm2);
        containers.add(rm1);
        containers.add(rm5);
        containers.add(rm4);
        ProportionalCapacityPreemptionPolicy.sortContainers(containers);
        assert (((RMContainer)containers.get(0)).equals(rm1));
        assert (((RMContainer)containers.get(1)).equals(rm2));
        assert (((RMContainer)containers.get(2)).equals(rm3));
        assert (((RMContainer)containers.get(3)).equals(rm4));
        assert (((RMContainer)containers.get(4)).equals(rm5));
    }

    ProportionalCapacityPreemptionPolicy buildPolicy(int[][] qData) {
        ProportionalCapacityPreemptionPolicy policy = new ProportionalCapacityPreemptionPolicy(this.conf, this.mDisp, this.mCS, this.mClock);
        ParentQueue mRoot = this.buildMockRootQueue(this.rand, qData);
        Mockito.when((Object)this.mCS.getRootQueue()).thenReturn((Object)mRoot);
        Resource clusterResources = Resource.newInstance((int)TestProportionalCapacityPreemptionPolicy.leafAbsCapacities((int[])qData[0], (int[])qData[7]), (int)0);
        Mockito.when((Object)this.mCS.getClusterResources()).thenReturn((Object)clusterResources);
        return policy;
    }

    ParentQueue buildMockRootQueue(Random r, int[] ... queueData) {
        int[] abs = queueData[0];
        int[] maxCap = queueData[1];
        int[] used = queueData[2];
        int[] pending = queueData[3];
        int[] reserved = queueData[4];
        int[] apps = queueData[5];
        int[] gran = queueData[6];
        int[] queues = queueData[7];
        return this.mockNested(abs, maxCap, used, pending, reserved, apps, gran, queues);
    }

    ParentQueue mockNested(int[] abs, int[] maxCap, int[] used, int[] pending, int[] reserved, int[] apps, int[] gran, int[] queues) {
        float tot = TestProportionalCapacityPreemptionPolicy.leafAbsCapacities((int[])abs, (int[])queues);
        LinkedList pqs = new LinkedList();
        ParentQueue root = this.mockParentQueue(null, queues[0], pqs);
        Mockito.when((Object)root.getQueueName()).thenReturn((Object)"/");
        Mockito.when((Object)Float.valueOf(root.getAbsoluteUsedCapacity())).thenReturn((Object)Float.valueOf((float)used[0] / tot));
        Mockito.when((Object)Float.valueOf(root.getAbsoluteCapacity())).thenReturn((Object)Float.valueOf((float)abs[0] / tot));
        Mockito.when((Object)Float.valueOf(root.getAbsoluteMaximumCapacity())).thenReturn((Object)Float.valueOf((float)maxCap[0] / tot));
        for (int i = 1; i < queues.length; ++i) {
            ParentQueue p = (ParentQueue)pqs.removeLast();
            String queueName = "queue" + (char)(65 + i - 1);
            Object q = queues[i] > 0 ? this.mockParentQueue(p, queues[i], pqs) : this.mockLeafQueue(p, tot, i, abs, used, pending, reserved, apps, gran);
            Mockito.when((Object)q.getParent()).thenReturn((Object)p);
            Mockito.when((Object)q.getQueueName()).thenReturn((Object)queueName);
            Mockito.when((Object)Float.valueOf(q.getAbsoluteUsedCapacity())).thenReturn((Object)Float.valueOf((float)used[i] / tot));
            Mockito.when((Object)Float.valueOf(q.getAbsoluteCapacity())).thenReturn((Object)Float.valueOf((float)abs[i] / tot));
            Mockito.when((Object)Float.valueOf(q.getAbsoluteMaximumCapacity())).thenReturn((Object)Float.valueOf((float)maxCap[i] / tot));
        }
        assert (0 == pqs.size());
        return root;
    }

    ParentQueue mockParentQueue(ParentQueue p, int subqueues, Deque<ParentQueue> pqs) {
        ParentQueue pq = (ParentQueue)Mockito.mock(ParentQueue.class);
        ArrayList cqs = new ArrayList();
        Mockito.when((Object)pq.getChildQueues()).thenReturn(cqs);
        for (int i = 0; i < subqueues; ++i) {
            pqs.add(pq);
        }
        if (p != null) {
            p.getChildQueues().add(pq);
        }
        return pq;
    }

    LeafQueue mockLeafQueue(ParentQueue p, float tot, int i, int[] abs, int[] used, int[] pending, int[] reserved, int[] apps, int[] gran) {
        LeafQueue lq = (LeafQueue)Mockito.mock(LeafQueue.class);
        Mockito.when((Object)lq.getTotalResourcePending()).thenReturn((Object)Resource.newInstance((int)pending[i], (int)0));
        TreeSet<FiCaSchedulerApp> qApps = new TreeSet<FiCaSchedulerApp>((Comparator<FiCaSchedulerApp>)new /* Unavailable Anonymous Inner Class!! */);
        if (apps[i] != 0) {
            int aUsed = used[i] / apps[i];
            int aPending = pending[i] / apps[i];
            int aReserve = reserved[i] / apps[i];
            for (int a = 0; a < apps[i]; ++a) {
                qApps.add(this.mockApp(i, this.appAlloc, aUsed, aPending, aReserve, gran[i]));
                ++this.appAlloc;
            }
        }
        Mockito.when((Object)lq.getApplications()).thenReturn(qApps);
        p.getChildQueues().add(lq);
        return lq;
    }

    FiCaSchedulerApp mockApp(int qid, int id, int used, int pending, int reserved, int gran) {
        FiCaSchedulerApp app = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ApplicationId appId = ApplicationId.newInstance((long)3141592653L, (int)id);
        ApplicationAttemptId appAttId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
        Mockito.when((Object)app.getApplicationAttemptId()).thenReturn((Object)appAttId);
        int cAlloc = 0;
        Resource unit = Resource.newInstance((int)gran, (int)0);
        ArrayList<RMContainer> cReserved = new ArrayList<RMContainer>();
        for (int i = 0; i < reserved; i += gran) {
            cReserved.add(this.mockContainer(appAttId, cAlloc, unit, 1));
            ++cAlloc;
        }
        Mockito.when((Object)app.getReservedContainers()).thenReturn(cReserved);
        ArrayList<RMContainer> cLive = new ArrayList<RMContainer>();
        for (int i = 0; i < used; i += gran) {
            cLive.add(this.mockContainer(appAttId, cAlloc, unit, 1));
            ++cAlloc;
        }
        Mockito.when((Object)app.getLiveContainers()).thenReturn(cLive);
        return app;
    }

    RMContainer mockContainer(ApplicationAttemptId appAttId, int id, Resource r, int priority) {
        ContainerId cId = ContainerId.newInstance((ApplicationAttemptId)appAttId, (int)id);
        Container c = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)c.getResource()).thenReturn((Object)r);
        Mockito.when((Object)c.getPriority()).thenReturn((Object)Priority.create((int)priority));
        RMContainer mC = (RMContainer)Mockito.mock(RMContainer.class);
        Mockito.when((Object)mC.getContainerId()).thenReturn((Object)cId);
        Mockito.when((Object)mC.getContainer()).thenReturn((Object)c);
        return mC;
    }

    static int leafAbsCapacities(int[] abs, int[] subqueues) {
        int ret = 0;
        for (int i = 0; i < abs.length; ++i) {
            if (0 != subqueues[i]) continue;
            ret += abs[i];
        }
        return ret;
    }

    void printString(CSQueue nq, String indent) {
        if (nq instanceof ParentQueue) {
            System.out.println(indent + nq.getQueueName() + " cur:" + nq.getAbsoluteUsedCapacity() + " guar:" + nq.getAbsoluteCapacity());
            for (CSQueue q : ((ParentQueue)nq).getChildQueues()) {
                this.printString(q, indent + "  ");
            }
        } else {
            System.out.println(indent + nq.getQueueName() + " pen:" + ((LeafQueue)nq).getTotalResourcePending() + " cur:" + nq.getAbsoluteUsedCapacity() + " guar:" + nq.getAbsoluteCapacity());
            for (FiCaSchedulerApp a : ((LeafQueue)nq).getApplications()) {
                System.out.println(indent + "  " + a.getApplicationId());
            }
        }
    }
}

