/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.security.AccessControlException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.TestMoveApplication;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMoveApplication {
    private ResourceManager resourceManager = null;
    private static boolean failMove;

    @Before
    public void setUp() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoSchedulerWithMove.class, FifoSchedulerWithMove.class);
        conf.set("yarn.admin.acl", " ");
        conf.setBoolean("yarn.acl.enable", true);
        this.resourceManager = new ResourceManager();
        this.resourceManager.init((Configuration)conf);
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.resourceManager.getRMContext().getNMTokenSecretManager().rollMasterKey();
        this.resourceManager.start();
        failMove = false;
    }

    @After
    public void tearDown() {
        this.resourceManager.stop();
    }

    @Test
    public void testMoveRejectedByScheduler() throws Exception {
        failMove = true;
        Application application = new Application("user1", this.resourceManager);
        application.submit();
        RMApp app = (RMApp)this.resourceManager.rmContext.getRMApps().get(application.getApplicationId());
        while (app.getState() != RMAppState.ACCEPTED) {
            Thread.sleep(100L);
        }
        ClientRMService clientRMService = this.resourceManager.getClientRMService();
        try {
            clientRMService.moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)application.getApplicationId(), (String)"newqueue"));
            Assert.fail((String)"Should have hit exception");
        }
        catch (YarnException ex) {
            Assert.assertEquals((Object)"Move not supported", (Object)ex.getCause().getMessage());
        }
    }

    @Test(timeout=10000L)
    public void testMoveTooLate() throws Exception {
        Application application = new Application("user1", this.resourceManager);
        ApplicationId appId = application.getApplicationId();
        application.submit();
        ClientRMService clientRMService = this.resourceManager.getClientRMService();
        clientRMService.forceKillApplication(KillApplicationRequest.newInstance((ApplicationId)appId));
        RMApp rmApp = (RMApp)this.resourceManager.getRMContext().getRMApps().get(appId);
        while (rmApp.getState() != RMAppState.KILLED) {
            Thread.sleep(100L);
        }
        try {
            clientRMService.moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)appId, (String)"newqueue"));
            Assert.fail((String)"Should have hit exception");
        }
        catch (YarnException ex) {
            Assert.assertEquals(YarnException.class, ((Object)((Object)ex)).getClass());
            Assert.assertEquals((Object)"App in KILLED state cannot be moved.", (Object)ex.getMessage());
        }
    }

    @Test(timeout=5000L)
    public void testMoveSuccessful() throws Exception {
        Application application = new Application("user1", this.resourceManager);
        ApplicationId appId = application.getApplicationId();
        application.submit();
        RMApp app = (RMApp)this.resourceManager.rmContext.getRMApps().get(appId);
        while (app.getState() != RMAppState.ACCEPTED) {
            Thread.sleep(100L);
        }
        ClientRMService clientRMService = this.resourceManager.getClientRMService();
        clientRMService.moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)appId, (String)"newqueue"));
        RMApp rmApp = (RMApp)this.resourceManager.getRMContext().getRMApps().get(appId);
        Assert.assertEquals((Object)"newqueue", (Object)rmApp.getQueue());
    }

    @Test
    public void testMoveRejectedByPermissions() throws Exception {
        failMove = true;
        Application application = new Application("user1", this.resourceManager);
        application.submit();
        ClientRMService clientRMService = this.resourceManager.getClientRMService();
        try {
            UserGroupInformation.createRemoteUser((String)"otheruser").doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
            Assert.fail((String)"Should have hit exception");
        }
        catch (Exception ex) {
            Assert.assertEquals(AccessControlException.class, ex.getCause().getCause().getClass());
        }
    }

    static /* synthetic */ boolean access$000() {
        return failMove;
    }
}

