/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FifoPolicy
extends SchedulingPolicy {
    @VisibleForTesting
    public static final String NAME = "FIFO";
    private FifoComparator comparator = new FifoComparator();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Comparator<Schedulable> getComparator() {
        return this.comparator;
    }

    @Override
    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        if (schedulables.isEmpty()) {
            return;
        }
        Schedulable earliest = null;
        for (Schedulable schedulable : schedulables) {
            if (earliest != null && schedulable.getStartTime() >= earliest.getStartTime()) continue;
            earliest = schedulable;
        }
        earliest.setFairShare(Resources.clone((Resource)totalResources));
    }

    @Override
    public byte getApplicableDepth() {
        return 1;
    }

    static class FifoComparator
    implements Comparator<Schedulable>,
    Serializable {
        private static final long serialVersionUID = -5905036205491177060L;

        FifoComparator() {
        }

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            int res = s1.getPriority().compareTo(s2.getPriority());
            if (res == 0) {
                res = (int)Math.signum(s1.getStartTime() - s2.getStartTime());
            }
            if (res == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }
}

