/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.labelmanagement;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.java.dev.eval.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelExpressionHandlingHelper;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelStorage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;

public class LabelManager {
    private static final Log LOG = LogFactory.getLog(LabelManager.class);
    private long lastModified = 0L;
    public static final String NODE_LABELS_FILE = "node.labels.file";
    public static final String NODE_LABELS_MONITOR_INTERVAL = "node.labels.monitor.interval";
    public static final long DEFAULT_RELOAD_INTERVAL = 120000L;
    private FileSystem fs;
    private Path labelFile = null;
    private long labelManagerMonitorInterval = 120000L;
    private static LabelManager s_instance = new LabelManager();
    private Timer timer;
    private FileMonitor ttask;
    private volatile boolean isServiceEnabled;

    private LabelManager() {
    }

    public static LabelManager getInstance() {
        return s_instance;
    }

    void serviceInit(Configuration conf) throws Exception {
        this.fs = FileSystem.get((Configuration)conf);
        String labelFilePath = conf.get(NODE_LABELS_FILE, null);
        if (labelFilePath != null) {
            this.labelFile = new Path(labelFilePath);
            if (!this.fs.exists(this.labelFile)) {
                LOG.warn((Object)("Could not find node label file " + this.fs.makeQualified(this.labelFile) + ". Node labels will not be set."));
                this.labelFile = null;
            }
            this.labelManagerMonitorInterval = conf.getLong(NODE_LABELS_MONITOR_INTERVAL, 120000L);
        }
        LabelStorage.getInstance().storageInit(this.fs, this.labelFile);
    }

    void serviceStart() throws Exception {
        if (this.labelFile != null) {
            this.timer = new Timer();
            this.ttask = new FileMonitor(this, null);
            this.timer.scheduleAtFixedRate((TimerTask)this.ttask, 0L, this.labelManagerMonitorInterval);
            this.isServiceEnabled = true;
        }
    }

    void serviceStop() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public boolean isServiceEnabled() {
        return this.isServiceEnabled;
    }

    private boolean fileChanged() throws IOException {
        FileStatus labelFileStatus = null;
        if (!this.fs.exists(this.labelFile)) {
            return false;
        }
        labelFileStatus = this.fs.getFileStatus(this.labelFile);
        if (labelFileStatus != null && (this.lastModified == 0L || this.lastModified < labelFileStatus.getModificationTime())) {
            this.lastModified = labelFileStatus.getModificationTime();
            return true;
        }
        return false;
    }

    @InterfaceAudience.Private
    public void refreshLabels() throws IOException {
        LabelStorage.getInstance().loadAndApplyLabels();
    }

    public Set<String> getLabelsForNode(String node) {
        return LabelStorage.getInstance().getLabelsForNode(node);
    }

    public List<NodeToLabelsList> getLabelsForAllNodes() {
        return LabelStorage.getInstance().getLabelsForAllNodes();
    }

    public Expression getEffectiveLabelExpr(String appLabelStr) throws IOException {
        return LabelExpressionHandlingHelper.getEffectiveLabelExpr((String)appLabelStr);
    }

    public Expression constructAppLabel(Queue.QueueLabelPolicy policy, Expression appLabelExpression, Expression queueLabelExpression) {
        return LabelExpressionHandlingHelper.constructAppLabel((Queue.QueueLabelPolicy)policy, (Expression)appLabelExpression, (Expression)queueLabelExpression);
    }

    public LabelApplicabilityStatus isNodeApplicableForApp(String node, Expression finalAppLabelExp) throws IOException {
        return LabelExpressionHandlingHelper.isNodeApplicableForApp((String)node, (Expression)finalAppLabelExp);
    }

    public Path getLabelFile() {
        return this.labelFile;
    }

    static /* synthetic */ boolean access$100(LabelManager x0) throws IOException {
        return x0.fileChanged();
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }
}

