/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.hadoop.yarn.api.records.Resource;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class ResourceInfo {
  int memory;
  int vCores;
  double disks;
  
  public ResourceInfo() { 
  }

  public ResourceInfo(Resource res) {
    memory = res.getMemory();
    vCores = res.getVirtualCores();
    disks = res.getDisks();
  }

  public int getMemory() {
    return memory;
  }

  public int getvCores() {
    return vCores;
  }

  public double getDisks() {
    return disks;
  }

  @Override
  public String toString() {
    return "<memory:" + memory + ", vCores:" + vCores + ", disks:" + disks +">";
  }
}
