/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.DominantResourceFairnessPolicy;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DominantResourceFairnessPolicy
extends SchedulingPolicy {
    public static final String NAME = "DRF";
    private DominantResourceFairnessComparator comparator = new DominantResourceFairnessComparator();

    public String getName() {
        return NAME;
    }

    public byte getApplicableDepth() {
        return 7;
    }

    public Comparator<Schedulable> getComparator() {
        return this.comparator;
    }

    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        for (ResourceType type : ResourceType.values()) {
            ComputeFairShares.computeShares(schedulables, (Resource)totalResources, (ResourceType)type);
        }
    }

    public void initialize(Resource clusterCapacity) {
        this.comparator.setClusterCapacity(clusterCapacity);
    }
}

