/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.TestDelegationTokenRenewer;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDelegationTokenRenewer {
    private static final Log LOG = LogFactory.getLog(TestDelegationTokenRenewer.class);
    private static final Text KIND = new Text("TestDelegationTokenRenewer.Token");
    private static BlockingQueue<Event> eventQueue;
    private static volatile AtomicInteger counter;
    private static AsyncDispatcher dispatcher;
    private static Configuration conf;
    DelegationTokenRenewer delegationTokenRenewer;

    @BeforeClass
    public static void setUpClass() throws Exception {
        conf = new Configuration();
        URI uri = new URI("hdfs://localhost:0");
        System.out.println("scheme is : " + uri.getScheme());
        conf.setClass("fs." + uri.getScheme() + ".impl", MyFS.class, DistributedFileSystem.class);
        FileSystem.setDefaultUri((Configuration)conf, (URI)uri);
        LOG.info((Object)("filesystem uri = " + FileSystem.getDefaultUri((Configuration)conf).toString()));
    }

    @Before
    public void setUp() throws Exception {
        counter = new AtomicInteger(0);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        eventQueue = new LinkedBlockingQueue();
        dispatcher = new AsyncDispatcher(eventQueue);
        Renewer.access$200();
        this.delegationTokenRenewer = this.createNewDelegationTokenRenewer(conf, counter);
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService mockClientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockContext.getDelegationTokenRenewer()).thenReturn((Object)this.delegationTokenRenewer);
        Mockito.when((Object)mockContext.getDispatcher()).thenReturn((Object)dispatcher);
        Mockito.when((Object)mockContext.getClientRMService()).thenReturn((Object)mockClientRMService);
        InetSocketAddress sockAddr = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)mockClientRMService.getBindAddress()).thenReturn((Object)sockAddr);
        this.delegationTokenRenewer.setRMContext(mockContext);
        this.delegationTokenRenewer.init(conf);
        this.delegationTokenRenewer.start();
    }

    @After
    public void tearDown() {
        this.delegationTokenRenewer.stop();
    }

    static MyToken createTokens(Text renewer) throws IOException {
        Text user1 = new Text("user1");
        MyDelegationTokenSecretManager sm = new MyDelegationTokenSecretManager(86400000L, 86400000L, 604800000L, 3600000L, null);
        sm.startThreads();
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(user1, renewer, user1);
        MyToken token1 = new MyToken(dtId1, sm);
        token1.setService(new Text("localhost:0"));
        return token1;
    }

    @Test(timeout=60000L)
    public void testDTRenewal() throws Exception {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        LOG.info((Object)("dfs=" + Integer.valueOf(dfs.hashCode()) + ";conf=" + conf.hashCode()));
        MyToken token1 = dfs.getDelegationToken(new Text("user1"));
        MyToken token2 = dfs.getDelegationToken(new Text("user2"));
        MyToken token3 = dfs.getDelegationToken(new Text("user3"));
        Renewer.access$302((Token)token1);
        LOG.info((Object)("token=" + token1 + " should be renewed for 2 secs"));
        String nn1 = "hdfs://host1:0";
        String nn2 = "hdfs://host2:0";
        String nn3 = "hdfs://host3:0";
        Credentials ts = new Credentials();
        ts.addToken(new Text(nn1), (Token)token1);
        ts.addToken(new Text(nn2), (Token)token2);
        ts.addToken(new Text(nn3), (Token)token3);
        ApplicationId applicationId_0 = BuilderUtils.newApplicationId((long)0L, (int)0);
        this.delegationTokenRenewer.addApplicationAsync(applicationId_0, ts, true);
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        int numberOfExpectedRenewals = 4;
        int attempts = 10;
        while (attempts-- > 0) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (Renewer.access$400() != numberOfExpectedRenewals) continue;
        }
        LOG.info((Object)("dfs=" + dfs.hashCode() + ";Counter = " + Renewer.access$400() + ";t=" + Renewer.access$500()));
        Assert.assertEquals((String)"renew wasn't called as many times as expected(4):", (long)numberOfExpectedRenewals, (long)Renewer.access$400());
        Assert.assertEquals((String)"most recently renewed token mismatch", (Object)Renewer.access$500(), (Object)token1);
        ts = new Credentials();
        MyToken token4 = dfs.getDelegationToken(new Text("user4"));
        Renewer.access$302((Token)token4);
        LOG.info((Object)("token=" + token4 + " should be renewed for 2 secs"));
        String nn4 = "hdfs://host4:0";
        ts.addToken(new Text(nn4), (Token)token4);
        ApplicationId applicationId_1 = BuilderUtils.newApplicationId((long)0L, (int)1);
        this.delegationTokenRenewer.addApplicationAsync(applicationId_1, ts, true);
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        this.delegationTokenRenewer.applicationFinished(applicationId_1);
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        numberOfExpectedRenewals = Renewer.access$400();
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        LOG.info((Object)("Counter = " + Renewer.access$400() + ";t=" + Renewer.access$500()));
        Assert.assertEquals((String)"renew wasn't called as many times as expected", (long)numberOfExpectedRenewals, (long)Renewer.access$400());
        try {
            token4.renew(conf);
            Assert.fail((String)"Renewal of cancelled token should have failed");
        }
        catch (SecretManager.InvalidToken ite) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testAppRejectionWithCancelledDelegationToken() throws Exception {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        LOG.info((Object)("dfs=" + Integer.valueOf(dfs.hashCode()) + ";conf=" + conf.hashCode()));
        MyToken token = dfs.getDelegationToken(new Text("user1"));
        token.cancelToken();
        Credentials ts = new Credentials();
        ts.addToken(token.getKind(), (Token)token);
        ApplicationId appId = BuilderUtils.newApplicationId((long)0L, (int)0);
        this.delegationTokenRenewer.addApplicationAsync(appId, ts, true);
        int waitCnt = 20;
        while (waitCnt-- > 0) {
            if (!eventQueue.isEmpty()) {
                Event evt = (Event)eventQueue.take();
                if (evt.getType() != RMAppEventType.APP_REJECTED) continue;
                Assert.assertTrue((boolean)((RMAppEvent)evt).getApplicationId().equals((Object)appId));
                return;
            }
            Thread.sleep(500L);
        }
        Assert.fail((String)"App submission with a cancelled token should have failed");
    }

    @Test(timeout=60000L)
    public void testDTRenewalWithNoCancel() throws Exception {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        LOG.info((Object)("dfs=" + Integer.valueOf(dfs.hashCode()) + ";conf=" + conf.hashCode()));
        Credentials ts = new Credentials();
        MyToken token1 = dfs.getDelegationToken(new Text("user1"));
        Renewer.access$302((Token)token1);
        LOG.info((Object)("token=" + token1 + " should be renewed for 2 secs"));
        String nn1 = "hdfs://host1:0";
        ts.addToken(new Text(nn1), (Token)token1);
        ApplicationId applicationId_1 = BuilderUtils.newApplicationId((long)0L, (int)1);
        this.delegationTokenRenewer.addApplicationAsync(applicationId_1, ts, false);
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        this.delegationTokenRenewer.applicationFinished(applicationId_1);
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        int numberOfExpectedRenewals = Renewer.access$400();
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        LOG.info((Object)("Counter = " + Renewer.access$400() + ";t=" + Renewer.access$500()));
        Assert.assertEquals((String)"renew wasn't called as many times as expected", (long)numberOfExpectedRenewals, (long)Renewer.access$400());
        token1.renew(conf);
    }

    @Test(timeout=60000L)
    public void testDTKeepAlive1() throws Exception {
        Configuration lconf = new Configuration(conf);
        lconf.setBoolean("yarn.log-aggregation-enable", true);
        lconf.setLong("yarn.nm.liveness-monitor.expiry-interval-ms", 6000L);
        lconf.setLong("yarn.resourcemanager.delayed.delegation-token.removal-interval-ms", 1000L);
        DelegationTokenRenewer localDtr = this.createNewDelegationTokenRenewer(lconf, counter);
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService mockClientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockContext.getClientRMService()).thenReturn((Object)mockClientRMService);
        Mockito.when((Object)mockContext.getDelegationTokenRenewer()).thenReturn((Object)localDtr);
        Mockito.when((Object)mockContext.getDispatcher()).thenReturn((Object)dispatcher);
        InetSocketAddress sockAddr = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)mockClientRMService.getBindAddress()).thenReturn((Object)sockAddr);
        localDtr.setRMContext(mockContext);
        localDtr.init(lconf);
        localDtr.start();
        MyFS dfs = (MyFS)FileSystem.get((Configuration)lconf);
        LOG.info((Object)("dfs=" + Integer.valueOf(dfs.hashCode()) + ";conf=" + lconf.hashCode()));
        Credentials ts = new Credentials();
        MyToken token1 = dfs.getDelegationToken(new Text("user1"));
        String nn1 = "hdfs://host1:0";
        ts.addToken(new Text(nn1), (Token)token1);
        ApplicationId applicationId_0 = BuilderUtils.newApplicationId((long)0L, (int)0);
        localDtr.addApplicationAsync(applicationId_0, ts, true);
        this.waitForEventsToGetProcessed(localDtr);
        if (!eventQueue.isEmpty()) {
            Event evt = (Event)eventQueue.take();
            if (evt instanceof RMAppEvent) {
                Assert.assertEquals((Object)((RMAppEvent)evt).getType(), (Object)RMAppEventType.START);
            } else {
                Assert.fail((String)"RMAppEvent.START was expected!!");
            }
        }
        localDtr.applicationFinished(applicationId_0);
        this.waitForEventsToGetProcessed(localDtr);
        token1.renew(lconf);
        Thread.sleep(10000L);
        try {
            token1.renew(lconf);
            Assert.fail((String)"Renewal of cancelled token should have failed");
        }
        catch (SecretManager.InvalidToken ite) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testDTKeepAlive2() throws Exception {
        Configuration lconf = new Configuration(conf);
        lconf.setBoolean("yarn.log-aggregation-enable", true);
        lconf.setLong("yarn.nm.liveness-monitor.expiry-interval-ms", 6000L);
        lconf.setLong("yarn.resourcemanager.delayed.delegation-token.removal-interval-ms", 1000L);
        DelegationTokenRenewer localDtr = this.createNewDelegationTokenRenewer(conf, counter);
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService mockClientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockContext.getClientRMService()).thenReturn((Object)mockClientRMService);
        Mockito.when((Object)mockContext.getDelegationTokenRenewer()).thenReturn((Object)localDtr);
        Mockito.when((Object)mockContext.getDispatcher()).thenReturn((Object)dispatcher);
        InetSocketAddress sockAddr = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)mockClientRMService.getBindAddress()).thenReturn((Object)sockAddr);
        localDtr.setRMContext(mockContext);
        localDtr.init(lconf);
        localDtr.start();
        MyFS dfs = (MyFS)FileSystem.get((Configuration)lconf);
        LOG.info((Object)("dfs=" + Integer.valueOf(dfs.hashCode()) + ";conf=" + lconf.hashCode()));
        Credentials ts = new Credentials();
        MyToken token1 = dfs.getDelegationToken(new Text("user1"));
        String nn1 = "hdfs://host1:0";
        ts.addToken(new Text(nn1), (Token)token1);
        ApplicationId applicationId_0 = BuilderUtils.newApplicationId((long)0L, (int)0);
        localDtr.addApplicationAsync(applicationId_0, ts, true);
        localDtr.applicationFinished(applicationId_0);
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        localDtr.updateKeepAliveApplications(Collections.singletonList(applicationId_0));
        token1.renew(lconf);
        Thread.sleep(4500L);
        token1.renew(lconf);
        Thread.sleep(3000L);
        try {
            token1.renew(lconf);
            Assert.fail((String)"Renewal of cancelled token should have failed");
        }
        catch (SecretManager.InvalidToken ite) {
            // empty catch block
        }
    }

    private DelegationTokenRenewer createNewDelegationTokenRenewer(Configuration conf, AtomicInteger counter) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void waitForEventsToGetProcessed(DelegationTokenRenewer dtr) throws InterruptedException {
        int wait = 40;
        while (wait-- > 0 && counter.get() > 0) {
            Thread.sleep(200L);
        }
    }

    @Test(timeout=20000L)
    public void testConcurrentAddApplication() throws IOException, InterruptedException, BrokenBarrierException {
        CyclicBarrier startBarrier = new CyclicBarrier(2);
        CyclicBarrier endBarrier = new CyclicBarrier(2);
        Credentials creds1 = new Credentials();
        Token token1 = (Token)Mockito.mock(Token.class);
        creds1.addToken(new Text("token"), token1);
        ((Token)Mockito.doReturn((Object)true).when((Object)token1)).isManaged();
        ((Token)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)token1)).renew((Configuration)Matchers.any(Configuration.class));
        Credentials creds2 = new Credentials();
        Token token2 = (Token)Mockito.mock(Token.class);
        creds2.addToken(new Text("token"), token2);
        ((Token)Mockito.doReturn((Object)true).when((Object)token2)).isManaged();
        ((Token)Mockito.doReturn((Object)Long.MAX_VALUE).when((Object)token2)).renew((Configuration)Matchers.any(Configuration.class));
        DelegationTokenRenewer dtr = this.createNewDelegationTokenRenewer(conf, counter);
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService mockClientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockContext.getClientRMService()).thenReturn((Object)mockClientRMService);
        InetSocketAddress sockAddr = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)mockClientRMService.getBindAddress()).thenReturn((Object)sockAddr);
        dtr.setRMContext(mockContext);
        Mockito.when((Object)mockContext.getDelegationTokenRenewer()).thenReturn((Object)dtr);
        dtr.init(conf);
        dtr.start();
        3 submitThread = new /* Unavailable Anonymous Inner Class!! */;
        submitThread.start();
        startBarrier.await();
        dtr.addApplicationAsync((ApplicationId)Mockito.mock(ApplicationId.class), creds2, false);
        endBarrier.await();
        submitThread.join();
    }

    @Test(timeout=20000L)
    public void testAppSubmissionWithInvalidDelegationToken() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        MockRM rm = new MockRM(conf);
        ByteBuffer tokens = ByteBuffer.wrap("BOGUS".getBytes());
        ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance(new HashMap(), new HashMap(), new ArrayList(), new HashMap(), (ByteBuffer)tokens, new HashMap());
        ApplicationSubmissionContext appSubContext = ApplicationSubmissionContext.newInstance((ApplicationId)ApplicationId.newInstance((long)1234121L, (int)0), (String)"BOGUS", (String)"default", (Priority)Priority.UNDEFINED, (ContainerLaunchContext)amContainer, (boolean)false, (boolean)true, (int)1, (Resource)Resource.newInstance((int)1024, (int)1), (String)"BOGUS");
        SubmitApplicationRequest request = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)appSubContext);
        try {
            rm.getClientRMService().submitApplication(request);
            Assert.fail((String)"Error was excepted.");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Bad header found in token storage"));
        }
    }

    static /* synthetic */ Text access$000() {
        return KIND;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }
}

