/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestQueuePlacementPolicy {
    private static final Configuration conf = new Configuration();
    private static final Set<String> configuredQueues = Sets.newHashSet((Object[])new String[]{"root.someuser"});

    @BeforeClass
    public static void setup() {
        conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
    }

    @Test
    public void testSpecifiedUserPolicy() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='user' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.specifiedq", (Object)policy.assignAppToQueue("specifiedq", "someuser"));
        Assert.assertEquals((Object)"root.someuser", (Object)policy.assignAppToQueue("default", "someuser"));
        Assert.assertEquals((Object)"root.otheruser", (Object)policy.assignAppToQueue("default", "otheruser"));
    }

    @Test
    public void testNoCreate() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='user' create=\"false\" />");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.specifiedq", (Object)policy.assignAppToQueue("specifiedq", "someuser"));
        Assert.assertEquals((Object)"root.someuser", (Object)policy.assignAppToQueue("default", "someuser"));
        Assert.assertEquals((Object)"root.specifiedq", (Object)policy.assignAppToQueue("specifiedq", "otheruser"));
        Assert.assertEquals((Object)"root.default", (Object)policy.assignAppToQueue("default", "otheruser"));
    }

    @Test
    public void testSpecifiedThenReject() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='reject' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.specifiedq", (Object)policy.assignAppToQueue("specifiedq", "someuser"));
        Assert.assertEquals(null, (Object)policy.assignAppToQueue("default", "someuser"));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOmittedTerminalRule() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='user' create=\"false\" />");
        sb.append("</queuePlacementPolicy>");
        this.parse(sb.toString());
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testTerminalRuleInMiddle() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='default' />");
        sb.append("  <rule name='user' />");
        sb.append("</queuePlacementPolicy>");
        this.parse(sb.toString());
    }

    private QueuePlacementPolicy parse(String str) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(IOUtils.toInputStream((String)str));
        Element root = doc.getDocumentElement();
        return QueuePlacementPolicy.fromXml((Element)root, (Set)configuredQueues, (Configuration)conf);
    }
}

