/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.TestClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestClientRMService {
    private static final Log LOG = LogFactory.getLog(TestClientRMService.class);
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private String appType = "MockApp";
    private static RMDelegationTokenSecretManager dtsm;
    private static final String QUEUE_1 = "Q-1";
    private static final String QUEUE_2 = "Q-2";
    private static final UserGroupInformation owner;
    private static final UserGroupInformation other;

    @BeforeClass
    public static void setupSecretManager() throws IOException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)new NullRMStateStore());
        dtsm = new RMDelegationTokenSecretManager(60000L, 60000L, 60000L, 60000L, rmContext);
        dtsm.startThreads();
    }

    @AfterClass
    public static void teardownSecretManager() {
        if (dtsm != null) {
            dtsm.stopThreads();
        }
    }

    @Test
    public void testGetClusterNodes() throws Exception {
        1 rm = new /* Unavailable Anonymous Inner Class!! */;
        rm.start();
        MockNM node = rm.registerNode("host1:1234", 1024);
        rm.sendNodeStarted(node);
        node.nodeHeartbeat(true);
        MockNM lostNode = rm.registerNode("host2:1235", 1024);
        rm.sendNodeStarted(lostNode);
        lostNode.nodeHeartbeat(true);
        rm.NMwaitForState(lostNode.getNodeId(), NodeState.RUNNING);
        rm.sendNodeLost(lostNode);
        Configuration conf = new Configuration();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress rmAddress = rm.getClientRMService().getBindAddress();
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        ApplicationClientProtocol client = (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, rmAddress, conf);
        GetClusterNodesRequest request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.RUNNING));
        List nodeReports = client.getClusterNodes(request).getNodeReports();
        junit.framework.Assert.assertEquals((int)1, (int)nodeReports.size());
        junit.framework.Assert.assertNotSame((String)"Node is expected to be healthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        node.nodeHeartbeat(false);
        nodeReports = client.getClusterNodes(request).getNodeReports();
        junit.framework.Assert.assertEquals((String)"Unhealthy nodes should not show up by default", (int)0, (int)nodeReports.size());
        request = GetClusterNodesRequest.newInstance(EnumSet.of(NodeState.UNHEALTHY));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        junit.framework.Assert.assertEquals((int)1, (int)nodeReports.size());
        junit.framework.Assert.assertEquals((String)"Node is expected to be unhealthy!", (Object)NodeState.UNHEALTHY, (Object)((NodeReport)nodeReports.get(0)).getNodeState());
        rm.registerNode("host3:1236", 1024);
        request = GetClusterNodesRequest.newInstance(EnumSet.allOf(NodeState.class));
        nodeReports = client.getClusterNodes(request).getNodeReports();
        junit.framework.Assert.assertEquals((int)3, (int)nodeReports.size());
    }

    @Test
    public void testGetApplicationReport() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationReportRequest request = (GetApplicationReportRequest)recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(ApplicationId.newInstance((long)0L, (int)0));
        try {
            rmService.getApplicationReport(request);
            junit.framework.Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            junit.framework.Assert.assertEquals((String)ex.getMessage(), (String)("Application with id '" + request.getApplicationId() + "' doesn't exist in RM."));
        }
    }

    @Test
    public void testGetApplicationAttemptReport() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationAttemptReportRequest request = (GetApplicationAttemptReportRequest)recordFactory.newRecordInstance(GetApplicationAttemptReportRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        request.setApplicationAttemptId(attemptId);
        try {
            GetApplicationAttemptReportResponse response = rmService.getApplicationAttemptReport(request);
            junit.framework.Assert.assertEquals((Object)attemptId, (Object)response.getApplicationAttemptReport().getApplicationAttemptId());
        }
        catch (ApplicationNotFoundException ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetApplicationAttempts() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetApplicationAttemptsRequest request = (GetApplicationAttemptsRequest)recordFactory.newRecordInstance(GetApplicationAttemptsRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        request.setApplicationId(ApplicationId.newInstance((long)123456L, (int)1));
        try {
            GetApplicationAttemptsResponse response = rmService.getApplicationAttempts(request);
            junit.framework.Assert.assertEquals((int)1, (int)response.getApplicationAttemptList().size());
            junit.framework.Assert.assertEquals((Object)attemptId, (Object)((ApplicationAttemptReport)response.getApplicationAttemptList().get(0)).getApplicationAttemptId());
        }
        catch (ApplicationNotFoundException ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetContainerReport() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetContainerReportRequest request = (GetContainerReportRequest)recordFactory.newRecordInstance(GetContainerReportRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)attemptId, (int)1);
        request.setContainerId(containerId);
        try {
            GetContainerReportResponse response = rmService.getContainerReport(request);
            junit.framework.Assert.assertEquals((Object)containerId, (Object)response.getContainerReport().getContainerId());
        }
        catch (ApplicationNotFoundException ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetContainers() throws YarnException, IOException {
        ClientRMService rmService = this.createRMService();
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        GetContainersRequest request = (GetContainersRequest)recordFactory.newRecordInstance(GetContainersRequest.class);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)attemptId, (int)1);
        request.setApplicationAttemptId(attemptId);
        try {
            GetContainersResponse response = rmService.getContainers(request);
            junit.framework.Assert.assertEquals((Object)containerId, (Object)((ContainerReport)response.getContainerList().get(0)).getContainerId());
        }
        catch (ApplicationNotFoundException ex) {
            junit.framework.Assert.fail((String)ex.getMessage());
        }
    }

    public ClientRMService createRMService() throws IOException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ConcurrentHashMap apps = this.getRMApps(rmContext, yarnScheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn((Object)apps);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        return new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
    }

    @Test
    public void testForceKillNonExistingApplication() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        KillApplicationRequest request = KillApplicationRequest.newInstance((ApplicationId)applicationId);
        try {
            rmService.forceKillApplication(request);
            junit.framework.Assert.fail();
        }
        catch (ApplicationNotFoundException ex) {
            junit.framework.Assert.assertEquals((String)ex.getMessage(), (String)("Trying to kill an absent application " + request.getApplicationId()));
        }
    }

    @Test
    public void testForceKillApplication() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        MockRM rm = new MockRM();
        rm.init((Configuration)conf);
        rm.start();
        ClientRMService rmService = rm.getClientRMService();
        GetApplicationsRequest getRequest = GetApplicationsRequest.newInstance(EnumSet.of(YarnApplicationState.KILLED));
        RMApp app1 = rm.submitApp(1024);
        RMApp app2 = rm.submitApp(1024, true);
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)0L, (long)rmService.getApplications(getRequest).getApplicationList().size());
        KillApplicationRequest killRequest1 = KillApplicationRequest.newInstance((ApplicationId)app1.getApplicationId());
        KillApplicationRequest killRequest2 = KillApplicationRequest.newInstance((ApplicationId)app2.getApplicationId());
        int killAttemptCount = 0;
        for (int i = 0; i < 100; ++i) {
            KillApplicationResponse killResponse1 = rmService.forceKillApplication(killRequest1);
            ++killAttemptCount;
            if (killResponse1.getIsKillCompleted()) break;
            Thread.sleep(10L);
        }
        Assert.assertTrue((String)"Kill attempt count should be greater than 1 for managed AMs", (killAttemptCount > 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)1L, (long)rmService.getApplications(getRequest).getApplicationList().size());
        KillApplicationResponse killResponse2 = rmService.forceKillApplication(killRequest2);
        Assert.assertTrue((String)"Killing UnmanagedAM should falsely acknowledge true", (boolean)killResponse2.getIsKillCompleted());
        for (int i = 0; i < 100 && 2 != rmService.getApplications(getRequest).getApplicationList().size(); ++i) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((String)"Incorrect number of apps in the RM", (long)2L, (long)rmService.getApplications(getRequest).getApplicationList().size());
    }

    @Test(expected=ApplicationNotFoundException.class)
    public void testMoveAbsentApplication() throws YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, null);
        ApplicationId applicationId = BuilderUtils.newApplicationId((long)System.currentTimeMillis(), (int)0);
        MoveApplicationAcrossQueuesRequest request = MoveApplicationAcrossQueuesRequest.newInstance((ApplicationId)applicationId, (String)"newqueue");
        rmService.moveApplicationAcrossQueues(request);
    }

    @Test
    public void testGetQueueInfo() throws Exception {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, null, null, null, null);
        GetQueueInfoRequest request = (GetQueueInfoRequest)this.recordFactory.newRecordInstance(GetQueueInfoRequest.class);
        request.setQueueName("testqueue");
        request.setIncludeApplications(true);
        GetQueueInfoResponse queueInfo = rmService.getQueueInfo(request);
        List applications = queueInfo.getQueueInfo().getApplications();
        junit.framework.Assert.assertEquals((int)2, (int)applications.size());
        request.setQueueName("nonexistentqueue");
        request.setIncludeApplications(true);
        queueInfo = rmService.getQueueInfo(request);
    }

    @Test
    public void testTokenRenewalByOwner() throws Exception {
        owner.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void testTokenRenewalWrongUser() throws Exception {
        try {
            owner.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            return;
        }
        junit.framework.Assert.fail((String)"renew should have failed");
    }

    @Test
    public void testTokenRenewalByLoginUser() throws Exception {
        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void checkTokenRenewal(UserGroupInformation owner, UserGroupInformation renewer) throws IOException, YarnException {
        RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(new Text(owner.getUserName()), new Text(renewer.getUserName()), null);
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)dtsm);
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        RenewDelegationTokenRequest request = (RenewDelegationTokenRequest)Records.newRecord(RenewDelegationTokenRequest.class);
        request.setDelegationToken(dToken);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        rmService.renewDelegationToken(request);
    }

    @Test(timeout=30000L)
    public void testAppSubmit() throws Exception {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        ApplicationId appId1 = TestClientRMService.getApplicationId((int)100);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId1)).thenReturn((Object)true);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        try {
            rmService.submitApplication(submitRequest1);
        }
        catch (YarnException e) {
            junit.framework.Assert.fail((String)"Exception is not expected.");
        }
        RMApp app1 = (RMApp)rmContext.getRMApps().get(appId1);
        junit.framework.Assert.assertNotNull((String)"app doesn't exist", (Object)app1);
        junit.framework.Assert.assertEquals((String)"app name doesn't match", (String)"N/A", (String)app1.getName());
        junit.framework.Assert.assertEquals((String)"app queue doesn't match", (String)"default", (String)app1.getQueue());
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        ApplicationId appId2 = TestClientRMService.getApplicationId((int)101);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, name, queue);
        submitRequest2.getApplicationSubmissionContext().setApplicationType("matchType");
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            junit.framework.Assert.fail((String)"Exception is not expected.");
        }
        RMApp app2 = (RMApp)rmContext.getRMApps().get(appId2);
        junit.framework.Assert.assertNotNull((String)"app doesn't exist", (Object)app2);
        junit.framework.Assert.assertEquals((String)"app name doesn't match", (String)name, (String)app2.getName());
        junit.framework.Assert.assertEquals((String)"app queue doesn't match", (String)queue, (String)app2.getQueue());
        try {
            rmService.submitApplication(submitRequest2);
        }
        catch (YarnException e) {
            junit.framework.Assert.fail((String)"Exception is not expected.");
        }
        GetApplicationsRequest getAllAppsRequest = GetApplicationsRequest.newInstance(new HashSet());
        GetApplicationsResponse getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        junit.framework.Assert.assertEquals((int)5, (int)getAllApplicationsResponse.getApplicationList().size());
        HashSet<String> appTypes = new HashSet<String>();
        appTypes.add("matchType");
        getAllAppsRequest = GetApplicationsRequest.newInstance(appTypes);
        getAllApplicationsResponse = rmService.getApplications(getAllAppsRequest);
        junit.framework.Assert.assertEquals((int)1, (int)getAllApplicationsResponse.getApplicationList().size());
        junit.framework.Assert.assertEquals((Object)appId2, (Object)((ApplicationReport)getAllApplicationsResponse.getApplicationList().get(0)).getApplicationId());
    }

    @Test
    public void testGetApplications() throws IOException, YarnException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        ApplicationACLsManager mockAclsManager = (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class);
        QueueACLsManager mockQueueACLsManager = (QueueACLsManager)Mockito.mock(QueueACLsManager.class);
        Mockito.when((Object)mockQueueACLsManager.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (QueueACL)Matchers.any(QueueACL.class), Matchers.anyString())).thenReturn((Object)true);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, mockAclsManager, mockQueueACLsManager, null);
        String[] queues = new String[]{"Q-1", "Q-2"};
        String[] appNames = new String[]{MockApps.newAppName(), MockApps.newAppName(), MockApps.newAppName()};
        ApplicationId[] appIds = new ApplicationId[]{TestClientRMService.getApplicationId((int)101), TestClientRMService.getApplicationId((int)102), TestClientRMService.getApplicationId((int)103)};
        List<String> tags = Arrays.asList("Tag1", "Tag2", "Tag3");
        for (int i = 0; i < appIds.length; ++i) {
            ApplicationId appId = appIds[i];
            Mockito.when((Object)mockAclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, null, appId)).thenReturn((Object)true);
            SubmitApplicationRequest submitRequest = this.mockSubmitAppRequest(appId, appNames[i], queues[i % queues.length], new HashSet<String>(tags.subList(0, i + 1)));
            rmService.submitApplication(submitRequest);
        }
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        Assert.assertEquals((String)"Incorrect total number of apps", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        request.setLimit(1L);
        Assert.assertEquals((String)"Failed to limit applications", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> queueSet = new HashSet<String>();
        request.setQueues(queueSet);
        queueSet.add(queues[0]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)2L, (long)rmService.getApplications(request, false).getApplicationList().size());
        queueSet.add(queues[1]);
        Assert.assertEquals((String)"Incorrect number of applications in queue", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance();
        HashSet<String> userSet = new HashSet<String>();
        request.setUsers(userSet);
        userSet.add("random-user-name");
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)0L, (long)rmService.getApplications(request).getApplicationList().size());
        userSet.add(UserGroupInformation.getCurrentUser().getShortUserName());
        Assert.assertEquals((String)"Incorrect number of applications for user", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.ALL, null, null, null, null, null, null, null, null);
        HashSet tagSet = new HashSet();
        request.setApplicationTags(tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(0)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(1)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)2L, (long)rmService.getApplications(request).getApplicationList().size());
        tagSet = Sets.newHashSet((Object[])new String[]{tags.get(2)});
        request.setApplicationTags((Set)tagSet);
        Assert.assertEquals((String)"Incorrect number of matching tags", (long)1L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.VIEWABLE);
        Assert.assertEquals((String)"Incorrect number of applications for the scope", (long)6L, (long)rmService.getApplications(request).getApplicationList().size());
        request = GetApplicationsRequest.newInstance((ApplicationsRequestScope)ApplicationsRequestScope.OWN);
        Assert.assertEquals((String)"Incorrect number of applications for the scope", (long)3L, (long)rmService.getApplications(request).getApplicationList().size());
    }

    @Test(timeout=4000L)
    public void testConcurrentAppSubmit() throws IOException, InterruptedException, BrokenBarrierException, YarnException {
        YarnScheduler yarnScheduler = TestClientRMService.mockYarnScheduler();
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.mockRMContext(yarnScheduler, rmContext);
        RMStateStore stateStore = (RMStateStore)Mockito.mock(RMStateStore.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)stateStore);
        RMAppManager appManager = new RMAppManager(rmContext, yarnScheduler, null, (ApplicationACLsManager)Mockito.mock(ApplicationACLsManager.class), new Configuration());
        ApplicationId appId1 = TestClientRMService.getApplicationId((int)100);
        ApplicationId appId2 = TestClientRMService.getApplicationId((int)101);
        SubmitApplicationRequest submitRequest1 = this.mockSubmitAppRequest(appId1, null, null);
        SubmitApplicationRequest submitRequest2 = this.mockSubmitAppRequest(appId2, null, null);
        CyclicBarrier startBarrier = new CyclicBarrier(2);
        CyclicBarrier endBarrier = new CyclicBarrier(2);
        8 eventHandler = new /* Unavailable Anonymous Inner Class!! */;
        Mockito.when((Object)rmContext.getDispatcher().getEventHandler()).thenReturn((Object)eventHandler);
        ClientRMService rmService = new ClientRMService(rmContext, yarnScheduler, appManager, null, null, null);
        9 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
        startBarrier.await();
        rmService.submitApplication(submitRequest2);
        endBarrier.await();
        t.join();
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue) {
        return this.mockSubmitAppRequest(appId, name, queue, null);
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue, Set<String> tags) {
        return this.mockSubmitAppRequest(appId, name, queue, tags, false);
    }

    private SubmitApplicationRequest mockSubmitAppRequest(ApplicationId appId, String name, String queue, Set<String> tags, boolean unmanaged) {
        ContainerLaunchContext amContainerSpec = (ContainerLaunchContext)Mockito.mock(ContainerLaunchContext.class);
        Resource resource = Resources.createResource((int)1024);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)this.recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        submissionContext.setAMContainerSpec(amContainerSpec);
        submissionContext.setApplicationName(name);
        submissionContext.setQueue(queue);
        submissionContext.setApplicationId(appId);
        submissionContext.setResource(resource);
        submissionContext.setApplicationType(this.appType);
        submissionContext.setApplicationTags(tags);
        submissionContext.setUnmanagedAM(unmanaged);
        SubmitApplicationRequest submitRequest = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        submitRequest.setApplicationSubmissionContext(submissionContext);
        return submitRequest;
    }

    private void mockRMContext(YarnScheduler yarnScheduler, RMContext rmContext) throws IOException {
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)dispatcher);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)dispatcher.getEventHandler()).thenReturn((Object)eventHandler);
        QueueInfo queInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queInfo.setQueueName("testqueue");
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"testqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)queInfo);
        Mockito.when((Object)yarnScheduler.getQueueInfo((String)Matchers.eq((Object)"nonexistentqueue"), Matchers.anyBoolean(), Matchers.anyBoolean())).thenThrow(new Throwable[]{new IOException("queue does not exist")});
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        Mockito.when((Object)rmContext.getRMApplicationHistoryWriter()).thenReturn((Object)writer);
        ConcurrentHashMap apps = this.getRMApps(rmContext, yarnScheduler);
        Mockito.when((Object)rmContext.getRMApps()).thenReturn((Object)apps);
        Mockito.when((Object)yarnScheduler.getAppsInQueue((String)Matchers.eq((Object)"testqueue"))).thenReturn((Object)this.getSchedulerApps((Map)apps));
        ResourceScheduler rs = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)rs);
    }

    private ConcurrentHashMap<ApplicationId, RMApp> getRMApps(RMContext rmContext, YarnScheduler yarnScheduler) {
        ConcurrentHashMap<ApplicationId, RMApp> apps = new ConcurrentHashMap<ApplicationId, RMApp>();
        ApplicationId applicationId1 = TestClientRMService.getApplicationId((int)1);
        ApplicationId applicationId2 = TestClientRMService.getApplicationId((int)2);
        ApplicationId applicationId3 = TestClientRMService.getApplicationId((int)3);
        YarnConfiguration config = new YarnConfiguration();
        apps.put(applicationId1, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId1, config, "testqueue"));
        apps.put(applicationId2, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId2, config, "a"));
        apps.put(applicationId3, (RMApp)this.getRMApp(rmContext, yarnScheduler, applicationId3, config, "testqueue"));
        return apps;
    }

    private List<ApplicationAttemptId> getSchedulerApps(Map<ApplicationId, RMApp> apps) {
        ArrayList<ApplicationAttemptId> schedApps = new ArrayList<ApplicationAttemptId>();
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId((int)1), (int)0));
        schedApps.add(ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId((int)3), (int)0));
        return schedApps;
    }

    private static ApplicationId getApplicationId(int id) {
        return ApplicationId.newInstance((long)123456L, (int)id);
    }

    private static ApplicationAttemptId getApplicationAttemptId(int id) {
        return ApplicationAttemptId.newInstance((ApplicationId)TestClientRMService.getApplicationId((int)id), (int)1);
    }

    private RMAppImpl getRMApp(RMContext rmContext, YarnScheduler yarnScheduler, ApplicationId applicationId3, YarnConfiguration config, String queueName) {
        ApplicationSubmissionContext asContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)asContext.getMaxAppAttempts()).thenReturn((Object)1);
        RMAppImpl app = (RMAppImpl)Mockito.spy((Object)new RMAppImpl(applicationId3, rmContext, (Configuration)config, null, null, queueName, asContext, yarnScheduler, null, System.currentTimeMillis(), "YARN", null));
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)123456L, (int)1), (int)1);
        RMAppAttemptImpl rmAppAttemptImpl = (RMAppAttemptImpl)Mockito.spy((Object)new RMAppAttemptImpl(attemptId, rmContext, yarnScheduler, null, asContext, (Configuration)config, false));
        Container container = Container.newInstance((ContainerId)ContainerId.newInstance((ApplicationAttemptId)attemptId, (int)1), null, (String)"", null, null, null);
        RMContainerImpl containerimpl = (RMContainerImpl)Mockito.spy((Object)new RMContainerImpl(container, attemptId, null, "", rmContext));
        HashMap<ApplicationAttemptId, RMAppAttemptImpl> attempts = new HashMap<ApplicationAttemptId, RMAppAttemptImpl>();
        attempts.put(attemptId, rmAppAttemptImpl);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)rmAppAttemptImpl);
        Mockito.when((Object)app.getAppAttempts()).thenReturn(attempts);
        Mockito.when((Object)rmAppAttemptImpl.getMasterContainer()).thenReturn((Object)container);
        ResourceScheduler rs = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)rmContext.getScheduler()).thenReturn((Object)rs);
        Mockito.when((Object)rmContext.getScheduler().getRMContainer((ContainerId)Matchers.any(ContainerId.class))).thenReturn((Object)containerimpl);
        SchedulerAppReport sAppReport = (SchedulerAppReport)Mockito.mock(SchedulerAppReport.class);
        Mockito.when((Object)rmContext.getScheduler().getSchedulerAppInfo((ApplicationAttemptId)Matchers.any(ApplicationAttemptId.class))).thenReturn((Object)sAppReport);
        ArrayList<RMContainerImpl> rmContainers = new ArrayList<RMContainerImpl>();
        rmContainers.add(containerimpl);
        Mockito.when((Object)rmContext.getScheduler().getSchedulerAppInfo(attemptId).getLiveContainers()).thenReturn(rmContainers);
        ContainerStatus cs = (ContainerStatus)Mockito.mock(ContainerStatus.class);
        Mockito.when((Object)containerimpl.getFinishedStatus()).thenReturn((Object)cs);
        Mockito.when((Object)containerimpl.getDiagnosticsInfo()).thenReturn((Object)"N/A");
        Mockito.when((Object)containerimpl.getContainerExitStatus()).thenReturn((Object)0);
        Mockito.when((Object)containerimpl.getContainerState()).thenReturn((Object)ContainerState.COMPLETE);
        return app;
    }

    private static YarnScheduler mockYarnScheduler() {
        YarnScheduler yarnScheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        Mockito.when((Object)yarnScheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)yarnScheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        Mockito.when((Object)yarnScheduler.getAppsInQueue("Q-1")).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId((int)101), TestClientRMService.getApplicationAttemptId((int)102)));
        Mockito.when((Object)yarnScheduler.getAppsInQueue("Q-2")).thenReturn(Arrays.asList(TestClientRMService.getApplicationAttemptId((int)103)));
        return yarnScheduler;
    }

    static /* synthetic */ UserGroupInformation access$000() {
        return owner;
    }

    static /* synthetic */ void access$100(TestClientRMService x0, UserGroupInformation x1, UserGroupInformation x2) throws IOException, YarnException {
        x0.checkTokenRenewal(x1, x2);
    }

    static /* synthetic */ UserGroupInformation access$200() {
        return other;
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }

    static {
        owner = UserGroupInformation.createRemoteUser((String)"owner");
        other = UserGroupInformation.createRemoteUser((String)"other");
    }
}

