/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;

public class RMServerUtils {
    public static List<RMNode> queryRMNodes(RMContext context, EnumSet<NodeState> acceptedStates) {
        ArrayList<RMNode> results = new ArrayList<RMNode>();
        if (acceptedStates.contains(NodeState.NEW) || acceptedStates.contains(NodeState.RUNNING) || acceptedStates.contains(NodeState.UNHEALTHY)) {
            for (RMNode rmNode : context.getRMNodes().values()) {
                if (!acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        if (acceptedStates.contains(NodeState.DECOMMISSIONED) || acceptedStates.contains(NodeState.LOST) || acceptedStates.contains(NodeState.REBOOTED)) {
            for (RMNode rmNode : context.getInactiveRMNodes().values()) {
                if (!acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        return results;
    }

    public static void validateResourceRequests(List<ResourceRequest> ask, Resource maximumResource) throws InvalidResourceRequestException {
        for (ResourceRequest resReq : ask) {
            SchedulerUtils.validateResourceRequest((ResourceRequest)resReq, (Resource)maximumResource);
        }
    }

    public static void validateBlacklistRequest(ResourceBlacklistRequest blacklistRequest) throws InvalidResourceBlacklistRequestException {
        List plus;
        if (blacklistRequest != null && (plus = blacklistRequest.getBlacklistAdditions()) != null && plus.contains("*")) {
            throw new InvalidResourceBlacklistRequestException("Cannot add * to the blacklist!");
        }
    }

    public static void validateContainerReleaseRequest(List<ContainerId> containerReleaseList, ApplicationAttemptId appAttemptId) throws InvalidContainerReleaseException {
        for (ContainerId cId : containerReleaseList) {
            if (appAttemptId.equals((Object)cId.getApplicationAttemptId())) continue;
            throw new InvalidContainerReleaseException("Cannot release container : " + cId.toString() + " not belonging to this application attempt : " + appAttemptId);
        }
    }

    public static UserGroupInformation verifyAccess(AccessControlList acl, String method, Log LOG) throws IOException {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Couldn't get current user", (Throwable)ioe);
            RMAuditLogger.logFailure((String)"UNKNOWN", (String)method, (String)acl.toString(), (String)"AdminService", (String)"Couldn't get current user");
            throw ioe;
        }
        if (!acl.isUserAllowed(user)) {
            LOG.warn((Object)("User " + user.getShortUserName() + " doesn't have permission" + " to call '" + method + "'"));
            RMAuditLogger.logFailure((String)user.getShortUserName(), (String)method, (String)acl.toString(), (String)"AdminService", (String)"Unauthorized user");
            throw new AccessControlException("User " + user.getShortUserName() + " doesn't have permission" + " to call '" + method + "'");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(method + " invoked by user " + user.getShortUserName()));
        }
        return user;
    }

    public static YarnApplicationState createApplicationState(RMAppState rmAppState) {
        switch (1.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$rmapp$RMAppState[rmAppState.ordinal()]) {
            case 1: {
                return YarnApplicationState.NEW;
            }
            case 2: {
                return YarnApplicationState.NEW_SAVING;
            }
            case 3: {
                return YarnApplicationState.SUBMITTED;
            }
            case 4: {
                return YarnApplicationState.ACCEPTED;
            }
            case 5: {
                return YarnApplicationState.RUNNING;
            }
            case 6: 
            case 7: {
                return YarnApplicationState.FINISHED;
            }
            case 8: {
                return YarnApplicationState.KILLED;
            }
            case 9: {
                return YarnApplicationState.FAILED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    public static YarnApplicationAttemptState createApplicationAttemptState(RMAppAttemptState rmAppAttemptState) {
        switch (1.$SwitchMap$org$apache$hadoop$yarn$server$resourcemanager$rmapp$attempt$RMAppAttemptState[rmAppAttemptState.ordinal()]) {
            case 1: {
                return YarnApplicationAttemptState.NEW;
            }
            case 2: {
                return YarnApplicationAttemptState.SUBMITTED;
            }
            case 3: {
                return YarnApplicationAttemptState.SCHEDULED;
            }
            case 4: {
                return YarnApplicationAttemptState.ALLOCATED;
            }
            case 5: {
                return YarnApplicationAttemptState.LAUNCHED;
            }
            case 6: 
            case 7: {
                return YarnApplicationAttemptState.ALLOCATED_SAVING;
            }
            case 8: {
                return YarnApplicationAttemptState.RUNNING;
            }
            case 9: {
                return YarnApplicationAttemptState.FINISHING;
            }
            case 10: {
                return YarnApplicationAttemptState.FINISHED;
            }
            case 11: {
                return YarnApplicationAttemptState.KILLED;
            }
            case 12: {
                return YarnApplicationAttemptState.FAILED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }
}

