/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

public class AllocationConfiguration {
    private static final AccessControlList EVERYBODY_ACL = new AccessControlList("*");
    private static final AccessControlList NOBODY_ACL = new AccessControlList(" ");
    private final Map<String, Resource> minQueueResources;
    @VisibleForTesting
    final Map<String, Resource> maxQueueResources;
    private final Map<String, ResourceWeights> queueWeights;
    @VisibleForTesting
    final Map<String, Integer> queueMaxApps;
    @VisibleForTesting
    final Map<String, Integer> userMaxApps;
    private final int userMaxAppsDefault;
    private final int queueMaxAppsDefault;
    private final Map<String, Map<QueueACL, AccessControlList>> queueAcls;
    private final Map<String, Long> minSharePreemptionTimeouts;
    private final long defaultMinSharePreemptionTimeout;
    private final long fairSharePreemptionTimeout;
    private final Map<String, SchedulingPolicy> schedulingPolicies;
    private final Map<String, String> labels;
    private final Map<String, Queue.QueueLabelPolicy> labelPolicies;
    private final SchedulingPolicy defaultSchedulingPolicy;
    @VisibleForTesting
    QueuePlacementPolicy placementPolicy;
    @VisibleForTesting
    Set<String> queueNames;

    public AllocationConfiguration(Map<String, Resource> minQueueResources, Map<String, Resource> maxQueueResources, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, ResourceWeights> queueWeights, int userMaxAppsDefault, int queueMaxAppsDefault, Map<String, SchedulingPolicy> schedulingPolicies, SchedulingPolicy defaultSchedulingPolicy, Map<String, Long> minSharePreemptionTimeouts, Map<String, Map<QueueACL, AccessControlList>> queueAcls, long fairSharePreemptionTimeout, long defaultMinSharePreemptionTimeout, QueuePlacementPolicy placementPolicy, Set<String> queueNames, Map<String, String> queueLabels, Map<String, Queue.QueueLabelPolicy> queueLabelPolicies) {
        this.minQueueResources = minQueueResources;
        this.maxQueueResources = maxQueueResources;
        this.queueMaxApps = queueMaxApps;
        this.userMaxApps = userMaxApps;
        this.queueWeights = queueWeights;
        this.userMaxAppsDefault = userMaxAppsDefault;
        this.queueMaxAppsDefault = queueMaxAppsDefault;
        this.defaultSchedulingPolicy = defaultSchedulingPolicy;
        this.schedulingPolicies = schedulingPolicies;
        this.minSharePreemptionTimeouts = minSharePreemptionTimeouts;
        this.queueAcls = queueAcls;
        this.fairSharePreemptionTimeout = fairSharePreemptionTimeout;
        this.defaultMinSharePreemptionTimeout = defaultMinSharePreemptionTimeout;
        this.placementPolicy = placementPolicy;
        this.queueNames = queueNames;
        this.labels = queueLabels;
        this.labelPolicies = queueLabelPolicies;
    }

    public AllocationConfiguration(Configuration conf) {
        this.minQueueResources = new HashMap<String, Resource>();
        this.maxQueueResources = new HashMap<String, Resource>();
        this.queueWeights = new HashMap<String, ResourceWeights>();
        this.queueMaxApps = new HashMap<String, Integer>();
        this.userMaxApps = new HashMap<String, Integer>();
        this.userMaxAppsDefault = Integer.MAX_VALUE;
        this.queueMaxAppsDefault = Integer.MAX_VALUE;
        this.queueAcls = new HashMap<String, Map<QueueACL, AccessControlList>>();
        this.minSharePreemptionTimeouts = new HashMap<String, Long>();
        this.defaultMinSharePreemptionTimeout = Long.MAX_VALUE;
        this.fairSharePreemptionTimeout = Long.MAX_VALUE;
        this.schedulingPolicies = new HashMap<String, SchedulingPolicy>();
        this.defaultSchedulingPolicy = SchedulingPolicy.DEFAULT_POLICY;
        this.placementPolicy = QueuePlacementPolicy.fromConfiguration(conf, new HashSet<String>());
        this.queueNames = new HashSet<String>();
        this.labels = new HashMap<String, String>();
        this.labelPolicies = new HashMap<String, Queue.QueueLabelPolicy>();
    }

    public AccessControlList getQueueAcl(String queue, QueueACL operation) {
        AccessControlList operationAcl;
        Map<QueueACL, AccessControlList> queueAcls = this.queueAcls.get(queue);
        if (queueAcls != null && (operationAcl = queueAcls.get(operation)) != null) {
            return operationAcl;
        }
        return queue.equals("root") ? EVERYBODY_ACL : NOBODY_ACL;
    }

    public long getMinSharePreemptionTimeout(String queueName) {
        Long minSharePreemptionTimeout = this.minSharePreemptionTimeouts.get(queueName);
        return minSharePreemptionTimeout == null ? this.defaultMinSharePreemptionTimeout : minSharePreemptionTimeout;
    }

    public long getFairSharePreemptionTimeout() {
        return this.fairSharePreemptionTimeout;
    }

    public ResourceWeights getQueueWeight(String queue) {
        ResourceWeights weight = this.queueWeights.get(queue);
        return weight == null ? ResourceWeights.NEUTRAL : weight;
    }

    public int getUserMaxApps(String user) {
        Integer maxApps = this.userMaxApps.get(user);
        return maxApps == null ? this.userMaxAppsDefault : maxApps;
    }

    public int getQueueMaxApps(String queue) {
        Integer maxApps = this.queueMaxApps.get(queue);
        return maxApps == null ? this.queueMaxAppsDefault : maxApps;
    }

    public Resource getMinResources(String queue) {
        Resource minQueueResource = this.minQueueResources.get(queue);
        return minQueueResource == null ? Resources.none() : minQueueResource;
    }

    public Resource getMaxResources(String queueName) {
        Resource maxQueueResource = this.maxQueueResources.get(queueName);
        return maxQueueResource == null ? Resources.unbounded() : maxQueueResource;
    }

    public boolean hasAccess(String queueName, QueueACL acl, UserGroupInformation user) {
        int lastPeriodIndex = queueName.length();
        while (lastPeriodIndex != -1) {
            String queue = queueName.substring(0, lastPeriodIndex);
            if (this.getQueueAcl(queue, acl).isUserAllowed(user)) {
                return true;
            }
            lastPeriodIndex = queueName.lastIndexOf(46, lastPeriodIndex - 1);
        }
        return false;
    }

    public SchedulingPolicy getSchedulingPolicy(String queueName) {
        SchedulingPolicy policy = this.schedulingPolicies.get(queueName);
        return policy == null ? this.defaultSchedulingPolicy : policy;
    }

    public SchedulingPolicy getDefaultSchedulingPolicy() {
        return this.defaultSchedulingPolicy;
    }

    public Set<String> getQueueNames() {
        return this.queueNames;
    }

    public QueuePlacementPolicy getPlacementPolicy() {
        return this.placementPolicy;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, Queue.QueueLabelPolicy> getLabelPolicies() {
        return this.labelPolicies;
    }
}

