/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestFifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestApplicationMasterService {
    private static final Log LOG = LogFactory.getLog(TestFifoScheduler.class);
    private final int GB = 1024;
    private static YarnConfiguration conf;

    @BeforeClass
    public static void setup() {
        conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
    }

    @Test(timeout=3000000L)
    public void testRMIdentifierOnContainerAllocation() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        am1.addRequests(new String[]{"127.0.0.1"}, 1024, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            alloc1Response = am1.schedule();
        }
        Container allocatedContainer = (Container)alloc1Response.getAllocatedContainers().get(0);
        ContainerTokenIdentifier tokenId = BuilderUtils.newContainerTokenIdentifier((Token)allocatedContainer.getContainerToken());
        Assert.assertEquals((long)MockRM.getClusterTimeStamp(), (long)tokenId.getRMIdentifer());
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testInvalidContainerReleaseRequest() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = rm.submitApp(1024);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
            MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
            am1.registerAppAttempt();
            am1.addRequests(new String[]{"127.0.0.1"}, 1024, 1, 1);
            AllocateResponse alloc1Response = am1.schedule();
            nm1.nodeHeartbeat(true);
            while (alloc1Response.getAllocatedContainers().size() < 1) {
                LOG.info((Object)"Waiting for containers to be created for app 1...");
                Thread.sleep(1000L);
                alloc1Response = am1.schedule();
            }
            Assert.assertTrue((alloc1Response.getAllocatedContainers().size() > 0 ? 1 : 0) != 0);
            RMApp app2 = rm.submitApp(1024);
            nm1.nodeHeartbeat(true);
            RMAppAttempt attempt2 = app2.getCurrentAppAttempt();
            MockAM am2 = rm.sendAMLaunched(attempt2.getAppAttemptId());
            am2.registerAppAttempt();
            ContainerId cId = ((Container)alloc1Response.getAllocatedContainers().get(0)).getId();
            am2.addContainerToBeReleased(cId);
            try {
                am2.schedule();
                Assert.fail((String)"Exception was expected!!");
            }
            catch (InvalidContainerReleaseException e) {
                StringBuilder sb = new StringBuilder("Cannot release container : ");
                sb.append(cId.toString());
                sb.append(" not belonging to this application attempt : ");
                sb.append(attempt2.getAppAttemptId().toString());
                Assert.assertTrue((boolean)e.getMessage().contains(sb.toString()));
            }
        }
        finally {
            if (rm != null) {
                rm.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=1200000L)
    public void testFinishApplicationMasterBeforeRegistering() throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        try {
            rm.start();
            MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
            RMApp app1 = rm.submitApp(2048);
            MockAM am1 = MockRM.launchAM(app1, rm, nm1);
            FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.FAILED, (String)"", (String)"");
            Throwable cause = null;
            try {
                am1.unregisterAppAttempt(req, false);
            }
            catch (Exception e) {
                cause = e.getCause();
            }
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof InvalidApplicationMasterRequestException));
            Assert.assertNotNull((Object)cause.getMessage());
            Assert.assertTrue((boolean)cause.getMessage().contains("Application Master is trying to unregister before registering for:"));
        }
        finally {
            if (rm != null) {
                rm.stop();
            }
        }
    }
}

