/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
public class Application {
    private static final Log LOG = LogFactory.getLog(Application.class);
    private AtomicInteger taskCounter = new AtomicInteger(0);
    private AtomicInteger numAttempts = new AtomicInteger(0);
    private final String user;
    private final String queue;
    private final ApplicationId applicationId;
    private final ApplicationAttemptId applicationAttemptId;
    private final ResourceManager resourceManager;
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final Map<Priority, Resource> requestSpec = new TreeMap<Priority, Resource>((Comparator<Priority>)new Priority.Comparator());
    private final Map<Priority, Map<String, ResourceRequest>> requests = new TreeMap<Priority, Map<String, ResourceRequest>>((Comparator<Priority>)new Priority.Comparator());
    final Map<Priority, Set<Task>> tasks = new TreeMap<Priority, Set<Task>>((Comparator<Priority>)new Priority.Comparator());
    private final Set<ResourceRequest> ask = new TreeSet<ResourceRequest>((Comparator<ResourceRequest>)new ResourceRequest.ResourceRequestComparator());
    private final Map<String, NodeManager> nodes = new HashMap<String, NodeManager>();
    Resource used = (Resource)recordFactory.newRecordInstance(Resource.class);

    public Application(String user, ResourceManager resourceManager) throws YarnException {
        this(user, "default", resourceManager);
    }

    public Application(String user, String queue, ResourceManager resourceManager) throws YarnException {
        this.user = user;
        this.queue = queue;
        this.resourceManager = resourceManager;
        GetNewApplicationRequest request = (GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class);
        GetNewApplicationResponse newApp = this.resourceManager.getClientRMService().getNewApplication(request);
        this.applicationId = newApp.getApplicationId();
        this.applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.applicationId, (int)this.numAttempts.getAndIncrement());
    }

    public String getUser() {
        return this.user;
    }

    public String getQueue() {
        return this.queue;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    public static String resolve(String hostName) {
        return "/default-rack";
    }

    public int getNextTaskId() {
        return this.taskCounter.incrementAndGet();
    }

    public Resource getUsedResources() {
        return this.used;
    }

    public synchronized void submit() throws IOException, YarnException {
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        context.setApplicationId(this.applicationId);
        context.setQueue(this.queue);
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        context.setAMContainerSpec(amContainer);
        context.setResource(Resources.createResource((int)1024));
        SubmitApplicationRequest request = (SubmitApplicationRequest)recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        request.setApplicationSubmissionContext(context);
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        this.resourceManager.getClientRMService().submitApplication(request);
        AppAddedSchedulerEvent addAppEvent = new AppAddedSchedulerEvent(this.applicationId, this.queue, "user");
        scheduler.handle((Event)addAppEvent);
        AppAttemptAddedSchedulerEvent addAttemptEvent = new AppAttemptAddedSchedulerEvent(this.applicationAttemptId, false);
        scheduler.handle((Event)addAttemptEvent);
    }

    public synchronized void addResourceRequestSpec(Priority priority, Resource capability) {
        Resource currentSpec = this.requestSpec.put(priority, capability);
        if (currentSpec != null) {
            throw new IllegalStateException("Resource spec already exists for priority " + priority.getPriority() + " - " + currentSpec.getMemory());
        }
    }

    public synchronized void addNodeManager(String host, int containerManagerPort, NodeManager nodeManager) {
        this.nodes.put(host + ":" + containerManagerPort, nodeManager);
    }

    private synchronized NodeManager getNodeManager(String host) {
        return this.nodes.get(host);
    }

    public synchronized void addTask(Task task) {
        Priority priority = task.getPriority();
        Map<String, ResourceRequest> requests = this.requests.get(priority);
        if (requests == null) {
            requests = new HashMap<String, ResourceRequest>();
            this.requests.put(priority, requests);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added priority=" + priority + " application=" + this.applicationId));
            }
        }
        Resource capability = this.requestSpec.get(priority);
        Set<Task> tasks = this.tasks.get(priority);
        if (tasks == null) {
            tasks = new HashSet<Task>();
            this.tasks.put(priority, tasks);
        }
        tasks.add(task);
        LOG.info((Object)("Added task " + task.getTaskId() + " to application " + this.applicationId + " at priority " + priority));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addTask: application=" + this.applicationId + " #asks=" + this.ask.size()));
        }
        for (String host : task.getHosts()) {
            this.addResourceRequest(priority, requests, host, capability);
        }
        for (String rack : task.getRacks()) {
            this.addResourceRequest(priority, requests, rack, capability);
        }
        this.addResourceRequest(priority, requests, "*", capability);
    }

    public synchronized void finishTask(Task task) throws IOException, YarnException {
        Set<Task> tasks = this.tasks.get(task.getPriority());
        if (!tasks.remove(task)) {
            throw new IllegalStateException("Finishing unknown task " + task.getTaskId() + " from application " + this.applicationId);
        }
        NodeManager nodeManager = task.getNodeManager();
        ContainerId containerId = task.getContainerId();
        task.stop();
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        StopContainersRequest stopRequest = StopContainersRequest.newInstance(containerIds);
        nodeManager.stopContainers(stopRequest);
        Resources.subtractFrom((Resource)this.used, (Resource)this.requestSpec.get(task.getPriority()));
        LOG.info((Object)("Finished task " + task.getTaskId() + " of application " + this.applicationId + " on node " + nodeManager.getHostName() + ", currently using " + this.used + " resources"));
    }

    private synchronized void addResourceRequest(Priority priority, Map<String, ResourceRequest> requests, String resourceName, Resource capability) {
        ResourceRequest request = requests.get(resourceName);
        if (request == null) {
            request = BuilderUtils.newResourceRequest((Priority)priority, (String)resourceName, (Resource)capability, (int)1);
            requests.put(resourceName, request);
        } else {
            request.setNumContainers(request.getNumContainers() + 1);
        }
        this.ask.remove(request);
        this.ask.add(BuilderUtils.newResourceRequest((ResourceRequest)request));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addResourceRequest: applicationId=" + this.applicationId.getId() + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " capability=" + capability + " numContainers=" + request.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    public synchronized List<Container> getResources() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getResources begin: application=" + this.applicationId + " #ask=" + this.ask.size()));
            for (ResourceRequest request : this.ask) {
                LOG.debug((Object)("getResources: application=" + this.applicationId + " ask-request=" + request));
            }
        }
        Allocation allocation = this.resourceManager.getResourceScheduler().allocate(this.applicationAttemptId, new ArrayList<ResourceRequest>(this.ask), new ArrayList(), null, null);
        System.out.println("-=======" + this.applicationAttemptId);
        System.out.println("----------" + ((RMApp)this.resourceManager.getRMContext().getRMApps().get(this.applicationId)).getRMAppAttempt(this.applicationAttemptId));
        List containers = allocation.getContainers();
        this.ask.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getResources() for " + this.applicationId + ":" + " ask=" + this.ask.size() + " recieved=" + containers.size()));
        }
        return containers;
    }

    public synchronized void assign(List<Container> containers) throws IOException, YarnException {
        int numContainers = containers.size();
        for (Priority priority : this.requests.keySet()) {
            this.assign(priority, NodeType.NODE_LOCAL, containers);
            this.assign(priority, NodeType.RACK_LOCAL, containers);
            this.assign(priority, NodeType.OFF_SWITCH, containers);
            if (!containers.isEmpty()) continue;
            break;
        }
        int assignedContainers = numContainers - containers.size();
        LOG.info((Object)("Application " + this.applicationId + " assigned " + assignedContainers + "/" + numContainers));
    }

    public synchronized void schedule() throws IOException, YarnException {
        this.assign(this.getResources());
    }

    private synchronized void assign(Priority priority, NodeType type, List<Container> containers) throws IOException, YarnException {
        Iterator<Container> i = containers.iterator();
        block0: while (i.hasNext()) {
            Container container = i.next();
            String host = container.getNodeId().toString();
            if (!Resources.equals((Resource)this.requestSpec.get(priority), (Resource)container.getResource())) continue;
            for (Task task : this.tasks.get(priority)) {
                if (task.getState() != Task.State.PENDING || !task.canSchedule(type, host)) continue;
                NodeManager nodeManager = this.getNodeManager(host);
                task.start(nodeManager, container.getId());
                i.remove();
                Resources.addTo((Resource)this.used, (Resource)container.getResource());
                LOG.info((Object)("Assigned container (" + container + ") of type " + type + " to task " + task.getTaskId() + " at priority " + priority + " on node " + nodeManager.getHostName() + ", currently using " + this.used + " resources"));
                this.updateResourceRequests(this.requests.get(priority), type, task);
                StartContainerRequest scRequest = StartContainerRequest.newInstance((ContainerLaunchContext)this.createCLC(), (Token)container.getContainerToken());
                ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
                list.add(scRequest);
                StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
                nodeManager.startContainers(allRequests);
                continue block0;
            }
        }
    }

    private void updateResourceRequests(Map<String, ResourceRequest> requests, NodeType type, Task task) {
        if (type == NodeType.NODE_LOCAL) {
            for (String host : task.getHosts()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("updateResourceRequests: application=" + this.applicationId + " type=" + type + " host=" + host + " request=" + (requests == null ? "null" : (Comparable)requests.get(host))));
                }
                this.updateResourceRequest(requests.get(host));
            }
        }
        if (type == NodeType.NODE_LOCAL || type == NodeType.RACK_LOCAL) {
            for (String rack : task.getRacks()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("updateResourceRequests: application=" + this.applicationId + " type=" + type + " rack=" + rack + " request=" + (requests == null ? "null" : (Comparable)requests.get(rack))));
                }
                this.updateResourceRequest(requests.get(rack));
            }
        }
        this.updateResourceRequest(requests.get("*"));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updateResourceRequests: application=" + this.applicationId + " #asks=" + this.ask.size()));
        }
    }

    private void updateResourceRequest(ResourceRequest request) {
        request.setNumContainers(request.getNumContainers() - 1);
        this.ask.remove(request);
        this.ask.add(BuilderUtils.newResourceRequest((ResourceRequest)request));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updateResourceRequest: application=" + this.applicationId + " request=" + request));
        }
    }

    private ContainerLaunchContext createCLC() {
        ContainerLaunchContext clc = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
        return clc;
    }
}

