/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmcontainer;

import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class RMContainerImpl
implements RMContainer {
    private static final Log LOG = LogFactory.getLog(RMContainerImpl.class);
    private static final StateMachineFactory<RMContainerImpl, RMContainerState, RMContainerEventType, RMContainerEvent> stateMachineFactory = new StateMachineFactory((Enum)RMContainerState.NEW).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition(null)).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.NEW, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition(null)).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RESERVED, (Enum)RMContainerEventType.RESERVED, (SingleArcTransition)new ContainerReservedTransition(null)).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.ALLOCATED, (Enum)RMContainerEventType.START, (SingleArcTransition)new ContainerStartedTransition(null)).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL).addTransition((Enum)RMContainerState.RESERVED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.ACQUIRED, (Enum)RMContainerEventType.ACQUIRED, (SingleArcTransition)new AcquiredTransition(null)).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new FinishedTransition(null)).addTransition((Enum)RMContainerState.ALLOCATED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new FinishedTransition(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.LAUNCHED, (SingleArcTransition)new LaunchedTransition(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new ContainerFinishedAtAcquiredState(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.EXPIRED, (Enum)RMContainerEventType.EXPIRE, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.ACQUIRED, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.COMPLETED, (Enum)RMContainerEventType.FINISHED, (SingleArcTransition)new FinishedTransition(null)).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.KILLED, (Enum)RMContainerEventType.KILL, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RELEASED, (Enum)RMContainerEventType.RELEASED, (SingleArcTransition)new KillTransition(null)).addTransition((Enum)RMContainerState.RUNNING, (Enum)RMContainerState.RUNNING, (Enum)RMContainerEventType.EXPIRE).addTransition((Enum)RMContainerState.COMPLETED, (Enum)RMContainerState.COMPLETED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.EXPIRED, (Enum)RMContainerState.EXPIRED, EnumSet.of(RMContainerEventType.RELEASED, RMContainerEventType.KILL)).addTransition((Enum)RMContainerState.RELEASED, (Enum)RMContainerState.RELEASED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).addTransition((Enum)RMContainerState.KILLED, (Enum)RMContainerState.KILLED, EnumSet.of(RMContainerEventType.EXPIRE, RMContainerEventType.RELEASED, RMContainerEventType.KILL, RMContainerEventType.FINISHED)).installTopology();
    private final StateMachine<RMContainerState, RMContainerEventType, RMContainerEvent> stateMachine = stateMachineFactory.make((Object)this);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ContainerId containerId;
    private final ApplicationAttemptId appAttemptId;
    private final NodeId nodeId;
    private final Container container;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final ContainerAllocationExpirer containerAllocationExpirer;
    private final String user;
    private Resource reservedResource;
    private NodeId reservedNode;
    private Priority reservedPriority;
    private long startTime;
    private long finishTime;
    private ContainerStatus finishedStatus;

    public RMContainerImpl(Container container, ApplicationAttemptId appAttemptId, NodeId nodeId, String user, RMContext rmContext) {
        this.containerId = container.getId();
        this.nodeId = nodeId;
        this.container = container;
        this.appAttemptId = appAttemptId;
        this.user = user;
        this.startTime = System.currentTimeMillis();
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.containerAllocationExpirer = rmContext.getContainerAllocationExpirer();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        rmContext.getRMApplicationHistoryWriter().containerStarted((RMContainer)this);
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appAttemptId;
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMContainerState getState() {
        this.readLock.lock();
        try {
            RMContainerState rMContainerState = (RMContainerState)this.stateMachine.getCurrentState();
            return rMContainerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Resource getReservedResource() {
        return this.reservedResource;
    }

    public NodeId getReservedNode() {
        return this.reservedNode;
    }

    public Priority getReservedPriority() {
        return this.reservedPriority;
    }

    public Resource getAllocatedResource() {
        return this.container.getResource();
    }

    public NodeId getAllocatedNode() {
        return this.container.getNodeId();
    }

    public Priority getAllocatedPriority() {
        return this.container.getPriority();
    }

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFinishTime() {
        try {
            this.readLock.lock();
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDiagnosticsInfo() {
        try {
            this.readLock.lock();
            if (this.getFinishedStatus() != null) {
                String string = this.getFinishedStatus().getDiagnostics();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogURL() {
        try {
            this.readLock.lock();
            String string = WebAppUtils.getRunningLogURL((String)("//" + this.container.getNodeHttpAddress()), (String)ConverterUtils.toString((ContainerId)this.containerId), (String)this.user);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContainerExitStatus() {
        try {
            this.readLock.lock();
            if (this.getFinishedStatus() != null) {
                int n = this.getFinishedStatus().getExitStatus();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerState getContainerState() {
        try {
            this.readLock.lock();
            if (this.getFinishedStatus() != null) {
                ContainerState containerState = this.getFinishedStatus().getState();
                return containerState;
            }
            ContainerState containerState = ContainerState.RUNNING;
            return containerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return this.containerId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMContainerEvent event) {
        LOG.debug((Object)("Processing " + event.getContainerId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            RMContainerState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on container " + this.containerId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(event.getContainerId() + " Container Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ContainerStatus getFinishedStatus() {
        return this.finishedStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerReport createContainerReport() {
        this.readLock.lock();
        ContainerReport containerReport = null;
        try {
            containerReport = ContainerReport.newInstance((ContainerId)this.getContainerId(), (Resource)this.getAllocatedResource(), (NodeId)this.getAllocatedNode(), (Priority)this.getAllocatedPriority(), (long)this.getStartTime(), (long)this.getFinishTime(), (String)this.getDiagnosticsInfo(), (String)this.getLogURL(), (int)this.getContainerExitStatus(), (ContainerState)this.getContainerState());
        }
        finally {
            this.readLock.unlock();
        }
        return containerReport;
    }

    static /* synthetic */ Resource access$802(RMContainerImpl x0, Resource x1) {
        x0.reservedResource = x1;
        return x0.reservedResource;
    }

    static /* synthetic */ NodeId access$902(RMContainerImpl x0, NodeId x1) {
        x0.reservedNode = x1;
        return x0.reservedNode;
    }

    static /* synthetic */ Priority access$1002(RMContainerImpl x0, Priority x1) {
        x0.reservedPriority = x1;
        return x0.reservedPriority;
    }

    static /* synthetic */ ApplicationAttemptId access$1100(RMContainerImpl x0) {
        return x0.appAttemptId;
    }

    static /* synthetic */ EventHandler access$1200(RMContainerImpl x0) {
        return x0.eventHandler;
    }

    static /* synthetic */ ContainerAllocationExpirer access$1300(RMContainerImpl x0) {
        return x0.containerAllocationExpirer;
    }

    static /* synthetic */ long access$1402(RMContainerImpl x0, long x1) {
        x0.finishTime = x1;
        return x0.finishTime;
    }

    static /* synthetic */ ContainerStatus access$1502(RMContainerImpl x0, ContainerStatus x1) {
        x0.finishedStatus = x1;
        return x0.finishedStatus;
    }

    static /* synthetic */ RMContext access$1600(RMContainerImpl x0) {
        return x0.rmContext;
    }

    static /* synthetic */ NodeId access$1700(RMContainerImpl x0) {
        return x0.nodeId;
    }

    static /* synthetic */ ContainerId access$1800(RMContainerImpl x0) {
        return x0.containerId;
    }
}

