/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.TestApplicationCleanup;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestApplicationCleanup {
    private static final Log LOG = LogFactory.getLog(TestApplicationCleanup.class);

    @Test
    public void testAppCleanup() throws Exception {
        int contReceived;
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5000);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        int request = 2;
        am.allocate("127.0.0.1", 1000, request, new ArrayList());
        nm1.nodeHeartbeat(true);
        List conts = am.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
        int waitCount = 0;
        for (contReceived = conts.size(); contReceived < request && waitCount++ < 200; contReceived += conts.size()) {
            LOG.info((Object)("Got " + contReceived + " containers. Waiting to get " + request));
            Thread.sleep(100L);
            conts = am.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
            nm1.nodeHeartbeat(true);
        }
        Assert.assertEquals((int)request, (int)contReceived);
        am.unregisterAppAttempt();
        NodeHeartbeatResponse resp = nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        resp = nm1.nodeHeartbeat(true);
        List containersToCleanup = resp.getContainersToCleanup();
        List appsToCleanup = resp.getApplicationsToCleanup();
        int numCleanedContainers = containersToCleanup.size();
        int numCleanedApps = appsToCleanup.size();
        waitCount = 0;
        while ((numCleanedContainers < 2 || numCleanedApps < 1) && waitCount++ < 200) {
            LOG.info((Object)("Waiting to get cleanup events.. cleanedConts: " + numCleanedContainers + " cleanedApps: " + numCleanedApps));
            Thread.sleep(100L);
            resp = nm1.nodeHeartbeat(true);
            List deltaContainersToCleanup = resp.getContainersToCleanup();
            List deltaAppsToCleanup = resp.getApplicationsToCleanup();
            containersToCleanup.addAll(deltaContainersToCleanup);
            appsToCleanup.addAll(deltaAppsToCleanup);
            numCleanedContainers = containersToCleanup.size();
            numCleanedApps = appsToCleanup.size();
        }
        Assert.assertEquals((int)1, (int)appsToCleanup.size());
        Assert.assertEquals((Object)app.getApplicationId(), appsToCleanup.get(0));
        Assert.assertEquals((int)1, (int)numCleanedApps);
        Assert.assertEquals((int)2, (int)numCleanedContainers);
        rm.stop();
    }

    @Test
    public void testContainerCleanup() throws Exception {
        int cleanedConts;
        int contReceived;
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        DrainDispatcher dispatcher = new DrainDispatcher();
        1 rm = new /* Unavailable Anonymous Inner Class!! */;
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5000);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        int request = 2;
        am.allocate("127.0.0.1", 1000, request, new ArrayList());
        dispatcher.await();
        nm1.nodeHeartbeat(true);
        List conts = am.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
        int waitCount = 0;
        for (contReceived = conts.size(); contReceived < request && waitCount++ < 200; contReceived += conts.size()) {
            LOG.info((Object)("Got " + contReceived + " containers. Waiting to get " + request));
            Thread.sleep(100L);
            conts = am.allocate(new ArrayList(), new ArrayList()).getAllocatedContainers();
            dispatcher.await();
            nm1.nodeHeartbeat(true);
        }
        Assert.assertEquals((int)request, (int)contReceived);
        ArrayList<ContainerId> release = new ArrayList<ContainerId>();
        release.add(((Container)conts.get(0)).getId());
        am.allocate(new ArrayList(), release);
        dispatcher.await();
        HashMap containerStatuses = new HashMap();
        ArrayList<ContainerStatus> containerStatusList = new ArrayList<ContainerStatus>();
        containerStatusList.add(BuilderUtils.newContainerStatus((ContainerId)((Container)conts.get(0)).getId(), (ContainerState)ContainerState.RUNNING, (String)"nothing", (int)0));
        containerStatuses.put(app.getApplicationId(), containerStatusList);
        NodeHeartbeatResponse resp = nm1.nodeHeartbeat(containerStatuses, true);
        dispatcher.await();
        List contsToClean = resp.getContainersToCleanup();
        waitCount = 0;
        for (cleanedConts = contsToClean.size(); cleanedConts < 1 && waitCount++ < 200; cleanedConts += contsToClean.size()) {
            LOG.info((Object)("Waiting to get cleanup events.. cleanedConts: " + cleanedConts));
            Thread.sleep(100L);
            resp = nm1.nodeHeartbeat(true);
            dispatcher.await();
            contsToClean = resp.getContainersToCleanup();
        }
        LOG.info((Object)("Got cleanup for " + contsToClean.get(0)));
        Assert.assertEquals((int)1, (int)cleanedConts);
        LOG.info((Object)"Testing container launch much after release and NM getting cleanup");
        containerStatuses.clear();
        containerStatusList.clear();
        containerStatusList.add(BuilderUtils.newContainerStatus((ContainerId)((Container)conts.get(0)).getId(), (ContainerState)ContainerState.RUNNING, (String)"nothing", (int)0));
        containerStatuses.put(app.getApplicationId(), containerStatusList);
        resp = nm1.nodeHeartbeat(containerStatuses, true);
        dispatcher.await();
        contsToClean = resp.getContainersToCleanup();
        waitCount = 0;
        for (cleanedConts = contsToClean.size(); cleanedConts < 1 && waitCount++ < 200; cleanedConts += contsToClean.size()) {
            LOG.info((Object)("Waiting to get cleanup events.. cleanedConts: " + cleanedConts));
            Thread.sleep(100L);
            resp = nm1.nodeHeartbeat(true);
            dispatcher.await();
            contsToClean = resp.getContainersToCleanup();
        }
        LOG.info((Object)("Got cleanup for " + contsToClean.get(0)));
        Assert.assertEquals((int)1, (int)cleanedConts);
        rm.stop();
    }

    public static void main(String[] args) throws Exception {
        TestApplicationCleanup t = new TestApplicationCleanup();
        t.testAppCleanup();
    }
}

