/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainerLaunch;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.TaskLogUtil;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.log.DFSContainerLogsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLogsUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ContainerLogsUtils.class);

    public static List<Path> getContainerLogDirs(ContainerId containerId, String remoteUser, Context context) throws YarnException {
        Container container = (Container)context.getContainers().get(containerId);
        Application application = ContainerLogsUtils.getApplicationForContainer(containerId, context);
        ContainerLogsUtils.checkAccess(remoteUser, application, context);
        if (container != null) {
            ContainerLogsUtils.checkState(container.getContainerState());
        }
        return ContainerLogsUtils.getContainerLogDirs(containerId, context.getLocalDirsHandler());
    }

    static List<Path> getContainerLogDirs(ContainerId containerId, LocalDirsHandlerService dirsHandler) throws YarnException {
        if (TaskLogUtil.isDfsLoggingEnabled()) {
            try {
                return DFSContainerLogsUtils.getContainerLogDirs((ContainerId)containerId);
            }
            catch (IOException e) {
                LOG.warn("Failed to find logs for container: " + containerId, (Throwable)e);
                throw new NotFoundException("Cannot find logs for container: " + containerId);
            }
        }
        List<String> logDirs = dirsHandler.getLogDirs();
        ArrayList<Path> containerLogDirs = new ArrayList<Path>(logDirs.size());
        for (String logDir : logDirs) {
            try {
                logDir = new URI(logDir).getPath();
            }
            catch (URISyntaxException e) {
                throw new YarnException("Internal error", (Throwable)e);
            }
            String appIdStr = ConverterUtils.toString((ApplicationId)containerId.getApplicationAttemptId().getApplicationId());
            Path appLogDir = new Path(logDir, appIdStr);
            containerLogDirs.add(new Path(appLogDir, containerId.toString()));
        }
        return containerLogDirs;
    }

    public static Path getContainerLogFile(ContainerId containerId, String fileName, String remoteUser, Context context) throws YarnException {
        if (TaskLogUtil.isDfsLoggingEnabled()) {
            try {
                return DFSContainerLogsUtils.getContainerLogFile((ContainerId)containerId, (String)fileName, (String)remoteUser);
            }
            catch (IOException e) {
                LOG.warn("Failed to find logs for container: " + containerId + " file: " + fileName, (Throwable)e);
                throw new NotFoundException("Cannot find logs for container: " + containerId + " file: " + fileName);
            }
        }
        Container container = (Container)context.getContainers().get(containerId);
        Application application = ContainerLogsUtils.getApplicationForContainer(containerId, context);
        ContainerLogsUtils.checkAccess(remoteUser, application, context);
        if (container != null) {
            ContainerLogsUtils.checkState(container.getContainerState());
        }
        String relativeContainerLogDir = ContainerLaunch.getRelativeContainerLogDir(application.getAppId().toString(), containerId.toString());
        String relativeFileName = relativeContainerLogDir + "/" + fileName;
        try {
            LocalDirsHandlerService dirsHandler = context.getLocalDirsHandler();
            return dirsHandler.getLogPathToRead(relativeFileName);
        }
        catch (IOException e) {
            LOG.warn("Failed to find log file", (Throwable)e);
            throw new NotFoundException("Cannot find this log on the local disk.");
        }
    }

    private static Application getApplicationForContainer(ContainerId containerId, Context context) {
        ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
        Application application = (Application)context.getApplications().get(applicationId);
        if (application == null) {
            throw new NotFoundException("Unknown container. Container either has not started or has already completed or doesn't belong to this node at all.");
        }
        return application;
    }

    private static void checkAccess(String remoteUser, Application application, Context context) throws YarnException {
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        if (callerUGI != null && !context.getApplicationACLsManager().checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, application.getUser(), application.getAppId())) {
            throw new YarnException("User [" + remoteUser + "] is not authorized to view the logs for application " + application.getAppId());
        }
    }

    private static void checkState(ContainerState state) {
        if (state == ContainerState.NEW || state == ContainerState.LOCALIZING || state == ContainerState.LOCALIZED) {
            throw new NotFoundException("Container is not yet running. Current state is " + (Object)((Object)state));
        }
        if (state == ContainerState.LOCALIZATION_FAILED) {
            throw new NotFoundException("Container wasn't started. Localization failed.");
        }
    }

    public static InputStream openLogFileForRead(String containerIdStr, Path logFile, Context context) throws IOException {
        if (TaskLogUtil.isDfsLoggingEnabled()) {
            return DFSContainerLogsUtils.openLogFileForRead((String)containerIdStr, (Path)logFile);
        }
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
        ApplicationId applicationId = containerId.getApplicationAttemptId().getApplicationId();
        String user = ((Application)context.getApplications().get(applicationId)).getUser();
        try {
            File file = new File(logFile.toString());
            return SecureIOUtils.openForRead((File)file, (String)user, null);
        }
        catch (IOException e) {
            if (e.getMessage().contains("did not match expected owner '" + user + "'")) {
                LOG.error("Exception reading log file " + logFile, (Throwable)e);
                throw new IOException("Exception reading log file. Application submitted by '" + user + "' doesn't own requested log file : " + logFile.toString(), e);
            }
            throw new IOException("Exception reading log file. It might be because log file was aggregated : " + logFile.toString(), e);
        }
    }

    public static long getFileLength(Path logFile) throws IOException {
        if (TaskLogUtil.isDfsLoggingEnabled()) {
            return DFSContainerLogsUtils.getFileLength((Path)logFile);
        }
        return new File(logFile.toString()).length();
    }

    public static Path[] getFilesInDir(Path dir) throws IOException {
        if (TaskLogUtil.isDfsLoggingEnabled()) {
            return DFSContainerLogsUtils.getFilesInDir((Path)dir);
        }
        Path[] paths = null;
        File[] files = new File(dir.toString()).listFiles();
        if (files != null) {
            paths = new Path[files.length];
            for (int i = 0; i < files.length; ++i) {
                paths[i] = new Path(files[i].getAbsolutePath());
            }
        }
        return paths;
    }
}

