/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.impl.pb.LocalResourcePBImpl;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.api.LocalizationProtocol;
import org.apache.hadoop.yarn.server.nodemanager.api.ResourceLocalizationSpec;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalResourceStatus;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalizerAction;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalizerHeartbeatResponse;
import org.apache.hadoop.yarn.server.nodemanager.api.protocolrecords.LocalizerStatus;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResourceFailedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ContainerLocalizer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourcesTracker;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourcesTrackerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizedResource;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalizerContext;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceRetentionSet;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ApplicationLocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationCleanupEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationRequestEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizerResourceRequestEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceFailedLocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceLocalizedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceRecoveredEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceReleaseEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ResourceRequestEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.ExternalTokenLocalizer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.ExternalTokenLocalizerFactory;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.LocalizerTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.security.LocalizerTokenSecretManager;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.security.authorize.NMPolicyProvider;
import org.apache.hadoop.yarn.server.nodemanager.util.NodeManagerBuilderUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.FSDownload;

public class ResourceLocalizationService
extends CompositeService
implements EventHandler<LocalizationEvent>,
LocalizationProtocol {
    private static final Log LOG = LogFactory.getLog(ResourceLocalizationService.class);
    public static final String NM_PRIVATE_DIR = "nmPrivate";
    public static final FsPermission NM_PRIVATE_PERM = new FsPermission(448);
    private Server server;
    private InetSocketAddress localizationServerAddress;
    private long cacheTargetSize;
    private long cacheCleanupPeriod;
    private final ContainerExecutor exec;
    protected final Dispatcher dispatcher;
    private final DeletionService delService;
    private LocalizerTracker localizerTracker;
    private RecordFactory recordFactory;
    private final ScheduledExecutorService cacheCleanup;
    private LocalizerTokenSecretManager secretManager;
    private NMStateStoreService stateStore;
    private LocalResourcesTracker publicRsrc;
    private LocalDirsHandlerService dirsHandler;
    private final ConcurrentMap<String, LocalResourcesTracker> privateRsrc = new ConcurrentHashMap<String, LocalResourcesTracker>();
    private final ConcurrentMap<String, LocalResourcesTracker> appRsrc = new ConcurrentHashMap<String, LocalResourcesTracker>();

    public ResourceLocalizationService(Dispatcher dispatcher, ContainerExecutor exec, DeletionService delService, LocalDirsHandlerService dirsHandler, NMStateStoreService stateStore) {
        super(ResourceLocalizationService.class.getName());
        this.exec = exec;
        this.dispatcher = dispatcher;
        this.delService = delService;
        this.dirsHandler = dirsHandler;
        this.cacheCleanup = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("ResourceLocalizationService Cache Cleanup").build());
        this.stateStore = stateStore;
    }

    FileContext getLocalFileContext(Configuration conf) {
        try {
            return FileContext.getLocalFSFileContext((Configuration)conf);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to access local fs");
        }
    }

    private void validateConf(Configuration conf) {
        int perDirFileLimit = conf.getInt("yarn.nodemanager.local-cache.max-files-per-directory", 8192);
        if (perDirFileLimit <= 36) {
            LOG.error((Object)"yarn.nodemanager.local-cache.max-files-per-directory parameter is configured with very low value.");
            throw new YarnRuntimeException("yarn.nodemanager.local-cache.max-files-per-directory parameter is configured with a value less than 37.");
        }
        LOG.info((Object)("per directory file limit = " + perDirFileLimit));
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.validateConf(conf);
        this.publicRsrc = new LocalResourcesTrackerImpl(null, null, this.dispatcher, true, conf, this.stateStore);
        this.recordFactory = RecordFactoryProvider.getRecordFactory((Configuration)conf);
        try {
            FileContext lfs = this.getLocalFileContext(conf);
            lfs.setUMask(new FsPermission(18));
            if (!this.stateStore.canRecover()) {
                this.cleanUpLocalDir(lfs, this.delService);
            }
            List<String> localDirs = this.dirsHandler.getLocalDirs();
            for (String localDir : localDirs) {
                Path userDir = new Path(localDir, "usercache");
                lfs.mkdir(userDir, null, true);
                Path fileDir = new Path(localDir, "filecache");
                lfs.mkdir(fileDir, null, true);
                Path sysDir = new Path(localDir, NM_PRIVATE_DIR);
                lfs.mkdir(sysDir, NM_PRIVATE_PERM, true);
            }
            List<String> logDirs = this.dirsHandler.getLogDirs();
            for (String logDir : logDirs) {
                lfs.mkdir(new Path(logDir), null, true);
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to initialize LocalizationService", (Throwable)e);
        }
        this.cacheTargetSize = conf.getLong("yarn.nodemanager.localizer.cache.target-size-mb", 10240L) << 20;
        this.cacheCleanupPeriod = conf.getLong("yarn.nodemanager.localizer.cache.cleanup.interval-ms", 600000L);
        this.localizationServerAddress = conf.getSocketAddr("yarn.nodemanager.localizer.address", "0.0.0.0:8040", 8040);
        this.localizerTracker = this.createLocalizerTracker(conf);
        this.addService((Service)this.localizerTracker);
        this.dispatcher.register(LocalizerEventType.class, (EventHandler)this.localizerTracker);
        super.serviceInit(conf);
    }

    public void recoverLocalizedResources(NMStateStoreService.RecoveredLocalizationState state) throws URISyntaxException {
        NMStateStoreService.LocalResourceTrackerState trackerState = state.getPublicTrackerState();
        this.recoverTrackerResources(this.publicRsrc, trackerState);
        for (Map.Entry<String, NMStateStoreService.RecoveredUserResources> userEntry : state.getUserResources().entrySet()) {
            String user = userEntry.getKey();
            NMStateStoreService.RecoveredUserResources userResources = userEntry.getValue();
            trackerState = userResources.getPrivateTrackerState();
            if (!trackerState.isEmpty()) {
                LocalResourcesTracker tracker = new LocalResourcesTrackerImpl(user, null, this.dispatcher, true, super.getConfig(), this.stateStore);
                LocalResourcesTracker oldTracker = this.privateRsrc.putIfAbsent(user, tracker);
                if (oldTracker != null) {
                    tracker = oldTracker;
                }
                this.recoverTrackerResources(tracker, trackerState);
            }
            for (Map.Entry<ApplicationId, NMStateStoreService.LocalResourceTrackerState> appEntry : userResources.getAppTrackerStates().entrySet()) {
                LocalResourcesTracker tracker;
                trackerState = appEntry.getValue();
                if (trackerState.isEmpty()) continue;
                ApplicationId appId = appEntry.getKey();
                String appIdStr = ConverterUtils.toString((ApplicationId)appId);
                LocalResourcesTracker oldTracker = this.appRsrc.putIfAbsent(appIdStr, tracker = new LocalResourcesTrackerImpl(user, appId, this.dispatcher, false, super.getConfig(), this.stateStore));
                if (oldTracker != null) {
                    tracker = oldTracker;
                }
                this.recoverTrackerResources(tracker, trackerState);
            }
        }
    }

    private void recoverTrackerResources(LocalResourcesTracker tracker, NMStateStoreService.LocalResourceTrackerState state) throws URISyntaxException {
        LocalResourceRequest req;
        LocalResourcePBImpl rsrc;
        for (YarnServerNodemanagerRecoveryProtos.LocalizedResourceProto localizedResourceProto : state.getLocalizedResources()) {
            rsrc = new LocalResourcePBImpl(localizedResourceProto.getResource());
            req = new LocalResourceRequest((LocalResource)rsrc);
            LOG.info((Object)("Recovering localized resource " + req + " at " + localizedResourceProto.getLocalPath()));
            tracker.handle((Event)new ResourceRecoveredEvent(req, new Path(localizedResourceProto.getLocalPath()), localizedResourceProto.getSize()));
        }
        for (Map.Entry entry : state.getInProgressResources().entrySet()) {
            rsrc = new LocalResourcePBImpl((YarnProtos.LocalResourceProto)entry.getKey());
            req = new LocalResourceRequest((LocalResource)rsrc);
            Path localPath = (Path)entry.getValue();
            tracker.handle((Event)new ResourceRecoveredEvent(req, localPath, 0L));
            LOG.info((Object)("Deleting in-progress localization for " + req + " at " + localPath));
            tracker.remove(tracker.getLocalizedResource(req), this.delService);
        }
    }

    @Override
    public LocalizerHeartbeatResponse heartbeat(LocalizerStatus status) {
        return this.localizerTracker.processHeartbeat(status);
    }

    public void serviceStart() throws Exception {
        this.cacheCleanup.scheduleWithFixedDelay(new CacheCleanup(this.dispatcher), this.cacheCleanupPeriod, this.cacheCleanupPeriod, TimeUnit.MILLISECONDS);
        this.server = this.createServer();
        this.server.start();
        this.localizationServerAddress = this.getConfig().updateConnectAddr("yarn.nodemanager.localizer.address", this.server.getListenerAddress());
        LOG.info((Object)("Localizer started on port " + this.server.getPort()));
        super.serviceStart();
    }

    LocalizerTracker createLocalizerTracker(Configuration conf) {
        return new LocalizerTracker(conf);
    }

    Server createServer() {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        if (UserGroupInformation.isSecurityEnabled()) {
            this.secretManager = new LocalizerTokenSecretManager();
        }
        Server server = rpc.getServer(LocalizationProtocol.class, (Object)this, this.localizationServerAddress, conf, (SecretManager)this.secretManager, conf.getInt("yarn.nodemanager.localizer.client.thread-count", 5));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            server.refreshServiceAcl(conf, (PolicyProvider)new NMPolicyProvider());
        }
        return server;
    }

    public void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        this.cacheCleanup.shutdown();
        super.serviceStop();
    }

    public void handle(LocalizationEvent event) {
        switch ((LocalizationEventType)event.getType()) {
            case INIT_APPLICATION_RESOURCES: {
                this.handleInitApplicationResources(((ApplicationLocalizationEvent)event).getApplication());
                break;
            }
            case INIT_CONTAINER_RESOURCES: {
                this.handleInitContainerResources((ContainerLocalizationRequestEvent)event);
                break;
            }
            case CACHE_CLEANUP: {
                this.handleCacheCleanup(event);
                break;
            }
            case CLEANUP_CONTAINER_RESOURCES: {
                this.handleCleanupContainerResources((ContainerLocalizationCleanupEvent)event);
                break;
            }
            case DESTROY_APPLICATION_RESOURCES: {
                this.handleDestroyApplicationResources(((ApplicationLocalizationEvent)event).getApplication());
                break;
            }
            default: {
                throw new YarnRuntimeException("Unknown localization event: " + (Object)((Object)event));
            }
        }
    }

    private void handleInitApplicationResources(Application app) {
        String userName = app.getUser();
        this.privateRsrc.putIfAbsent(userName, new LocalResourcesTrackerImpl(userName, null, this.dispatcher, true, super.getConfig(), this.stateStore));
        String appIdStr = ConverterUtils.toString((ApplicationId)app.getAppId());
        this.appRsrc.putIfAbsent(appIdStr, new LocalResourcesTrackerImpl(app.getUser(), app.getAppId(), this.dispatcher, false, super.getConfig(), this.stateStore));
        this.dispatcher.getEventHandler().handle((Event)new ApplicationInitedEvent(app.getAppId()));
    }

    private void handleInitContainerResources(ContainerLocalizationRequestEvent rsrcReqs) {
        Container c = rsrcReqs.getContainer();
        LoadingCache statCache = CacheBuilder.newBuilder().build(FSDownload.createStatusCacheLoader((Configuration)this.getConfig()));
        LocalizerContext ctxt = new LocalizerContext(c.getUser(), c.getContainerId(), c.getCredentials(), (LoadingCache<Path, Future<FileStatus>>)statCache);
        Map<LocalResourceVisibility, Collection<LocalResourceRequest>> rsrcs = rsrcReqs.getRequestedResources();
        for (Map.Entry<LocalResourceVisibility, Collection<LocalResourceRequest>> e : rsrcs.entrySet()) {
            LocalResourcesTracker tracker = this.getLocalResourcesTracker(e.getKey(), c.getUser(), c.getContainerId().getApplicationAttemptId().getApplicationId());
            for (LocalResourceRequest req : e.getValue()) {
                tracker.handle((Event)new ResourceRequestEvent(req, e.getKey(), ctxt));
            }
        }
    }

    private void handleCacheCleanup(LocalizationEvent event) {
        ResourceRetentionSet retain = new ResourceRetentionSet(this.delService, this.cacheTargetSize);
        retain.addResources(this.publicRsrc);
        LOG.debug((Object)("Resource cleanup (public) " + retain));
        for (LocalResourcesTracker t : this.privateRsrc.values()) {
            retain.addResources(t);
            LOG.debug((Object)("Resource cleanup " + t.getUser() + ":" + retain));
        }
    }

    private void handleCleanupContainerResources(ContainerLocalizationCleanupEvent rsrcCleanup) {
        Container c = rsrcCleanup.getContainer();
        Map<LocalResourceVisibility, Collection<LocalResourceRequest>> rsrcs = rsrcCleanup.getResources();
        for (Map.Entry<LocalResourceVisibility, Collection<LocalResourceRequest>> e : rsrcs.entrySet()) {
            LocalResourcesTracker tracker = this.getLocalResourcesTracker(e.getKey(), c.getUser(), c.getContainerId().getApplicationAttemptId().getApplicationId());
            for (LocalResourceRequest req : e.getValue()) {
                tracker.handle((Event)new ResourceReleaseEvent(req, c.getContainerId()));
            }
        }
        String locId = ConverterUtils.toString((ContainerId)c.getContainerId());
        this.localizerTracker.cleanupPrivLocalizers(locId);
        String userName = c.getUser();
        String containerIDStr = c.toString();
        String appIDStr = ConverterUtils.toString((ApplicationId)c.getContainerId().getApplicationAttemptId().getApplicationId());
        for (String localDir : this.dirsHandler.getLocalDirs()) {
            Path usersdir = new Path(localDir, "usercache");
            Path userdir = new Path(usersdir, userName);
            Path allAppsdir = new Path(userdir, "appcache");
            Path appDir = new Path(allAppsdir, appIDStr);
            Path containerDir = new Path(appDir, containerIDStr);
            this.delService.delete(userName, containerDir, new Path[0]);
            Path sysDir = new Path(localDir, NM_PRIVATE_DIR);
            Path appSysDir = new Path(sysDir, appIDStr);
            Path containerSysDir = new Path(appSysDir, containerIDStr);
            this.delService.delete(null, containerSysDir, new Path[0]);
        }
        this.dispatcher.getEventHandler().handle((Event)new ContainerEvent(c.getContainerId(), ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP));
    }

    private void handleDestroyApplicationResources(Application application) {
        String userName = application.getUser();
        ApplicationId appId = application.getAppId();
        String appIDStr = application.toString();
        LocalResourcesTracker appLocalRsrcsTracker = (LocalResourcesTracker)this.appRsrc.remove(ConverterUtils.toString((ApplicationId)appId));
        if (appLocalRsrcsTracker != null) {
            for (LocalizedResource rsrc : appLocalRsrcsTracker) {
                Path localPath = rsrc.getLocalPath();
                if (localPath == null) continue;
                try {
                    this.stateStore.removeLocalizedResource(userName, appId, localPath);
                }
                catch (IOException e) {
                    LOG.error((Object)("Unable to remove resource " + rsrc + " for " + appIDStr + " from state store"), (Throwable)e);
                }
            }
        } else {
            LOG.warn((Object)("Removing uninitialized application " + application));
        }
        for (String localDir : this.dirsHandler.getLocalDirs()) {
            Path usersdir = new Path(localDir, "usercache");
            Path userdir = new Path(usersdir, userName);
            Path allAppsdir = new Path(userdir, "appcache");
            Path appDir = new Path(allAppsdir, appIDStr);
            this.delService.delete(userName, appDir, new Path[0]);
            Path sysDir = new Path(localDir, NM_PRIVATE_DIR);
            Path appSysDir = new Path(sysDir, appIDStr);
            this.delService.delete(null, appSysDir, new Path[0]);
        }
        this.dispatcher.getEventHandler().handle((Event)new ApplicationEvent(application.getAppId(), ApplicationEventType.APPLICATION_RESOURCES_CLEANEDUP));
    }

    LocalResourcesTracker getLocalResourcesTracker(LocalResourceVisibility visibility, String user, ApplicationId appId) {
        switch (visibility) {
            default: {
                return this.publicRsrc;
            }
            case PRIVATE: {
                return (LocalResourcesTracker)this.privateRsrc.get(user);
            }
            case APPLICATION: 
        }
        return (LocalResourcesTracker)this.appRsrc.get(ConverterUtils.toString((ApplicationId)appId));
    }

    private String getUserFileCachePath(String user) {
        return StringUtils.join((CharSequence)"/", Arrays.asList(".", "usercache", user, "filecache"));
    }

    private String getAppFileCachePath(String user, String appId) {
        return StringUtils.join((CharSequence)"/", Arrays.asList(".", "usercache", user, "appcache", appId, "filecache"));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public PublicLocalizer getPublicLocalizer() {
        return this.localizerTracker.publicLocalizer;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public LocalizerRunner getLocalizerRunner(String locId) {
        return (LocalizerRunner)this.localizerTracker.privLocalizers.get(locId);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public Map<String, LocalizerRunner> getPrivateLocalizers() {
        return this.localizerTracker.privLocalizers;
    }

    private static ExecutorService createLocalizerExecutor(Configuration conf) {
        int nThreads = conf.getInt("yarn.nodemanager.localizer.fetch.thread-count", 4);
        ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("PublicLocalizer #%d").build();
        return Executors.newFixedThreadPool(nThreads, tf);
    }

    private void cleanUpLocalDir(FileContext lfs, DeletionService del) {
        long currentTimeStamp = System.currentTimeMillis();
        for (String localDir : this.dirsHandler.getLocalDirs()) {
            this.renameLocalDir(lfs, localDir, "usercache", currentTimeStamp);
            this.renameLocalDir(lfs, localDir, "filecache", currentTimeStamp);
            this.renameLocalDir(lfs, localDir, NM_PRIVATE_DIR, currentTimeStamp);
            try {
                this.deleteLocalDir(lfs, del, localDir);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to delete localDir: " + localDir));
            }
        }
    }

    private void renameLocalDir(FileContext lfs, String localDir, String localSubDir, long currentTimeStamp) {
        try {
            lfs.rename(new Path(localDir, localSubDir), new Path(localDir, localSubDir + "_DEL_" + currentTimeStamp), new Options.Rename[0]);
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            LOG.warn((Object)("Failed to rename the local file under " + localDir + "/" + localSubDir));
        }
    }

    private void deleteLocalDir(FileContext lfs, DeletionService del, String localDir) throws IOException {
        RemoteIterator fileStatus = lfs.listStatus(new Path(localDir));
        if (fileStatus != null) {
            while (fileStatus.hasNext()) {
                FileStatus status = (FileStatus)fileStatus.next();
                try {
                    if (status.getPath().getName().matches(".*usercache_DEL_.*")) {
                        LOG.info((Object)("usercache path : " + status.getPath().toString()));
                        this.cleanUpFilesPerUserDir(lfs, del, status.getPath());
                        continue;
                    }
                    if (!status.getPath().getName().matches(".*nmPrivate_DEL_.*") && !status.getPath().getName().matches(".*filecache_DEL_.*")) continue;
                    del.delete(null, status.getPath(), new Path[0]);
                }
                catch (IOException ex) {
                    LOG.warn((Object)("Failed to delete this local Directory: " + status.getPath().getName()));
                }
            }
        }
    }

    private void cleanUpFilesPerUserDir(FileContext lfs, DeletionService del, Path userDirPath) throws IOException {
        RemoteIterator userDirStatus = lfs.listStatus(userDirPath);
        DeletionService.FileDeletionTask dependentDeletionTask = del.createFileDeletionTask(null, userDirPath, new Path[0]);
        if (userDirStatus != null) {
            ArrayList<DeletionService.FileDeletionTask> deletionTasks = new ArrayList<DeletionService.FileDeletionTask>();
            while (userDirStatus.hasNext()) {
                FileStatus status = (FileStatus)userDirStatus.next();
                String owner = status.getOwner();
                DeletionService.FileDeletionTask deletionTask = del.createFileDeletionTask(owner, null, new Path[]{status.getPath()});
                deletionTask.addFileDeletionTaskDependency(dependentDeletionTask);
                deletionTasks.add(deletionTask);
            }
            for (DeletionService.FileDeletionTask task : deletionTasks) {
                del.scheduleFileDeletionTask(task);
            }
        } else {
            del.scheduleFileDeletionTask(dependentDeletionTask);
        }
    }

    static class CacheCleanup
    extends Thread {
        private final Dispatcher dispatcher;

        public CacheCleanup(Dispatcher dispatcher) {
            super("CacheCleanup");
            this.dispatcher = dispatcher;
        }

        @Override
        public void run() {
            this.dispatcher.getEventHandler().handle((Event)new LocalizationEvent(LocalizationEventType.CACHE_CLEANUP));
        }
    }

    class LocalizerRunner
    extends Thread {
        final LocalizerContext context;
        final String localizerId;
        final Map<LocalResourceRequest, LocalizerResourceRequestEvent> scheduled;
        final List<LocalizerResourceRequestEvent> pending;
        private final RecordFactory recordFactory;

        LocalizerRunner(LocalizerContext context, String localizerId) {
            super("LocalizerRunner for " + localizerId);
            this.recordFactory = RecordFactoryProvider.getRecordFactory((Configuration)ResourceLocalizationService.this.getConfig());
            this.context = context;
            this.localizerId = localizerId;
            this.pending = Collections.synchronizedList(new ArrayList());
            this.scheduled = new HashMap<LocalResourceRequest, LocalizerResourceRequestEvent>();
        }

        public void addResource(LocalizerResourceRequestEvent request) {
            this.pending.add(request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalResource findNextResource() {
            List<LocalizerResourceRequestEvent> list = this.pending;
            synchronized (list) {
                Iterator<LocalizerResourceRequestEvent> i = this.pending.iterator();
                while (i.hasNext()) {
                    LocalizerResourceRequestEvent evt = i.next();
                    LocalizedResource nRsrc = evt.getResource();
                    if (!ResourceState.DOWNLOADING.equals((Object)nRsrc.getState())) {
                        i.remove();
                        continue;
                    }
                    if (!nRsrc.tryAcquire()) continue;
                    if (nRsrc.getState().equals((Object)ResourceState.DOWNLOADING)) {
                        LocalResourceRequest nextRsrc = nRsrc.getRequest();
                        LocalResource next = (LocalResource)this.recordFactory.newRecordInstance(LocalResource.class);
                        next.setResource(ConverterUtils.getYarnUrlFromPath((Path)nextRsrc.getPath()));
                        next.setTimestamp(nextRsrc.getTimestamp());
                        next.setType(nextRsrc.getType());
                        next.setVisibility(evt.getVisibility());
                        next.setPattern(evt.getPattern());
                        this.scheduled.put(nextRsrc, evt);
                        return next;
                    }
                    nRsrc.unlock();
                }
                return null;
            }
        }

        LocalizerHeartbeatResponse update(List<LocalResourceStatus> remoteResourceStatuses) {
            LocalizerHeartbeatResponse response = (LocalizerHeartbeatResponse)this.recordFactory.newRecordInstance(LocalizerHeartbeatResponse.class);
            String user = this.context.getUser();
            ApplicationId applicationId = this.context.getContainerId().getApplicationAttemptId().getApplicationId();
            if (remoteResourceStatuses.isEmpty()) {
                LocalResource next = this.findNextResource();
                if (next != null) {
                    response.setLocalizerAction(LocalizerAction.LIVE);
                    try {
                        ArrayList<ResourceLocalizationSpec> rsrcs = new ArrayList<ResourceLocalizationSpec>();
                        ResourceLocalizationSpec rsrc = NodeManagerBuilderUtils.newResourceLocalizationSpec(next, this.getPathForLocalization(next));
                        rsrcs.add(rsrc);
                        response.setResourceSpecs(rsrcs);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"local path for PRIVATE localization could not be found.Disks might have failed.", (Throwable)e);
                    }
                    catch (URISyntaxException e) {}
                } else if (this.pending.isEmpty()) {
                    response.setLocalizerAction(LocalizerAction.DIE);
                } else {
                    response.setLocalizerAction(LocalizerAction.LIVE);
                }
                return response;
            }
            ArrayList<ResourceLocalizationSpec> rsrcs = new ArrayList<ResourceLocalizationSpec>();
            block15: for (LocalResourceStatus stat : remoteResourceStatuses) {
                LocalResource rsrc = stat.getResource();
                LocalResourceRequest req = null;
                try {
                    req = new LocalResourceRequest(rsrc);
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                LocalizerResourceRequestEvent assoc = this.scheduled.get(req);
                if (assoc == null) {
                    LOG.error((Object)("Unknown resource reported: " + req));
                    continue;
                }
                switch (stat.getStatus()) {
                    case FETCH_SUCCESS: {
                        try {
                            ResourceLocalizationService.this.getLocalResourcesTracker(req.getVisibility(), user, applicationId).handle((Event)new ResourceLocalizedEvent(req, ConverterUtils.getPathFromYarnURL((URL)stat.getLocalPath()), stat.getLocalSize()));
                        }
                        catch (URISyntaxException e) {
                            // empty catch block
                        }
                        assoc.getResource().unlock();
                        this.scheduled.remove(req);
                        if (this.pending.isEmpty()) {
                            response.setLocalizerAction(LocalizerAction.DIE);
                            continue block15;
                        }
                        response.setLocalizerAction(LocalizerAction.LIVE);
                        LocalResource next = this.findNextResource();
                        if (next == null) continue block15;
                        try {
                            ResourceLocalizationSpec resource = NodeManagerBuilderUtils.newResourceLocalizationSpec(next, this.getPathForLocalization(next));
                            rsrcs.add(resource);
                        }
                        catch (IOException e) {
                            LOG.error((Object)"local path for PRIVATE localization could not be found. Disks might have failed.", (Throwable)e);
                        }
                        catch (URISyntaxException e) {}
                        continue block15;
                    }
                    case FETCH_PENDING: {
                        response.setLocalizerAction(LocalizerAction.LIVE);
                        continue block15;
                    }
                    case FETCH_FAILURE: {
                        LOG.info((Object)("DEBUG: FAILED " + req + ", " + stat.getException().getMessage()));
                        response.setLocalizerAction(LocalizerAction.DIE);
                        ResourceLocalizationService.this.getLocalResourcesTracker(req.getVisibility(), user, applicationId).handle((Event)new ResourceFailedLocalizationEvent(req, stat.getException().getMessage()));
                        assoc.getResource().unlock();
                        this.scheduled.remove(req);
                        continue block15;
                    }
                }
                LOG.info((Object)("Unknown status: " + (Object)((Object)stat.getStatus())));
                response.setLocalizerAction(LocalizerAction.DIE);
                ResourceLocalizationService.this.getLocalResourcesTracker(req.getVisibility(), user, applicationId).handle((Event)new ResourceFailedLocalizationEvent(req, stat.getException().getMessage()));
            }
            response.setResourceSpecs(rsrcs);
            return response;
        }

        private Path getPathForLocalization(LocalResource rsrc) throws IOException, URISyntaxException {
            String user = this.context.getUser();
            ApplicationId appId = this.context.getContainerId().getApplicationAttemptId().getApplicationId();
            LocalResourceVisibility vis = rsrc.getVisibility();
            LocalResourcesTracker tracker = ResourceLocalizationService.this.getLocalResourcesTracker(vis, user, appId);
            String cacheDirectory = null;
            cacheDirectory = vis == LocalResourceVisibility.PRIVATE ? ResourceLocalizationService.this.getUserFileCachePath(user) : ResourceLocalizationService.this.getAppFileCachePath(user, appId.toString());
            Path dirPath = ResourceLocalizationService.this.dirsHandler.getLocalPathForWrite(cacheDirectory, ContainerLocalizer.getEstimatedSize(rsrc), false);
            return tracker.getPathForLocalization(new LocalResourceRequest(rsrc), dirPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Path nmPrivateCTokensPath = null;
            try {
                String extTokenEnvVar;
                Path extTokenPath;
                nmPrivateCTokensPath = ResourceLocalizationService.this.dirsHandler.getLocalPathForWrite("nmPrivate/" + String.format("%s.tokens", this.localizerId));
                this.writeCredentials(nmPrivateCTokensPath);
                ExternalTokenLocalizer extTokenLocalizer = ExternalTokenLocalizerFactory.get();
                if (extTokenLocalizer != null) {
                    extTokenLocalizer.run(this.context, ResourceLocalizationService.this.getConfig(), ResourceLocalizationService.this.dirsHandler);
                }
                List<String> localDirs = ResourceLocalizationService.this.dirsHandler.getLocalDirs();
                List<String> logDirs = ResourceLocalizationService.this.dirsHandler.getLogDirs();
                if (ResourceLocalizationService.this.dirsHandler.areDisksHealthy()) {
                    String appIdStr = this.context.getContainerId().getApplicationAttemptId().getApplicationId().toString();
                    extTokenPath = null;
                    extTokenEnvVar = null;
                    if (extTokenLocalizer != null) {
                        extTokenPath = extTokenLocalizer.getTokenPath(appIdStr, ResourceLocalizationService.this.getConfig());
                        extTokenEnvVar = extTokenLocalizer.getTokenEnvVar();
                    }
                } else {
                    throw new IOException("All disks failed. " + ResourceLocalizationService.this.dirsHandler.getDisksHealthReport());
                }
                ResourceLocalizationService.this.exec.startLocalizer(nmPrivateCTokensPath, extTokenPath, extTokenEnvVar, ResourceLocalizationService.this.localizationServerAddress, this.context.getUser(), ConverterUtils.toString((ApplicationId)this.context.getContainerId().getApplicationAttemptId().getApplicationId()), this.localizerId, localDirs, logDirs);
            }
            catch (Exception e) {
                try {
                    LOG.info((Object)"Localizer failed", (Throwable)e);
                    ContainerId cId = this.context.getContainerId();
                    ResourceLocalizationService.this.dispatcher.getEventHandler().handle((Event)new ContainerResourceFailedEvent(cId, null, e.getMessage()));
                }
                catch (Throwable throwable) {
                    for (LocalizerResourceRequestEvent event : this.scheduled.values()) {
                        event.getResource().unlock();
                    }
                    ResourceLocalizationService.this.delService.delete(null, nmPrivateCTokensPath, new Path[0]);
                    throw throwable;
                }
                for (LocalizerResourceRequestEvent event : this.scheduled.values()) {
                    event.getResource().unlock();
                }
                ResourceLocalizationService.this.delService.delete(null, nmPrivateCTokensPath, new Path[0]);
            }
            for (LocalizerResourceRequestEvent event : this.scheduled.values()) {
                event.getResource().unlock();
            }
            ResourceLocalizationService.this.delService.delete(null, nmPrivateCTokensPath, new Path[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeCredentials(Path nmPrivateCTokensPath) throws IOException {
            FilterOutputStream tokenOut = null;
            try {
                Credentials credentials = this.context.getCredentials();
                FileContext lfs = ResourceLocalizationService.this.getLocalFileContext(ResourceLocalizationService.this.getConfig());
                tokenOut = lfs.create(nmPrivateCTokensPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                LOG.info((Object)("Writing credentials to the nmPrivate file " + nmPrivateCTokensPath.toString() + ". Credentials list: "));
                if (LOG.isDebugEnabled()) {
                    for (Token tk : credentials.getAllTokens()) {
                        LOG.debug((Object)(tk.getService() + " : " + tk.encodeToUrlString()));
                    }
                }
                if (UserGroupInformation.isSecurityEnabled()) {
                    credentials = new Credentials(credentials);
                    LocalizerTokenIdentifier id = ResourceLocalizationService.this.secretManager.createIdentifier();
                    Token localizerToken = new Token((TokenIdentifier)id, (SecretManager)ResourceLocalizationService.this.secretManager);
                    credentials.addToken(id.getKind(), localizerToken);
                }
                credentials.writeTokenStorageToStream((DataOutputStream)tokenOut);
            }
            finally {
                if (tokenOut != null) {
                    tokenOut.close();
                }
            }
        }
    }

    class PublicLocalizer
    extends Thread {
        final FileContext lfs;
        final Configuration conf;
        final ExecutorService threadPool;
        final CompletionService<Path> queue;
        final Map<Future<Path>, LocalizerResourceRequestEvent> pending;

        PublicLocalizer(Configuration conf) {
            super("Public Localizer");
            this.lfs = ResourceLocalizationService.this.getLocalFileContext(conf);
            this.conf = conf;
            this.pending = Collections.synchronizedMap(new HashMap());
            this.threadPool = ResourceLocalizationService.createLocalizerExecutor(conf);
            this.queue = new ExecutorCompletionService<Path>(this.threadPool);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addResource(LocalizerResourceRequestEvent request) {
            LocalizedResource rsrc = request.getResource();
            LocalResourceRequest key = rsrc.getRequest();
            LOG.info((Object)("Downloading public rsrc:" + key));
            if (rsrc.tryAcquire()) {
                if (rsrc.getState().equals((Object)ResourceState.DOWNLOADING)) {
                    LocalResourceRequest resource = request.getResource().getRequest();
                    try {
                        Path publicRootPath = ResourceLocalizationService.this.dirsHandler.getLocalPathForWrite("./filecache", ContainerLocalizer.getEstimatedSize(resource), true);
                        Path publicDirDestPath = ResourceLocalizationService.this.publicRsrc.getPathForLocalization(key, publicRootPath);
                        if (!publicDirDestPath.getParent().equals((Object)publicRootPath)) {
                            DiskChecker.checkDir((File)new File(publicDirDestPath.toUri().getPath()));
                        }
                        Map<Future<Path>, LocalizerResourceRequestEvent> map = this.pending;
                        synchronized (map) {
                            this.pending.put(this.queue.submit((Callable<Path>)new FSDownload(this.lfs, null, this.conf, publicDirDestPath, (LocalResource)resource, request.getContext().getStatCache())), request);
                        }
                    }
                    catch (IOException e) {
                        rsrc.unlock();
                        ResourceLocalizationService.this.publicRsrc.handle((Event)new ResourceFailedLocalizationEvent(request.getResource().getRequest(), e.getMessage()));
                        LOG.error((Object)"Local path for public localization is not found.  May be disks failed.", (Throwable)e);
                    }
                    catch (RejectedExecutionException re) {
                        rsrc.unlock();
                        ResourceLocalizationService.this.publicRsrc.handle((Event)new ResourceFailedLocalizationEvent(request.getResource().getRequest(), re.getMessage()));
                        LOG.error((Object)("Failed to submit rsrc " + rsrc + " for download." + " Either queue is full or threadpool is shutdown."), (Throwable)re);
                    }
                } else {
                    rsrc.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Path local;
                    LocalizerResourceRequestEvent assoc;
                    try {
                        Future<Path> completed = this.queue.take();
                        assoc = this.pending.remove(completed);
                        try {
                            local = completed.get();
                            if (null == assoc) {
                                LOG.error((Object)("Localized unkonwn resource to " + completed));
                                return;
                            }
                        }
                        catch (ExecutionException e) {
                            LOG.info((Object)("Failed to download rsrc " + assoc.getResource()), e.getCause());
                            LocalResourceRequest req = assoc.getResource().getRequest();
                            ResourceLocalizationService.this.publicRsrc.handle((Event)new ResourceFailedLocalizationEvent(req, e.getMessage()));
                            assoc.getResource().unlock();
                        }
                        catch (CancellationException cancellationException) {
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"Public cache exiting");
                        this.threadPool.shutdownNow();
                        return;
                    }
                    {
                        LocalResourceRequest key = assoc.getResource().getRequest();
                        ResourceLocalizationService.this.publicRsrc.handle((Event)new ResourceLocalizedEvent(key, local, FileUtil.getDU((File)new File(local.toUri()))));
                        assoc.getResource().unlock();
                    }
                }
                return;
            }
            catch (Throwable t) {
                LOG.fatal((Object)"Error: Shutting down", t);
                return;
            }
            finally {
                LOG.info((Object)"Public cache exiting");
                this.threadPool.shutdownNow();
            }
        }
    }

    class LocalizerTracker
    extends AbstractService
    implements EventHandler<LocalizerEvent> {
        private final PublicLocalizer publicLocalizer;
        private final Map<String, LocalizerRunner> privLocalizers;

        LocalizerTracker(Configuration conf) {
            this(conf, new HashMap<String, LocalizerRunner>());
        }

        LocalizerTracker(Configuration conf, Map<String, LocalizerRunner> privLocalizers) {
            super(LocalizerTracker.class.getName());
            this.publicLocalizer = new PublicLocalizer(conf);
            this.privLocalizers = privLocalizers;
        }

        public synchronized void serviceStart() throws Exception {
            this.publicLocalizer.start();
            super.serviceStart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LocalizerHeartbeatResponse processHeartbeat(LocalizerStatus status) {
            String locId = status.getLocalizerId();
            Map<String, LocalizerRunner> map = this.privLocalizers;
            synchronized (map) {
                LocalizerRunner localizer = this.privLocalizers.get(locId);
                if (null == localizer) {
                    LOG.info((Object)("Unknown localizer with localizerId " + locId + " is sending heartbeat. Ordering it to DIE"));
                    LocalizerHeartbeatResponse response = (LocalizerHeartbeatResponse)ResourceLocalizationService.this.recordFactory.newRecordInstance(LocalizerHeartbeatResponse.class);
                    response.setLocalizerAction(LocalizerAction.DIE);
                    return response;
                }
                return localizer.update(status.getResources());
            }
        }

        public void serviceStop() throws Exception {
            for (LocalizerRunner localizer : this.privLocalizers.values()) {
                localizer.interrupt();
            }
            this.publicLocalizer.interrupt();
            super.serviceStop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(LocalizerEvent event) {
            String locId = event.getLocalizerId();
            block2 : switch ((LocalizerEventType)event.getType()) {
                case REQUEST_RESOURCE_LOCALIZATION: {
                    LocalizerResourceRequestEvent req = (LocalizerResourceRequestEvent)event;
                    switch (req.getVisibility()) {
                        case PUBLIC: {
                            this.publicLocalizer.addResource(req);
                            break block2;
                        }
                        case PRIVATE: 
                        case APPLICATION: {
                            Map<String, LocalizerRunner> map = this.privLocalizers;
                            synchronized (map) {
                                LocalizerRunner localizer = this.privLocalizers.get(locId);
                                if (null == localizer) {
                                    LOG.info((Object)("Created localizer for " + locId));
                                    localizer = new LocalizerRunner(req.getContext(), locId);
                                    this.privLocalizers.put(locId, localizer);
                                    localizer.start();
                                }
                                localizer.addResource(req);
                                break block2;
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanupPrivLocalizers(String locId) {
            Map<String, LocalizerRunner> map = this.privLocalizers;
            synchronized (map) {
                LocalizerRunner localizer = this.privLocalizers.get(locId);
                if (null == localizer) {
                    return;
                }
                this.privLocalizers.remove(locId);
                localizer.interrupt();
            }
        }
    }
}

