/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.DiskChecker;

class DirectoryCollection {
    private static final Log LOG = LogFactory.getLog(DirectoryCollection.class);
    private List<String> localDirs;
    private List<String> failedDirs;
    private int numFailures;
    private float diskUtilizationPercentageCutoff;
    private long diskUtilizationSpaceCutoff;

    public DirectoryCollection(String[] dirs) {
        this(dirs, 100.0f, 0L);
    }

    public DirectoryCollection(String[] dirs, float utilizationPercentageCutOff) {
        this(dirs, utilizationPercentageCutOff, 0L);
    }

    public DirectoryCollection(String[] dirs, long utilizationSpaceCutOff) {
        this(dirs, 100.0f, utilizationSpaceCutOff);
    }

    public DirectoryCollection(String[] dirs, float utilizationPercentageCutOff, long utilizationSpaceCutOff) {
        this.localDirs = new CopyOnWriteArrayList<String>(dirs);
        this.failedDirs = new CopyOnWriteArrayList<String>();
        this.diskUtilizationPercentageCutoff = utilizationPercentageCutOff;
        this.diskUtilizationSpaceCutoff = utilizationSpaceCutOff;
        this.diskUtilizationPercentageCutoff = utilizationPercentageCutOff < 0.0f ? 0.0f : (utilizationPercentageCutOff > 100.0f ? 100.0f : utilizationPercentageCutOff);
        this.diskUtilizationSpaceCutoff = utilizationSpaceCutOff < 0L ? 0L : utilizationSpaceCutOff;
    }

    synchronized List<String> getGoodDirs() {
        return Collections.unmodifiableList(this.localDirs);
    }

    synchronized List<String> getFailedDirs() {
        return Collections.unmodifiableList(this.failedDirs);
    }

    synchronized int getNumFailures() {
        return this.numFailures;
    }

    synchronized boolean createNonExistentDirs(FileContext localFs, FsPermission perm) {
        boolean failed = false;
        for (String dir : this.localDirs) {
            try {
                this.createDir(localFs, new Path(dir), perm);
            }
            catch (IOException e) {
                LOG.warn((Object)("Unable to create directory " + dir + " error " + e.getMessage() + ", removing from the list of valid directories."));
                this.localDirs.remove(dir);
                this.failedDirs.add(dir);
                ++this.numFailures;
                failed = true;
            }
        }
        return !failed;
    }

    synchronized boolean checkDirs() {
        int oldNumFailures = this.numFailures;
        HashSet<String> checkFailedDirs = new HashSet<String>();
        for (String dir : this.localDirs) {
            try {
                File testDir = new File(dir);
                DiskChecker.checkDir((File)testDir);
                if (this.isDiskUsageUnderPercentageLimit(testDir)) {
                    LOG.warn((Object)("Directory " + dir + " error, used space above threshold of " + this.diskUtilizationPercentageCutoff + "%, removing from the list of valid directories."));
                    checkFailedDirs.add(dir);
                    continue;
                }
                if (!this.isDiskFreeSpaceWithinLimit(testDir)) continue;
                LOG.warn((Object)("Directory " + dir + " error, free space below limit of " + this.diskUtilizationSpaceCutoff + "MB, removing from the list of valid directories."));
                checkFailedDirs.add(dir);
            }
            catch (DiskChecker.DiskErrorException de) {
                LOG.warn((Object)("Directory " + dir + " error " + de.getMessage() + ", removing from the list of valid directories."));
                checkFailedDirs.add(dir);
            }
        }
        for (String dir : checkFailedDirs) {
            this.localDirs.remove(dir);
            this.failedDirs.add(dir);
            ++this.numFailures;
        }
        return this.numFailures > oldNumFailures;
    }

    private boolean isDiskUsageUnderPercentageLimit(File dir) {
        float freePercentage = 100.0f * ((float)dir.getUsableSpace() / (float)dir.getTotalSpace());
        float usedPercentage = 100.0f - freePercentage;
        return usedPercentage > this.diskUtilizationPercentageCutoff || usedPercentage >= 100.0f;
    }

    private boolean isDiskFreeSpaceWithinLimit(File dir) {
        long freeSpace = dir.getUsableSpace() / 0x100000L;
        return freeSpace < this.diskUtilizationSpaceCutoff;
    }

    private void createDir(FileContext localFs, Path dir, FsPermission perm) throws IOException {
        block3: {
            if (dir == null) {
                return;
            }
            try {
                localFs.getFileStatus(dir);
            }
            catch (FileNotFoundException e) {
                this.createDir(localFs, dir.getParent(), perm);
                localFs.mkdir(dir, perm, false);
                if (perm.equals((Object)perm.applyUMask(localFs.getUMask()))) break block3;
                localFs.setPermission(dir, perm);
            }
        }
    }

    public float getDiskUtilizationPercentageCutoff() {
        return this.diskUtilizationPercentageCutoff;
    }

    public void setDiskUtilizationPercentageCutoff(float diskUtilizationPercentageCutoff) {
        this.diskUtilizationPercentageCutoff = diskUtilizationPercentageCutoff < 0.0f ? 0.0f : (diskUtilizationPercentageCutoff > 100.0f ? 100.0f : diskUtilizationPercentageCutoff);
    }

    public long getDiskUtilizationSpaceCutoff() {
        return this.diskUtilizationSpaceCutoff;
    }

    public void setDiskUtilizationSpaceCutoff(long diskUtilizationSpaceCutoff) {
        this.diskUtilizationSpaceCutoff = diskUtilizationSpaceCutoff = diskUtilizationSpaceCutoff < 0L ? 0L : diskUtilizationSpaceCutoff;
    }
}

