/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;

@Singleton
@Path(value="/ws/v1/timeline")
public class TimelineWebServices {
    private static final Log LOG = LogFactory.getLog(TimelineWebServices.class);
    private TimelineStore store;
    private TimelineACLsManager timelineACLsManager;

    @Inject
    public TimelineWebServices(TimelineStore store, TimelineACLsManager timelineACLsManager) {
        this.store = store;
        this.timelineACLsManager = timelineACLsManager;
    }

    @GET
    @Produces(value={"application/json"})
    public AboutInfo about(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.init(res);
        return new AboutInfo("Timeline API");
    }

    @GET
    @Path(value="/{entityType}")
    @Produces(value={"application/json"})
    public TimelineEntities getEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="entityType") String entityType, @QueryParam(value="primaryFilter") String primaryFilter, @QueryParam(value="secondaryFilter") String secondaryFilter, @QueryParam(value="windowStart") String windowStart, @QueryParam(value="windowEnd") String windowEnd, @QueryParam(value="fromId") String fromId, @QueryParam(value="fromTs") String fromTs, @QueryParam(value="limit") String limit, @QueryParam(value="fields") String fields) {
        this.init(res);
        TimelineEntities entities = null;
        try {
            EnumSet<TimelineReader.Field> fieldEnums = TimelineWebServices.parseFieldsStr(fields, ",");
            boolean modified = TimelineWebServices.extendFields(fieldEnums);
            UserGroupInformation callerUGI = TimelineWebServices.getUser(req);
            entities = this.store.getEntities(TimelineWebServices.parseStr(entityType), TimelineWebServices.parseLongStr(limit), TimelineWebServices.parseLongStr(windowStart), TimelineWebServices.parseLongStr(windowEnd), TimelineWebServices.parseStr(fromId), TimelineWebServices.parseLongStr(fromTs), TimelineWebServices.parsePairStr(primaryFilter, ":"), TimelineWebServices.parsePairsStr(secondaryFilter, ",", ":"), fieldEnums);
            if (entities != null) {
                Iterator entitiesItr = entities.getEntities().iterator();
                while (entitiesItr.hasNext()) {
                    TimelineEntity entity = (TimelineEntity)entitiesItr.next();
                    try {
                        if (!this.timelineACLsManager.checkAccess(callerUGI, entity)) {
                            entitiesItr.remove();
                            continue;
                        }
                        if (modified) {
                            entity.setPrimaryFilters(null);
                            continue;
                        }
                        TimelineWebServices.cleanupOwnerInfo(entity);
                    }
                    catch (YarnException e) {
                        LOG.error((Object)("Error when verifying access for user " + callerUGI + " on the events of the timeline entity " + new EntityIdentifier(entity.getEntityId(), entity.getEntityType())), (Throwable)e);
                        entitiesItr.remove();
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("windowStart, windowEnd or limit is not a numeric value.");
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("requested invalid field.");
        }
        catch (IOException e) {
            LOG.error((Object)"Error getting entities", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (entities == null) {
            return new TimelineEntities();
        }
        return entities;
    }

    @GET
    @Path(value="/{entityType}/{entityId}")
    @Produces(value={"application/json"})
    public TimelineEntity getEntity(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="entityType") String entityType, @PathParam(value="entityId") String entityId, @QueryParam(value="fields") String fields) {
        this.init(res);
        TimelineEntity entity = null;
        try {
            EnumSet<TimelineReader.Field> fieldEnums = TimelineWebServices.parseFieldsStr(fields, ",");
            boolean modified = TimelineWebServices.extendFields(fieldEnums);
            entity = this.store.getEntity(TimelineWebServices.parseStr(entityId), TimelineWebServices.parseStr(entityType), fieldEnums);
            if (entity != null) {
                UserGroupInformation callerUGI = TimelineWebServices.getUser(req);
                if (!this.timelineACLsManager.checkAccess(callerUGI, entity)) {
                    entity = null;
                } else if (modified) {
                    entity.setPrimaryFilters(null);
                } else {
                    TimelineWebServices.cleanupOwnerInfo(entity);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("requested invalid field.");
        }
        catch (IOException e) {
            LOG.error((Object)"Error getting entity", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (YarnException e) {
            LOG.error((Object)"Error getting entity", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (entity == null) {
            throw new NotFoundException("Timeline entity " + new EntityIdentifier(TimelineWebServices.parseStr(entityId), TimelineWebServices.parseStr(entityType)) + " is not found");
        }
        return entity;
    }

    @GET
    @Path(value="/{entityType}/events")
    @Produces(value={"application/json"})
    public TimelineEvents getEvents(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="entityType") String entityType, @QueryParam(value="entityId") String entityId, @QueryParam(value="eventType") String eventType, @QueryParam(value="windowStart") String windowStart, @QueryParam(value="windowEnd") String windowEnd, @QueryParam(value="limit") String limit) {
        this.init(res);
        TimelineEvents events = null;
        try {
            UserGroupInformation callerUGI = TimelineWebServices.getUser(req);
            events = this.store.getEntityTimelines(TimelineWebServices.parseStr(entityType), TimelineWebServices.parseArrayStr(entityId, ","), TimelineWebServices.parseLongStr(limit), TimelineWebServices.parseLongStr(windowStart), TimelineWebServices.parseLongStr(windowEnd), TimelineWebServices.parseArrayStr(eventType, ","));
            if (events != null) {
                Iterator eventsItr = events.getAllEvents().iterator();
                while (eventsItr.hasNext()) {
                    TimelineEvents.EventsOfOneEntity eventsOfOneEntity = (TimelineEvents.EventsOfOneEntity)eventsItr.next();
                    try {
                        TimelineEntity entity = this.store.getEntity(eventsOfOneEntity.getEntityId(), eventsOfOneEntity.getEntityType(), EnumSet.of(TimelineReader.Field.PRIMARY_FILTERS));
                        if (this.timelineACLsManager.checkAccess(callerUGI, entity)) continue;
                        eventsItr.remove();
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error when verifying access for user " + callerUGI + " on the events of the timeline entity " + new EntityIdentifier(eventsOfOneEntity.getEntityId(), eventsOfOneEntity.getEntityType())), (Throwable)e);
                        eventsItr.remove();
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("windowStart, windowEnd or limit is not a numeric value.");
        }
        catch (IOException e) {
            LOG.error((Object)"Error getting entity timelines", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (events == null) {
            return new TimelineEvents();
        }
        return events;
    }

    @POST
    @Consumes(value={"application/json"})
    public TimelinePutResponse postEntities(@Context HttpServletRequest req, @Context HttpServletResponse res, TimelineEntities entities) {
        this.init(res);
        if (entities == null) {
            return new TimelinePutResponse();
        }
        UserGroupInformation callerUGI = TimelineWebServices.getUser(req);
        try {
            ArrayList<EntityIdentifier> entityIDs = new ArrayList<EntityIdentifier>();
            TimelineEntities entitiesToPut = new TimelineEntities();
            ArrayList<TimelinePutResponse.TimelinePutError> errors = new ArrayList<TimelinePutResponse.TimelinePutError>();
            for (TimelineEntity entity : entities.getEntities()) {
                EntityIdentifier entityID;
                block10: {
                    TimelinePutResponse.TimelinePutError error;
                    entityID = new EntityIdentifier(entity.getEntityId(), entity.getEntityType());
                    TimelineEntity existingEntity = null;
                    try {
                        existingEntity = this.store.getEntity(entityID.getId(), entityID.getType(), EnumSet.of(TimelineReader.Field.PRIMARY_FILTERS));
                        if (existingEntity != null && !this.timelineACLsManager.checkAccess(callerUGI, existingEntity)) {
                            throw new YarnException("The timeline entity " + entityID + " was not put by " + callerUGI + " before");
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Skip the timeline entity: " + entityID + ", because " + e.getMessage()));
                        error = new TimelinePutResponse.TimelinePutError();
                        error.setEntityId(entityID.getId());
                        error.setEntityType(entityID.getType());
                        error.setErrorCode(4);
                        errors.add(error);
                        continue;
                    }
                    try {
                        if (existingEntity != null) break block10;
                        TimelineWebServices.injectOwnerInfo(entity, callerUGI == null ? "" : callerUGI.getShortUserName());
                    }
                    catch (YarnException e) {
                        LOG.warn((Object)("Skip the timeline entity: " + entityID + ", because " + e.getMessage()));
                        error = new TimelinePutResponse.TimelinePutError();
                        error.setEntityId(entityID.getId());
                        error.setEntityType(entityID.getType());
                        error.setErrorCode(3);
                        errors.add(error);
                        continue;
                    }
                }
                entityIDs.add(entityID);
                entitiesToPut.addEntity(entity);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Storing the entity " + entityID + ", JSON-style content: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)entity)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing entities: " + StringHelper.CSV_JOINER.join(entityIDs)));
            }
            TimelinePutResponse response = this.store.put(entitiesToPut);
            response.addErrors(errors);
            return response;
        }
        catch (IOException e) {
            LOG.error((Object)"Error putting entities", (Throwable)e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void init(HttpServletResponse response) {
        response.setContentType(null);
    }

    private static SortedSet<String> parseArrayStr(String str, String delimiter) {
        String[] strs;
        if (str == null) {
            return null;
        }
        TreeSet<String> strSet = new TreeSet<String>();
        for (String aStr : strs = str.split(delimiter)) {
            strSet.add(aStr.trim());
        }
        return strSet;
    }

    private static NameValuePair parsePairStr(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(delimiter, 2);
        try {
            return new NameValuePair(strs[0].trim(), GenericObjectMapper.OBJECT_READER.readValue(strs[1].trim()));
        }
        catch (Exception e) {
            return new NameValuePair(strs[0].trim(), strs[1].trim());
        }
    }

    private static Collection<NameValuePair> parsePairsStr(String str, String aDelimiter, String pDelimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(aDelimiter);
        HashSet<NameValuePair> pairs = new HashSet<NameValuePair>();
        for (String aStr : strs) {
            pairs.add(TimelineWebServices.parsePairStr(aStr, pDelimiter));
        }
        return pairs;
    }

    private static EnumSet<TimelineReader.Field> parseFieldsStr(String str, String delimiter) {
        if (str == null) {
            return null;
        }
        String[] strs = str.split(delimiter);
        ArrayList<TimelineReader.Field> fieldList = new ArrayList<TimelineReader.Field>();
        for (String s : strs) {
            if ((s = s.trim().toUpperCase()).equals("EVENTS")) {
                fieldList.add(TimelineReader.Field.EVENTS);
                continue;
            }
            if (s.equals("LASTEVENTONLY")) {
                fieldList.add(TimelineReader.Field.LAST_EVENT_ONLY);
                continue;
            }
            if (s.equals("RELATEDENTITIES")) {
                fieldList.add(TimelineReader.Field.RELATED_ENTITIES);
                continue;
            }
            if (s.equals("PRIMARYFILTERS")) {
                fieldList.add(TimelineReader.Field.PRIMARY_FILTERS);
                continue;
            }
            if (s.equals("OTHERINFO")) {
                fieldList.add(TimelineReader.Field.OTHER_INFO);
                continue;
            }
            throw new IllegalArgumentException("Requested nonexistent field " + s);
        }
        if (fieldList.size() == 0) {
            return null;
        }
        TimelineReader.Field f1 = (TimelineReader.Field)((Object)fieldList.remove(fieldList.size() - 1));
        if (fieldList.size() == 0) {
            return EnumSet.of(f1);
        }
        return EnumSet.of(f1, (Enum[])fieldList.toArray(new TimelineReader.Field[fieldList.size()]));
    }

    private static boolean extendFields(EnumSet<TimelineReader.Field> fieldEnums) {
        boolean modified = false;
        if (fieldEnums != null && !fieldEnums.contains((Object)TimelineReader.Field.PRIMARY_FILTERS)) {
            fieldEnums.add(TimelineReader.Field.PRIMARY_FILTERS);
            modified = true;
        }
        return modified;
    }

    private static Long parseLongStr(String str) {
        return str == null ? null : Long.valueOf(Long.parseLong(str.trim()));
    }

    private static String parseStr(String str) {
        return str == null ? null : str.trim();
    }

    private static UserGroupInformation getUser(HttpServletRequest req) {
        String remoteUser = req.getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return callerUGI;
    }

    private static void injectOwnerInfo(TimelineEntity timelineEntity, String owner) throws YarnException {
        if (timelineEntity.getPrimaryFilters() != null && timelineEntity.getPrimaryFilters().containsKey(TimelineStore.SystemFilter.ENTITY_OWNER.toString())) {
            throw new YarnException("User should not use the timeline system filter key: " + (Object)((Object)TimelineStore.SystemFilter.ENTITY_OWNER));
        }
        timelineEntity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)owner);
    }

    private static void cleanupOwnerInfo(TimelineEntity timelineEntity) {
        if (timelineEntity.getPrimaryFilters() != null) {
            timelineEntity.getPrimaryFilters().remove(TimelineStore.SystemFilter.ENTITY_OWNER.toString());
        }
    }

    @XmlRootElement(name="about")
    @XmlAccessorType(value=XmlAccessType.NONE)
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class AboutInfo {
        private String about;

        public AboutInfo() {
        }

        public AboutInfo(String about) {
            this.about = about;
        }

        @XmlElement(name="About")
        public String getAbout() {
            return this.about;
        }

        public void setAbout(String about) {
            this.about = about;
        }
    }
}

