/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineACLsManager {
    @Test
    public void testYarnACLsNotEnabled() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", false);
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        TimelineEntity entity = new TimelineEntity();
        entity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)"owner");
        Assert.assertTrue((String)"Always true when ACLs are not enabled", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"user"), entity));
    }

    @Test
    public void testYarnACLsEnabled() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "admin");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        TimelineEntity entity = new TimelineEntity();
        entity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)"owner");
        Assert.assertTrue((String)"Owner should be allowed to access", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), entity));
        Assert.assertFalse((String)"Other shouldn't be allowed to access", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"other"), entity));
        Assert.assertTrue((String)"Admin should be allowed to access", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"admin"), entity));
    }

    @Test
    public void testCorruptedOwnerInfo() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "owner");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        TimelineEntity entity = new TimelineEntity();
        try {
            timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), entity);
            Assert.fail((String)"Exception is expected");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"It's not the exact expected exception", (boolean)e.getMessage().contains("is corrupted."));
        }
    }
}

