/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStoreTestUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.MemoryApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSController;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSView;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AppAttemptPage;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AppPage;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.ContainerPage;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.TestAHSWebApp;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAHSWebApp
extends ApplicationHistoryStoreTestUtils {
    public void setApplicationHistoryStore(ApplicationHistoryStore store) {
        this.store = store;
    }

    @Before
    public void setup() {
        this.store = new MemoryApplicationHistoryStore();
    }

    @Test
    public void testAppControllerIndex() throws Exception {
        ApplicationHistoryManager ahManager = (ApplicationHistoryManager)Mockito.mock(ApplicationHistoryManager.class);
        Injector injector = WebAppTests.createMockInjector(ApplicationHistoryManager.class, (Object)ahManager, (Module[])new Module[0]);
        AHSController controller = (AHSController)injector.getInstance(AHSController.class);
        controller.index();
        Assert.assertEquals((Object)"Application History", (Object)controller.get("title", "unknown"));
    }

    @Test
    public void testView() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationContext.class, (Object)this.mockApplicationHistoryManager(5, 1, 1), (Module[])new Module[0]);
        AHSView ahsViewInstance = (AHSView)injector.getInstance(AHSView.class);
        ahsViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        ahsViewInstance.set("app.state", YarnApplicationState.FAILED.toString());
        ahsViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        ahsViewInstance.set("app.state", StringHelper.cjoin((Object[])new Object[]{YarnApplicationState.FAILED.toString(), YarnApplicationState.KILLED}));
        ahsViewInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    public void testAppPage() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationContext.class, (Object)this.mockApplicationHistoryManager(1, 5, 1), (Module[])new Module[0]);
        AppPage appPageInstance = (AppPage)injector.getInstance(AppPage.class);
        appPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        appPageInstance.set("app.id", ApplicationId.newInstance((long)0L, (int)1).toString());
        appPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    public void testAppAttemptPage() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationContext.class, (Object)this.mockApplicationHistoryManager(1, 1, 5), (Module[])new Module[0]);
        AppAttemptPage appAttemptPageInstance = (AppAttemptPage)injector.getInstance(AppAttemptPage.class);
        appAttemptPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        appAttemptPageInstance.set("appattempt.id", ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1).toString());
        appAttemptPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    @Test
    public void testContainerPage() throws Exception {
        Injector injector = WebAppTests.createMockInjector(ApplicationContext.class, (Object)this.mockApplicationHistoryManager(1, 1, 1), (Module[])new Module[0]);
        ContainerPage containerPageInstance = (ContainerPage)injector.getInstance(ContainerPage.class);
        containerPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
        containerPageInstance.set("container.id", ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)1), (int)1), (int)1).toString());
        containerPageInstance.render();
        WebAppTests.flushOutput((Injector)injector);
    }

    ApplicationHistoryManager mockApplicationHistoryManager(int numApps, int numAppAttempts, int numContainers) throws Exception {
        MockApplicationHistoryManagerImpl ahManager = new MockApplicationHistoryManagerImpl(this, this.store);
        for (int i = 1; i <= numApps; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            this.writeApplicationStartData(appId);
            for (int j = 1; j <= numAppAttempts; ++j) {
                ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)j);
                this.writeApplicationAttemptStartData(appAttemptId);
                for (int k = 1; k <= numContainers; ++k) {
                    ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)k);
                    this.writeContainerStartData(containerId);
                    this.writeContainerFinishData(containerId);
                }
                this.writeApplicationAttemptFinishData(appAttemptId);
            }
            this.writeApplicationFinishData(appId);
        }
        return ahManager;
    }

    static /* synthetic */ ApplicationHistoryStore access$000(TestAHSWebApp x0) {
        return x0.store;
    }
}

