/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationHistoryServer {
    ApplicationHistoryServer historyServer = null;

    @Test(timeout=50000L)
    public void testStartStopServer() throws Exception {
        this.historyServer = new ApplicationHistoryServer();
        YarnConfiguration config = new YarnConfiguration();
        this.historyServer.init((Configuration)config);
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)this.historyServer.getServiceState());
        Assert.assertEquals((long)3L, (long)this.historyServer.getServices().size());
        ApplicationHistoryClientService historyService = this.historyServer.getClientService();
        Assert.assertNotNull((Object)this.historyServer.getClientService());
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)historyService.getServiceState());
        this.historyServer.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)this.historyServer.getServiceState());
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)historyService.getServiceState());
        this.historyServer.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)this.historyServer.getServiceState());
    }

    @Test(timeout=60000L)
    public void testLaunch() throws Exception {
        ExitUtil.disableSystemExit();
        try {
            this.historyServer = ApplicationHistoryServer.launchAppHistoryServer((String[])new String[0]);
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((long)0L, (long)e.status);
            ExitUtil.resetFirstExitException();
            Assert.fail();
        }
    }

    @After
    public void stop() {
        if (this.historyServer != null) {
            this.historyServer.stop();
        }
    }
}

