/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.TestMemoryTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.TestTimelineWebServices;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.TimelineWebServices;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTimelineWebServices
extends JerseyTest {
    private static TimelineStore store;
    private long beforeTime;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    private TimelineStore mockTimelineStore() throws Exception {
        this.beforeTime = System.currentTimeMillis() - 1L;
        TestMemoryTimelineStore store = new TestMemoryTimelineStore();
        store.setup();
        return store.getTimelineStore();
    }

    public TestTimelineWebServices() {
        super((AppDescriptor)((WebAppDescriptor.Builder)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.applicationhistoryservice.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").clientConfig((ClientConfig)new DefaultClientConfig(new Class[]{YarnJacksonJaxbJsonProvider.class}))).build());
    }

    @Test
    public void testAbout() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineWebServices.AboutInfo about = (TimelineWebServices.AboutInfo)response.getEntity(TimelineWebServices.AboutInfo.class);
        junit.framework.Assert.assertNotNull((Object)about);
        junit.framework.Assert.assertEquals((String)"Timeline API", (String)about.getAbout());
    }

    private static void verifyEntities(TimelineEntities entities) {
        junit.framework.Assert.assertNotNull((Object)entities);
        junit.framework.Assert.assertEquals((int)2, (int)entities.getEntities().size());
        TimelineEntity entity1 = (TimelineEntity)entities.getEntities().get(0);
        junit.framework.Assert.assertNotNull((Object)entity1);
        junit.framework.Assert.assertEquals((String)"id_1", (String)entity1.getEntityId());
        junit.framework.Assert.assertEquals((String)"type_1", (String)entity1.getEntityType());
        junit.framework.Assert.assertEquals((long)123L, (long)entity1.getStartTime());
        junit.framework.Assert.assertEquals((int)2, (int)entity1.getEvents().size());
        junit.framework.Assert.assertEquals((int)4, (int)entity1.getPrimaryFilters().size());
        junit.framework.Assert.assertEquals((int)4, (int)entity1.getOtherInfo().size());
        TimelineEntity entity2 = (TimelineEntity)entities.getEntities().get(1);
        junit.framework.Assert.assertNotNull((Object)entity2);
        junit.framework.Assert.assertEquals((String)"id_2", (String)entity2.getEntityId());
        junit.framework.Assert.assertEquals((String)"type_1", (String)entity2.getEntityType());
        junit.framework.Assert.assertEquals((long)123L, (long)entity2.getStartTime());
        junit.framework.Assert.assertEquals((int)2, (int)entity2.getEvents().size());
        junit.framework.Assert.assertEquals((int)4, (int)entity2.getPrimaryFilters().size());
        junit.framework.Assert.assertEquals((int)4, (int)entity2.getOtherInfo().size());
    }

    @Test
    public void testGetEntities() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testFromId() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", "id_2").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)1L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromId", "id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)2L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testFromTs() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", Long.toString(this.beforeTime)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)0L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("fromTs", Long.toString(System.currentTimeMillis())).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)2L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testPrimaryFilterString() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "user:username").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testPrimaryFilterInteger() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "appname:" + Integer.toString(Integer.MAX_VALUE)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testPrimaryFilterLong() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "long:" + Long.toString(0x80000000L)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testPrimaryFilterNumericString() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "other:123abc").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        Assert.assertEquals((long)0L, (long)((TimelineEntities)response.getEntity(TimelineEntities.class)).getEntities().size());
    }

    @Test
    public void testPrimaryFilterNumericStringWithQuotes() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("primaryFilter", "other:\"123abc\"").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testSecondaryFilters() {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").queryParam("secondaryFilter", "user:username,appname:" + Integer.toString(Integer.MAX_VALUE)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TestTimelineWebServices.verifyEntities((TimelineEntities)((TimelineEntities)response.getEntity(TimelineEntities.class)));
    }

    @Test
    public void testGetEntity() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        junit.framework.Assert.assertNotNull((Object)entity);
        junit.framework.Assert.assertEquals((String)"id_1", (String)entity.getEntityId());
        junit.framework.Assert.assertEquals((String)"type_1", (String)entity.getEntityType());
        junit.framework.Assert.assertEquals((long)123L, (long)entity.getStartTime());
        junit.framework.Assert.assertEquals((int)2, (int)entity.getEvents().size());
        junit.framework.Assert.assertEquals((int)4, (int)entity.getPrimaryFilters().size());
        junit.framework.Assert.assertEquals((int)4, (int)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEntityFields1() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", "events,otherinfo").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        junit.framework.Assert.assertNotNull((Object)entity);
        junit.framework.Assert.assertEquals((String)"id_1", (String)entity.getEntityId());
        junit.framework.Assert.assertEquals((String)"type_1", (String)entity.getEntityType());
        junit.framework.Assert.assertEquals((long)123L, (long)entity.getStartTime());
        junit.framework.Assert.assertEquals((int)2, (int)entity.getEvents().size());
        junit.framework.Assert.assertEquals((int)0, (int)entity.getPrimaryFilters().size());
        junit.framework.Assert.assertEquals((int)4, (int)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEntityFields2() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("id_1").queryParam("fields", "lasteventonly,primaryfilters,relatedentities").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEntity entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        junit.framework.Assert.assertNotNull((Object)entity);
        junit.framework.Assert.assertEquals((String)"id_1", (String)entity.getEntityId());
        junit.framework.Assert.assertEquals((String)"type_1", (String)entity.getEntityType());
        junit.framework.Assert.assertEquals((long)123L, (long)entity.getStartTime());
        junit.framework.Assert.assertEquals((int)1, (int)entity.getEvents().size());
        junit.framework.Assert.assertEquals((int)4, (int)entity.getPrimaryFilters().size());
        junit.framework.Assert.assertEquals((int)0, (int)entity.getOtherInfo().size());
    }

    @Test
    public void testGetEvents() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("type_1").path("events").queryParam("entityId", "id_1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineEvents events = (TimelineEvents)response.getEntity(TimelineEvents.class);
        junit.framework.Assert.assertNotNull((Object)events);
        junit.framework.Assert.assertEquals((int)1, (int)events.getAllEvents().size());
        TimelineEvents.EventsOfOneEntity partEvents = (TimelineEvents.EventsOfOneEntity)events.getAllEvents().get(0);
        junit.framework.Assert.assertEquals((int)2, (int)partEvents.getEvents().size());
        TimelineEvent event1 = (TimelineEvent)partEvents.getEvents().get(0);
        junit.framework.Assert.assertEquals((long)456L, (long)event1.getTimestamp());
        junit.framework.Assert.assertEquals((String)"end_event", (String)event1.getEventType());
        junit.framework.Assert.assertEquals((int)1, (int)event1.getEventInfo().size());
        TimelineEvent event2 = (TimelineEvent)partEvents.getEvents().get(1);
        junit.framework.Assert.assertEquals((long)123L, (long)event2.getTimestamp());
        junit.framework.Assert.assertEquals((String)"start_event", (String)event2.getEventType());
        junit.framework.Assert.assertEquals((int)0, (int)event2.getEventInfo().size());
    }

    @Test
    public void testPostEntities() throws Exception {
        TimelineEntities entities = new TimelineEntities();
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId("test id");
        entity.setEntityType("test type");
        entity.setStartTime(Long.valueOf(System.currentTimeMillis()));
        entities.addEntity(entity);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("timeline").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)entities);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelinePutResponse putResposne = (TimelinePutResponse)response.getEntity(TimelinePutResponse.class);
        junit.framework.Assert.assertNotNull((Object)putResposne);
        junit.framework.Assert.assertEquals((int)0, (int)putResposne.getErrors().size());
        response = (ClientResponse)r.path("ws").path("v1").path("timeline").path("test type").path("test id").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        entity = (TimelineEntity)response.getEntity(TimelineEntity.class);
        junit.framework.Assert.assertNotNull((Object)entity);
        junit.framework.Assert.assertEquals((String)"test id", (String)entity.getEntityId());
        junit.framework.Assert.assertEquals((String)"test type", (String)entity.getEntityType());
    }

    static /* synthetic */ TimelineStore access$002(TimelineStore x0) {
        store = x0;
        return store;
    }

    static /* synthetic */ TimelineStore access$100(TestTimelineWebServices x0) throws Exception {
        return x0.mockTimelineStore();
    }

    static /* synthetic */ TimelineStore access$000() {
        return store;
    }

    static /* synthetic */ Injector access$200(TestTimelineWebServices x0) {
        return x0.injector;
    }
}

