/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.net.URI;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryStoreTestUtils;
import org.apache.hadoop.yarn.server.applicationhistoryservice.FileSystemApplicationHistoryStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationAttemptHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ApplicationHistoryData;
import org.apache.hadoop.yarn.server.applicationhistoryservice.records.ContainerHistoryData;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestFileSystemApplicationHistoryStore
extends ApplicationHistoryStoreTestUtils {
    private static Log LOG = LogFactory.getLog((String)TestFileSystemApplicationHistoryStore.class.getName());
    private FileSystem fs;
    private Path fsWorkingPath;

    @Before
    public void setup() throws Exception {
        this.fs = new RawLocalFileSystem();
        Configuration conf = new Configuration();
        this.fs.initialize(new URI("/"), conf);
        this.fsWorkingPath = new Path("target", TestFileSystemApplicationHistoryStore.class.getSimpleName());
        this.fs.delete(this.fsWorkingPath, true);
        conf.set("yarn.timeline-service.generic-application-history.fs-history-store.uri", this.fsWorkingPath.toString());
        this.store = new FileSystemApplicationHistoryStore();
        this.store.init(conf);
        this.store.start();
    }

    @After
    public void tearDown() throws Exception {
        this.store.stop();
        this.fs.delete(this.fsWorkingPath, true);
        this.fs.close();
    }

    @Test
    public void testReadWriteHistoryData() throws IOException {
        LOG.info((Object)"Starting testReadWriteHistoryData");
        this.testWriteHistoryData(5);
        this.testReadHistoryData(5);
    }

    private void testWriteHistoryData(int num) throws IOException {
        this.testWriteHistoryData(num, false, false);
    }

    private void testWriteHistoryData(int num, boolean missingContainer, boolean missingApplicationAttempt) throws IOException {
        for (int i = 1; i <= num; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            this.writeApplicationStartData(appId);
            for (int j = 1; j <= num; ++j) {
                ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)j);
                this.writeApplicationAttemptStartData(appAttemptId);
                if (missingApplicationAttempt && j == num) continue;
                for (int k = 1; k <= num; ++k) {
                    ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)k);
                    this.writeContainerStartData(containerId);
                    if (missingContainer && k == num) continue;
                    this.writeContainerFinishData(containerId);
                }
                this.writeApplicationAttemptFinishData(appAttemptId);
            }
            this.writeApplicationFinishData(appId);
        }
    }

    private void testReadHistoryData(int num) throws IOException {
        this.testReadHistoryData(num, false, false);
    }

    private void testReadHistoryData(int num, boolean missingContainer, boolean missingApplicationAttempt) throws IOException {
        Assert.assertEquals((int)num, (int)this.store.getAllApplications().size());
        for (int i = 1; i <= num; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)i);
            ApplicationHistoryData appData = this.store.getApplication(appId);
            Assert.assertNotNull((Object)appData);
            Assert.assertEquals((String)appId.toString(), (String)appData.getApplicationName());
            Assert.assertEquals((String)appId.toString(), (String)appData.getDiagnosticsInfo());
            Assert.assertEquals((int)num, (int)this.store.getApplicationAttempts(appId).size());
            for (int j = 1; j <= num; ++j) {
                ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)j);
                ApplicationAttemptHistoryData attemptData = this.store.getApplicationAttempt(appAttemptId);
                Assert.assertNotNull((Object)attemptData);
                Assert.assertEquals((String)appAttemptId.toString(), (String)attemptData.getHost());
                if (missingApplicationAttempt && j == num) {
                    Assert.assertNull((Object)attemptData.getDiagnosticsInfo());
                    continue;
                }
                Assert.assertEquals((String)appAttemptId.toString(), (String)attemptData.getDiagnosticsInfo());
                Assert.assertEquals((int)num, (int)this.store.getContainers(appAttemptId).size());
                for (int k = 1; k <= num; ++k) {
                    ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)k);
                    ContainerHistoryData containerData = this.store.getContainer(containerId);
                    Assert.assertNotNull((Object)containerData);
                    Assert.assertEquals((Object)Priority.newInstance((int)containerId.getId()), (Object)containerData.getPriority());
                    if (missingContainer && k == num) {
                        Assert.assertNull((Object)containerData.getDiagnosticsInfo());
                        continue;
                    }
                    Assert.assertEquals((String)containerId.toString(), (String)containerData.getDiagnosticsInfo());
                }
                ContainerHistoryData masterContainer = this.store.getAMContainer(appAttemptId);
                Assert.assertNotNull((Object)masterContainer);
                Assert.assertEquals((Object)ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1), (Object)masterContainer.getContainerId());
            }
        }
    }

    @Test
    public void testWriteAfterApplicationFinish() throws IOException {
        LOG.info((Object)"Starting testWriteAfterApplicationFinish");
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        this.writeApplicationFinishData(appId);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        try {
            this.writeApplicationAttemptStartData(appAttemptId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not opened"));
        }
        try {
            this.writeApplicationAttemptFinishData(appAttemptId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not opened"));
        }
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)1);
        try {
            this.writeContainerStartData(containerId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not opened"));
        }
        try {
            this.writeContainerFinishData(containerId);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("is not opened"));
        }
    }

    @Test
    public void testMassiveWriteContainerHistoryData() throws IOException {
        LOG.info((Object)"Starting testMassiveWriteContainerHistoryData");
        long mb = 0x100000L;
        long usedDiskBefore = this.fs.getContentSummary(this.fsWorkingPath).getLength() / mb;
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        this.writeApplicationStartData(appId);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        for (int i = 1; i <= 100000; ++i) {
            ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)appAttemptId, (int)i);
            this.writeContainerStartData(containerId);
            this.writeContainerFinishData(containerId);
        }
        this.writeApplicationFinishData(appId);
        long usedDiskAfter = this.fs.getContentSummary(this.fsWorkingPath).getLength() / mb;
        Assert.assertTrue((usedDiskAfter - usedDiskBefore < 20L ? 1 : 0) != 0);
    }

    @Test
    public void testMissingContainerHistoryData() throws IOException {
        LOG.info((Object)"Starting testMissingContainerHistoryData");
        this.testWriteHistoryData(3, true, false);
        this.testReadHistoryData(3, true, false);
    }

    @Test
    public void testMissingApplicationAttemptHistoryData() throws IOException {
        LOG.info((Object)"Starting testMissingApplicationAttemptHistoryData");
        this.testWriteHistoryData(3, false, true);
        this.testReadHistoryData(3, false, true);
    }
}

